/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.PlatformThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadStatusRecomputation
implements FieldValueTransformer {
    ThreadStatusRecomputation() {
    }

    public Object transform(Object receiver, Object originalValue) {
        Thread thread = (Thread)receiver;
        if (thread.getState() == Thread.State.TERMINATED) {
            return 2;
        }
        assert (thread.getState() == Thread.State.NEW) : "All threads are in NEW state during image generation";
        if (thread == PlatformThreads.singleton().mainThread) {
            return 5;
        }
        return 0;
    }
}

