/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrFrameType;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.ExecutionSampleEvent;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class SamplerBuffersAccess {
    private static final CodeInfoDecoder.FrameInfoCursor FRAME_INFO_CURSOR = new CodeInfoDecoder.FrameInfoCursor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private SamplerBuffersAccess() {
    }

    @Uninterruptible(reason="Prevent JFR recording.")
    public static void processActiveBuffers() {
        assert (VMOperation.isInProgressAtSafepoint());
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            SamplerBuffer buffer = JfrThreadLocal.getSamplerBuffer(thread);
            if (buffer.isNonNull()) {
                SamplerBuffersAccess.serializeStackTraces(buffer);
                assert (JfrThreadLocal.getSamplerBuffer(thread) == buffer);
            }
            thread = VMThreads.nextThread(thread);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    public static void processFullBuffers(boolean useSafepointChecks) {
        SamplerBuffer buffer;
        while (!(buffer = SubstrateJVM.getSamplerBufferPool().popFullBuffer()).isNull()) {
            SamplerBuffersAccess.serializeStackTraces(buffer);
            SubstrateJVM.getSamplerBufferPool().releaseBuffer(buffer);
            if (!useSafepointChecks) continue;
            SamplerBuffersAccess.safepointCheck();
        }
        SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
    }

    @Uninterruptible(reason="The callee explicitly does a safepoint check.", calleeMustBe=false)
    private static void safepointCheck() {
        SamplerBuffersAccess.safepointCheck0();
    }

    private static void safepointCheck0() {
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void serializeStackTraces(SamplerBuffer rawStackTraceBuffer) {
        assert (rawStackTraceBuffer.isNonNull());
        Pointer end = rawStackTraceBuffer.getPos();
        Pointer current = SamplerBufferAccess.getDataStart(rawStackTraceBuffer);
        while (current.belowThan((UnsignedWord)end)) {
            Pointer entryStart = current;
            assert (entryStart.unsignedRemainder(8).equal(0));
            int sampleHash = current.readInt(0);
            boolean isTruncated = (current = current.add(4)).readInt(0) == 1;
            current = current.add(4);
            int sampleSize = current.readInt(0);
            current = current.add(4);
            current = current.add(4);
            long sampleTick = current.readLong(0);
            current = current.add(8);
            long threadId = current.readLong(0);
            current = current.add(8);
            long threadState = current.readLong(0);
            current = current.add(8);
            assert (current.subtract((UnsignedWord)entryStart).equal(SamplerSampleWriter.getHeaderSize()));
            CIntPointer statusPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            JfrStackTraceRepository.JfrStackTraceTableEntry entry = SubstrateJVM.getStackTraceRepo().getOrPutStackTrace(current, WordFactory.unsigned((int)sampleSize), sampleHash, statusPtr);
            long stackTraceId = entry.isNull() ? 0L : entry.getId();
            int status = statusPtr.read();
            if (status == 1 || status == 2) {
                assert (current.add(sampleSize).belowThan((UnsignedWord)end));
                boolean serialized = SamplerBuffersAccess.serializeStackTrace(current, sampleSize, isTruncated, stackTraceId);
                if (serialized) {
                    SubstrateJVM.getStackTraceRepo().commitSerializedStackTrace(entry);
                }
            } else assert (status == 4 || status == 8);
            current = current.add(sampleSize);
            long endMarker = current.readLong(0);
            if (endMarker == -2L) {
                if (stackTraceId != 0L) {
                    ExecutionSampleEvent.writeExecutionSample(sampleTick, threadId, stackTraceId, threadState);
                } else {
                    JfrThreadLocal.increaseMissedSamples();
                }
            } else assert (endMarker == -1L);
            current = current.add(8);
        }
        SamplerBufferAccess.reinitialize(rawStackTraceBuffer);
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static boolean serializeStackTrace(Pointer rawStackTrace, int sampleSize, boolean isTruncated, long stackTraceId) {
        assert (sampleSize % 8 == 0);
        JfrBuffer targetBuffer = SubstrateJVM.getStackTraceRepo().getCurrentBuffer();
        if (targetBuffer.isNull()) {
            return false;
        }
        int numStackTraceElements = SamplerBuffersAccess.visitRawStackTrace(rawStackTrace, sampleSize, (JfrNativeEventWriterData)WordFactory.nullPointer());
        if (numStackTraceElements == 0) {
            return false;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, targetBuffer);
        JfrNativeEventWriter.putLong(data, stackTraceId);
        JfrNativeEventWriter.putBoolean(data, isTruncated);
        JfrNativeEventWriter.putInt(data, numStackTraceElements);
        SamplerBuffersAccess.visitRawStackTrace(rawStackTrace, sampleSize, data);
        boolean success = JfrNativeEventWriter.commit(data);
        SubstrateJVM.getStackTraceRepo().setCurrentBuffer(data.getJfrBuffer());
        return success;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static int visitRawStackTrace(Pointer rawStackTrace, int sampleSize, JfrNativeEventWriterData data) {
        int numStackTraceElements = 0;
        Pointer rawStackTraceEnd = rawStackTrace.add(sampleSize);
        Pointer ipPtr = rawStackTrace;
        while (ipPtr.belowThan((UnsignedWord)rawStackTraceEnd)) {
            long ip = ipPtr.readLong(0);
            numStackTraceElements += SamplerBuffersAccess.visitFrame(data, ip);
            ipPtr = ipPtr.add(8);
        }
        return numStackTraceElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent JFR recording, epoch change, and that the GC frees the CodeInfo.")
    private static int visitFrame(JfrNativeEventWriterData data, long address) {
        CodePointer ip = (CodePointer)WordFactory.pointer((long)address);
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull()) {
            VMError.shouldNotReachHere("Stack walk must walk only frames of known code.");
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        CodeInfo tetheredCodeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
        try {
            int n = SamplerBuffersAccess.visitFrame(data, tetheredCodeInfo, ip);
            return n;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static int visitFrame(JfrNativeEventWriterData data, CodeInfo codeInfo, CodePointer ip) {
        int numStackTraceElements = 0;
        FRAME_INFO_CURSOR.initialize(codeInfo, ip);
        while (FRAME_INFO_CURSOR.advance()) {
            if (data.isNonNull()) {
                FrameInfoQueryResult frame = FRAME_INFO_CURSOR.get();
                SamplerBuffersAccess.serializeStackTraceElement(data, frame);
            }
            ++numStackTraceElements;
        }
        return numStackTraceElements;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void serializeStackTraceElement(JfrNativeEventWriterData data, FrameInfoQueryResult stackTraceElement) {
        long methodId = SubstrateJVM.getMethodRepo().getMethodId(stackTraceElement.getSourceClass(), stackTraceElement.getSourceMethodName(), stackTraceElement.getMethodId());
        JfrNativeEventWriter.putLong(data, methodId);
        JfrNativeEventWriter.putInt(data, stackTraceElement.getSourceLineNumber());
        JfrNativeEventWriter.putInt(data, stackTraceElement.getBci());
        JfrNativeEventWriter.putLong(data, JfrFrameType.FRAME_AOT_COMPILED.getId());
    }
}

