/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class OSCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public OSCommittedMemoryProvider() {
    }

    @Override
    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer isolatePointer, CEntryPointCreateIsolateParameters parameters) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            int result = OSCommittedMemoryProvider.protectSingleIsolateImageHeap();
            if (result == 0) {
                isolatePointer.write((WordBase)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL);
            }
            return result;
        }
        return ImageHeapProvider.get().initialize((Pointer)WordFactory.nullPointer(), (UnsignedWord)WordFactory.zero(), isolatePointer, (WordPointer)WordFactory.nullPointer());
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return 0;
        }
        PointerBase heapBase = Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return ImageHeapProvider.get().freeImageHeap(heapBase);
    }
}

