/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.logging;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jfr.logging.JfrLogConfiguration;
import com.oracle.svm.core.jfr.logging.JfrLogTag;
import com.oracle.svm.core.jfr.logging.Target_jdk_jfr_internal_LogTag;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Set;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrLogging {
    private final JfrLogConfiguration configuration = new JfrLogConfiguration();
    private final String[] logLevels = JfrLogging.createLogLevels();
    private final String[] logTagSets = JfrLogging.createLogTagSets();
    private int levelDecorationFill = 0;
    private int tagSetDecorationFill = 0;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrLogging() {
    }

    public void parseConfiguration(String config) {
        this.configuration.parse(config);
    }

    public void warnInternal(String message) {
        int tagSetId = SubstrateUtil.cast((Object)((Object)LogTag.JFR_SYSTEM), Target_jdk_jfr_internal_LogTag.class).id;
        this.log(tagSetId, JfrLogConfiguration.JfrLogLevel.WARNING.level, message);
    }

    public void log(int tagSetId, int level, String message) {
        if (message == null) {
            return;
        }
        this.verifyLogLevel(level);
        this.verifyLogTagSetId(tagSetId);
        String levelDecoration = this.logLevels[level];
        String tagSetDecoration = this.logTagSets[tagSetId];
        if (levelDecoration.length() > this.levelDecorationFill) {
            this.levelDecorationFill = levelDecoration.length();
        }
        if (tagSetDecoration.length() > this.tagSetDecorationFill) {
            this.tagSetDecorationFill = tagSetDecoration.length();
        }
        Log log = Log.log();
        log.string("[");
        log.string(levelDecoration, this.levelDecorationFill, 1);
        log.string("][");
        log.string(tagSetDecoration, this.tagSetDecorationFill, 1);
        log.string("] ");
        log.string(message).newline();
    }

    public void logEvent(int level, String[] lines, boolean system) {
        if (lines == null) {
            return;
        }
        this.verifyLogLevel(level);
        LogTag logTag = system ? LogTag.JFR_SYSTEM_EVENT : LogTag.JFR_EVENT;
        int tagSetId = SubstrateUtil.cast((Object)((Object)logTag), Target_jdk_jfr_internal_LogTag.class).id;
        for (int i = 0; i < lines.length; ++i) {
            this.log(tagSetId, level, lines[i]);
        }
    }

    private void verifyLogLevel(int level) {
        if (level < 0 || level >= this.logLevels.length || this.logLevels[level] == null) {
            throw new IllegalArgumentException("LogLevel passed is outside valid range");
        }
    }

    private void verifyLogTagSetId(int tagSetId) {
        if (tagSetId < 0 || tagSetId >= this.logTagSets.length) {
            throw new IllegalArgumentException("LogTagSet id is outside valid range");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String[] createLogLevels() {
        LogLevel[] values = LogLevel.values();
        String[] result = new String[JfrLogging.getMaxLogLevel(values) + 1];
        for (LogLevel logLevel : values) {
            result[JfrLogging.getLevel((LogLevel)logLevel)] = logLevel.toString().toLowerCase();
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getMaxLogLevel(LogLevel[] values) {
        int result = 0;
        for (LogLevel logLevel : values) {
            result = Math.max(result, JfrLogging.getLevel(logLevel));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String[] createLogTagSets() {
        LogTag[] values = LogTag.values();
        String[] result = new String[JfrLogging.getMaxLogTagSetId(values) + 1];
        for (LogTag logTagSet : values) {
            StringBuilder builder = new StringBuilder();
            Set<JfrLogTag> set = JfrLogConfiguration.LOG_TAG_SETS.get((Object)logTagSet);
            if (set == null) continue;
            for (JfrLogTag logTag : set) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(logTag.toString().toLowerCase());
            }
            result[JfrLogging.getId((LogTag)logTagSet)] = builder.toString();
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getMaxLogTagSetId(LogTag[] values) {
        int result = 0;
        for (LogTag logTagSet : values) {
            result = Math.max(result, JfrLogging.getId(logTagSet));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int getLevel(LogLevel logLevel) {
        return (Integer)ReflectionUtil.readField(LogLevel.class, (String)"level", (Object)((Object)logLevel));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getId(LogTag logTag) {
        return (Integer)ReflectionUtil.readField(LogTag.class, (String)"id", (Object)((Object)logTag));
    }
}

