/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class PredefinedClassesSupport {
    public static final String ENABLE_BYTECODES_OPTION = SubstrateOptionsParser.commandArgument(Options.SupportPredefinedClasses, "+");
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<Class<?>> predefinedClasses = new HashSet();
    private final ReentrantLock lock = new ReentrantLock();
    private final EconomicMap<String, Class<?>> predefinedClassesByHash = ImageHeapMap.create();
    private final EconomicMap<String, Class<?>> loadedClassesByName = EconomicMap.create();

    @Fold
    public static boolean supportsBytecodes() {
        return Options.SupportPredefinedClasses.getValue();
    }

    @Fold
    public static boolean hasBytecodeClasses() {
        return PredefinedClassesSupport.supportsBytecodes() && !PredefinedClassesSupport.singleton().predefinedClassesByHash.isEmpty();
    }

    public static RuntimeException throwNoBytecodeClasses() {
        if (!PredefinedClassesSupport.supportsBytecodes()) {
            throw VMError.unsupportedFeature("Loading classes from bytecodes at runtime has been disabled. Enable with option: " + ENABLE_BYTECODES_OPTION);
        }
        assert (!PredefinedClassesSupport.hasBytecodeClasses());
        throw VMError.unsupportedFeature("No classes have been predefined during the image build to load from bytecodes at runtime.");
    }

    @Fold
    static PredefinedClassesSupport singleton() {
        return (PredefinedClassesSupport)ImageSingletons.lookup(PredefinedClassesSupport.class);
    }

    public static String hash(byte[] classData, int offset, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(classData, offset, length);
            return SubstrateUtil.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(String hash, Class<?> clazz) {
        Class existing = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.putIfAbsent((Object)hash, clazz);
        if (existing != clazz) {
            VMError.guarantee(existing == null, "Can define only one class per hash");
            PredefinedClassesSupport.singleton().predefinedClasses.add(clazz);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        PredefinedClassesSupport.singleton().predefinedClasses.add(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isPredefined(Class<?> clazz) {
        return PredefinedClassesSupport.singleton().predefinedClasses.contains(clazz);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String expectedName, byte[] data, int offset, int length, ProtectionDomain protectionDomain) {
        if (!PredefinedClassesSupport.hasBytecodeClasses()) {
            throw PredefinedClassesSupport.throwNoBytecodeClasses();
        }
        String hash = PredefinedClassesSupport.hash(data, offset, length);
        Class clazz = (Class)PredefinedClassesSupport.singleton().predefinedClassesByHash.get((Object)hash);
        if (clazz == null) {
            String name = expectedName != null ? expectedName : "(name not specified)";
            throw VMError.unsupportedFeature("Defining a class from new bytecodes at run time is not supported. Class " + name + " with hash " + hash + " was not provided during the image build. Please see BuildConfiguration.md.");
        }
        if (expectedName != null && !expectedName.equals(clazz.getName())) {
            throw new NoClassDefFoundError(clazz.getName() + " (wrong name: " + expectedName + ")");
        }
        PredefinedClassesSupport.loadClass(classLoader, protectionDomain, clazz);
        return clazz;
    }

    public static void loadClass(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        boolean loaded = PredefinedClassesSupport.loadClassIfNotLoaded(classLoader, protectionDomain, clazz);
        if (!loaded) {
            if (classLoader == clazz.getClassLoader()) {
                throw new LinkageError("loader " + String.valueOf(classLoader) + " attempted duplicate class definition for " + clazz.getName() + " defined by " + String.valueOf(clazz.getClassLoader()));
            }
            throw VMError.unsupportedFeature("A predefined class can be loaded (defined) at runtime only once by a single class loader. Hierarchies of class loaders and distinct sets of classes are not supported. Class " + clazz.getName() + " has already been loaded by class loader: " + String.valueOf(clazz.getClassLoader()));
        }
    }

    public static boolean loadClassIfNotLoaded(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        return PredefinedClassesSupport.singleton().loadClass0(classLoader, protectionDomain, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadClass0(ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) {
        if (DynamicHub.fromClass(clazz).isLoaded()) {
            return false;
        }
        PredefinedClassesSupport.loadSuperType(clazz, clazz.getSuperclass(), classLoader);
        for (Class<?> intf : clazz.getInterfaces()) {
            PredefinedClassesSupport.loadSuperType(clazz, intf, classLoader);
        }
        this.lock.lock();
        try {
            if (DynamicHub.fromClass(clazz).isLoaded()) {
                boolean bl = false;
                return bl;
            }
            DynamicHub hub = DynamicHub.fromClass(clazz);
            hub.setClassLoaderAtRuntime(classLoader);
            if (protectionDomain != null) {
                hub.setProtectionDomainAtRuntime(protectionDomain);
            }
            this.loadedClassesByName.put((Object)clazz.getName(), clazz);
            int n = 1;
            return n != 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void loadSuperType(Class<?> clazz, Class<?> supertype, ClassLoader classLoader) {
        if (supertype == null) {
            return;
        }
        if (classLoader != null && !DynamicHub.fromClass(supertype).isLoaded()) {
            Class<?> loaded;
            try {
                loaded = classLoader.loadClass(supertype.getName());
            }
            catch (ClassNotFoundException e) {
                throw PredefinedClassesSupport.throwUnresolvable(supertype, e);
            }
            if (loaded != supertype) {
                throw new LinkageError("Loader " + String.valueOf(classLoader) + " supplied unexpected class " + loaded.getName() + " for supertype of " + clazz.getName() + " when expecting " + supertype.getName());
            }
        } else {
            PredefinedClassesSupport.throwIfUnresolvable(supertype, classLoader);
        }
    }

    public static void throwIfUnresolvable(Class<?> clazz, ClassLoader classLoader) {
        if (clazz == null) {
            return;
        }
        DynamicHub hub = DynamicHub.fromClass(clazz);
        if (!hub.isLoaded() || !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)classLoader)) {
            throw PredefinedClassesSupport.throwUnresolvable(clazz, null);
        }
    }

    private static RuntimeException throwUnresolvable(Class<?> clazz, ClassNotFoundException cause) {
        String name = clazz.getName();
        NoClassDefFoundError error = new NoClassDefFoundError(name.replace('.', '/'));
        error.initCause(cause != null ? cause : new ClassNotFoundException(name));
        throw error;
    }

    static Class<?> getLoadedForNameOrNull(String name, ClassLoader classLoader) {
        Class<?> clazz = PredefinedClassesSupport.singleton().getLoaded(name);
        if (clazz == null || !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)classLoader)) {
            return null;
        }
        return clazz;
    }

    private Class<?> getLoaded(String name) {
        this.lock.lock();
        try {
            Class clazz = (Class)this.loadedClassesByName.get((Object)name);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static final class Options {
        static final HostedOptionKey<Boolean> SupportPredefinedClasses = new HostedOptionKey<Boolean>(true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class TestingBackdoor {
        public static Set<Class<?>> getConfigurationPredefinedClasses() {
            HashSet set = new HashSet();
            for (Class clazz : PredefinedClassesSupport.singleton().predefinedClassesByHash.getValues()) {
                set.add(clazz);
            }
            return set;
        }
    }
}

