/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.thread.VirtualThreads;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeInterface;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_8)
public class StackValueNode
extends AbstractStateSplit
implements MemoryAccess,
Lowerable,
IterableNodeType {
    public static final NodeClass<StackValueNode> TYPE = NodeClass.create(StackValueNode.class);
    static final int MAX_SIZE = 0xA00000;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    protected final int sizeInBytes;
    protected final int alignmentInBytes;
    protected final StackSlotIdentity slotIdentity;
    protected final boolean checkVirtualThread;

    protected StackValueNode(int sizeInBytes, int alignmentInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        this(TYPE, sizeInBytes, alignmentInBytes, slotIdentity, checkVirtualThread);
    }

    protected StackValueNode(NodeClass<? extends StackValueNode> type, int sizeInBytes, int alignmentInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        super(type, FrameAccess.getWordStamp());
        this.sizeInBytes = sizeInBytes;
        this.alignmentInBytes = alignmentInBytes;
        this.slotIdentity = slotIdentity;
        this.checkVirtualThread = checkVirtualThread;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getAlignmentInBytes() {
        return this.alignmentInBytes;
    }

    public LocationIdentity getLocationIdentity() {
        if (this.checkVirtualThread) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface((ValueNodeInterface)this.lastLocationAccess, (ValueNodeInterface)lla);
        this.lastLocationAccess = lla;
    }

    public static ValueNode create(long numElements, long elementSize, GraphBuilderContext b, boolean disallowVirtualThread) {
        if (UnsignedMath.aboveOrEqual((long)numElements, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)elementSize, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)(numElements * elementSize), (long)0xA00000L)) {
            throw new PermanentBailoutException("stack value has illegal size " + numElements + " * " + elementSize);
        }
        int sizeInBytes = NumUtil.safeToInt((long)(numElements * elementSize));
        return StackValueNode.create(sizeInBytes, b.getGraph().method(), b.bci(), disallowVirtualThread);
    }

    public static StackValueNode create(int sizeInBytes, ResolvedJavaMethod method, int bci, boolean disallowVirtualThread) {
        String name = method.asStackTraceElement(bci).toString();
        StackSlotIdentity slotIdentity = new StackSlotIdentity(name, false);
        boolean checkVirtualThread = disallowVirtualThread && VirtualThreads.isSupported() && !Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method);
        return StackValueNode.create(sizeInBytes, slotIdentity, checkVirtualThread);
    }

    public static StackValueNode create(int sizeInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        if (UnsignedMath.aboveOrEqual((int)sizeInBytes, (int)0xA00000)) {
            throw new PermanentBailoutException("stack value has illegal size " + sizeInBytes + ": " + slotIdentity.name);
        }
        int alignmentInBytes = ConfigurationValues.getTarget().stackAlignment;
        return new StackValueNode(sizeInBytes, alignmentInBytes, slotIdentity, checkVirtualThread);
    }

    public static class StackSlotIdentity {
        protected final boolean shared;
        protected final String name;

        public StackSlotIdentity(String name, boolean shared) {
            this.name = name;
            this.shared = shared;
        }

        public String toString() {
            return this.name;
        }
    }
}

