'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  1/6/2026 3:27:33 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  2018, 2026, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide contains information about import and export formats and the process of importing and exporting data.","Audience","Administrators should use this guide.","About This Guide","98045.htm");
Page[2]=new Array("All project data is stored in a central database. You can import and export information to and from this database using external files and then share this information with other P6 Professional users, Oracle Contractor users, other project management tools (such as Microsoft Project and Microsoft Excel), and your organization's human resource and accounting systems. You can also use external files to archive your projects or create a backup of your database. The file format you select when you import or export determines the type of information you can share. You must have the 'Export Project Data' project privilege to export projects.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","You can import and export between P6 Professional and other applications using the following file formats:","The Oracle proprietary format (XER) supports all project, resource, and role information developed using the P6 Professional or P6 EPPM suite of project management tools. The Primavera PM XER file format enables you to export data between P6 Professional release 5.0 or more recent versions, for use within P6 Professional. The Contractor XER format is supported to import data from Contractor 4.0 and subsequent versions into PM, as well as export data to Contractor 5.0 or 6.1 and later.","Primavera's P6 XML format enables you to share project and baseline information between P6 Professional or P6 EPPM databases.","XLSX files enable you to share information with other spreadsheet applications.","MPX format enables you to share information with Microsoft Project, as well as to integrate with other third-party tools.","Microsoft Project XML format enables you to share information with Microsoft Project 2007, 2010, and 2013.","UN/CEFACT Schema XML files enable you to export information to organizations that require UN/CEFACT format, such as the Defense Contract Management Agency (DMCA).","IPMDAR files enable you to export information to organizations that require IPMDAR format.","CPP files enable you to export information to organizations that require CPP format.","Note To share data with P3 users, use the following utilities to convert between XER and P3 format (on-premises only):","P3 to XER (P330XERConvert.exe)","XER to P3 (XERP330Convert.exe)","Importing and exporting projects","importing_and_exporting_projects.htm");
Page[3]=new Array("All resource and role information is stored in a central database. You can import and export information to and from this database using external files and share this information with other P6 Professional users. Since resources and roles are defined at the global level, you can import and export them without opening the projects that contain them.","Resource information can be imported and exported using either the Primavera PM (XER), Spreadsheet (XLSX), or eXtensible Markup Language (XML). Roles can only be imported and exported using the Primavera PM (XER) format. You can import and export all resource and role information to ensure that resources and roles are consistent throughout your organization. XER format transfers all resource and role information, such as the resource hierarchy, resource categories, category values, and category value assignments.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","Importing and exporting resources and roles","importing_and_exporting_resources_and_roles.htm");
Page[4]=new Array("You can import and export between P6 Professional and other applications using the following file formats:","The Oracle proprietary format (XER) supports all project, resource, and role information developed using the P6 Professional or P6 EPPM suite of project management tools. The Primavera PM XER file format enables you to export data between P6 Professional release 5.0 or more recent versions, for use within P6 Professional. The Contractor XER format is supported to import data from Contractor 4.0 and subsequent versions into PM, as well as export data to Contractor 5.0 or 6.1 and later.","Primavera's P6 XML format enables you to share project and baseline information between P6 Professional or P6 EPPM databases.","XLSX files enable you to share information with other spreadsheet applications.","MPX format enables you to share information with Microsoft Project, as well as to integrate with other third-party tools.","Microsoft Project XML format enables you to share information with Microsoft Project 2007, 2010, and 2013.","UN/CEFACT Schema XML files enable you to export information to organizations that require UN/CEFACT format, such as the Defense Contract Management Agency (DMCA).","IPMDAR files enable you to export information to organizations that require IPMDAR format.","CPP files enable you to export information to organizations that require CPP format.","Differences Between XML and XER Export Formats","The following table compares the features and benefits of both formats for exporting project data. An X represents that a particular format is better suited for that functionality.","Functionality","XML","XER","Data formats","XER is proprietary.","XML is an industry-standard format.","X","Multiple projects","XER supports exporting multiple projects at once to a single XER file.","XML supports exporting multiple projects at once to a single XML file.","X","X","Baseline Export","XER does not support the export of baselines.","XML supports the export of baselines.","X","Job Services","XER supports scheduling exports on a regular basis as services.","XML does not.","X","Differences Between XML and XER Import Formats","The following table compares the features and benefits of both formats for importing project data. An X represents that a particular format is better suited for that functionality.","Functionality","XML","XER","Security","XML always enforces individual user security settings, and never violates your security restrictions. If there is a security conflict, the import will try to continue and ignore data that a user should not have access to; if it is not possible to continue while ignoring data, the import is stopped. Security is never bypassed when updating data.","XER allows updates to all data if you are assigned the Project Superuser or Admin Superuser security profiles.","X","Exclusive Project Access","XML always opens a project as exclusive, and will stop the import if it cannot gain exclusive access. This ensures that other users are not changing data during the import process.","XER accesses projects as shared, which means other users can update data in the middle of the import process.","X","Committing Data","XML will not commit partial data. If an import action for a specific transaction fails before all data is committed, XML rolls back the data; global and project-specific imports are treated as separate transactions.","XER can end up with partial commits of data.","X","Work Shift Handling","XML replaces any existing work shifts.","XER tries to insert work shifts, which can potentially corrupt your shift decisions.","X","Multiple projects","XER supports importing multiple projects at once from a single XER file.","XML supports importing multiple projects at once from a single XML file.","X","X","Baseline Import","XER does not support the import of baselines.","XML supports the import of baselines.","X","Import/Export file formats","import_export_file_formats.htm");
Page[5]=new Array("The following table summarizes how you can use the Import wizard.","File Format","Information Type","Purpose","Primavera PM XER","Project","Import complete project information from other P6 Professional or P6 EPPM modules and Oracle Primavera Contractor","Primavera PM XER","Resource Only","Import complete resource information from other P6 Professional or P6 EPPM modules and Oracle Primavera Contractor","Primavera PM XER","Role Only","Import complete role information from other P6 Professional or P6 EPPM modules","Primavera P6 XML","Project","Import project and baseline information from other P6 Professional or P6 EPPM modules. This is a subset of complete project data.","Microsoft Project XML","Project","Import project information from Microsoft Project","MPX","Project","Import project information from Microsoft Project or other third-party applications that support the MPX format","MPX","Resource Only","Import resource information from Microsoft Project or other third-party applications that support the MPX format","XLSX","Activities","Import activity information from Microsoft Excel or other third-party applications that support the XLSX format","XLSX","Activity Relationships","Import activity relationship information from Microsoft Excel or other third-party applications that support the XLSX format","XLSX","Expenses","Import expense information from Microsoft Excel or other third-party applications that support the XLSX format","XLSX","Resources","Import resource information from Microsoft Excel or other third-party applications that support the XLSX format","XLSX","Resource Assignments","Import resource assignment information from Microsoft Excel or other third-party applications that support the XLSX format","Note","Imported data from other applications may look different when it is scheduled in P6 Professional.","When connected to a P6 Professional database: This setting is available in the Project Access tab in the Admin, Users dialog box.","When connected to a P6 EPPM database: This setting is available from P6.","Importing information using a wizard","importing_information_using_a_wizard.htm");
Page[6]=new Array("The following table summarizes how you can use the Export wizard.","File Format","Information Type","Purpose","Primavera PM XER","Project","Export complete project information to other P6 Professional 5.0 and later users","Primavera PM XER","Resource Only","Export complete resource information to other P6 Professional 5.0 and later users","Primavera PM XER","Role Only","Export complete role information to other P6 Professional 5.0 and later users","Primavera P6 XML","Project","Export project and baseline information to other P6 Professional or P6 EPPM users.","Primavera Contractor XER","Project","Export complete project information to Oracle Primavera Contractor 5.0 or 6.1","Primavera Contractor XER","Resource Only","Export complete resource information to Oracle Primavera Contractor 5.0 or 6.1","Microsoft Project XML","Project and Resource","Export project information to Microsoft Project or other third-party applications","Microsoft Project MPX","Resource Only","Export resource information for all resources to Microsoft Project or other third-party applications","Microsoft Project MPX","Project","Export project information to Microsoft Project","XLSX","Activities","Export activity information to Microsoft Excel","XLSX","Activity Relationships","Export activity relationships, such as predecessor and successor IDs, to Microsoft Excel","XLSX","Expenses","Export activity expense information, such as expense item and activity ID, to Microsoft Excel","XLSX","Resources","Export resource information to Microsoft Excel","XLSX","Resource Assignments","Export resource assignment information to Microsoft Excel","UN/CEFACT XML","Project","Export project information in the Integrated Master Schedule (IMS) schema","IPMDAR","Project and Resource Assignments","Export project and resource assignment information to a collection of JSON files.","CPP","Projects and Resource Assignments","Export project, calendar, and resource assignment information to a collection of JSON files.","Note","MPX/Microsoft Project XML/ XLSX formats do not support your complete set of project information.","When P6 Professional is connected to a P6 EPPM database: For information about the tables and fields that are converted, see the P6 EPPM Import/Export Data Map Guides.","When P6 Professional is connected to a P6 Professional database: For information about the tables and fields that are converted, see the P6 Professional Import/Export Data Map Guides.","Exporting information using a wizard","exporting_information_using_a_wizard.htm");
Page[7]=new Array("If your Administrator has set up integration between P6 EPPM and Oracle Primavera Cloud, you can exchange data with Oracle Primavera Cloud for risk, task, work package, and scope integration.","To send data to Oracle Primavera Cloud:","Open the project or projects that you want to exchange with Oracle Primavera Cloud.","Select Exchange Data from the File Menu, and then select the menu option for sending data to Oracle Primavera Cloud.","To update the projects from Oracle Primavera Cloud:","Open the project or projects that you want to exchange with Oracle Primavera Cloud.","Select Exchange Data from the File Menu, and then select the menu option for updating data from Oracle Primavera Cloud.","Note","You must have the Exchange Project Data with Oracle Primavera Cloud privilege set in P6 and P6 EPPM must be configured for integration with Oracle Primavera Cloud.","The process for updating from Oracle Primavera Cloud updates the WBS structure, including work packages for scope integration. This option also updates pre response and post response pessimistic dates for activities based on risk analysis in Oracle Primavera Cloud, even though you cannot see them in P6 Professional.","Do not modify the WBS structure, including WBS names and codes, once a project has been integrated with Oracle Primavera Cloud for scope management. Do not move activities between WBS nodes once a project has been integrated with Oracle Primavera Cloud for scope management","Exchanging data with Oracle Primavera Cloud using Primavera Gateway (P6 EPPM Only)","88654.htm");
Page[8]=new Array("Follow the steps below to export a project to an XER file that can be imported by other P6 Professional or P6 EPPM users.","Open the projects you want to export.","Choose File, Export.","Choose Primavera PM - (XER).","Select the appropriate version from the pull-down menu. Click Next.","Choose Project.","Click Next.","Mark the Export checkbox for all projects you want to export.","Type the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Tip","If you want to make backup copies of a project, export the project as an XER file (the Oracle proprietary format) then store the export file.","When connected to a P6 Professional database: You can set up a job service to export your projects at a specified time. ","You can export or import projects as a service through the command line.","Note","If you export multiple projects in a single XER file, the interproject relationships between activities in the projects are preserved.","You can also export a project to an XER file and automatically email the file to another P6 Professional user. Choose File, Send Project. ","When you export a project containing financial period performance data, only financial periods containing values for that project are exported. The module will not export all financial periods in the Financial Period dictionary. ","If you are exporting a project that you previously imported; and, that project contains relationships to external projects that do not exist in your database; and, you scheduled the project; be sure that you scheduled the project with the Ignore Relationships To and From Other Projects option selected (in the Schedule Options dialog box). If you select this option when scheduling the project, the module will preserve the external activity dates.","When connected to a P6 EPPM database: No risk data is exported when using XER format. Risk Categories are part of global data and are exported when using XER format.","Export projects to an XER file","export_projects_to_an_xer_file.htm");
Page[9]=new Array("Choose File, Import.","Choose Primavera PM (XER). Click Next.","Choose Project.","Select the file you want to import.","Double click the Import Action field to select how the project data is imported, then specify where to import the projects in the Import To field.<br /><br />Select Update Existing Project to add any new/modified data in the XER file to an existing project.<br /><br />Selected Create New Project to create a new project while the existing project's data remains the same. <br /><br />Select Replace Existing Project to delete the existing project and replace it with the project imported from the XER file.<br /><br />Select Add Into Existing Project to create a new WBS node in the project and import all data from the XER file under that new WBS node.<br />","Choose the data to import by modifying the layout configuration in the Update Project Options dialog box (if necessary).<br /><br />In the Modify Import Configuration dialog box, select the data you want to modify. If resource security is enabled, some restrictions apply when importing activity resource assignments. <br /><br />Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data (that is, data in the project you are updating but is not included in the import file) from the project. (The Delete field applies only to relationships to external projects, thresholds, activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.)","Select the currency in which to import cost fields.(This dialog box only displays if the import file does not specify a currency, or if the currency does not match a currency defined in P6 Professional when P6 Professional is connected to a P6 Professional database and using P6 when connected to a P6 EPPM database.)","Click Finish.","Click Close.","Note","P6 and P6 Professional handle the import of XER files slightly differently.The XML import options in P6 have a few extra options when compared to the XML import options in P6 Professional (Document Categories, Document Statuses, Locations, and WP and Docs). However the import options for XER files in P6 Professional allow less configuration than the XML import options. Also, in P6 Professional only users with the Admin Superuser global security profile or Project Superuser project security profile can import projects, whereas any user with the appropriate permissions can import projects in P6.","You can import an XER file from a compressed file in .zip format if the zip file contains only a single XER file.","When you import an XER project file that contains financial periods, the financial periods in the XER file must exactly match the financial periods in the financial period calendar assigned to the project. If they do not match, no past period actual data will be imported. ","When selecting the import action, you must select the Create New Project option if you want P6 Professional to import past period actual data. If you choose any other option, past period actual values are not imported.","For projects containing WBS Summary tasks, you should not choose to delete unreferenced data (Step 6 above). If you choose to delete unreferenced data, all WBS Summary tasks will be deleted.","When you import a project that contains relationships to external projects that do not exist in your database, the module will preserve the external activity dates when you schedule the project if you select the Ignore Relationships To and From Other Projects option in the Schedule Options dialog box.","If you manually plan future period distribution for resource/role assignments to activities, be sure to select the appropriate import action when importing data; otherwise, manual future period assignment values may be assigned. For example, if you are updating an existing project with imported data and you choose to import activity resource assignments, future period assignment values that exist in the project you are importing will overwrite future period assignment values in the project you are updating. Therefore, if the project you are importing does not contain manual future period assignment values and the project you are updating does contain manual future period assignment values, the manual future period values will be lost when the same assignment exists in both projects. ","The following applies only when you choose Update Existing as the Resource import action: When you import a shared resource calendar and a personal resource calendar with the same name already exists in the database, the data from the shared calendar updates the personal resource calendar by the same name, but the personal resource calendar remains a personal resource calendar. Likewise, when you import a personal resource calendar and a shared resource calendar with the same name already exists in the database, the data from the personal resource calendar updates the shared resource calendar by the same name, but the shared resource calendar remains a shared resource calendar. ","The following applies when you choose Keep Existing as the Resource import action: Subsequent to the import, there may be unassigned personal resource calendars; these calendars can be deleted.","When connected to a P6 EPPM database: No risk data is imported when using XER format. Risk Categories are part of global data and are imported when using XER format.","When connected to a P6 EPPM database: The following applies only when you import an XER to an R8.0 application (or earlier) from an R8.1 application: If more than one issue has the same name and is assigned to different activities within the same WBS, the import occurs without error and the issue names are kept the same. However, the rule applicable to version R8.0 and earlier that issue names must be unique for issues assigned to activities within a WBS would subsequently apply. This means, for example, that you would not be allowed to change the name of one of the issues and then change it back to its original name. Doing so would cause the application to issue a message that the issue name must be unique.","Import projects in XER format","import_projects_in_xer_format.htm");
Page[10]=new Array("In the email containing the XER project, double-click the attached XER file.","The module opens automatically (if not already open) and launches the Import wizard. The file name is automatically populated in the wizard. ","In the Import Wizard, click Next.","Double click the Import Action field to select how the project data is imported, then specify where to import the project in the Import To field.","Choose the data to import by modifying the layout configuration in the Update Project Options dialog box (if necessary).","In the Modify Import Configuration dialog box, select the data you want to modify. Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data (data in the project you are updating but is not included in the import file) from the project. (The Delete field applies only to activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.) Click OK.","Select the currency in which to import cost fields. (This dialog box only displays if the import file does not specify a currency, or if the currency does not match a currency defined in the application.)","Click Finish.","Click Close.","Import an XER email attachment","import_an_xer_email_attachment.htm");
Page[11]=new Array("Open the project you want to export and email.","Choose File, Send Project.<br /><br />The application creates an XER export file, automatically opens your email system, and attaches the XER file to the body of the email message. The subject line of the email is automatically populated with the name of the project.<br />","Enter the email address and send the email.","Note","If an email system is not present on your computer, the application will launch the Create a Mail Profile wizard. You can choose to create a mail profile, or click Cancel to exit. If you click Cancel, you cannot email the XER file; the file will remain in your local Temp directory.","This feature applies to XER files only.","Export and email an XER project","export_and_email_an_xer_project.htm");
Page[12]=new Array("Follow the steps below to export resources to an XER file that can be imported by other P6 Professional users.","Choose File, Export.","Choose Primavera PM - (XER).","From the pull-down menu, select the appropriate version. Click Next.","Choose Resource Only. Click Next.","Type or select the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Export resources to an XER file","export_resources.htm");
Page[13]=new Array("Choose File, Import.","Choose Primavera PM - (XER). Click Next.","Choose Resource Only. Click Next.","Select the file you want to import. Click Next.","Select how to import the resource data by modifying the layout configuration in the Update Resource Options dialog box (if necessary).<br /><br />In the Modify Import Configuration dialog box, select the data you want to modify. If resource security is enabled, some restrictions apply when importing resources.  <br /><br />Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data, data in the project you are updating but is not included in the import file, from the project. (The Delete field applies only to relationships to external projects, thresholds, activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.) Click OK.<br />","Click Next in the Update Resource Options dialog box.","Optional: If the import files specify a currency, or if a selected currency does not match P6 Professional definitions, select the currency in which to import cost fields.","Click Finish.","Click Close.","Note","You can import an XER file from a compressed file in .zip format if the zip file contains only a single XER file.","Import resources from an XER file","import_resources_from_an_xer_file.htm");
Page[14]=new Array("Choose File, Export.","Choose Primavera PM - (XER).","From the pull-down menu, select the appropriate version. Click Next.","Choose Role Only. Click Next.","Type or select the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Export roles to an XER file","export_roles_to_an_xer_file.htm");
Page[15]=new Array("Choose File, Import.","Choose Primavera PM - (XER). Click Next.","Choose Role Only. Click Next.","Select the export file you want to import.","Select how you want the role information imported by modifying the layout configuration selected in the Update Role Options dialog box (if necessary).<br /><br />In the Modify Import Configuration dialog box, select the data you want to modify. Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data, data in the project you are updating but is not included in the import file, from the project. (The Delete field applies only to relationships to external projects, thresholds, activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.) Click OK.","Select the currency in which to import cost fields.(This dialog box only displays if the import file does not specify a currency, or if the currency does not match a currency defined in P6 Professional when P6 Professional is connected to a P6 Professional database and using P6 when connected to a P6 EPPM database.)","Click Finish.","Click Close.","Note","You can import an XER file from a compressed file in .zip format if the zip file contains only a single XER file.","Import roles from an XER file","import_roles_from_an_xer_file.htm");
Page[16]=new Array("You can use the Windows command line interface to export projects in XER format as a service.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","To use the Windows command line interface to export projects as a service, do the following:","Using an XML editor, or any program that can save files as XML files, create an actions.xml file that specifies the project or projects you want to export.","You can specify more than one action in a single file, by including multiple &lt;action&gt; nodes.","The following is a sample actions.xml file that drives the run of exporting one project. All tags must appear in the file; however, you can leave some tags empty, as noted below. Values in bold are literal values you must enter as shown. The other values are samples that will vary with your configuration.","&lt;actions&gt;","   &lt;action&gt;","     &lt;type&gt;export&lt;/type&gt;","     &lt;Projects&gt;","           &lt;ProjectID&gt;Highway Project &lt;/ProjectID&gt;","     &lt;/Projects&gt;","   &lt;outputFile&gt;C:\\HighwayProjectExport.xer&lt;/outputFile&gt;","   &lt;/action&gt;","   &lt;/actions&gt;","Tag","Description","&lt;type&gt;","Required. The type of action to take. For project exporting, type is export. Note that export is case sensitive.","&lt;Project ID&gt;","Required. Specify one or more valid project IDs. (Do not enter an EPS ID.) You can specify multiple project IDs by specifying a list of projects separately, each with a separate tag on its own line, such as shown below:","           &lt;ProjectID&gt;Highway Project &lt;/ProjectID&gt;","           &lt;ProjectID&gt;RSCD&lt;/ProjectID&gt;","&lt;outputFile&gt;","Required. Must be set to a valid path and filename, for example, to C:\\HighwayProjectExport.xer.","Note","If you include non-English characters in the actions.xml file, save the file as Unicode and use the XML encoding attribute to specify the language, prior to the &lt;actions&gt; tag. For example, to specify German or French encoding:","&lt;?xml version=&quot;1.0&quot; encoding=&quot;windows-1252&quot;?&gt;","If you are using a batch file, use the chcp command to specify the appropriate language encoding. See Microsoft.com for more internationalization details.","Close P6 Professional if it is running.","On the Windows command line, a batch file, or code, issue a command in the following form from the folder where Primavera.CacheService.exe is located:","Primavera.CacheService.exe /username=&lt;name&gt; /password=&lt;name&gt; /alias=&lt;name&gt; /actionScript=&lt;path&gt; /pmlogfile=&lt;path&gt;","Parameter","Description","/username=&lt;name&gt;","Required. The username to log in to P6 Professional.","/password=&lt;name&gt;","The password for the username, if there is one for the username.","/alias=&lt;name&gt;","Optional. The name of an existing destination database alias. If you do not specify an alias, the most recently accessed alias is used.","/actionScript=&lt;path&gt;","Required. The full path to the edited actions.xml file. You must include the file name.","/pmlogfile=&lt;path&gt;","Optional. The full path for creating the log file that contains processing results. You must include the file name. If the logfile is not set, the default log file destination is PrimaveraCmdLineLog.txt in the Primavera.CacheService.exe application folder.","For example:","Primavera.CacheService.exe /username=ResnerW /password=59djxJQx /alias=PMDB /actionScript=actions.xml /pmlogfile=c:\\exportProjectLog.txt","If any values include spaces, enclose the value in double quotes(&quot;).","If the export runs successfully, then an exit code of 0 is returned; if any errors are logged to the log file, an exit code greater than 0 is issued, which indicates failure.","Processing results are written to the log file, or you can echo them to the command line interface. These are the possible results:","Code","Description","0","Success.","1","Invalid alias.","2","Invalid username or password.","3","XML file not found.","4","Invalid action type (you did not specify export).","9","Export action failure.","214783647","Unhandled exception, including invalid characters.","If the command does not include all the required parameters, P6 Professional opens.","Note","If you export multiple projects in a single XER file, the interproject relationships between activities in the projects are preserved.","When you export a project containing financial period performance data, only financial periods containing values for that project are exported. The module will not export all financial periods in the Financial Period dictionary. ","When connected to a P6 Professional database: See Financial periods dialog.","If you are exporting a project that you previously imported; and, that project contains relationships to external projects that do not exist in your database; and, you scheduled the project; be sure that you scheduled the project with the Ignore Relationships To and From Other Projects option selected (in the Schedule Options dialog box). If you select this option when scheduling the project, the module will preserve the external activity dates.","When connected to a P6 EPPM database: No risk data is exported when using XER format. Risk Categories are part of global data and are exported when using XER format.","Export projects from the command line","45050.htm");
Page[17]=new Array("You can use the Windows command line interface to import projects in XER format, which also enables you to do so from a batch file or programmatically.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","To use the Windows command line interface to import an XER file, do the following:","Using an XML editor, or any program that can save files as XML files, create an actions.xml file that specifies the EPS you want to import the project to, the layout you want to use, and the XER file you want to import from.","You can specify more than one import action in a single file by including multiple &lt;action&gt; nodes.","The following is a sample actions.xml file that imports 2 XER files from the same script. All tags must appear in the file; however, you can leave some tags empty, as noted below. Values in bold are literal values you must enter as is. Values in italics are samples that will vary with your configuration.","&lt;actions&gt;","   &lt;action&gt;","      &lt;type&gt;import&lt;/type&gt;","      &lt;importFormat&gt;XER&lt;/importFormat&gt;","      &lt;importType&gt;PROJECT&lt;/importType&gt;","      &lt;importAction&gt;CREATE&lt;/importAction&gt;","      &lt;importTo&gt;EPS1&lt;/importTo&gt;","      &lt;importConfiguration&gt;MyConfig1&lt;/importConfiguration&gt;","      &lt;importFile&gt;c:\\projects.xer&lt;/importFile&gt;","   &lt;/action&gt;","   &lt;action&gt;","      &lt;type&gt;import&lt;/type&gt;","      &lt;importFormat&gt;XER&lt;/importFormat&gt;","      &lt;importType&gt;PROJECT&lt;/importType&gt;","      &lt;importAction&gt;CREATE&lt;/importAction&gt;","      &lt;importTo&gt;EPS2&lt;/importTo&gt;","      &lt;importConfiguration&gt;MyConfig2&lt;/importConfiguration&gt;","      &lt;importFile&gt;c:\\projects2.xer&lt;/importFile&gt;","   &lt;/action&gt;","&lt;/actions&gt;","Tag","Description","&lt;type&gt;","Required. The type of action to take. For project importing, type is import. Note that import is case sensitive.","&lt;importFormat&gt;","Required. The format being imported. Value must be XER.","&lt;importType&gt;","Required. The type data being imported. Value must be PROJECT.","&lt;importAction&gt;","Required. The action to take while importing. Value must be CREATE.","&lt;importTo&gt;","Optional. The short name of the EPS element you are importing to. This name must exist in the destination database. If you do not provide a name, the default EPS is used.","&lt;importConfiguration&gt;","Optional. The import configuration to use while importing. This name must exist in the destination database. If you do not provide a name, the default import configuration used.","&lt;importFile&gt;","Required. The full path to the XER file you want to import.","Note","If you include non-English characters in the actions.xml file, save the file as Unicode and use the XML encoding attribute to specify the language, prior to the &lt;actions&gt; tag. For example, to specify German or French encoding:","&lt;?xml version=&quot;1.0&quot; encoding=&quot;windows-1252&quot;?&gt;","If you are using a batch file, use the chcp command to specify the appropriate language encoding. See Microsoft.com for more internationalization details.","Close P6 Professional if it is running.","On the Windows command line, a batch file, or code, issue a command in the following form from the folder where Primavera.CacheService.exe is located:","Primavera.CacheService.exe /username=&lt;name&gt; /password=&lt;name&gt; /alias=&lt;name&gt; /actionScript=&lt;path&gt; /pmlogfile=&lt;path&gt;","Parameter","Description","/username=&lt;name&gt;","Required. The username to log in to P6 Professional.","/password=&lt;name&gt;","The password for the username, if there is one for the username.","/alias=&lt;name&gt;","Optional. The name of an existing destination database alias. If you do not specify an alias, the most recently accessed alias is used.","/actionScript=&lt;path&gt;","The full path to the actions.xml file you created. You must include the file name.","/pmlogfile=&lt;path&gt;","Optional. The full path for creating the log file that contains processing results. You must include the file name. If the logfile is not set, the default log file destination is PrimaveraCmdLineLog.txt in the Primavera.CacheService.exe application folder.","For example:","Primavera.CacheService.exe /username=ResnerW /password=59djxJQx /alias=PMDB /actionScript=c:\\imports\\importprojects.xml /pmlogfile=c:\\imports\\ImportProjectLog.txt","If any values include spaces, enclose the value in double quotes(&quot;). For example:","Primavera.CacheService.exe /username=ResnerW /password=59djxJQx /alias=PMDB /actionScript=&quot;c:\\project imports\\importprojects.xml&quot; /pmlogfile=&quot;c:\\project imports\\Import Project Log.txt&quot;","If the import runs successfully, then an exit code of 0 is returned; if any errors are logged to the log file, an exit code greater than 0 is issued, which indicates failure.","Processing results are written to the log file, or you can echo them to the command line interface. These are the possible results:","Code","Description","0","Success.","1","Invalid alias.","2","Invalid username or password.","3","XML file not found.","4","Invalid action type (you did not specify CREATE).","5","Insufficient security privileges.","6","Failure while processing the import action. Could include invalid or missing values in the xml file.","214783647","Unhandled exception, including invalid characters.","If the command does not include all the required parameters, P6 Professional opens.","Note","When you import projects with the command line interface, you can create only new projects, you cannot update an existing project.","If there are multiple projects in an XER file, they are created under the same EPS when you use the command line interface.","You cannot filter out specific projects within an XER file.","When connected to a P6 EPPM database: No risk data is imported when using XER format. Risk Categories are part of global data and are imported when using XER format.","Import projects from the command line","49709.htm");
Page[18]=new Array("Follow the steps below to export projects to an XML file that can be imported by other P6 Professional users.","Open the project(s) you want to export.","Choose File, Export.","Choose Primavera P6 - (XML). Click Next.","Double click the Baselines to Export field.","In the Baselines to Export dialog box, mark the Export checkbox next to each baseline you want to export, then click OK.","Select the &quot;Export XML file to a compressed file&quot; option if you want to export the XML file to a zip. If you select to export project layouts, these files will also be included in the zip.","Clear the option to &quot;Export all project level layouts&quot; if you do not need to include project level layouts with the export file.","Click Finish.","Click Close.","Note","When connected to a P6 EPPM database, your administrator must enter the URL of the content repository into the P6 URL field on the General page of Application Settings in P6.","You can export multiple projects to a single XML file.","Global data that is assigned to the project is exported.","If you are exporting a project that you previously imported; and, that project contains relationships to external projects that do not exist in your database; and, you scheduled the project; be sure that you scheduled the project with the Ignore Relationships To and From Other Projects option selected (in the Schedule Options dialog box). If you select this option when scheduling the project, the module will preserve the external activity dates.","Manual future period buckets are exported when you export a project to an XML file.","XML files exported from PM version 7.0 and later can not be imported into PM version 6.1 and earlier.","You can export XML files without having access to all resources, but the following applies if you export XML files without having access to all resources:","If you export projects with resources that are outside of your access hierarchy, data that is exported will be limited since not all resources in the project can be loaded from the dictionary.","Export a project to an XML file","export_a_project_to_an_xml_file.htm");
Page[19]=new Array("Choose File, Import.","Choose Primavera P6 - (XML). Click Next.","Select the file you want to import. Clear the option &quot;Import all project level layouts&quot; if you do not need them to be included with the project. Click Next.","Click the Import Action field and use the drop-down menu to choose how the project data is imported.<br /><br />Select Update Existing Project to add any new or modified data in the XML file to an open project.<br /><br />Select Create New Project to create a new project without changing existing projects. <br /><br />Select Ignore this Project to not import the selected projects. ","When P6 Professional is connected to an EPPM database, click the Currencies import in field and use the drop-down menu to choose how currencies are imported.","Select Base Rate to import cost data in the base rate for your database. Choose this option if you do not want costs to be converted using the exchange rates in the XML file and your database.","Select XML Rate to import cost data and convert it using the exchange rate in the XML file and your database. Choose this option if you want cost to be converted to account for differences in the exchange rate between the originating database for the XML file and your database.","Double click the Import To field and specify where to import the project.","Double click the Baselines to Import field. In the Baselines to Import dialog box, mark the Import checkbox next to each baseline you want to import. Click OK, then click Next.","Note If you select to import with the update existing option and you select to import baselines, matching baselines will be updated with the data from the XML file according to the options in the selected template. Baselines you choose to import but which do not have a match in your database against the project you selected to update will be added to the project.","If you chose to create a new project, double click the Financial Period Calendar Field. In the Select Financial Period Calendar box, select an appropriate financial period calendar (if necessary).","Choose the data to import by adding or editing a template in the Update Project Options dialog box (if necessary).<br /><br />In the Update Project Options dialog box, you can search for templates using the Search field. As you type, it will filter only those templates that match the text in this field.","Click Edit to launch the Import Options dialog box.","On the Basic tab of the Import Options dialog box, modify the selected option by choosing the action to take when the same data exists in the import file and the project being updated. If resource security is enabled, some restrictions apply when importing activity resource assignments. <br /><br />Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data (that is, data in the project you are updating but is not included in the import file) from the project. (The Delete field applies only to relationships to external projects, thresholds, activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.)","On the Advanced tab of the Import Options dialog box, modify global data, including codes, UDFs, calendars, and resources, as necessary. ","Note This tab is disabled if multiple projects are being imported. However, if you select the &quot;Ignore this Project&quot; option for all projects but one, this tab is enabled.","Click Save to update the existing template or click Save As to create a new template with a unique name. Click Next. ","Click Finish.<br />","Note","You can import a compressed file in zip format if it contains a single Primavera XML file.","When you import an XER project file that contains financial periods, the financial periods in the XER file must exactly match the financial periods in the financial period calendar assigned to the project. If they do not match, no past period actual data will be imported.","When you import a project that contains relationships to external projects that do not exist in your database, the module will preserve the external activity dates when you schedule the project if you select the Ignore Relationships To and From Other Projects option in the Schedule Options dialog box.","The following applies only when you choose Update Existing as the Resource import action: When you import a shared resource calendar and a personal resource calendar with the same name already exists in the database, the data from the shared calendar updates the personal resource calendar by the same name, but the personal resource calendar remains a personal resource calendar. Likewise, when you import a personal resource calendar and a shared resource calendar with the same name already exists in the database, the data from the personal resource calendar updates the shared resource calendar by the same name, but the shared resource calendar remains a shared resource calendar. ","Subsequent to the import, there may be unassigned personal resource calendars depending on the import action you selected for resources and calendars during the import operation; these calendars can be deleted.","To import an XML file that contains updates to your personal resource calendar, you must have the Add/Edit/Delete Resource Calendars privilege. Otherwise any updates to your personal resource calendar are not imported.","When connected to a P6 EPPM database: Risk data from P6 is imported when using XML format.","When connected to a P6 Professional database: Risk data is imported when using XML format.","You can import XML files without having access to all resources, but the following restrictions apply: ","If the XML file contains resources that are in your hierarchy, these will be imported. ","If the XML file contains new resources, these will be imported as long as the new resources are in your hierarchy.","You can choose to not import any new resources by choosing the &#8220;Do Not Import&#8221; option for Resources. Choosing the &#8220;Do Not Import&#8221; option for Resources causes the system to import the assignments of any existing resources in your hierarchy.  In this case, any new resources in the XML file are ignored by the importer.","If the XML file contains resources that are not in your hierarchy, no items are imported. The system cancels the entire import process and issues an error. ","If the XML file contains resources in your hierarchy that are in conflict with existing resources outside of your hierarchy in the database, no items are imported. The system cancels the entire import process and issues an error.","When connected to a P6 EPPM database: For more information on defining access to resources, see the P6 EPPM Application Administration Guide.","When connected to a P6 Professional database: For more information on defining access to resources, see the P6 Professional Installation and Configuration Guide.","When connected to a P6 EPPM database: If the currency stored in the XML file matches a currency in your database, you can select whether to import financial data using the base currency in your database or the currency present in the XML file. If you chose to use the XML rate, financial data is converted as follows:","Cost imported = Cost in XML file * (Exchange rate in XML file / Exchange rate of the matching currency in your database)","For example:","Michelle Peterson in the London office exports a project to a Primavera XML file and sends the project file to her colleague Judy Billings in the Paris office. The XML file that Michelle generates, contains information about the view currency Michelle used and its exchange rate with the base currency in her database. When Judy receives the file, she imports it into her database using the option to import with the XML rate.","Michelle's view currency is GB Pounds () and the base currency in her database is US Dollars ($). The exchange rate between GB Pounds and the base currency in Michelle's database is 0.79. Judy's database has a base currency of Euros (), and the exchange rate between GB Pounds () and the base currency is 0.88.","Costs are always stored in units of the base currency of the database. So to import the correct value in GB Pounds, P6 converts the costs in the XML file by multiplying by the exchange rate for GB Pounds in the XML file divided by the exchange rate for GB Pounds in Judy's database.","In Michelle's database, Activity A1000 has a planned cost of 1,000. The cost is stored in the database in the base currency of US Dollars as $1,265.82. The Primavera XML file contains the cost of the activity in the base units as well as information about the ID, name, and exchange rate for GB Pounds in Michelle's database. When Judy imports the file, P6 converts the cost of Activity A1000 as follows:","$1,265.82  (XML exchange rate / destination exchange rate)","= $1,265.82  (0.79 / 0.88) = 1,136.36","When Judy changes her view currency to GB Pounds (), the value stored in the database is converted to the view currency by multiplying by the exchange rate for the view currency, so:","1,136.36  0.88 = 1000.00","Import a project in XML format","import_a_project_in_xml_format.htm");
Page[20]=new Array("To delete project data using Microsoft Excel, place a 'D' or ' d' in the Delete This Row column for the selected row in the worksheet. When importing, the information included in the deleted row will be removed from the project.","Note","Deleting an activity will delete all records related to the activity including issues, resource assignments, relationships, and activity codes.","Delete data in the XLSX file","delete_data_in_the_xls_file.htm");
Page[21]=new Array("Do the following to change the value of a unique field in the exported file. ","In Excel, choose Edit, Copy to copy the row you want to update.","Choose Edit, Paste to add a copy of the row to the Excel sheet.","Modify the value for the field you want to update in the new row.","Type &#8216; d' or &#8216;D' in the &#8216;Delete this row' column in the original row to delete the old activity. The Delete column is the last column in the Excel sheet.","Note","To modify the Activity ID of an activity, you must first delete the activity. Deleting an activity will delete all records related to the activity, including issues, assignments, relationships, and activity codes. ","The table below lists the unique fields for each subject area.","Subject Area","Column(s)","Activities","Activity ID","Activity Relationships","Successor, Predecessor, Relationship Type","Expenses","Activity ID, Expense Item","Resource Assignments","Activity ID, Resource ID, Role ID, Cost Account ID","Modify Unique Fields in the XLSX file","modify_unique_fields_in_the_xls_file.htm");
Page[22]=new Array("When importing data items from Microsoft Excel, the column headers in the XLSX file must match the data item names in P6 Professional. An activity row must include an Activity ID to successfully import into P6 Professional. If not, an error message is written to the log file, PRM_XLSIMPORT.TXT, located in the user's Temp directory.","Click on a subject area to view its general rules for importing successfully.","General","To successfully import information, each subject area should be updated in its own sheet. ","To import successfully, you should not change the language set in P6 Professional. For example, if the text in the export file is in English, the updates you want to import should be in English also.","If you change the sheet name, you will not be able to import its subject area into P6 Professional. ","If you choose to import a column with a field name that does not match the field name in P6 Professional, the column will not import and this action is recorded in the log file as an error. The field names are located in the first row of an export file. You can change the captions of each column in the second row of the worksheet.","The order of the columns in the import file is not relevant. Data from a column in a file will be imported even if that column is not visible in your current view.","If an item does not exist in the dictionary of the project to which you are importing, then Import will not add that item. For example, if you assign a new code or resource to an activity, and that code or resource is not in the existing Activity Code or Resource dictionary, then import will not add it to the dictionary. This is recorded in the import log file. This applies to resources, roles, activity codes and values, calendars, cost accounts, WBS, resource codes and values.","If an EPS-level code assignment exists on a project that is imported into a different EPS that does not include the code, then the code and its values are converted to a project-level activity code and the code assignments are preserved. ","WBS","If you modify the WBS for an activity, Import adds the activity to the WBS level if the WBS level exists in P6 Professional. ","If a specified WBS does not exist in P6 Professional, but the parent WBS does exist, then Import adds the activity to the parent WBS and record this action in the import log file. For example, if you have an activity and add ProjectB.A.1.01 as its WBS, if this node does not exist, Import adds the activity to ProjectB.A.1. ","If a specified WBS for an activity does not exist in P6 Professional, and the parent WBS does not exist, then the activity will not import successfully. An error message is recorded in the import log file.","Resource/Role Assignments","If you change the value of a unique field, P6 Professional adds a new value to the project. For example, if you change the Activity ID for resource assignments, Import keeps the original assignment and adds a duplicate assignment with the new Activity ID.","Dates","The date format used to export dates to Excel is a text field. When editing the date fields in Excel, the format is based on the date format selected in Excel.","When importing, the project planned start date uses the data date as its value. The planned dates cannot be modified.","Dates are imported based on the date format selected in P6 Professional (Edit, User Preferences, Dates tab).","Duration and Units","The format used to display durations and units is based on the preferences set in P6 Professional (Edit, User Preferences, Time Units tab).","Export does not support sub-units as a time format. Make sure the sub-unit checkboxes are clear in the Edit, User Preferences, Time Units tab.","When connected to a P6 Professional database: If the planned duration for activities is null in the export file, the default activity duration (Admin, Admin Preferences, General tab) is used during import.","When connected to a P6 EPPM database: If the planned duration for activities is null in the export file, the default activity duration, defined using P6, is used during import.","Percent Complete","The percentage value must be between 0 and 100. If the value is between 0 and 100, P6 Professional recognizes that value as a percentage. For example, if the value in the import file is 5, the value is imported as 5%.","Cost","The currency symbol type exported is based on the setting defined in Edit, User Preferences, Currency tab.","Note","To import data from an XLSX file, you must be logged in as a user with the Import XLSX global privilege.","To successfully import data, do not edit the USERDATA sheet in the export file. Use this sheet as a reference for the user preference settings (Edit, User Preferences).","To ensure data integrity, you should only import user-defined fields (UDFs) into the same P6 Professional or P6 EPPM database from which the data was exported. If you import UDFs into a different database, make sure the P6 Professional or P6 EPPM databases have identical UDF dictionaries.","Do not remove, edit, or enter null values for unique fields. These fields are necessary to import data successfully. ","P6 Professional ignores financial period (past period actual) columns when importing XLSX files.","Modifying and importing data from an XLSX file","modifying_data_in_an_xls_file.htm");
Page[23]=new Array("Open the projects you want to export.","Choose File, Export.","Choose Spreadsheet - (XLSX).","Select the subject area(s) you want to export.","Mark the checkbox for the project from which you want to export its data. If exporting resources only, you will skip this step in the wizard.","Add, modify, or select a template that specifies the fields you want to export. You can create a filter to export only a portion of the activities in the project. In the template, select each subject area from the dropdown list to modify its columns, filter, and sort information. Click OK.<br /><br />The export file will use the default template for the selected subject areas if you do not add a new one.<br />","Type or select the name of the export file and the location where the file will be saved. If you have selected more than one subject area to export, each subject area will appear in a separate worksheet in the same spreadsheet file.","Click Finish.","Click Close.","Note","You can right-click in the Activity Table in the Activities window and select Export to Excel to instantly export activity data for the open project.","Export does not support sub-units as unit and duration formats. Make sure the Sub-unit checkbox is cleared in the Edit, User Preferences, Time Units tab.","To successfully import information, you must update each subject area in its own sheet in the export file.","The first row in the export file lists the field name for each column. Do not edit these fields; they are necessary for importing. You can edit the caption in the second row of the export file. However, caption changes are ignored during import.","When selecting the fields to export with each subject area in the template, required fields cannot be removed from the selected options list.","If you change the sheet name in the export file, you will not be able to import its data into P6 Professional. ","You can export financial period (past period actual) data to an XLSX file; however, past period actual data is ignored when you import an XLSX file to P6 Professional.","When you export resource assignments to an XLSX file, only the lowest level of cost accounts associated with resource assignments is exported to the XLSX file. For example, assume your cost account hierarchy has a cost account named CA, with a subordinate level named CA.A. If you assign the cost account CA.A to a resource assignment, when you export resource assignments to an XLSX file, the XLSX file displays &quot;A&quot; as the cost account, not &quot;CA.A.&quot; If you then import this XLSX file to the same project in P6 Professional, in some cases, a duplicate resource assignment will be created that lists &quot;A&quot; as the assigned cost account for the duplicate resource assignment.","Export project data and resources to an XLSX file","export_project_data_to_an_xls_file.htm");
Page[24]=new Array("When P6 Professional is connected to a P6 Professional database, this setting is available in the Project Access tab in the Admin, Users dialog box. When P6 Professional is connected to a P6 EPPM database, this setting is available from P6.","Choose File, Import.","Select Spreadsheet - (XLSX). Click Next.","Click the Browse button to select the file you want to import. The subject areas available are based on the export file.","Mark the checkboxes to select the subject areas you want to import.","Click the browse button in the Import To field to select the project in which you want to import. Click Next.","View the summary and click Finish.","Click Close.","Note","To ensure data integrity, you should only import user-defined fields (UDFs) into the same P6 Professional or P6 EPPM database from which the data was exported. If you import UDFs into a different database, make sure the P6 Professional or P6 EPPM databases have identical UDF dictionaries.","The language used in the export file must remain the same, to import successfully. For example, if the text in the export file is in English, the updates you want to import must be in English also.","P6 Professional ignores past period actual (financial period) columns when importing data from XLSX files.","To import data from an XLSX file, you must be logged in as a user with the Import XLSX global privilege.","When you export resource assignments to an XLSX file, only the lowest level of cost accounts associated with resource assignments is exported to the XLSX file. For example, assume your cost account hierarchy has a cost account named CA, with a subordinate level named CA.A. If you assign the cost account CA.A to a resource assignment, when you export resource assignments to an XLSX file, the XLSX file displays &quot;A&quot; as the cost account, not &quot;CA.A.&quot; If you then import this XLSX file to the same project in P6 Professional, in some cases, an additional resource assignment will be created that lists &quot;A&quot; as the assigned cost account for the duplicate resource assignment.","Import project information and resources in XLSX format","import_project_in_xls_format.htm");
Page[25]=new Array("When updating unit, cost, duration, and percent complete fields, you might choose to import one updated field at a time, into P6 Professional. For example, you can export the Activities subject area, and update the activity percent complete and the remaining duration in the export file. When you import, PM updates the activity data. However, to update other activity values related to the remaining duration and percent complete, PM does not know which field was updated first. In PM, you cannot update these fields simultaneously.","To update unit, cost, duration, and percent complete fields","Make a copy of the export file.","In the copied file, update the necessary field for an activity.","In the selected activity row, use the Backspace or Delete key to null the remaining fields that are not unique, and those that are not marked with an asterisk (*). As a result, during import, only the field with the new value updates and PM calculates the other fields as necessary. ","Import the file into the selected project. Repeat these steps for each unit, cost, duration, and percent complete field you want to update.","Update Unit, Cost, Duration, and Percent Complete fields in Excel","modify_units,_costs,_duration,_and_percent_complete_fields.htm");
Page[26]=new Array("You can export activity data to Excel using the right-click menu in the Activity Table. Right-click in the Activity Table and choose Export to Excel. P6 Professional will export the columns displayed in the Activity Table for the open project.","Note","You must choose File, Export to export multiple projects to Microsoft Excel.","You can export baseline fields to Microsoft Excel. ","Export activity data to Excel","export_activity_data_to_excel.htm");
Page[27]=new Array("Open the projects you want to export.","Choose File, Export.","Choose Microsoft Project.","From the pull-down menu, select the type of file to which you want to export. Click Next.","Mark the Export checkbox of all projects you want to export. Double click in the Export File Name field if you want to change the name and location of the Microsoft Project file.","Add a new template or modify the existing template (if necessary). The template contains options for exchanging data with Microsoft Project.","Click Next to review the settings for your export.","Click Finish.","Click Close.","Note","If you are transferring data in XML format, you must map Cost-type custom fields in MSP to Cost-type UDFs in P6 Professional. Likewise, you must map Number-type custom fields in MSP to Number-type UDFs in P6 Professional. If there is a mismatch in the custom mappings you define, you will receive an error during import or export. You can define custom mappings when you create or modify a template in the Modify Template dialog box.","To export manual future period values, you require Microsoft Project 2002 or a more recent version. If you plan to exchange project data containing manual future period assignment values with Microsoft Project, you will achieve the most accurate conversion results using Microsoft Project 2003 or later. ","The MPX file format does not support resource curves. Therefore, if your exported projects contain resource curves or manual future period assignment values, choose a different export file format if you want to retain these values.","When you export project data, secure codes and secure code assignments related to the project are not exported.","P6 Professional does not export past period actual data to Microsoft Project.","Export projects to a Microsoft Project file","export_projects_to_a_microsoft_project_file.htm");
Page[28]=new Array("Choose File, Import.","Choose Microsoft Project.","Select the appropriate format from the drop down menu. Click Next.","If you chose MPX in the previous step, choose Project. Click Next.","Click Select and choose the files you want to import.<br /><br />Type a password for any file that is password protected.<br /><br />Click the Import Action field and use the drop-down menu to choose how the project data is imported. <br /><br />Select Create New Project to create a new project while the existing project's data remains the same.<br /><br />Select Add into Existing Project to append to the selected WBS.<br /><br />Select Replace Existing Project or Update Existing Project to delete an existing open project without preserving information and replace it with the project imported from the Microsoft Project file. ","Double click the Import To field and specify where to import the projects. Click Next.","Add a new template or modify the existing template (if necessary). The template contains options for exchanging data with Microsoft Project. When you finish, click Next.","Perform this step only if you chose Update Existing Project as the import option:<br /><br />In the Update Project Options dialog box, click Modify and choose the data to import by modifying the layout configuration (if necessary).<br /><br />In the Modify Import Configuration dialog box, select the data you want to modify. If resource security is enabled, some restrictions apply when importing activity resource assignments. <br /><br />Select the action to perform during the import process. Mark the Delete checkbox to remove unreferenced data (that is, data in the project you are updating but is not included in the import file) from the project. (The Delete field applies only to relationships to external projects, thresholds, activities, activity relationships, and activity resource assignments. Global data types are not affected by this setting.) Click OK.","Click Next to review the settings for your import.","Click Finish.","Click Close.","Note","You must be an Admin superuser with all resources access to import MSP XML files.","If you are transferring data in XML format, you must map Cost-type custom fields in MSP to Cost-type UDFs in P6 Professional. Likewise, you must map Number-type custom fields in MSP to Number-type UDFs in P6 Professional. If there is a mismatch in the custom mappings you define, you will receive an error during import or export. You can define custom mappings when you create or modify a template in the Modify Template dialog box.","Microsoft Jet 4.0 users should install Service Pack 6. Import errors may occur on computers running Microsoft Jet 4.0 Service Pack 5 or earlier.","If you manually plan future period distribution for resource/role assignments to activities in P6 Professional, here are some import considerations for projects with manual future period assignment values:","Suspend and resume dates in MSP are not honored when imported to P6. When you import an MSP project that has suspend and resume dates, the suspend time is imported as a 0 (zero) bucket value.","The MPX file format does not support time-phased data and therefore does not support manual future period buckets. When you import an MPX file, if you choose the Replace Existing import action and the project you are replacing contains manual future period buckets, all manual buckets will be deleted.","Since ProjectLink was removed from P6 Professional, importing a Microsoft Project XML file that was exported from P6 Professional is not supported.","You must have the Project Superuser security profile to use the Update Existing Project option to update existing P6 Professional projects with MSP.","Import a Microsoft Project file","import_a_microsoft_project_file.htm");
Page[29]=new Array("Choose File, Export.","Choose Microsoft Project.","Select MPX. Click Next.","Choose Resource Only.","Type or select the name of the export file and the location where the file will be saved. Click Next.","Add a new template or modify the existing template (if necessary). The template contains options for exchanging data with Microsoft Project. ","Click Finish.","Click Close.","Export resources to Microsoft Project (supported for MPX format)","export_resources_to_microsoft_project.htm");
Page[30]=new Array("Choose File, Import.","Choose Microsoft Project.","From the pull-down menu, select MPX.","Choose Resource Only.","Select the files you want to import.","Add a new template or modify the existing template (if necessary). The template contains options for exchanging data with Microsoft Project. ","Click Next to review the settings for your import.","Click Finish.","When connected to a P6 Professional database: Click Close.","Note","Microsoft Jet 4.0 users should install Service Pack 6. Import errors may occur on computers running Microsoft Jet 4.0 Service Pack 5 or earlier.","Import resources from a Microsoft Project file (supported for MPX format)","import_resources_from_a_microsoft_project_file.htm");
Page[31]=new Array("You can export a P6 Professional project to XER format, then import the XER project to Oracle Primavera Contractor 5.0 or 6.1 or later. You cannot import an XER file to an earlier version of Oracle Primavera Contractor than 5.0.","Open the project you want to export.","Choose File, Export.","Choose Primavera Contractor - (XER).","Select the appropriate version from the pull-down menu. Click Next.","Choose Project.","Mark the Export checkbox for the project you want to export.<br /><br />You can only select one project.<br />","Type the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Note","While both P6 Professional and Oracle Primavera Contractor can import and export XER files, the formats of the XER files are different. Therefore, when exporting a project for use with Oracle Primavera Contractor, you must select the Primavera Contractor - (XER) option instead of the Primavera PM - (XER) option.","If you are exporting a project that you previously imported; and, that project contains relationships to external projects that do not exist in your database; and, you scheduled the project; be sure that you scheduled the project with the Ignore Relationships To and From Other Projects option selected (in the Schedule Options dialog box). If you select this option when scheduling the project, the module will preserve the external activity dates.","Export a project for use with Oracle Primavera Contractor","export_a_project_for_use_with_oracle_primavera_contractor.htm");
Page[32]=new Array("You can export the resource dictionary in P6 Professional project to XER format, then import the XER file to Oracle Primavera Contractor 5.0 or 6.1 or later. You cannot import an XER file to an earlier version of Oracle Primavera Contractor than 5.0.","Choose File, Export.","Choose Primavera Contractor - (XER).","Select the appropriate version from the pull-down menu. Click Next.","Choose Resource Only. Click Next.","Type or select the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Note","While both P6 Professional and Oracle Primavera Contractor 5.0 or 6.1 or later can import and export XER files, the formats of the XER files are different. Therefore, when exporting resources for use with Oracle Primavera Contractor 5.0 or 6.1 or later, you must select the Primavera Contractor - (XER) option instead of the Primavera PM - (XER) option.","Export resources for use with Oracle Primavera Contractor","export_resources_for_use_with_primavera_contractor.htm");
Page[33]=new Array("Oracle Primavera Contractor does not contain some of the functionality available in P6 Professional. To enable Oracle Primavera Contractor to import an XER file exported from P6 Professional, the following data is contained in the XER file but not imported into Oracle Primavera Contractor:","Budget data","EPS Codes","Financial periods","Funding data","Issues","Issue Codes","Manual future period assignment values","Multiple critical float paths","Past period actuals","Portfolios","Project Codes","Resource Shifts","When connected to a P6 Professional database: Risks","Roles","Thresholds","Work products and documents","Data not exported to Oracle Primavera Contractor","data_not_exported_to_primavera_contractor.htm");
Page[34]=new Array("Open the project you want to export.","Choose File, Export.","Choose UN/CEFACT (XML). Click Next.","Verify that the currently opened project is listed. Click Next.","Add a new template or select an existing template. Click Next.","Type the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Tip","You can only export one project at a time.","Export templates are only available when connected to a P6 EPPM database.","Export projects to a UN/CEFACT (XML) file","66757.htm");
Page[35]=new Array("Choose File, Export.","Choose UN/CEFACT (XML). Click Next.","Verify that an opened project is listed. Click Next.","Click Add","On the General page, enter data into each required field. Required fields are marked with an asterisk.","Optionally enter data into the other fields.","Mark the Export WBS checkbox to export the Work Breakdown Structure with the project.","In the Export OBS field, click to select the structure you want to export as the OBS for the project.","On the Project page, enter data into each required field.","Optionally enter data into the other fields.","Optionally select up to three Project Notes to include. Select a type for the note and select from the Content list to include a Project Notebook topic.","On the Activity page, enter data into each required field on each tab.","Optionally enter data into the other fields.","Click Save.","Note","Export templates are project specific. Open the project that you intend to export before creating an export template for it.","Create an Export Template for UN/CEFACT Export","89425.htm");
Page[36]=new Array("Schedule and summarize the project you want to export.","Open the project you want to export.","Choose File, Export.","Choose IPMDAR. Click Next.","Verify that the currently opened project is listed. Click Next.","Add a new template or select an existing template. Click Next.","Type the name of the export file and the location where the file will be saved.","Click Finish.","Click Close.","Tip","You can only export one project at a time.","The IPMDAR export generates a collection of JSON files which constitute the IPMDAR data.","Export projects to an IPMDAR file","100656.htm");
Page[37]=new Array("Choose File, Export.","Choose IPMDAR. Click Next.","Verify that an opened project is listed. Click Next.","Click Add","On the General page, enter data into each required field. Required fields are marked with an asterisk.","Optionally enter data into the other fields.","On the Project page, select the project codes and project UDFs to export.","On the Activity page, select the fields, activity codes, and activity UDFs to export.","On the Resource page, select the resource codes and resource UDFs to export.","Click Save.","Note","Export templates are project specific. Open the project that you intend to export before creating an export template for it.","Create an Export Template for IPMDAR Export","100657.htm");
Page[38]=new Array("Follow the steps below to export project to a .zip file containing the multiple JSON files that constitute the CPP data. The projects you want to export must be scheduled and summarized.","Open the project you want to export.","Choose File, Export.","Choose CPP Format. Click Next.","Select a project and double click the Baselines to Export field.","In the Select Baseline dialog box, choose Project Baselines or All Projects, select the baseline or project to assign as the baseline and click Assign.","Click Validate to view the validation report.","Repeat steps 4, 5 and 6 for each project you are exporting.","Click Next.","Select a template. Click Finish.","Note","After the export job has been processed, choose Tools, Job Status to download the project files from the Job Status dialog box.","Export a project to a CPP file","102229.htm");
Page[39]=new Array("Choose File, Export.","Choose CPP Format. Click Next.","Select a project. Click Next.","Click Add","In the Template Name box, type a name for the template.","On the Project tab, configure the fields.","On the Schedule tab, configure the unlocked fields.","On the Schedule Logic tab, configure the unlocked fields.","On the Schedule Resources tab, configure the unlocked fields.","On the Schedule EU tab, configure the unlocked fields.","Click OK.","Tip","To export the full path of a code value (that is the path to a code value's place in its hierarchy), in the code value picker, mark the Include code value path option. When this option is selected, each hierarchical level of the path to the code value is separated with a dot. For example, ENG.Elec.Micro.Interface.","Create an Export Template for CPP Export","102440.htm");
var PageCount=40;


/*
Date: 1/6/2026 3:27 PM
Source: EPPM_26_dev
BookID: 98043
PubProduct: PRIMAVERA_P6_PRO
BookTitle: Importing and Exporting Guide
Version: Version 26
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
