'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  1/6/2026 3:29:24 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999,  2026, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to configure consent notices in P6 Professional and how to install multiple versions of P6 Professional.","Audience","Cloud administrators should use this guide.","About This Guide","97654.htm");
Page[2]=new Array("Consent notices inform users how personal information (PI) is collected, processed, stored, and transmitted, along with details related to applicable regulations and policies. Consent notices also alert users that the action they are taking may risk exposing PI. P6 Professional helps you to ensure that you have requested the appropriate consent to collect, process, store, and transmit the PI your organization holds as part of P6 Professional data.","Consent notices should:","be written in clear language which is easy to understand.","provide the right level of detail.","identify the purpose and legal basis for your collection, processing, storage, and transmission of PI.","identify whether data will be transferred to named third parties.","identify PI categories and list the data which will be collected, processed, stored, and transmitted.","About Consent Notices","97647.htm");
Page[3]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact, or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details. For example a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Depending on local data protection laws, organizations may be responsible for ensuring the privacy of PI wherever it is stored, including in backups, locally stored downloads, and data stored in development environments.","As part of P6 EPPM Cloud Services, you may be using an identity domain to manage your user access and entitlements across a number of cloud and on-premises applications and services. If you are using or accessing an identity domain, you are responsible for deleting your details and data from the identity domain environment. You are responsible for retrieving your content in the identity domain during your applicable services period.","About Personal Information","97539.htm");
Page[4]=new Array("Oracle might use cookies for authentication, session management, remembering application behavior preferences and performance characteristics, and to provide documentation support.","Also, Oracle might use cookies to remember your log-in details, collect statistics to optimize site functionality, and deliver marketing based on your interests.","Cookies Usage in P6 Professional","97607.htm");
Page[5]=new Array("Information security and privacy laws can carry heavy penalties and fines for organizations which do not adequately protect PI they gather and store. If these laws apply to your organization, it is your responsibility to configure consent notices before they are required. You should work with your data security and legal teams to determine the wording of the consent notices you will configure in P6 Professional.","If a consent notice is declined, it is your responsibility to take any necessary action. For example, you may be required to ensure that the data is not stored or shared.","Your Responsibilities","97644.htm");
Page[6]=new Array("PI may be visible in multiple areas of P6 Professional, including but not limited to user administration, resource and role administration, assignments, work products and documents, reports, issues, notebooks, risks, user defined fields, codes, calendars, project websites, P6 Visualizer, and timesheets.","PI may be at risk of exposure in multiple areas of P6 Professional, including but not limited to project export, downloaded tables, reports, documents, project websites, API, and log files.","As part of the Primavera Virtual Desktop Cloud Service, you may be using an identity domain to manage your user access and entitlements across a number of cloud and on-premises applications and services. If you are using or accessing an identity domain, you are responsible for deleting your details and data from the identity domain environment. You are responsible for retrieving your content in the identity domain during your applicable services period.","Personal Information (PI) Data in P6 Professional","97643.htm");
Page[7]=new Array("To configure consent notices for P6 Professional, complete the following steps:","Log in to P6 Professional.","Choose Admin, Admin Preferences.","Click the Consent Notice tab.","Select a consent type from the list.","Enter and format the text for the consent notice in the Consent Message area.","Note Work with your data security and legal teams to determine the wording of the consent notice.","Select Enable Consent Notice to allow the notice to be shown to users of the selected consent type.","Continue to configure consent notices for other consent types.","Configuring Consent Notices (P6 Professional Only)","97642.htm");
Page[8]=new Array("You can see the status of consent acceptance for users. You can also email users who have rejected a consent notice, print a list of the users who have accepted, rejected, or not yet responded to consent notices, and reset consent acceptance for all users if there is a need to regain consent.","To audit consent notices for P6 Professional, complete the following steps:","Log in to P6 Professional.","Choose Admin, Admin Preferences.","Click the Status of User Acceptance tab.","Select a consent notice type from the list.","To email users who have rejected or not responded to a consent notice click Email.","To print a list of all users and their consent status click Print.","To reset all users status of this consent notice type, click Forget All User Acceptance.","Auditing Consent Notices (P6 Professional Only)","97641.htm");
Page[9]=new Array("This section describes how to install P6 Professional, P6 Visualizer, and Job Service. Run the Installation Wizard on the client/desktop computers that will be used by project personnel.","Install P6 Professional only after you install and configure the database server. The Setup wizard needs to connect to the database server when installing P6 Professional.","You can download the media pack that contains the installer and all required install files from the Oracle Software Delivery Cloud website at https://edelivery.oracle.com.","Installing P6 Professional","54955.htm");
Page[10]=new Array("Before you install P6 Professional, first install the client software for the database you will be using. The database client software enables the client computer to connect over the network to the database on the server computer.","Database Client Software","7579.htm");
Page[11]=new Array("If your database is installed on Oracle Server, use your Oracle database installer to set up an application user and configure your Oracle Net Services client files to match your network. If you are unfamiliar with this process, contact your database administrator.","Note","If your database is installed on Oracle Server, during P6 Professional installation, use the Oracle EZCONNECT string (//&lt;server name&gt;:&lt;listen port&gt;/&lt;service name&gt;) to connect to the P6 Professional database. If you prefer, you can also use the TNSNAMES file instead of EZCONNECT. The TNSNAMES file is in the Oracle home folder on the client computer, not in a shared location. Reference the TNSPING.EXE location in your path environment variable.","If you plan to launch content repository documents from P6 Professional, you must use the TNSNAMES method. ","Ensure that all clients are configured to use TCP/IP as the default network protocol.","Oracle Server Database Client Software","9062.htm");
Page[12]=new Array("If your database is hosted on Oracle Server or on Oracle Autonomous Database, you must configure client computers to use the Oracle Instant Client.","To configure a client computer for Oracle Instant Client:","Copy Oracle Instant Client to a local drive.","Open the Windows Control Panel and click System.","Click Advanced System Settings.","On the Advanced tab, click Environment Variables.","In the System variables pane, locate the Path variable.","Click Edit.","In the Variable Value field, add the location of the Oracle Instant Client (specified in step 1).","Click OK.","Click OK.","Click OK.","Configuring Client Computers for Oracle Instant Client","32738.htm");
Page[13]=new Array("When you install P6 Professional on a client computer, the Microsoft SQL Server client files necessary to connect to P6 Professional are automatically installed for you. Alternatively, you can use your Microsoft SQL Server installation CD to install the client network utility. If you are unfamiliar with this process, contact your database administrator.","Microsoft SQL Server Database Client Software","9061.htm");
Page[14]=new Array("When you run the Installation Wizard, you are presented with the following installation options: Typical and Advanced.","Use the Typical installation option to install typical components.","Use the Advanced installation option when the Typical option does not apply. For example if you want to control the installation of specific P6 Professional components, such as Visualizer and the P6 Professional Database Tools. ","Before You Begin","Before you run the Installation Wizard, review the following items that may impact a successful installation:","You must have full administrative rights to the computer on which you are installing P6 Professional.","Download and extract (unzip) the software to a folder on the local hard drive, such as C:\\Temp.","Avoid downloading the software too deep within the Windows folder structure. It can limit the file name to 256 characters.","Even though you are running P6 Professional as a standalone, a network interface card or modem must be installed and TCP/IP networking software must be running on the computer.","Ensure the DEP (Data Execution Prevention) setting, Turn on DEP for all programs and services except those I select, is not enabled as it can block the creation of the database.","Ensure anti-virus software, anti-spyware software, security software and/or any firewalls are not enabled as they may block programs, protocols, or ports necessary for database creation.","Ensure the UAC (User Account Control) is not enabled as it may block the installation and creation of the database.","Running the Installation Wizard","92677.htm");
Page[15]=new Array("To install P6 Professional with the Typical option:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Typical option.","Click OK.","Click Install.","When P6 Professional is installed, the Next Steps window appears.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Typical Installation","99673.htm");
Page[16]=new Array("Use the Advanced installation option when the Typical option does not apply. For example if you want to control the installation of specific P6 Professional components, such as Visualizer and the P6 Professional Database Tools. ","To install P6 Professional Standalone with the Advanced option:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Advanced option.","Click OK.","Select the options to be installed.","Click Next.","Click Install.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Advanced Installation","92907.htm");
Page[17]=new Array("Under certain circumstances, you might want to restrict the drivers available with a P6 EPPM installation. For example, if you want to prevent users from installing standalone instances of the application. It is possible to exclude unnecessary drivers from the installation whether you install from the installation wizard, deploy ClickOnce, or install from the command line.","Install Wizard: During the advanced installation process, in the Primavera Professional Common Components branch of the installer, you can expand the Drivers section and clear the options for any drivers you do not wish to install.","ClickOnce Deployments:","On Premises: In the P6 Pro Enterprise Deployment Utility, in the Supported Drivers section, clear the options for any drivers you do not wish to install.","Cloud: Submit a Service Request in My Oracle Support","Command Line Installations: Use the /action parameter with the value DeleteDriver and specify the driver type to delete using the /dbtype parameter to update the bootstrap file. For example:","Primavera.Launcher.DBConfig.exe /action=DeleteDriver /dbtype=SQLite","For more information, see: How to Disable Specific Database Drivers (such as SQLite) When Installing P6 Professional (KB584939)","Removing Specific Drivers from Installation","101585.htm");
Page[18]=new Array("If you selected the Run Database Configuration option during installation, the Database Configuration wizard launches automatically after P6 Professional installation is complete. You can also run it manually at any time. Use Database Configuration to create a database connection for P6 Professional and Job Services.","You can also run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Note","To change database connection settings, the Database Configuration wizard must access the PrmBootStrapV2.xml file. This file is located in &lt;local drive&gt;\\%LOCALAPPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;version number&gt;\\.","To run Database Configuration after installation, complete the following steps:","If Database Configuration does not launch automatically, click Start, All Programs, Oracle - Primavera P6, P6 Professional &lt;release level&gt;, P6 Professional &lt;release level&gt; Help and Tools, Database Configuration.","On the Select Driver Type dialog box, in the P6 Professional driver type field, select Microsoft SQL Server/SQL Express.","In the Connection String field, enter the connection string to your database.","If you are not using a named instance, enter the connection string in the format &lt;server name&gt;,&lt;port&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com,1234/PMDB","If you are using a named instance, enter the connection string in the format &lt;server name&gt;\\&lt;instance name&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com\\primavera/PMDB","Optionally, select the Enable Project Checker option if you want users assigned the Admin Superuser or Project Superuser security profiles to be able to run the Project Checker feature from the Tools menu.","Optionally, select the Enable SQL Logging option if you want to be able to analyze SQL logs.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration After Installation","84993.htm");
Page[19]=new Array("Note Configuring a database from the command line requires that you pass the password you intend to use in plain text on the command line. Oracle recommends that after configuring the database, you change the password for security. Alternatively, use the graphical user interface for configuring databases, which does not require passing the password in plain text.","You can configure the database connection by opening a command window as an Administrator and running Primavera.Launcher.DBconfig.exe. You can find Primavera.Launcher.DBconfig.exe in the install location of P6 Professional. The default location for Primavera.Launcher.DBconfig.exe is: &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional ","When you run Primavera.Launcher.DBconfig.exe you must also pass certain parameters. You can pass the parameters in any order, however you must include a space between each parameter and there must be no space between a parameter and its value. All parameters are case-sensitive except the boolean values &quot;yes&quot; and &quot;no&quot;.","The following command line parameters are available:","Parameter","Description","/action=","Use this parameter to specify whether to Add a new database, or Edit or Delete an existing database. This parameter can also be used to AddorEdit a database alias, adding the alias if it does not exist, or editing it if it does. You can also use this parameter to DeleteDriver if you wish to exclude the specific driver types listed with the /dbtype parameter from the bootstrap file.","This parameter is optional. If you do not pass this parameter, the default value will be used. The default value is  Add.","/alias=","Use this parameter to set the name of the database alias.","This parameter is mandatory.","/bcurrname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the name of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is US Dollar.","/bcurrshortname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the abbreviation of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is USD.","/bcurrsymbol=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the symbol of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is $.","/connectionString=","Use this parameter to provide the connection string for a Cloud, Oracle or SQL Server database, or the location for an SQLite database.","This parameter is mandatory.","/dbtype=","Use this parameter to specify the driver type to use for the database. Valid values are Oracle, SQLServer, CloudServer, and SQLite.","This parameter is mandatory.","/groupid=","Use this parameter to provide the public group ID for the database. This ID must be an integer.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 1.","/hidedbconfig=","Use this parameter to hide access to the database configuration screens from the launcher dialog box. Valid values are Yes and No.","This parameter is optional. The default value is no.","/keypath=","Use this parameter to provide the key name and the path your P6.key file. The value should be expressed as &lt;Key Name&gt;@&lt;Key Store File Path&gt;. Alternatively, use this parameter to switch on the option to use the default database keystore, by passing a null value, i.e. &quot;&quot;.","This parameter is optional if you choose to use the default database keystore.","/loadsampledata=","This parameter is only valid when creating a new standalone database.","Use this parameter to specify whether to load sample data into the new database. Valid values are Yes and No.","This parameter is optional. The default value is yes.","/logfile=","Use this parameter provide the path and name for a log file.","This parameter is optional. If you do not pass this parameter, the default log file will be created as Primavera.Launcher.DBConfig.log in the user's %TEMP% folder.","/password=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the password for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/projectCheckerEnabled=","This parameter is valid for Oracle, Microsoft SQL, and Cloud Connect databases only.","Use this parameter to specify whether the Tools, Project Checker menu item is available to Superusers. Valid values are true and false.","This parameter is optional. The default value is false.","/pusername=","Use this parameter to provide the pubuser name for the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/puserpwd=","Use this parameter to provide the password for the pubuser in the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/readtimeout=","Use this parameter to specify the number of seconds to wait for a response from the cloud database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 900.","/runtest=","Use this parameter to specify whether to test the database connection. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the database will not be tested.","/uselocalrepository=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to enable the local cache database. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the local cache database will be enabled.","/username=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the username for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/usesaml=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to use SAML authentication. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, SAML authentication will not be enabled.","Examples","Delete an alias:","Primavera.Launcher.DBconfig.exe /dbtype=&quot;SQLServer&quot; /runsilent=&quot;Yes&quot; /action=&quot;Delete&quot; /alias=&quot;MyAlias&quot;","Add an alias that does not use the default database key:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLServer&quot; /alias=&quot;MySqlServerAlias&quot; /connectionString=&quot;mysqlserver,4321/mysqldatabase&quot;  /pusername=&quot;sqlpubuser&quot; /puserpwd=&quot;sqlpubuserpassword&quot; /groupid=2 /keypath=&quot;mykey@C:\\database key file\\p6.key&quot;","Create a new standalone database with the base currency as Euro:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLite&quot; /alias=&quot;MyStandaloneAlias&quot; /connectionString=&quot;C:\\My P6 Database\\MyStandaloneDatabase.db&quot; /username=&quot;myuser&quot; /password=&quot;mypassword&quot;  /bcurrshortname=&quot;EUR&quot; /bcurrname=&quot;Euro&quot; /bcurrsymbol=&quot;&quot; /loadsampledata=&quot;No&quot;","Configuring a Microsoft SQL Server Database Connection From the Command Line","81039.htm");
Page[20]=new Array("Before connecting to a database hosted on Oracle Autonomous Database, you must install client software (for example, Oracle Instant Client), download the wallet containing client credentials, and configure certain files and environment variables.","To prepare for connection to an Autonomous Database:","If you have not already installed an Oracle Database client, see: Oracle Server Database Client Software (on page 9)","Download the wallet from the URL provided by your sales contact.","Extract the wallet file to a suitable location on your local machine, for example, C:\\OracleWallet.","Open the sqlnet.ora file at the extracted wallet location in a text editor.","Find the following line, and replace the text in quotation marks with the location of the extracted wallet file.","(DIRECTORY=&quot;?/network/admin&quot;)","For example, (DIRECTORY=&quot;C:\\OracleWallet&quot;)","Save the file.","Create the TNS_ADMIN environment variable and set it to the location of the credentials file.","On Windows, open the command line and enter:","set TNS_ADMIN=&lt;wallet_location&gt;","Where &lt;wallet_location&gt; is the path to the extracted wallet files.","On Linux, open a terminal and enter:","export TNS_ADMIN=&lt;wallet_location&gt;","Where &lt;wallet_location&gt; is the path to the extracted wallet files.","Prerequisites for Connecting to Autonomous Databases","102501.htm");
Page[21]=new Array("Note Configuring a database from the command line requires that you pass the password you intend to use in plain text on the command line. Oracle recommends that after configuring the database, you change the password for security. Alternatively, use the graphical user interface for configuring databases, which does not require passing the password in plain text.","You can configure the database connection by opening a command window as an Administrator and running Primavera.Launcher.DBconfig.exe. You can find Primavera.Launcher.DBconfig.exe in the install location of P6 Professional. The default location for Primavera.Launcher.DBconfig.exe is: &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional ","When you run Primavera.Launcher.DBconfig.exe you must also pass certain parameters. You can pass the parameters in any order, however you must include a space between each parameter and there must be no space between a parameter and its value. All parameters are case-sensitive except the boolean values &quot;yes&quot; and &quot;no&quot;.","The following command line parameters are available:","Parameter","Description","/action=","Use this parameter to specify whether to Add a new database, or Edit or Delete an existing database. This parameter can also be used to AddorEdit a database alias, adding the alias if it does not exist, or editing it if it does. You can also use this parameter to DeleteDriver if you wish to exclude the specific driver types listed with the /dbtype parameter from the bootstrap file.","This parameter is optional. If you do not pass this parameter, the default value will be used. The default value is  Add.","/alias=","Use this parameter to set the name of the database alias.","This parameter is mandatory.","/bcurrname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the name of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is US Dollar.","/bcurrshortname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the abbreviation of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is USD.","/bcurrsymbol=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the symbol of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is $.","/connectionString=","Use this parameter to provide the connection string for a Cloud, Oracle or SQL Server database, or the location for an SQLite database.","This parameter is mandatory.","/dbtype=","Use this parameter to specify the driver type to use for the database. Valid values are Oracle, SQLServer, CloudServer, and SQLite.","This parameter is mandatory.","/groupid=","Use this parameter to provide the public group ID for the database. This ID must be an integer.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 1.","/hidedbconfig=","Use this parameter to hide access to the database configuration screens from the launcher dialog box. Valid values are Yes and No.","This parameter is optional. The default value is no.","/keypath=","Use this parameter to provide the key name and the path your P6.key file. The value should be expressed as &lt;Key Name&gt;@&lt;Key Store File Path&gt;. Alternatively, use this parameter to switch on the option to use the default database keystore, by passing a null value, i.e. &quot;&quot;.","This parameter is optional if you choose to use the default database keystore.","/loadsampledata=","This parameter is only valid when creating a new standalone database.","Use this parameter to specify whether to load sample data into the new database. Valid values are Yes and No.","This parameter is optional. The default value is yes.","/logfile=","Use this parameter provide the path and name for a log file.","This parameter is optional. If you do not pass this parameter, the default log file will be created as Primavera.Launcher.DBConfig.log in the user's %TEMP% folder.","/password=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the password for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/projectCheckerEnabled=","This parameter is valid for Oracle, Microsoft SQL, and Cloud Connect databases only.","Use this parameter to specify whether the Tools, Project Checker menu item is available to Superusers. Valid values are true and false.","This parameter is optional. The default value is false.","/pusername=","Use this parameter to provide the pubuser name for the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/puserpwd=","Use this parameter to provide the password for the pubuser in the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/readtimeout=","Use this parameter to specify the number of seconds to wait for a response from the cloud database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 900.","/runtest=","Use this parameter to specify whether to test the database connection. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the database will not be tested.","/uselocalrepository=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to enable the local cache database. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the local cache database will be enabled.","/username=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the username for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/usesaml=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to use SAML authentication. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, SAML authentication will not be enabled.","Examples","Delete an alias:","Primavera.Launcher.DBconfig.exe /dbtype=&quot;Oracle&quot; /runsilent=&quot;Yes&quot; /action=&quot;Delete&quot; /alias=&quot;MyAlias&quot;","Add a cloud server alias with SAML authentication enabled and the local cache database not enabled:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;CloudServer&quot; /alias=&quot;MyCloudAlias&quot; /connectionString=&quot;myclouddatabase@https://mycloudserver/p6procloudconnect&quot; /usesaml=&quot;Yes&quot; /uselocalrepository=&quot;No&quot;","Edit an Oracle alias to change the database key to KeyTwo:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /action=&quot;Edit&quot; /dbtype=&quot;Oracle&quot; /alias=&quot;MyOracleAlias&quot; /connectionString=&quot;//myoracleserverdatabase:1234/orcl&quot; /pusername=&quot;databasepublic&quot; /puserpwd=&quot;databasepublicpassword&quot; /keypath=&quot;KeyTwo@C:\\p6.key&quot;","Configuring an Oracle Database Connection From the Command Line","81041.htm");
Page[22]=new Array("Note Configuring a database from the command line requires that you pass the password you intend to use in plain text on the command line. Oracle recommends that after configuring the database, you change the password for security. Alternatively, use the graphical user interface for configuring databases, which does not require passing the password in plain text.","You can configure the database connection by opening a command window as an Administrator and running Primavera.Launcher.DBconfig.exe. You can find Primavera.Launcher.DBconfig.exe in the install location of P6 Professional. The default location for Primavera.Launcher.DBconfig.exe is: &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional ","When you run Primavera.Launcher.DBconfig.exe you must also pass certain parameters. You can pass the parameters in any order, however you must include a space between each parameter and there must be no space between a parameter and its value. All parameters are case-sensitive except the boolean values &quot;yes&quot; and &quot;no&quot;.","The following command line parameters are available:","Parameter","Description","/action=","Use this parameter to specify whether to Add a new database, or Edit or Delete an existing database. This parameter can also be used to AddorEdit a database alias, adding the alias if it does not exist, or editing it if it does. You can also use this parameter to DeleteDriver if you wish to exclude the specific driver types listed with the /dbtype parameter from the bootstrap file.","This parameter is optional. If you do not pass this parameter, the default value will be used. The default value is  Add.","/alias=","Use this parameter to set the name of the database alias.","This parameter is mandatory.","/bcurrname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the name of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is US Dollar.","/bcurrshortname=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the abbreviation of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is USD.","/bcurrsymbol=","This parameter is only valid when creating a new standalone database.","Use this parameter to set the symbol of the base currency for the database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is $.","/connectionString=","Use this parameter to provide the connection string for a Cloud, Oracle or SQL Server database, or the location for an SQLite database.","This parameter is mandatory.","/dbtype=","Use this parameter to specify the driver type to use for the database. Valid values are Oracle, SQLServer, CloudServer, and SQLite.","This parameter is mandatory.","/groupid=","Use this parameter to provide the public group ID for the database. This ID must be an integer.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 1.","/hidedbconfig=","Use this parameter to hide access to the database configuration screens from the launcher dialog box. Valid values are Yes and No.","This parameter is optional. The default value is no.","/keypath=","Use this parameter to provide the key name and the path your P6.key file. The value should be expressed as &lt;Key Name&gt;@&lt;Key Store File Path&gt;. Alternatively, use this parameter to switch on the option to use the default database keystore, by passing a null value, i.e. &quot;&quot;.","This parameter is optional if you choose to use the default database keystore.","/loadsampledata=","This parameter is only valid when creating a new standalone database.","Use this parameter to specify whether to load sample data into the new database. Valid values are Yes and No.","This parameter is optional. The default value is yes.","/logfile=","Use this parameter provide the path and name for a log file.","This parameter is optional. If you do not pass this parameter, the default log file will be created as Primavera.Launcher.DBConfig.log in the user's %TEMP% folder.","/password=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the password for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/projectCheckerEnabled=","This parameter is valid for Oracle, Microsoft SQL, and Cloud Connect databases only.","Use this parameter to specify whether the Tools, Project Checker menu item is available to Superusers. Valid values are true and false.","This parameter is optional. The default value is false.","/pusername=","Use this parameter to provide the pubuser name for the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/puserpwd=","Use this parameter to provide the password for the pubuser in the database.","This parameter is mandatory, but applies only to Oracle and SQLServer databases.","/readtimeout=","Use this parameter to specify the number of seconds to wait for a response from the cloud database.","This parameter is optional, but the value is mandatory. If you do not pass this parameter, the default value will be used. The default value is 900.","/runtest=","Use this parameter to specify whether to test the database connection. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the database will not be tested.","/uselocalrepository=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to enable the local cache database. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, the local cache database will be enabled.","/username=","This parameter is only valid when creating a new standalone database.","Use this parameter to provide the username for the user of the new standalone instance of P6 Professional.","This parameter is mandatory when creating a new standalone database.","/usesaml=","This parameter is only valid when connecting to a CloudServer database.","Use this parameter to specify whether to use SAML authentication. Valid values are Yes and No.","This parameter is optional. If you do not pass this parameter, SAML authentication will not be enabled.","Examples","Delete an alias:","Primavera.Launcher.DBconfig.exe /dbtype=&quot;SQLite&quot; /runsilent=&quot;Yes&quot; /action=&quot;Delete&quot; /alias=&quot;MyAlias&quot;","Add an alias that does not use the default database key:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLite&quot; /alias=&quot;MySqlServerAlias&quot; /connectionString=&quot;mysqlserver,4321/mysqldatabase&quot;  /pusername=&quot;sqlpubuser&quot; /puserpwd=&quot;sqlpubuserpassword&quot; /groupid=2 /keypath=&quot;mykey@C:\\database key file\\p6.key&quot;","Create a new standalone database with the base currency as Euro:","Primavera.Launcher.DBconfig.exe /runsilent=&quot;Yes&quot; /dbtype=&quot;SQLite&quot; /alias=&quot;MyStandaloneAlias&quot; /connectionString=&quot;C:\\My P6 Database\\MyStandaloneDatabase.db&quot; /username=&quot;myuser&quot; /password=&quot;mypassword&quot;  /bcurrshortname=&quot;EUR&quot; /bcurrname=&quot;Euro&quot; /bcurrsymbol=&quot;&quot; /loadsampledata=&quot;No&quot;","Configuring a Microsoft SQLite Database Connection From the Command Line","100538.htm");
Page[23]=new Array("To enable users to utilize P6 Integration API functionality within P6 Professional when using a non-default Microsoft SQL Server port, add an ADMINISTRATOR_SETTINGS row to the SETTINGS table for each Microsoft SQL Server database you use with P6 Professional. The table below summarizes the settings.","ADMINISTRATOR_SETTINGS Settings","Setting Description:&nbsp;Points to the JDBC connection URL for a P6 Professional Microsoft SQL Server database.","Namespace","Administrator_Settings","Setting Name","JdbcConnectionURL","Setting Value","&lt;jdbc connection url&gt;","When entering a value for jdbc connection url for Microsoft SQL Server, use the standard connection string. For example:","jdbc:sqlserver://&lt;servername&gt;:&lt;portnumber&gt;;database=&lt;databasename&gt;;","Database Administrator Settings for a Non-Default Microsoft SQL Server Port","79647.htm");
Page[24]=new Array("Use Database Configuration to change connection settings for the client module if your database server configuration changes. For example, if the database is moved to a new server, run Database Configuration to configure the connection to the new server.","Note","To change database connection settings, the Database Configuration wizard must access the PrmBootStrapV2.xml file. This file is located in &lt;local drive&gt;\\%LOCALAPPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;version number&gt;\\.","To run Database Configuration manually, complete the following steps:","Click Start, All Programs, Oracle - Primavera P6, P6 Professional &lt;release level&gt;, P6 Professional &lt;release level&gt; Help and Tools, Database Configuration.","On the Database Configuration wizard, click Add to create a new alias.","In the Database alias field, enter a name for the new alias. ","In the Driver type field, select the Microsoft SQL Server / SQL Express driver.","In the Connection String field, enter the connection string to your database.","If you are not using a named instance, enter the connection string in the format &lt;server name&gt;,&lt;port&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com,1234/PMDB","If you are using a named instance, enter the connection string in the format &lt;server name&gt;\\&lt;instance name&gt;/&lt;database name&gt;.","For example, p6server.nesbidcorp.com\\primavera/PMDB","Optionally, select the Enable Project Checker option if you want users assigned the Admin Superuser or Project Superuser security profiles to be able to run the Project Checker feature from the Tools menu.","Optionally, select the Enable SQL Logging option if you want to be able to analyze SQL logs.","If your database is encrypted using a database key, in the Keystore section:","If you want to use the default key for the database, select Use default database keystore.","If you do not want to use the default key:","In the Keystore file field, click @&nbsp;Browse.","In the Open dialog box, browse to your key file and click Open.","In the Key Name list select the key to use.","Click Next.","In the Enter public login Information section, enter your public login information that was defined by your administrator.","Click Test&nbsp;to test the database connection. If the connection is successful, click Save. If the connection is not successful, revise the database connection information you provided.","Running Database Configuration Manually","92896.htm");
Page[25]=new Array("After installing P6 Professional, you must set the industry type for the software. The industry type determines the terminology and default calculation settings that display in P6 Professional.","To set the industry type, complete the following steps:","Log in to P6 Professional.","Choose Admin, Admin Preferences.","Click the Industry tab.","Select the option that most closely aligns with your industry.","Note If you set the industry type and later change it, the new industry setting is immediately effective for new users. However, the change will not take effect for users who have logged in since it was last set. For information on how to make it effective for existing users, see: How To Change The P6 Industry Type In P6 PPM (Professional), P6 EPPM R8.2 And Later Releases (KB670189).","The following table lists each industry type and its corresponding terminology and default settings:","Industry Type","Industry Terminology Examples","Default startup window in P6 Professional","Engineering and Construction","Budgeted Units<br />Budgeted Cost<br />Original Duration","Activities window","Government, Aerospace, and Defense","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","High-Technology, Manufacturing, and Others","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","Utilities, Oil, and Gas","Budgeted Units<br />Budgeted Cost<br />Original Duration","Projects window","Setting the Industry Type","49447.htm");
Page[26]=new Array("P6 Professional requires you to choose an industry type. The industry type determines the terminology and default calculation settings that display in P6 Professional. You choose an industry type from P6, Application Settings, General link.","The following table lists each industry type and its corresponding terminology and default settings. Choose the option that best matches your industry. ","Industry Types","Industry Type","Industry Terminology Examples","Default startup window in P6 Professional","Engineering and Construction","Budgeted Units<br />Budgeted Cost<br />Original Duration","Activities window","Government, Aerospace, and Defense","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","High-Technology, Manufacturing","Planned Units<br />Planned Cost<br />Planned Duration","Projects window","Utilities, Oil, and Gas","Budgeted Units<br />Budgeted Cost<br />Original Duration","Projects window","Note","If you choose the Engineering and Construction or the Utilities, Oil, and Gas industry type, P6 Professional users will see different terminology and defaults when switching to other P6 EPPM applications, such as P6.","If you set the industry type and later change it, the new industry setting is immediately effective for new users. However, the change will not take effect for users who have logged in since it was last set. For information on how to make it effective for existing users, refer to My Oracle Support's Knowledge article How To Change The P6 Industry Type In P6 PPM (Professional), P6 EPPM R8.2 And Later Releases (Doc ID 1386047.1).","Set the Industry Type (P6 EPPM Only)","6747.htm");
Page[27]=new Array("By default, online help for P6 Professional and Visualizer is hosted by Oracle. If you prefer to access Help locally, you can install a local copy of the Help.","Note The hosted versions always contain the most current version of P6 Professional and Visualizer help.","To install a local of the P6 Professional and Visualizer help, complete the following steps:","Download the Downloadable P6 Professional Help and extract it locally.","In the extracted zip file, double-click P6ProHelpInstaller.msi to launch the installation wizard.","Click Next.","Expand Local Help Files.","Do the following to install a local copy of P6 Professional help.","Expand PM Help.","Click the drop-down for the language you use in the P6 Professional user interface and select Will be installed on local hard drive. ","Note P6 Professional Help is available in English, French, German, Japanese, and simplified Chinese.  Selecting any other language installs Help in English. ","Do the following to install a local copy of Visualizer Help.","Expand Visualizer Help.","Click the drop-down for the language you use in the Visualizer user interface and select Will be installed on local hard drive.","Note Visualizer Help is available in English only. Selecting any other language installs Help in English.","Click Next.","Click Install.","Click Finish.","Installing Local Copies of P6 Professional and Visualizer Help","88570.htm");
Page[28]=new Array("You can install multiple versions of P6 Professional on the same machine.","Tip","If you change, repair, or remove a version earlier than 18.5, all other installed versions are also removed. If you uninstall version 18.5 or newer, only that version is removed.","Multiple users can install P6 Professional using ClickOnce on the same machine, however each user can only install one version of P6 Professional.","Installing Multiple Versions of P6 Professional","97999.htm");
Page[29]=new Array("P6 Visualizer is installed by default when installing P6 Professional. You can also install P6 Visualizer as a standalone.","To install P6 Visualizer only:","Download and extract the media zip file locally to the client computer.","In the extracted media zip file, in the Client_Applications folder, double-click P6ProfessionalSetup.exe to launch the installation wizard.","Note Microsoft .NET Framework and Windows Installer are required to run P6 Professional. If they are not installed, follow the prompts to install them and then restart your computer as needed. AllowP6ProfessionalSetup.exe  to run when your computer restarts and follow the prompts to complete installation of the required components.","Select the Advanced option.","Click OK.","Deselect the Primavera P6 Professional option.","Expand Primavera P6 Professional, P6 Professional Common Components.","Select the Visualizer option.","Click Next.","Click Install.","Click OK to automatically run Database Configuration immediately after installation. See Running Database Configuration After Installation for details.","Note You do not need to run Database Configuration immediately after installation, however you do need to run it before you can use P6 Professional. You can run Database Configuration manually at any time. See Running Database Configuration Manually for details.","Installing P6 Visualizer Only","92933.htm");
Page[30]=new Array("By default, online Help for Visualizer is hosted by Oracle. If you prefer to access Help locally, you can install a local copy of the Help.","Note The hosted version always contains the most current version of Visualizer help.","To install a local of the Visualizer Help, complete the following steps:","Download the Downloadable P6 Professional Help and extract it locally.","In the extracted zip file, double-click P6ProHelpInstaller.msi to launch the installation wizard.","Click Next.","Expand Local Help Files.","Expand Visualizer Help.","Click the drop-down for the language you use in the Visualizer user interface and select Will be installed on local hard drive.","Note Visualizer Help is available in English only. Selecting any other language installs Help in English.","Click Next.","Click Install.","Click Finish.","Installing Local Copies of Visualizer Help","88996.htm");
Page[31]=new Array("This chapter provides instructions for performing unattended setup of P6 Professional. An unattended setup enables administrators to run setup in silent mode and ensures that each user receives the same configuration.","As an administrator, you have several options for installing P6 Professional on client computers using the unattended setup. For example, you can physically run the unattended setup on each computer, write scripts that will run the unattended setup on the client computers you specify, or provide these instructions to users with administrator privileges, who can run the unattended setup on their computer.","Unattended Setup for P6 Professional","49492.htm");
Page[32]=new Array("An unattended setup allows an administrator to install P6 Professional on a client computer without having to answer the configuration prompts of the P6 Professional Setup wizard. All configuration details for the installation are specified in the command line. Unattended installations ensure that the client module is configured identically at setup.","To create an unattended setup, you format a command line command to silently launch setup.","The unattended setup can be run by an administrator on client computers by entering the appropriate command lines. The unattended setup will silently install P6 Professional according to the parameters you specify in the command line.","The following prerequisites, available in the Client_Applications folder of the P6 Professional physical media or download, must be installed on each client computer before running unattended setup:","Microsoft .NET Framework","An administrator should push these prerequisites to client computers before running unattended setup. The versions of these prerequisites on the physical media or download work with this release; check the tested configurations document before using newer versions.","Unattended Setup","49491.htm");
Page[33]=new Array("Complete the following steps to run unattended setup:","Copy the contents of the files in the Client_Applications folder to a local folder.","Oracle recommends creating a new folder, such as Installer. Do not include spaces in the folder name.","Open a command line by choosing Start, Run. Enter cmd and click OK.","On the command line window, go to location of the Installer folder. For example,","cd c:\\Installer","On the command line window, enter the following command:","P6ProfessionalSetup.exe /q","Note This command silently runs a Typical Installation, which installs P6 Professional and Visualizer to the default location (&lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional).","Installing Typical Components (P6 Professional and Visualizer)","To install P6 Professional and Visualizer, enter the following command:","P6ProfessionalSetup.exe /package /q msi_p6pro_64_INSTALLDIR=C:\\Temp","Installing Individual Components","Visualizer Only","To install Visualizer, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Visualizer REMOVE=msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;DBSchema,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp ","P6 Professional Only","To install P6 Professional, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PM REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;DBSchema,msi_p6pro_64;AdminConfig,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;PrmJob msi_p6pro_64_INSTALLDIR=C:\\Temp","Job Service only ","To install Job Service, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PrmJob REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;DBSchema,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Admin Configuration only ","To install Admin Configuration, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;AdminConfig REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Standalone Database Migration Tool only","To install the Standalone Database Migration Tool, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Standalone_Migration REMOVE=msi_p6pro_64;PM,msi_p6pro_64;Visualizer,msi_p6pro_64;PrmJob,msi_p6pro_64;DBSchema,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp","Standalone Upgrade Tool only","To install Standalone Upgrade Tool, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;DBSchema REMOVE=msi_p6pro_64;PM,msi_p6pro_64;Visualizer,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration,msi_p6pro_64;AdminConfig msi_p6pro_64_INSTALLDIR=C:\\Temp","SDEF Conversion Tools only","To install SDEF conversion tools, enter the following command:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;Feature_P3 REMOVE=msi_p6pro_64;Visualizer,msi_p6pro_64;PM,msi_p6pro_64;PrmJob,msi_p6pro_64;Standalone_Migration msi_p6pro_64_INSTALLDIR=C:\\Temp","Tip","PM and Visualizer components will be installed by default if you do not use the REMOVE parameter.","Component names are case-sensitive.","If you do not specify the INSTALLDIR property, the default location is used. The default location is &lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional.","To create a installer log file, add the /log parameter. For example:","P6ProfessionalSetup.exe /package /q ADDLOCAL=msi_p6pro_64;PM REMOVE=msi_p6pro_64;Visualizer msi_p6pro_64_INSTALLDIR=C:\\Temp /log &quot;&lt;LogFileLocation&gt;/install.log&quot; ","where &lt;LogFileLocation&gt; is the folder where you want to save the log file.","You can save your setup command line in a batch file in the install directory and run the batch file.","Enter P6ProfessionalSetup.exe /help to access documentation for command-line parameters.","To keep existing installations and install an additional version alongside the existing version, use the command line argument RELATED_BUNDLE_ACTION=PRESERVE. If the RELATED_BUNDLE_ACTION command line argument is missing or set to a different value from PRESERVE, existing installations will be removed.","Running Unattended Setup","50109.htm");
Page[34]=new Array("Create the database connection on one administrator computer. After configuring the database connection, push the PrmBootStrapV2.xml file from the administrator computer (host computer) with database configuration details to each target client computer.","Install P6 Professional on one administrator computer (host computer).","Create the database connection on the host computer.","See the Install and Configuration Guide for your database type for details.","The default location of PrmBootStrapV2.xml for the host computer is:"," \\%APPDATA%\\Oracle\\Primavera P6\\P6 Professional\\&lt;major version&gt;.&lt;minor version&gt;.&lt;build version&gt;","The default location of PrmBootStrapV2.xml for the target computer is:","\\&lt;application install location&gt;\\Data\\","Creating Database Connections for Unattended Setup","100640.htm");
Page[35]=new Array("Your organization can define a series of application-wide parameters and values that apply to all projects. Your organization can use these settings to customize your project to meet specific project management requirements and standards. While all users can view these settings, a user must have special security privileges to edit them. There are two types of settings: Administrative Preferences and Administrative Categories.","Application administrators use the Admin Preferences dialog box to establish default settings. You can use this dialog box to check the defaults that have been defined.","Administrative preferences (P6 Professional Only)","administrative_preferences.htm");
Page[36]=new Array("Prevent users from uploading potentially harmful files as documents in P6 Professional by providing a list of invalid file types. Oracle recommends that at least the default values of .exe, .com, .bat, .cmd, .vbs, .js, and .msi should be entered in this field.","Note This is not intended to replace robust virus checking software and procedures.","Choose Admin, Admin Preferences.","Click the Options tab, then type a comma-separated list of file types in the Invalid document types field.","Define invalid file types for upload (P6 Professional Only)","change_the_global_code_separator.htm");
Page[37]=new Array("You can create a list of websites that users can launch from user defined fields (UDFs), projects websites, and Notebook topics, by double clicking on the website and selecting Launch.","For any text field in edit mode, users can right click on the website, then choose to either launch or copy the site.","To add a website, complete the following steps:","Log in to P6 Professional.","Choose Admin, Admin Preferences.","Click the Exception Site List tab.","Click Add and enter the website.","Mark the checkbox next to a website to make it clickable by users.","Here are some rules on how to specify websites:","Website paths cannot contain spaces. You can include %20 in a path to represent a space. ","For example: http://www.magnacorp.com/Primavera%20Applications","Wildcards are allowed. For example, you can add https://* and http://* to allow all sites that begin with these roots to be launchable.","Here are some examples of entries and how they would be handled:","Website paths must begin with any of the following:","https://<br />http://<br />ftps://<br />ftp://<br />mailto:<br />telnet://","Allowed site: https://www.magnacorp.com/document","This would allow:","https://www.magnacorp.com/document","https://www.magnacorp.com/document/RiceB/1MCSbdcXKQ","but would NOT allow:","http://www.magnacorp.com/document/RiceB/1MCSbdcXKQ","because the exception site begins with https://","https://www.magnacorp.com/projectnano/document","because the allowed site specifies /document after .com.","Allowed site: https://*.magnacorp.com","This would allow:","https://www.magnacorp.com","https://server.magnacorp.com/user/942374/my-drive","https://apps.magnacorp.com/development/projectnano","But would not allow:","https://magnacorp.com","because the template requires there to be something between https:// and magnacorp.com.","A selected item with a wildcard in the site allow list overrides an unselected item if it matches the template specified with the wildcard.","For example:","Selected: https://*.magnacorp.com","Unselected: https://apps.magnacorp.com","In this situation, the website https://apps.magnacorp.com will be clickable, because the template including the wildcard * is selected.","Define Clickable Websites","99513.htm");

Page[38]=new Array("You can specify the day on which the calendar week begins.","Choose Admin, Admin Preferences.","Click the General tab.","In the Starting Day of Week section, select the day on which you want the workweek to begin.","Note","This setting applies to all global, project, and resource calendars.","Set the week start day (P6 Professional Only)","set_the_week_start_day.htm");
Page[39]=new Array("You can specify the default activity duration for new activities added in all projects.","Choose Admin, Admin Preferences.","Click the General tab.","In the Activity Duration section, type a default activity duration in minutes, hours, days, weeks, months, or years.","Note","If you change the default activity duration setting, the new default applies only to activities added after the change; existing activities are not affected.","Set a default activity duration (P6 Professional Only)","set_a_default_activity_duration.htm");
Page[40]=new Array("Choose Admin, Admin Preferences.","Click the Data Limits tab.","Specify the number of hierarchy levels each hierarchy may have.","Note","If you change maximum hierarchy level settings, your change only applies when you add new elements or edit existing elements.","Define maximum hierarchy levels (P6 Professional Only)","define_maximum_hierarchy_levels.htm");
Page[41]=new Array("Choose Admin, Admin Preferences.","Click the Data Limits tab.","In the bottom section, specify the maximum number of activity codes per project.","Define maximum project activity codes (P6 Professional Only)","define_maximum_project_activity_codes.htm");
Page[42]=new Array("Choose Admin, Admin Preferences.","Click the Data Limits tab.","In the bottom section of the tab, specify the maximum number of baselines per project.","Define maximum baselines (P6 Professional Only)","define_maximum_baselines.htm");
Page[43]=new Array("Choose Admin, Admin Preferences.","Click the ID Lengths tab, then specify the number of characters each code may have. Valid values are 1-40.","Note","If you change the maximum number of characters in a code length, your change only applies when you add new codes or edit existing codes.","Define maximum ID lengths (P6 Professional Only)","define_maximum_id_lengths.htm");
Page[44]=new Array("P6 Professional calculates and stores time unit values in hourly increments, but users can set preferences to display time units in other increments, such as days or weeks. The values specified for Hours per Time Period are used to convert hours to other time increments for display, and to convert all non-hourly time increments to hours for storage in the database. As an administrator, you can globally specify the conversion factors, or you can enable the Hours per Time Period settings defined for each calendar to control how units and durations are converted and stored.","Choose Admin, Admin Preferences.","Click the Time Periods tab.","If you want to globally specify conversion factors, in the Hours per Time Period section, type the default number of work hours you want to use for each time period.<br /><br />If you want to use the Hours per Time Period settings defined in each calendar as conversion factors, mark the &quot;Use assigned calendar to specify the number of work hours for each time period&quot; checkbox. ","Set default workhours (P6 Professional Only)","set_default_workhours.htm");
Page[45]=new Array("Choose Admin, Admin Preferences.","Click the Time Periods tab.","In the Time Period Abbreviations section, type the abbreviations you want to use when displaying each time period.","Set abbreviations for displaying time (P6 Professional Only)","set_abbreviations_for_displaying_time.htm");
Page[46]=new Array("Choose Admin, Admin Preferences.","Click the Earned Value tab.","In the Technique for Computing Performance Percent Complete section, select the default completion percentage method you want to use for computing earned-value percent complete when calculating an activity's earned value.","In the Technique for Computing ETC section, select the default method for computing earned value estimate-to-complete you want to use when calculating an activity's Estimate to Complete (ETC) value.","In the Earned Value Calculation section, choose how you want to calculate earned value. Choose to use the baseline's At Completion values and current dates, planned values with planned dates, or planned values with current dates when calculating earned value from a baseline.<br /><br />The current dates options use the Start/Finish dates for an activity or resource assignment.","Tip","For each project, earned value is calculated using the project baseline or each user's defined primary baseline, depending on a preference setting on the Settings tab of Project Details.","Define default earned value settings (P6 Professional Only)","define_default_earned_value_settings.htm");
Page[47]=new Array("In addition to specifying summarization options per project (Project Details, Settings tab), if you have administrator rights, you can specify global summarization options for storing resource spreads at the activity and resource levels.","Choose Admin, Preferences.","Select the Options tab.","In the 'Select summarization periods' section, choose how you want to summarize and store resource data: By calendar, By financial period, or both.<br /><br />If you choose to summarize and store resource data by calendar intervals, in the WBS Level field, choose the time interval, such as week or month, for storing summarized activity data. Then, in the Resource/Role Assignment Level field, choose the time interval, such as week or month, for storing summarized resource data.<br /><br />If you choose to summarize and store resource data by financial period intervals, activity and resource data is stored in financial period intervals that correspond to the financial periods defined in the financial period calendars. Choosing this option enables P6 Professional to display all activity and resource data (including non-past period actual data) in financial period timescale intervals.<br />","Tip","If you want all project data in the database to be summarized by financial period (including closed projects), you must create financial periods that span the date range of all projects in the database using each financial period calendar. For example, if the oldest project using a specific financial period calendar has a project start date of October 1st, 2001, the financial periods defined for that calendar should begin on or before that date.","If you choose to summarize data by financial period, you must summarize closed projects at least once to store project data in financial period intervals. Doing so ensures that data will display accurately in profiles and spreadsheets when users choose to display data for all projects in a financial period timescale interval (rather than open projects only).","Note","If you choose to summarize by both calendar and financial period intervals, the runtime of summarizer jobs will increase.","If you summarize projects with the 'By calendar' option selected, then clear the checkbox and summarize projects again, the previously existing summary activity and resource spreads are not removed; you must remove them manually.","If no financial period calendars are defined, you can select the 'By financial period' option but data will not be summarized by financial period.","Set global summarization options (P6 Professional Only)","set_global_summarization_options.htm");
Page[48]=new Array("Choose Admin, Admin Preferences.","Click the Options tab.","In the P6 Professional Online Help URL field: <br /><br />Leave the default URL to launch the version of the Help hosted by Oracle when Online Help is selected from the Help menu.<br /><br />Remove the URL to disable the Online Help option from the Help menu for all users. Users will only be able to access the local version of the help.<br /><br />Specify a new URL location to launch when Online Help is selected from the Help menu.","The Always launch Online Help for the F1 shortcut key and context-sensitive help option is not selected by default. To always launch online help for F1 key and help shortcuts, select this option.","Note","Using the hosted version ensures that you always have the most current help content. ","Clicking on Online Help will launch the URL specified in Admin Preferences.","If the P6 Professional Online Help URL field is blank, the Always launch Online Help for the F1 shortcut key and context-sensitive help option is disabled. ","When connected to a P6 EPPM database: Use P6 to set the online help location.","Set the Online Help location (P6 Professional Only)","62433.htm");
Page[49]=new Array("Your organization can define a series of application-wide parameters and values that apply to all projects. Your organization can use these settings to customize your projects to meet specific project management requirements and standards. While all users can view these settings, a user must have the have Add/Edit/Delete Categories global privilege to edit them.","Use the Admin Categories dialog box to define standard categories and values you can apply across all projects, including custom categories and category values for projects, resources, and WBS elements.","Use the following tabs to establish the following default categories and values:","Baseline Types: Create, edit, and delete baseline types. Use these categories to standardize and categorize baselines, and to help benchmark performance across projects.","Expense Categories: Create, edit, and delete expense categories. Use these categories to standardize and categorize project expenses, and organize and maintain expense information.","WBS Category: Create a WBS category and create, edit, and delete WBS category values. Use this category to standardize and categorize WBS elements.","Document Categories: Create, edit, and delete categories for work products and documents. Use these categories to standardize and categorize work products and documents, and organize and maintain work product and document information.","Document Status: Create, edit, and delete document status types. Use these status types to identify the current status of work products and documents within a project.","Risk Categories: Create, edit, and delete risk categories. Use these categories to classify risk types and to organize risks.","Notebook Topics: Create, edit, and delete notebook topics. Use notebook topics to organize related notes about an activity.","Units of Measure: Add, delete, and organize units of measure.","Administrative categories (P6 Professional Only)","administrative_categories.htm");
Page[50]=new Array("When P6 Professional is connected to a P6 EPPM database, you can use P6 to create baseline types that you can assign to baselines in any project. You can use baseline types to standardize baselines for all projects.","When P6 Professional is connected to a P6 Professional database, you can create baseline types that you can assign to baselines in any project. You can use baseline types to standardize baselines for all projects.","Choose Admin, Admin Categories.","Click the Baseline Types tab, then click Add.","Type the name of the new baseline type.","Create a baseline type","create_a_baseline_type.htm");
Page[51]=new Array("Choose Admin, Admin Categories.","Click the Baseline Types tab.","Double-click the baseline type you want to change, then enter a new baseline type.","Tip","To change the order in which baseline types are listed, select the baseline type you want to move, then click Shift Up or Shift Down.","Note","If you change a baseline type, your change applies to all baseline assignments.","Edit a baseline type (P6 Professional Only)","edit_a_baseline_type.htm");
Page[52]=new Array("Choose Admin, Admin Categories.","Click the Baseline Types tab.","Select the baseline type you want to delete, then click Delete.","Click Yes.","Delete a baseline type (P6 Professional Only)","delete_a_baseline_type.htm");
Page[53]=new Array("You can create expense categories that you can assign to expenses in any project. You can use these categories to organize and maintain your expense information.","Choose Admin, Admin Categories.","Click the Expense Categories tab, then click Add.","Type the name of the new expense category.","Create expense categories (P6 Professional Only)","create_expense_categories.htm");
Page[54]=new Array("Choose Admin, Admin Categories.","Click the Expense Categories tab.","Double-click the category whose name you want to change, then type the expense category's new name.","Tip","To change the order in which expense categories are listed, select the expense category you want to move, then click Shift Up or Shift Down.","Note","If you change an expense category's name, your change applies to all expense item assignments.","Rename expense categories (P6 Professional Only)","rename_expense_categoies.htm");
Page[55]=new Array("Choose Admin, Admin Categories.","Click the Expense Categories tab.","Select the category you want to delete, then click Delete.","Click Yes.","Delete expense categories (P6 Professional Only)","delete_expense_categories.htm");
Page[56]=new Array("You can use a custom work breakdown structure (WBS) category to organize and maintain WBS information in all projects.","Choose Admin, Admin Categories.","Click the WBS Category tab, which displays the current name of the WBS category, for example Project Phase. Project phase is the default WBS category. (See the graphic below.)","In the WBS Category field, type the new WBS category name. (This name will appear in the associated tab on the left side of this dialog box.)","Note","The category's current values and value assignments do not change when you change the WBS category.","Edit the WBS category (P6 Professional Only)","edit_the_wbs_category.htm");
Page[57]=new Array("Choose Admin, Admin Categories.","Click the tab that displays the name of the current WBS category, then click Add.","Type the new value.","Use the Shift Up and Shift Down arrows to position the new value in the Category Value list.","Create WBS category values (P6 Professional Only)","create_wbs_category_values.htm");
Page[58]=new Array("You can assign a WBS category value from the Work Breakdown Structure window.","Display a column for the WBS category, if it is not already displayed.<br /><br />Click the Display Options bar, choose Columns, and then choose Customize. In the Available Options section, under the General subsection, choose the WBS category. Click @&nbsp;, then click OK.<br />","In the WBS table, select the WBS element to which you want to assign a WBS category value, then double-click in the WBS category column.","Double-click the category value you want to assign.","Assign WBS Category values (P6 Professional Only)","assign_wbs_category_values.htm");
Page[59]=new Array("Choose Admin, Admin Categories.","Click the tab that displays the name of the current WBS category.","Double-click the value you want to change, then type the new value.","Note","If you change a category value, your change applies to all WBS assignments.","Change WBS category values (P6 Professional Only)","change_wbs_category_values.htm");
Page[60]=new Array("Choose Admin, Admin Categories.","Click the tab that displays the name of the current WBS category.","Select the value you want to delete, then click Delete.","Click Yes.","Delete WBS category values (P6 Professional Only)","delete_wbs_category_values.htm");
Page[61]=new Array("You can set up categories to assign to work products and documents.","Choose Admin, Admin Categories.","Click the Document Categories tab, then click Add.","Type the name of the new document category.","Tip","To change the order in which document categories are listed, select the document category you want to move, then click Shift Up or Shift Down.","Create document categories (P6 Professional Only)","create_document_categories.htm");
Page[62]=new Array("Choose Admin, Admin Categories.","Click the Document Categories tab.","Double-click the category whose name you want to change, then type the document category's new name.","Tip","To change the order in which document categories are listed, select the document category you want to move, then click Shift Up or Shift Down.","Note","If you change a document category's name, your change applies to all document item assignments.","Rename document categories (P6 Professional Only)","rename_document_categories.htm");
Page[63]=new Array("Choose Admin, Admin Categories.","Click the Document Categories tab.","Select the category you want to delete, then click Delete.","Click Yes.","Delete document categories (P6 Professional Only)","delete_document_categories.htm");
Page[64]=new Array("You can create status types that you can assign to documents in any project. A document's status helps you determine which documents are approved work products and documents, standards, and deliverables, and if they can be assigned to activities or work breakdown structure elements.","Choose Admin, Admin Categories.","Click the Document Status tab, then click Add.","Type the name of the new status.","Tip","To change the order in which document statuses are listed, select the document status you want to move, then click Shift Up or Shift Down.","Create a document status (P6 Professional Only)","create_a_document_status.htm");
Page[65]=new Array("Choose Admin, Admin Categories.","Click the Document Status tab.","Double-click the status whose name you want to change, then type the new name.","Tip","To change the order in which document statuses are listed, select the document status you want to move, then click Shift Up or Shift Down.","Note","If you change the name of a document status, your change applies to all document assignments.","Change document status names (P6 Professional Only)","change_document_status_names.htm");
Page[66]=new Array("Choose Admin, Admin Categories.","Click the Document Status tab.","Select the status you want to delete, then click Delete.","Click Yes.","Delete a document status (P6 Professional Only)","delete_a_document_status.htm");
Page[67]=new Array("You can create hierarchical risk categories of possible risks that you can assign to risks. Risk categories are a classification of risk types customized to your specific project or business that are used to categorize and organize risks. Categorizing risks enables you to analyze the types of risks occurring and see trends within the project or across multiple projects.","Choose Admin, Admin Categories.","Click the Risk Categories tab, then click Add.","Type the name of the new risk category.","Tip","To change the hierarchical order in which risk categories are listed, select the risk category you want to move, then click Shift up, Shift down, Shift Right, or Shift Left, as applicable.","Create risk categories (P6 Professional Only)","create_risk_types.htm");
Page[68]=new Array("Choose Admin, Admin Categories.","Click the Risk Categories tab.","Double-click the category you want to change, then enter the new risk category name.","Tip","To change the hierarchical order in which risk categories are listed, select the risk category you want to move, then click Shift up, Shift down, Shift Right, or Shift Left, as applicable.","Note","If you change a risk category, your change applies to all risk assignments.","Edit risk categories (P6 Professional Only)","edit_risk_types.htm");
Page[69]=new Array("Choose Admin, Admin Categories.","Click the Risk Categories tab.","Select the risk category you want to delete, then click Delete.","Click Yes.","Note Deleting a risk category deletes all children and their assignments. ","Delete risk categories (P6 Professional Only)","delete_risk_types.htm");
Page[70]=new Array("Use notebooks to set up general categories for activity, project, EPS, and WBS notes. You can assign notebooks in any project.","Choose Admin, Admin Categories.","Click the Notebook Topics tab, then click Add.","Type the name of the new notebook.","Mark the checkbox in the appropriate column to make the new notebook available in EPS, Project, WBS, or Activity views.","Tip","To change the order in which notebook topics are listed, select the notebook topic you want to move, then click Shift Up or Shift Down.","Create notebooks (P6 Professional Only)","create_notebooks.htm");
Page[71]=new Array("Choose Admin, Admin Categories.","Click the Notebook Topics tab.","Double-click the notebook whose name you want to change, then enter the notebook's new name.","Tip","To change the order in which notebook topics are listed, select the notebook topic you want to move, then click Shift Up or Shift Down.","Note","If you change a notebook's name, your change applies to all assignments.","Change notebook names (P6 Professional Only)","change_notebook_names.htm");
Page[72]=new Array("Choose Admin, Admin Categories.","Click the Notebook Topics tab.","Select the notebook topic you want to delete, then click Delete.","Click Yes.","Delete notebooks (P6 Professional Only)","delete_notebooks.htm");
Page[73]=new Array("A unit of measure describes the quantity of a particular resource. Labor resources are often measured in units of time, such as hours or days; materials can be measured in cubic or linear feet, or perhaps in tons or kilos; items used one-by-one can be measured individually (EA) or as shipped: a box, a case, a pallet. Money is generally measured in monetary units, such as dollars, Euros, or yen.","Choose Admin, Admin Categories.","In the Units of Measure tab, click Add.","In the Unit Abbreviation column, type the abbreviation to use as the label for the new unit of measure.","In the Unit Name column, type the name of the new unit of measure.","Define the units of measure for material resources (P6 Professional Only)","define_units_of_measure_for_material_resources.htm");
Page[74]=new Array("You can delete any available unit of measure.","Choose Admin, Admin Categories.","Select the Units of Measure tab, then select a Unit Abbreviation or Unit Name.","Click Delete.","Note","If the units of measure you attempt to delete is in use, a message will prompt you that the unit of measure is still in use. Click Yes to continue deleting. The unit of measure is deleted from the resource, but the resource remains.","Delete Units of Measure (P6 Professional Only)","delete_units_of_measure.htm");
Page[75]=new Array("You can specify the monetary unit or base currency used to store costs for all projects in the database, as well as the monetary unit or view currency used to display costs in windows and dialog boxes.","The exchange rate for the base currency is always 1.0. If you select a different currency than the base currency to view costs, the base currency value is multiplied times the current exchange rate for the view currency to calculate the values displayed in cost fields.","For example, if the base currency is U.S. Dollars, the view currency is Euros, and the exchange rate is 0.75 = $1, a value of $10 stored in the database is displayed as 7.5 in cost fields in windows and dialog boxes. Similarly, if you enter 7.5 in a cost field, it is stored in the database as $10.","Note","Only a user with Admin Superuser privileges can change the base currency and define additional view currency types.","When you enter values in cost fields, they are always displayed in the view currency.","If you are upgrading from a previous version, you should set up the base currency in the new version before you start adding and changing projects.","Currencies (P6 Professional Only)","currencies.htm");
Page[76]=new Array("Choose Admin, Currencies.","Click Add.","Click the General tab, then type an ID that clearly identifies the currency type.","Type the currency's name.","Enter the symbol used to identify the currency.","Enter the global exchange rate for the currency.","Click the Appearance tab, then select the symbol used to separate whole values from decimal values in the currency display, for example, 500.5 or 500,5.","Select the symbol used to separate groups of digits in the currency display, for example, 300,000 or 300-000.","Select the number of decimal places to display in currency values, for example, none (70), one (70.1), or two (70.14).","Select the format used to display positive and negative currency values.","Add a view currency (P6 Professional Only)","add_a_view_currency.htm");
Page[77]=new Array("The base currency, by default, is U.S. dollars.","Choose Admin, Currencies.","Select the current base currency, then click the General tab.","Type the new ID, name, and symbol over the existing values, to define the new base currency.","Click the Appearance tab.","Select the symbol used to separate whole values from decimal values in the currency display, for example, 500.5 or 500,5.","Select the symbol used to separate groups of digits in the currency display, for example, 300,000 or 300-000.","Select the number of decimal places to display in currency values, for example, none (70), one (70.1), or two (70.14).","Select the format used to display positive and negative currency values.","Tip","If you want to view costs in the old base currency, you will need to add it back to the list of available currencies.","Note","The Base checkbox indicates which currency is used to store cost data. You cannot mark or clear this checkbox.","Define a base currency (P6 Professional Only)","define_a_base_currency.htm");
Page[78]=new Array("P6 Professional enables you to define your organization's global financial period calendars in the Financial Period Calendars dialog box. Customized financial periods provide more accurate display and reporting of actual units and costs. Rather than spreading costs evenly throughout the length of a project, users can view how actual costs were incurred by customized financial period.","If your organization always updates the schedule according to the same time interval (for example, every week, every month, every quarter, etc.), you can quickly create a calendar and add a batch of financial periods to it. If the schedule may be updated irregularly, you can create a single financial period for any financial period calendar at any time.","When financial period calendars exist, users can store period performance for any defined period of the financial period calendar assigned to the project. When you store period performance, actual units and costs are stored as past period actuals. The past period actual values can be edited for any financial period in columns of the Activity Table and Activity Details, Resources tab. Past period actual spreads per financial period can be viewed in the Activity Usage Spreadsheet and Resource Usage Spreadsheet, and past period actual data can be displayed in profiles, time-distributed reports, and the Tracking view.","Tip","To ensure that data is displayed correctly in financial period timescale intervals in P6 Professional, activity and resource data must be summarized by financial period. To summarize project data by financial period, choose Admin, Preferences, then select the Options tab. In the 'Select summarization periods' section, choose the 'By financial period' option; for each project, data will be stored in financial period intervals the next time you summarize the project.","Financial Periods (P6 Professional Only)","financial_periods.htm");
Page[79]=new Array("You can create a financial period calendar to allow users to store data by financial period. If your projects are reported according to differing financial periods, you can create several financial periods calendars and assign the appropriate financial period calendar on a project-by-project basis. ","Choose Admin, Financial Period Calendars.","Click Add.","In the Financial Period Calendar Name field, type the name for the new calendar.","If you want this calendar to be the default financial period calendar to be assigned to new projects and projects imported without a financial period calendar, mar the Default option.","Click Close.","Tip","After you have created a financial period calendar, you must create financial periods for the calendar before your users can use the financial period calendar to store data for their projects.","Note","You must have the Add/Edit/Delete Financial Period Calendars global privilege to add or edit data in the Financial Period Calendars dialog box.","Create a financial period calendar (P6 Professional Only)","create_a_financial_period.htm");

Page[80]=new Array("You can create a batch of financial periods when each financial period will have the same duration (for example, two weeks, one month, three months, etc.) over an extended period of time. When creating a batch of financial periods, the financial periods must be at least one week in duration.","Choose Admin, Financial Period Calendars.","Select a financial period calendar and click Modify.","In the Batch Create Financial Periods section of the Financial Periods dialog box, enter the Batch Start Date and the Batch End Date.","Choose the duration of each financial period by selecting one of the following options:<br /><br />To make each financial period in the batch a certain number of weeks long, choose Every n Weeks (where n is the number of weeks) and enter a number of weeks.<br /><br />To make each financial period in the batch a certain number of months long, choose Every n Months and enter a number of months.<br /><br />Select Every Year to make each financial period in the batch one year long.<br />","In the Period Ends On field, choose the weekday or the month you want each financial period to end on.<br /><br />If you selected weeks as the duration for the batch, you must select a day of the week. If you selected years as the duration for the batch, you must select a month. If you selected months as the duration for the batch, this field is disabled because each financial period will end on the last day of the month.<br />","Click Batch Create.<br /><br />The financial periods will be created and displayed in the list of financial periods.","Tip","When you create a financial period, the default name is YYYY-MM-DD (e.g., 2004-04-01). To ensure the financial periods are listed in the proper order (e.g., in the Columns dialog box), you should use the default name or add a letter or number to the beginning of the name (e.g., 1 Fiscal Month, 2 Fiscal Month, etc.). Click on a period in the Period Name column to edit the name.","If your organization summarizes project data by financial period, to ensure that all project data in the database will be summarized (including closed projects), you must create financial period calendars that span the date range of all projects in the database. For example, if the oldest project using a particular financial period calendar has a project start date of October 1st, 2001, the financial periods for that calendar should begin on or before that date.","Note","You must have the Add/Edit/Delete Financial Period Calendars global privilege to add or edit data in the Financial Periods dialog box.","The start and end dates of a financial period cannot overlap existing financial period dates.","You cannot modify the start and end dates of a financial period after you create it. To modify the start and end dates of a period, you must delete the financial period, then create a new period with the new dates.","All periods start at midnight and end at 11:59 PM.","Create a batch of financial periods (P6 Professional Only)","create_a_batch_of_financial_periods.htm");
Page[81]=new Array("Choose Admin, Financial Period Calendars.","Click the financial period calendar containing the period you want to delete.","In the list of financial periods, select the period you want to delete.","Click Delete.","Note","You cannot delete a financial period that contains past period actual data for at least one project. If you attempt to delete multiple financial periods at the same time, none of the financial periods will be deleted if any period contains past period actual data. In this case, to delete a financial period, you must archive and delete the project containing past period actuals, then delete the financial period.","You must have the Add/Edit/Delete Financial Period Calendars global privilege to delete a financial period.","Delete a financial period (P6 Professional Only)","delete_a_financial_period.htm");
Page[82]=new Array("A user account provides a secure means for a person in your organization to access and use P6 Professional, however a user account alone isn't sufficient to access the software. A user account requires access to modules, and to be assigned security profiles. You might also need to assign your user access to resources.","Modules","The modules available for P6 Professional are:","P6 Professional","P6 Visualizer","You can assign a user access to either or both.","Security Profiles","Security profiles are collections of privileges that determine what a user assigned that security profile will or will not be allowed to do in P6 Professional. Users you create will not have access to any projects or features until you assign them a security profile.","Global security profiles allow you to restrict what users can do with global data (for example, resources, roles, codes, and calendars) and the actions they can take (for example, importing and exporting data, running services, using secure codes, and provisioning users).","Project security profiles allow you to restrict what users can do in projects assigned to a given OBS (also known as a Responsible Manager).","Resource Security","Resource security allows the administrator to restrict a user's resource access. By default, new users do not have access to resources.","Rules for Usernames and Passwords","The following rules apply to the usernames you can create and the passwords your users can use.","Login names for users must be between 1 and 255 characters long.","If the Enable Password Policy check box is cleared in the Admin Preferences dialog box, passwords must be between 1 and 20 characters long. If the Enable password policy check box is selected in the Admin Preferences dialog box, passwords must be at least 8 characters long and must contains at least one alpha and one numeric character.","If you intend to use reporting software, avoid using commas when creating data other than Project names. The way that data is passed to some reporting software can cause a comma to be interpreted as a delimiter between data items.","Oracle recommends the use of strong passwords. Strong passwords in P6 Professional are defined as passwords containing between 8 to 20 characters and at least one numeric and one alpha character. To further strengthen the password, use a mixture of upper and lower case letters.","To set up a new user:","Add a new user.","Assign the user access to the modules they will need to use.","Assign a global security profile.","Assign project security profiles to OBS nodes.","Users (P6 Professional Only)","112906.htm");
Page[83]=new Array("For each user, you perform the following steps to implement access to P6 Professional.","Note Personal information (PI) may be stored in this area of P6 EPPM.","Administrators should refer to the Consent Notices section of the Application Administration Guide. All other users of P6 EPPM should refer to the Consent notices section of the Help.","Choose Admin, Users.","Click Add to add a user.","On the General tab:","Enter the user's login name and personal name.","Click Password to enter the user's password. The minimum password requirements depend on the status of the password policy, and are described in the Change Password dialog box.","On the Global Access tab:","Assign a global security profile to the user. Global security profiles determine the global actions the user can perform and are defined in the Security Profiles dialog box (choose Admin, Security Profiles).","Enable or disable resource security for the user. To enable access to all resources, mark the All Resource Access checkbox (Admin Superusers automatically get All Resource Access). To restrict resource access to specific resource nodes, select up to five resource nodes. To disable access to all resources, clear the All Resource Access checkbox (if necessary), and do not select a resource node.","On the Project Access tab, click Assign to assign the user to an OBS element (responsible manager), then select an existing project security profile.<br /><br />This grants the user access to WBS elements (and associated activities) for which the assigned OBS element is responsible, in all projects. For the projects the user can access based on the user's OBS assignment, the project security profile determines the actions the user can perform for these projects.","On the Module Access tab, mark the checkbox for P6 Professional. This enables the user to access the application.","Note","While a user is working offline, changes to certain data can cause them not to be able to switch to working online. To ensure users who are currently working offline are not prevented from switching to working online, avoid making changing any of the following data if any user might currently be working offline: User details, Global or project security profiles, OBS assignments (both for users and for projects), and Resource security.","Only an Admin Superuser can add, edit, or delete Admin Superusers or change an Admin Superuser's password.","Only an Admin Superuser can apply the Admin Superuser profile to a user. Any user with the Add/Edit/Delete Users privilege can apply the Project Superuser profile to a user.","Setting up user security (P6 Professional Only)","setting_up_user_security.htm");
Page[84]=new Array("The P6 Professional module access option controls whether users can attempt to log into the P6 Professional application.","The Visualizer module access option controls whether users can attempt to log into the Visualizer application.","For each defined user, a user with the required security privilege can enable or disable access to the products listed in the Users dialog box (choose Admin, Users, then click the Module Access tab).","Module access (P6 Professional Only)","module_access.htm");
Page[85]=new Array("Security profiles determine a user's level of access to project information. The security profiles include both global profiles and project profiles. A global profile determines the user's access to application-wide information. A project profile determines the user's level of access to each project within the Enterprise Project Structure (EPS).","When connected to a P6 EPPM database: When you assign a project profile to a user as defined in P6, you also associate the project profile with an OBS element/responsible manager.","When connected to a P6 Professional database: When you assign a project profile to a user, you also associate the project profile with an OBS element/responsible manager.","The user's access privileges, as defined in the project profile, will then apply only to those elements of the EPS that are assigned to the OBS element/responsible manager you selected. ","Note","While a user is working offline, changes to certain data can cause them not to be able to switch to working online. To ensure users who are currently working offline are not prevented from switching to working online, avoid making changing any of the following data if any user might currently be working offline: User details, Global or project security profiles, OBS assignments (both for users and for projects), and Resource security.","Security profiles","security_profiles.htm");
Page[86]=new Array("P6 Professional requires that all users have a global profile. A global profile defines a set of privileges for access to global, or application-wide, information such as cost accounts, resources, and roles.","When P6 Professional is connected to a P6 EPPM database: ","To control user access to global information, you create global profiles using P6, and then assign specific profiles to individual users.","To allow complete access to all global information and all projects (assuming all applicable options have been applied using P6), you can assign a global profile called Admin superuser. You can assign the Admin Superuser profile to as many users as you like. However, since the Admin Superuser profile enables access to all information, you would typically restrict the number of users to whom you assign this profile. You cannot edit the Admin Superuser security profile.","Note Only an Admin Superuser can apply the Admin Superuser profile to a user.","When P6 Professional is connected to a P6 Professional database: ","To control user access to global information, you create global profiles, and then assign specific profiles to individual users.","To allow complete access to all global information and all projects (assuming all applicable checkboxes are marked on the Users dialog box, Module Access tab), you can assign a global profile called Admin superuser.","Global profiles","global_profiles.htm");
Page[87]=new Array("A global profile definition specifies the individual access privileges associated with the profile. For a global profile, access privileges apply to application-wide information and settings. The module requires you to assign a global profile to each user.","Edit Global Change Definitions option","Determines whether the profile will enable users to create, modify, and remove Global Change specifications available to all users in P6 Professional.","Add/Edit/Delete Categories option","Determines whether the profile will enable users to create, modify and remove categories data as defined in the Admin Categories dialog box.","Delete Resources option","Determines whether the profile will enable users to remove resource data. This privilege also selects the 'Add Resources' and 'Edit Resources' global privileges.","Note When a resource is deleted, all historical data for that resource and its assignments is also deleted. This includes resource costs and spreads from all projects to which that resource was assigned. Deleting resources can change the costs and units figures for all projects to which that resource was assigned. In most circumstances users should not delete reresources, but clear the Active option for the resource on the Resources tab on the Resources Administration page.","Exercise extreme caution when assigning the Delete Resources privilege.","Add Resources option","Determines whether the profile will enable users to create resource data. This privilege also selects the 'Edit Resources' global privilege.","Edit Resources option","Determines whether the profile will enable users to modify resource data. This privilege also enables users to assign, modify, and remove role assignments. To display resources' price/unit in reports, users must have this privilege and the 'View Resource and Role Costs/Financials' global privilege assigned to their profile. To display resource skill level (a resource's role proficiency) in the application and in reports, users must have this privilege and the 'View Resource Role Proficiency' global privilege assigned to their profile.","View Resource Role Proficiency option","Determines whether the profile will enable users to display, group/sort, filter, search, and report on resource and role proficiency. To display resource skill level (a resource's role proficiency), users must have this privilege and the Edit Resources global privilege assigned to their profile.","Add/Edit/Delete Cost Accounts option","Determines whether the profile will enable users to create, modify, and remove cost accounts data.","Import P6 Professional XER and MPX option","Determines whether the profile will enable users to import projects, resources, and roles from XER and MPX formats using P6 Professional. To create new projects when importing, users must also have the 'Create Project' project privilege assigned to their profile. Users must be an Admin or Project Superuser to update a project from an XER file.","Import XML option","Determines whether the profile will enable users to import projects from P6 Professional and Microsoft Project using XML format. To create new projects when importing, users must also have the 'Create Project' project privilege assigned to their profile.","Note For Microsoft Project imports, you can only create a new project (not update an existing one) during import. Also, P6 Professional supports imports from Microsoft Project 2002.","Import XLSX option","Determines whether the profile will enable users to import projects, resources, and roles from XLSX files into P6 Professional.","Add/Edit/Delete Global Reports option","Determines whether the profile will enable users to create, modify, and remove global reports, including editing report groups and global report batches and saving global reports created or modified in P6 Professional.","Edit Global Tracking Layouts option","Determines whether the profile will enable users to create, modify, and remove global tracking layouts in P6 Professional.","Add/Edit/Delete Roles option","Determines whether the profile will enable users to create, modify, and remove roles data.","Edit Global Activity Codes option","Determines whether the profile will enable users to modify global activity codes data. This privilege also enables users to create, modify, and remove global activity code values and associated Visualizer colors.","Add Global Activity Codes option","Determines whether the profile will enable users to create global activity codes and code values data. This privilege also selects the 'Edit Global Activity Codes' global privilege.","Delete Global Activity Codes option","Determines whether the profile will enable users to remove global activity codes and code values data. This privilege also selects the 'Add Global Activity Codes' and 'Edit Global Activity Codes' global privileges.","Add/Edit/Delete Global Calendars option","Determines whether the profile will enable users to create, modify, and remove global calendars data.","Add/Edit/Delete Resource Calendars option","Determines whether the profile will enable users to create, modify, and remove resource calendars data. This privilege also enables users to edit Shifts in P6 Professional. ","Add/Edit/Delete Security Profiles option","Determines whether the profile will enable users to create, modify, and remove global and project security profiles, which grant access to application-wide and project-specific information.","Add/Edit/Delete Users option","Determines whether the profile will enable users to create, modify, and remove P6 Professional user data. To search the LDAP directory when provisioning, users must also have the Provision Users from LDAP global privilege.","Add/Edit/Delete Global Activity and Assignment Layouts and Filters option","Determines whether the profile will enable users to create, modify, and remove global activity and resource assignment layouts and filters.","Add/Edit/Delete OBS option","Determines whether the profile will enable users to create, modify, and remove hierarchical data for the global Organizational Breakdown Structure.","Edit Project Codes option","Determines whether the profile will enable users to modify project codes data. This privilege also enables users to create, modify, and remove project code values.","Add Project Codes option","Determines whether the profile will enable users to create project codes and code values data. This privilege also selects the 'Edit Project Codes' global privilege.","Delete Project Codes option","Determines whether the profile will enable users to remove project codes and code values data. This privilege also selects the 'Add Project Codes' and 'Edit Project Codes' global privileges.","Edit Assignment Codes option","Determines whether the profile will enable users to modify assignment codes data. This privilege also enables users to create, modify, and remove assignment code values.","Add Assignment Codes option","Determines whether the profile will enable users to create assignment codes and code values data. This privilege also selects the 'Edit Assignment Codes' global privilege.","Delete Assignment Codes option","Determines whether the profile will enable users to remove assignment codes and code values data. This privilege also selects the 'Add Assignment Codes' and 'Edit Assignment Codes' global privileges.","Edit Resource Codes option","Determines whether the profile will enable users to modify resource codes data. This privilege also enables users to create, modify, and remove resource code values.","Add Resource Codes option","Determines whether the profile will enable users to create resource codes and code values data. This privilege also selects the 'Edit Resource Codes' global privilege.","Delete Resource Codes option","Determines whether the profile will enable users to remove resource codes and code values data. This privilege also selects the 'Add Resource Codes' and 'Edit Resource Codes' global privileges.","Add Role Codes option","Determines whether the profile will enable users to create role codes and code values data. This privilege also selects the 'Edit Role Codes' global privilege.","Edit Role Codes option","Determines whether the profile will enable users to modify role codes data. This privilege also enables users to create, modify, and remove role code values.","Delete Role Codes option","Determines whether the profile will enable users to remove role codes and code values data. This privilege also selects the 'Add Role Codes' and 'Edit Roles' global privileges.","Add/Edit/Delete Global Portfolios option","Determines whether the profile will enable users to create, modify, and remove global portfolios.","Administer Global External Applications option","Determines whether the profile will enable users to create, modify, and remove entries in the list of global external applications in P6 Professional.","Add/Edit/Delete Funding Sources option","Determines whether the profile will enable users to create, modify, and remove funding source data.","View Resource and Role Costs/Financials option","Determines whether the profile will enable users to display all values for labor, material, and nonlabor resource costs, price/unit values for roles, and costs for resource and resource assignments User Defined fields. For users who do not have this privilege assigned to their profile, all areas that display monetary values for labor, material, and nonlabor resources and roles will display dashes and cannot be edited. For resources, such areas include resource price/unit, values in resource spreadsheets and histograms in Resource Analysis and Team Usage, and Cost data types for Resource User Defined fields. For roles, the area is the price/unit value in roles data. To display resources' price/unit, users must have this privilege and the 'Edit Resources' global privilege assigned to their profile.","Administer Job Services option","Determines whether the profile will enable users to set up the Apply Actuals, Batch Reports, Export, Schedule, and Summarize services to run at specific time intervals using the Job Service.","Add/Delete Secure Codes option","Determines whether the profile will enable users to create and remove all secure project codes, global and EPS-level activity codes, resource codes, role codes, issue codes, and code values data. This privilege also selects the 'Edit Secure Codes,' 'Assign Secure Codes,' and 'View Secure Codes' global privileges.","Edit Secure Codes option","Determines whether the profile will enable users to modify all secure project codes, global and EPS-level activity codes and associated activity code value colors, and resource codes and code values data, as well as all secure issue codes, and code values data. This privilege also selects the &quot;Assign Secure Codes&quot; and &quot;View Secure Codes&quot; global privileges.","Assign Secure Codes option","Determines whether the profile will enable users to assign all secure project codes, global and EPS-level activity codes, resource codes role codes, issue codes, and code values data. This privilege also selects the 'View Secure Codes' global privilege.","View Secure Codes option","Determines whether the profile will enable users to display all secure project codes, global and EPS-level activity codes, and resource codes and code values data, as well as all secure issue codes and code values data.","Add/Edit/Delete Currencies option","Determines whether the profile will enable users to create, modify, and remove currencies data.","Add/Edit/Delete Categories option","Determines whether the profile will enable users to modify administrative categories as defined in the Admin Categories dialog box.","Edit Admin Preferences option","Determines whether the profile will enable users to modify administrative preferences as defined in the Admin Preferences dialog box.","Provision Users from LDAP","Determines whether the profile will enable users to search the LDAP directory when provisioning. For users who do not have this privilege assigned to their profile, the option to load an LDIF file to provision users will still be enabled. To search the LDAP directory, users also must also have the 'Add/Edit/Delete Users' global privilege.","Add/Edit/Delete Global Visualizer Layouts option","Determines whether the profile will enable users to edit, rename, and delete global Visualizer layouts, and allows users to promote (add) layouts from the User or Project Layouts category. To promote layouts from the Projects Layout category, you also need the Add/Edit/Delete Project Visualizer Layouts privilege.","Add/Edit/Delete Global Visualizer Filters option","Determines whether the profile will enable users to create, modify, and remove global filters in Visualizer.","Add/Edit/Delete Resource Curves option","Determines whether the profile will enable users to create, modify, and remove resource distribution curves definitions.","Add/Edit/Delete User Defined fields option","Determines whether the profile will enable users to create, modify, and remove User Defined fields. Even without this privilege, users can still display User Defined fields information.","Add/Edit/Delete Global Project/WBS Layouts option","Determines whether the profile will enable users to create, modify, and remove global project and WBS layouts.","Add/Edit/Delete Microsoft and Primavera Templates option","Determines whether the profile will enable users to create, modify, and remove templates that are used to import and export data to and from Microsoft Excel, Microsoft Project, Primavera XML, and Primavera XER formats.","Add/Edit/Delete Activity Step Templates option","Determines whether the profile will enable users to create, modify, and remove Activity Step Templates, which are used to add a set of common steps to multiple activities.","Add/Edit/Delete Financial Period Calendars option","Determines whether the profile will enable users to create, modify, and remove financial period calendars and financial period calendar data. To edit period data, users must also have the 'Edit Period Performance' project privilege assigned to their profile.","Add/Edit/Delete Stored Images option","Determines whether the profile will enable users to create, modify, and remove stored images.","Tip","P6 Professional includes a global profile called Admin Superuser. This profile automatically gives a user all of the preceding privileges for all projects and P6 Professional features (assuming all applicable checkboxes are marked on the Users dialog box, Module Access tab). To enable read/write privileges for all projects and features, you can apply the Admin Superuser profile to a user. ","The previous table groups each privilege by functionality. The privileges are listed in the same order as displayed in the Security Profiles dialog box. To view the privileges in alphabetical order in the Security Profiles dialog box, click the Privileges bar.","Global Privilege Definitions (P6 Professional Only)","48405.htm");
Page[88]=new Array("A global profile that gives a user read/write privileges for application-wide information and features. This information includes all projects, resources, cost accounts, and users. An Admin superuser always has access to all resources. If resource security is enabled, resource access settings will be ignored.","Admin superuser","admin_superuser.htm");
Page[89]=new Array("A project profile defines a set of privileges for access to project-specific information. Project profiles are assigned to users based on the OBS hierarchy. To control access to project-specific information, you create project profiles, and then assign specific OBS elements and associated project profiles to individual users. When P6 Professional is connected to a P6 EPPM database, you do those tasks using P6. The assigned OBS element determines the EPS and WBS elements for which the user can access project information. The assigned project profile determines the type of access privileges the user has to that project information.","All WBS elements must have an assigned responsible OBS. If a user's project profile assignment includes a WBS element's responsible OBS, then the user can access all activities&nbsp;and issues related to that WBS element. Similarly, all thresholds and project issues also have an assigned responsible OBS. If a user's project profile assignment includes a threshold or issue's responsible OBS, then the user can access that threshold or issue.","When P6 Professional is connected to a P6 Professional database:","The module does not require that each user have a profile for every project. However, unless a user's global profile is Admin Superuser, that user cannot access a project without a project profile. See Admin superuser. To allow complete access to a project/OBS assignment, the module includes a project profile called Project Superuser. You can apply the Project Superuser profile to as many users and for as many projects as you like. See Project superuser. Only an Admin Superuser can apply the Admin Superuser profile to a user.","When P6 Professional is connected to a P6 EPPM database:","When Each user does not require a profile for every project. However, unless a user's global profile is Admin Superuser, that user cannot access a project without a project profile. See Admin superuser. To allow complete access to a project/OBS assignment, you can apply a project profile called Project Superuser. You can apply the Project Superuser profile to as many users and for as many projects as you like. See Project superuser. Only an Admin Superuser can apply the Admin Superuser or Project Superuser profile to a user.","Project profiles","project_profiles.htm");
Page[90]=new Array("A project profile definition identifies the specific access privileges that are granted by the profile. Each project profile is associated with an organizational breakdown structure (OBS) element to determine which EPS structure elements an individual user can access.","Add Projects option","Determines whether the profile will enable users to modify EPS budget logs, funding sources, and spending plans.","Delete Projects option","Determines whether the profile will enable users to delete, cut, and paste projects within the EPS node.","Summarize Projects option","Determines whether the profile will enable users to summarize data for all projects in the EPS.","Edit Project Details Except Costs/Financials option","Determines whether the profile will enable users to edit fields in General, Dates, Defaults, Resources, and Settings tabs in Project Details. To assign a project baselines, users must also have the &quot;Assign Project Baselines&quot; project privilege assigned to their profile.","Add/Edit/Delete Issues and Issue Thresholds option","Determines whether the profile will enable users to create, modify, and remove thresholds and issues assigned to projects. The privilege also enables users to assign issue codes to project issues.","Add/Edit/Delete Project Baselines option","Determines whether the profile will enable users to create, modify, and remove baselines for projects.","Add/Edit/Delete Project Calendars option","Determines whether the profile will enable users to create, modify, and remove calendars assigned to projects.","Add/Edit/Delete Risks option","Determines whether the profile will enable users to create, modify, and remove risks assigned to projects.","Add/Edit/Delete Template Documents option","Determines whether the profile will enable users to create, modify, remove project template documents. If the content repository is installed and configured, this privilege also enables P6 users to check out and start reviews for project template documents. P6 Professional users cannot open documents added via a P6 installation with a configured content repository. A profile must be assigned the 'Add/Edit/Delete Work Products and Documents' project privilege before you can select this privilege.","Add/Edit/Delete Work Products and Documents option","Determines whether the profile will enable users to create, modify, and remove project documents that do not have a security policy applied. Document security policies are available only in P6 and only for documents stored in the content repository. When the content repository is installed and configured, this privilege also enables users to create document folders in P6.","Assign Project Baselines option","Determines whether the profile will enable users to assign project baselines to projects. To assign project baselines, users must also have the 'Edit Project Details Except Costs/Financials' project privilege assigned to their profile.","Approve Timesheets as Project Manager option","Determines whether the profile will enable users to approve or reject submitted timesheets as a Project Manager in Timesheet Approval.","Administer Project External Applications option","Determines whether the profile will enable users to modify entries in the External Applications feature in P6 Professional.","Schedule Projects option","Determines whether the profile will enable users to schedule a project.","Level Resources option","Determines whether the profile will enable users to level resources.","Apply Actuals option","Determines whether the profile will enable users to apply actuals to activities in a project.","Store Period Performance option","Determines whether the profile will enable users to track an actual this period value for actual units and costs in a project. A user must be assigned the Add/Edit Activities Except Relationships project privilege before you can assign this privilege.","Edit Period Performance option","Determines whether the profile will enable users to modify period performance values for labor and nonlabor units as well as labor, nonlabor, material, and expense costs using P6 Professional. The 'Add/Edit Activities Except Relationships' and 'View Project Costs/Financials' project privileges are also required for this functionality.","Maintain Project Baselines option","Determines whether the profile will enable users to create, modify, and remove baselines for projects.","Run Baseline Update option","Determines whether the profile will enable users to update a project's baselines with new project information using the Update Baseline utility.","Assign Project Baselines option","Determines whether the profile will enable users to assign project baselines to projects. To assign project baselines, users must also have the 'Edit Project Details Except Costs/Financials' project privilege assigned to their profile.","Add/Edit/Delete Work Products and Documents option","Determines whether the profile will enable users to create, modify, and remove a project's work products and documents.","View Project Costs/Financials option","Determines whether the profile will enable users to display all monetary values for projects. For users who do not have this privilege assigned to their profile, all areas that display monetary values will display dashes and cannot be edited. To use the Recalculate Assignment Costs feature, users must also have the 'Add/Edit Activities Except Relationships' project privilege assigned to their profile. To display the resource price/unit, users must have the 'View Resource and Role Costs/Financials' global privilege assigned to their profile.","Edit Project Activity Codes option","Determines whether the profile will enable users to modify project activity codes data. This privilege also enables users to create, modify, and remove project activity code values and associated Visualizer colors.","Add Project Activity Codes option","Determines whether the profile will enable users to create project activity codes and code values data. This privilege also selects the 'Edit Project Activity Codes' project privilege.","Delete Project Activity Codes option","Determines whether the profile will enable users to remove project activity codes and code values data. This privilege also selects the 'Add Project Activity Codes' and 'Edit Project Activity Codes' project privileges.","Edit EPS Activity Codes option","Determines whether the profile will enable users to modify the name of EPS-level activity codes. This privilege also enables users to create, modify, and remove EPS-level activity code values and associated Visualizer colors.","Add EPS Activity Codes option","Determines whether the profile will enable users to create EPS-level activity codes and code values. This privilege also selects the 'Edit EPS Activity Codes' project privilege.","Delete EPS Activity Codes option","Determines whether the profile will enable users to remove EPS-level activity codes and code values data. This privilege also selects the 'Add EPS Activity Codes' and 'Edit EPS Activity Codes' project privileges.","Monitor Project Thresholds option","Determines whether the profile will enable users to run the threshold monitor for a project.","Publish Project Web site option","Determines whether the profile will enable users to publish a project's Web site.","Edit Project Reports option","Determines whether the profile will enable users to edit a project's reports, edit a project's report batches, and export reports.","Add/Edit/Delete Project Calendars option","Determines whether the profile will enable users to create, modify, and remove calendars assigned to projects.","Run Global Change option","Determines whether the profile will enable users to run Global Change to update activity detail information.","Check In/Check Out Projects and Open Projects Exclusively option","Determines whether the profile will enable users to check projects out to work remotely and then check them back in. Also determines whether the profile will enable users to open projects exclusively.","Add/Edit/Delete WBS Except Costs/Financials option","Determines whether the profile will enable users to create, modify, and remove WBS hierarchy nodes and other WBS level data including notebook entries, earned value settings, milestones, and dates. This privilege does not allow users to edit cost and financial data at the WBS level.","Edit WBS Costs/Financials option","Determines whether the profile will enable users to modify Project or WBS budget logs, funding sources, spending plan, and financial data at the project level. To edit costs and financials at the WBS level, including cost UDFs, users must also have the &#8216;Add/Edit/Delete WBS Except Costs/Financials' project privilege assigned to their profile. The &#8216;Edit WBS Costs/Financials' privilege also selects the 'View Project Costs/Financials' project privilege.","Add/Edit/Delete EPS Except Costs/Financials option","Determines whether the profile will enable users to create, modify, and remove EPS hierarchy nodes, edit EPS notebook, and edit all EPS-related data except financial information.","Edit EPS Costs/Financials option","Determines whether the profile will enable users to modify EPS budget logs, funding sources, and spending plans.","Add/Edit/Delete Expenses option","Determines whether the profile will enable users to create, modify, and remove expenses assigned to projects.","Add/Edit/Delete Issues and Issue Thresholds option","Determines whether the profile will enable users to create, modify, and remove thresholds and issues assigned to projects. The privilege also enables users to assign issue codes to project issues.","Add/Edit/Delete Activity Relationships option","Determines whether the profile will enable users to create, modify, and remove activity relationships assigned to projects.","Add/Edit Activities Except Relationships option","Determines whether the profile will enable users to create and modify all activity information in projects, except activity relationships. To modify activity IDs, users must also have the 'Edit Activity ID' project privilege assigned to their profile. To use the Recalculate Assignment Costs feature, users must also have the 'View Project Costs/Financials' project privilege assigned to their profile.","Delete Activities option","Determines whether the profile will enable users to remove activities from projects.","Edit Activity ID option","Determines whether the profile will enable users to modify activity IDs. To modify activity IDs, users must also have the 'Add/Edit Activities Except Relationships' project privilege assigned to their profile.","Edit Future Periods option","Determines whether the profile will enable users to enter, modify, and delete future period assignment values in the Planned Units and Remaining (Early) Units fields of the Resource Usage Spreadsheet using P6 Professional. The 'Add/Edit Activities Except Relationships' project privilege is also required for this functionality.","Add/Edit/Delete Project Level Layouts option","Determines whether the profile will enable users to create, edit, and delete project level layouts in Activities, Assignments, or WBS views.","Add/Edit/Delete Project Visualizer Layouts option","Determines whether the profile will enable users to create, modify, and remove project layouts in Visualizer.","Add/Edit/Delete Risks option","Determines whether the profile will enable users to assign risks to activities and to create, modify, and remove risks.","Tip","A project profile, Project Superuser, automatically gives a user all of the above privileges for each project, according to the specified OBS element. ","To allow read-write privileges for all aspects of a project, you can assign a user to a project's root OBS element and then apply the Project Superuser profile to the project/OBS assignment. ","The previous table groups each privilege by functionality. The privileges are listed in the same order as displayed in the Security Profiles dialog box. To view the privileges in alphabetical order in the Security Profiles dialog box, click the Privileges bar.","Note To view resources' price/unit in reports, users must have &quot;Edit Resources&quot; and &quot;View Resource and Role Costs/Financials&quot; global privileges assigned to their profile.","Project Privilege Definitions (P6 Professional Only)","48406.htm");
Page[91]=new Array("A project profile that gives a user read/write privileges for all project/ OBS specific information and features.","Project superuser","project_superuser.htm");
Page[92]=new Array("Choose Admin, Users.","Click Add.","What appears next depends on your security configuration:","If P6 Professional is running in Native authentication mode, the Add User dialog box will appear:","Fill in the Login Name, Personal name, Enter new password, and Confirm new password fields.","Click OK.","If the ability to edit a personal resource calendar is required, you can select an associated resource from the Resource ID / Resource Name for Personal Calendar field, or you can create the link when you add resources.","Click the Contact tab. Enter the user's email address and office phone number.","Click Close.","If P6 Professional is running in LDAP authentication mode, the Import Domain Users dialog box will appear:","Note You must have the Add/Edit/Delete Users privilege and the Provision Users from LDAP privilege to search the LDAP directory. You do not need the Provision Users from LDAP privilege to import users from the LDIF file.","Click the Load LDIF button, or enter an LDAP query under LDAP User Search Criteria.<br /><br />If you clicked the Load LDIP button, browse to the location of the LDIF file, and click Open.<br />If you entered an LDAP query (for example, for example, UID=*) click Search.<br />","A list of users will appear, grouped by category. <br /><br />For example, LDAP repository users that do not exactly match P6 Professional users will be grouped together. If users exist in the LDAP repository, the Login Name, Personal Name, User EMail Address, and Office Phone fields are populated based on the field mappings in the LDAP configuration settings.<br />","Select the Import option next to each Login Name that you with to import. New or modified users are automatically selected.","Click Import Users.","Click Close in the Users dialog box.","Tip","When you create new users, they are automatically assigned the default global profile.","If a user is also a resource, the email address and office phone number you type in the Users dialog box overwrites the email address and office phone number recorded in the Resources window General tab, if that information is different. Likewise, email and phone information you enter in the Resources window overwrites the information in the Users dialog box.","If P6 Professional is running in LDAP authentication mode, the Password button does not appear because password management is handled through the directory server.","Add new users (P6 Professional Only)","add_new_users.htm");
Page[93]=new Array("Choose Admin, Users.","Click Count.<br /><br />The Count dialog box displays the number of users and the user name of each user assigned access to P6 Professional. Expand a module to display the user name of each user assigned access to a module.<br />","If you want to print the displayed information, click Print. Otherwise, click Close.","Tip","When you click Print, the table prints the same as it appears on the screen. So collapsed nodes are not expanded for printing, and expanded nodes print the entire list of users. ","List number of users having access to P6 Professional (P6 Professional Only)","list_number_of_users_having_access_to_p6_modules.htm");
Page[94]=new Array("Choose Admin, Users.","Select the user whose security profiles you want to change.","To change a global profile, click the Global Access tab and select a new global profile.","To change a project profile, click the Project Access tab.<br /><br />To remove the user's current access to project information associated with a specific responsible manager, select the manager, then click Remove.<br /><br />To grant the user access to project information associated with a specific responsible manager, click Assign. Double-click the OBS element to which you want to grant access, then click Close.<br /><br />To change the user's security profile for a project, double-click the security profile you want to change, then select a new project profile.","Note","While a user is working offline, changes to certain data can cause them not to be able to switch to working online. To ensure users who are currently working offline are not prevented from switching to working online, avoid making changing any of the following data if any user might currently be working offline: User details, Global or project security profiles, OBS assignments (both for users and for projects), and Resource security.","Change user security profiles (P6 Professional Only)","change_user_security_profiles.htm");
Page[95]=new Array("Depending on your global profile, you may be able to change a user's password or your own.","Choose Admin, Users.","Select the General tab.","Select the user who requires a change of password.","Click Password.","In the New Password field, enter the new password.","In the Confirm New Password field, enter the password again, to verify it.","Click OK.","Note","If the Enable password policy setting is selected in the Password Policy field of the Admin Preferences dialog box, enter a password that is a minimum of 8 characters long, and that contains one alpha and one numeric character.","If the Enable password policy setting is not selected, enter a password up to 20 characters long.","If P6 Professional is running in LDAP authentication mode, password management is handled through the directory server. You cannot change your password through the module and the Password button does not appear on the Users dialog box General tab.","Passwords are case-sensitive.","Passwords that were set before the new password policy was enabled are valid and usable.","Change user passwords (P6 Professional Only)","change_user_passwords.htm");
Page[96]=new Array("Choose Admin, Users.","Select the user for whom you want to enable or disable module access, then click the Module Access tab.","In the Access column, mark or clear the checkbox for the modules you want to enable or disable for the selected user.","Enable or disable user access to P6 Professional (P6 Professional Only)","enable_or_disable_user_access_to_p6_products.htm");
Page[97]=new Array("Choose Admin, Users.","Select the user you want to remove, then click Delete.","Click Yes.","Remove users (P6 Professional Only)","remove_users.htm");
Page[98]=new Array("Choose Admin, Security Profiles.","Choose Global Profiles, then click Add.","Type the new profile's name.","To make the new profile the default global profile, mark the Default checkbox.","Mark the appropriate checkboxes to grant specific privileges to the profile.","Create global profiles (P6 Professional Only)","create_global_profiles.htm");
Page[99]=new Array("Choose Admin, Users.","Select the user to whom you want to assign a global profile.","Click the Global Access tab, then select a global security profile.","Tip","A global profile, Admin Superuser, allows complete access to global information, features, and all projects. To grant the user read/write privileges for all projects and features, select Admin Superuser as the global profile. You can apply the Admin Superuser profile to as many users as you like.","Only an Admin Superuser can apply the Admin Superuser profile to a user.","To verify which privileges are associated with a particular global profile, open the Security Profiles dialog box (choose Admin, Security Profiles).","Assign global profiles (P6 Professional Only)","assign_global_profiles.htm");
Page[100]=new Array("Choose Admin, Security Profiles.","Choose Global Profiles.<br /><br />To change a profile's name, double-click the profile, then type a new name.<br /><br />To make a profile the default profile, mark its corresponding Default checkbox.<br /><br />To change a profile's privileges, select the profile, then mark or clear the checkboxes to grant or deny each privilege.","Change global profiles (P6 Professional Only)","change_global_profiles.htm");
Page[101]=new Array("Choose Admin, Security Profiles.","Choose Global Profiles.","Select the profile, then click Delete.","Click Yes.","Delete global profiles (P6 Professional Only)","delete_global_profiles.htm");
Page[102]=new Array("Choose Admin, Security Profiles.","Choose Project Profiles, then click Add.","Type the new profile's name.","To make the new profile the default project profile, mark the Default checkbox.","Mark the appropriate checkboxes to grant specific privileges to the profile.","Note","Unless a user's global profile is Admin Superuser, a user cannot access any projects without a project profile. ","Create project profiles (P6 Professional Only)","create_project_profiles.htm");
Page[103]=new Array("Choose Admin, Users.","Select the user to whom you want to assign a project profile, then click the Project Access tab.","Click Assign.","Double-click the OBS element/responsible manager whose project information you want to allow the user to access, then click Close.","Double-click the Security Profile field, then select a profile.","Repeat steps 3 through 5 for all projects to which you want the user to have access.","Tip","A project profile, Project Superuser, allows complete access to a project/OBS assignment. To grant the user read/write privileges for all aspects of a project, select Project Superuser as the user's profile. Only an Admin Superuser can apply the Project Superuser profile to a user.","To verify which privileges are associated with a particular project profile, open the Security Profiles dialog box (choose Admin, Security Profiles).","Note","A user is not required to have a profile for every OBS element. However, unless a user's global profile is Admin Superuser, a user cannot access project information without a project profile. ","Assign project profiles (P6 Professional Only)","assign_project_profiles.htm");
Page[104]=new Array("Choose Admin, Security Profiles.","Choose Project Profiles.<br /><br />To change a profile's name, double-click the profile, then type a new name.<br /><br />To make a profile the default profile, mark the Default checkbox.<br /><br />To change a profile's privileges, select the profile, then mark or clear the checkboxes to grant or deny each privilege.","Change project profiles (P6 Professional Only)","change_project_profiles.htm");
Page[105]=new Array("Choose Admin, Security Profiles.","Choose Project Profiles.","Select the profile you want to delete, then click Delete.","Click Yes.","Delete project profiles (P6 Professional Only)","delete_project_profiles.htm");
Page[106]=new Array("When P6 Professional is connected to a P6 EPPM database, the administrator, using P6, can restrict a user's access to resource information.","When P6 Professional is connected to a P6 Professional database, the administrator can restrict a user's access to resource information. ","The administrator can enable or disable resource security for each user. When resource security is disabled, the user has access to all resources. When resource security is enabled, the user has access to either none of the resources or selected parts of the resource hierarchy.","Note Personal information (PI) may be stored in this area of P6 EPPM.","Administrators should refer to the Consent Notices section of the Application Administration Guide. All other users of P6 EPPM should refer to the Consent notices section of the Help.","How does resource security work?","To enable resource security, the administrator assigns each user to one or more resource nodes in the resource hierarchy. These are the user's root nodes. Then, the position of each root node in the resource hierarchy determines the resources to which the user has access. Once assigned to a resource node, the user has accessy to the root node and all of its children.","The administrator can give each user access to the following:","All Resources<br />The user has access to all resources with no restriction. This option disables resource security.<br />For Admin superusers, resource security access settings are ignored; they are always granted All Resources access. ","No Resources<br />The user has no access to resources. This is the default resource access to new users. Also, if a resource is deleted from the resource hierarchy, users that previously had been assigned to the deleted resource automatically get no access to resources.<br />If a user has no resources access, all global resource-related privileges are ignored.","Resource nodes (Selected Resources)<br />The user has access to the assigned resource nodes and their children.","Note","When connected to a P6 EPPM database: You need the appropriate global privilege to manage resource security.","When connected to a P6 Professional database: You need Add/Edit/Delete Users global privilege to manage resource security.","In the Resource Assignments window you still have access to current project resources. ","Example","The following examples illustrate how resource security applies to users assigned to different resource nodes:","Shannon Zhu has restricted access with the root resource IT - Information Technology Group assigned. Shannon sees the following resources in the resource dictionary: IT, MathiasL, RiceB, LiR, AbrahamM, WrenJ, AndersonG, SharpeD, VincentI, ChopraA, BennettC, ZhuS, SinghD, CharlesM, LaffertyV, PaxsonD, and ITCon.","Vanessa Lafferty has restricted access with the root resources AndersonG - Glen Anderson, VP Development and CharlesM - Mandy Charles, VP IT Ops assigned. Vanessa sees the following resources in the resource dictionary: AndersonG, SharpeD, VincentI, ChopraA, BennettC, ZhuS, SinghD, CharlesM, LaffertyV, PaxsonD, and ITCon.","Roy Li has no resource access. Roy cannot see any resources in the Resource Administration page. Roy can see resources assigned to a project he has open.","Lane Mathis has access to All Resources. Lane can see all of the resources in the entire resource dictionary.","Introduction to Resource Security","admin_res_sec_introduction.htm");
Page[107]=new Array("Before you implement resource security in your organization, you should know about the impact of restricting resource access in P6 Professional. Users with restricted resource access may experience the impact of the feature in the following major areas:","Resources View","If resource security is enabled, the Resources View's Filter By options display the following resources:","All active resources<br />Displays all active resources that you have access to in a hierarchy. Those current project resources that are outside of your resource root nodes are not displayed. ","All resources<br />Displays all resources that you have access to in a hierarchy. Those current project resources that are outside of your resource root nodes are not displayed. ","Current Project's Resources<br />Displays only those current project resources that you have access to. In other words, those current project resources, who are under your root resource nodes. (Resources that you do not have access to are not displayed even if they are current project resources.) ","Resource Assignments View","In the Resource Assignments View you still have access to all current project resources even if they are not under your root nodes. If you have the proper privilege, you can modify their assignments or reassign any resource to new activities. ","Importing and Exporting Resources/Projects","If you have no resource access, you cannot import new resources or activity resource assignments, or issues associated with new resources. If you have limited resource access, new resources are imported under your root nodes and you can update existing resources only if you have access to them.","Implementing Resource Security (P6 Professional Only)","admin_res_sec_implement.htm");
Page[108]=new Array("Resource security allows the administrator to restrict a user's resource information access by assigning the user to one or more resource nodes in the hierarchy. Those resource nodes are the user's root nodes. Once assigned to those root nodes, the user has access only to those resource nodes and all of their children.","Resource security settings are honored the next time the user logs in. Thus, if you modify your own resource security settings, the changes will not take place until you exit the module and login again.","To enable resource security by assigning the user to a resource node:","Choose Admin, Users.","Click the Global Access tab.","Select a user from the list.<br /><br />The bottom of the Global Access tab displays the selected user's current resource access information.<br />","To enable resource security, click the browse button in the Resource Access field, and assign up to five resource nodes to the current user. <br /><br />The current user gets access only to the selected resources and their children after the next login.","To enable resource security by giving the user no access to any resources:","Choose Admin, Users.","Click the Global Access tab.","Select a user from the list.<br /><br />The bottom of the Global Access tab displays the selected user's current resource access information.<br />","To give the current user no access to resources:<br />","Clear the All Resources Access checkbox, if it is marked.","Delete the Resource Access field, if it is not empty.<br /><br />The current user gets no access to any resources after the next login. This is the default for new users.","Note","The All Resources Access option disables resource security and gives the user access to all resources.","Admin Superuser always has All Resources access, regardless of the resource security access settings.","If you have restricted or no resource access, you cannot give All Resource access. This option is enabled only for users with all resource access.","Enable Resource Security (P6 Professional Only)","admin_res_sec_setting.htm");
Page[109]=new Array("Resource security allows the administrator to restrict a user's resource information access by assigning the user to up to five resource nodes in the hierarchy. Those resource nodes are the user's root nodes. Once assigned to those root nodes, the user has access only to those resource node and all of their children.","To disable resource security:","Choose Admin, Users.","Click the Global Access tab.","Select the user from the list.<br /><br />The bottom of the Global Access tab displays the selected user's current resource access information.<br />","Select All Resources. &nbsp;","All Resources<br />This option disables resource security for the selected user and gives access to all resources.","Note","Admin Superuser always has All Resources access, regardless of the resource security access settings. ","Disable Resource Security (P6 Professional Only)","admin_resc_sec_disable.htm");
Page[110]=new Array("The Global Access tab in the Users dialog displays the selected user's resource access settings. The same settings can be displayed as columns as well. To view resource access information, add the Resource Access and All Resources Access columns to display in the Users dialog box. These columns are not displayed by default. ","All Resources Access<br /><br />The All Resource Access column displays a checkbox for each user. If the checkbox is marked, the user has access to all resources. This option disables resource security.<br /><br />This column is available only for users with all resource access or Admin Superusers.<br />","Resource Access<br /><br />The Resource Access column displays the user's assigned nodes. The user has access to these resource nodes and all their children.<br /><br />If the Resource Access column is empty and the All Resources Access checkbox is unmarked, the user has no access to any resources.","Displaying Resource Access Information (P6 Professional Only)","admin_res_sec_display_column.htm");
Page[111]=new Array("You can change each user's resource access in the Users dialog any time. The new settings apply when the user logs in.","To change resource security:","Choose Admin, Users.","Click the Global Access tab.","Select a user from the list.<br /><br />The bottom of the Global Access tab displays the selected user's current resource access information.<br />","Change the user's resource access settings.","Note","While a user is working offline, changes to certain data can cause them not to be able to switch to working online. To ensure users who are currently working offline are not prevented from switching to working online, avoid making changing any of the following data if any user might currently be working offline: User details, Global or project security profiles, OBS assignments (both for users and for projects), and Resource security.","Since a user's resource access depends on the position of the assigned resources in the hierarchy, changing that position also means changing the user's resource access.","Change Resource Security (P6 Professional Only)","admin_res_sec_change.htm");
Page[112]=new Array("The EPS-level activity codes that a user has access to is based on their project access. Do the following to set up user security:","Set up the OBS security.","Set up the EPS structure and select the responsible manager (OBS name) for the EPS level. The EPS levels the user can access is based on the OBS selected.","Assign a project profile to the user. The project profile determines the privileges for all aspects of a project. ","Set up security for EPS-level activity codes (P6 Professional Only)","eps-level_activity_code_security.htm");
Page[113]=new Array("Only users with the appropriate combination of secure code and global EPS-level activity code privileges can add, edit, delete, view, and assign &quot;secure&quot; EPS-level activity codes and values.","To limit the access of a specific EPS-level activity code and its values to certain users, mark the Secure checkbox for the code in the Activity Code Definitions - EPS dialog box. You must have the Add EPS Activity Codes project-level security privilege and the Add and Delete Secure Codes global security privilege to set up a secure code. ","To add a secure EPS-level activity code in the Activity Code Definitions - EPS dialog box, you must have the Add EPS Activity Code project security privilege, and the Add and Delete Secure Code global security privilege.","To edit a secure EPS-level activity code in the Activity Code dictionary, you must have the Edit EPS Activity Code project security privilege, and the Add and Delete Secure Codes or Edit Secure Codes global security privileges.","To delete a secure EPS-level activity code from the Activity Code dictionary, you must have the Delete EPS Activity Code project security privilege, and the Add and Delete Secure Codes global security privilege.","To assign and remove EPS-level activity code values to/from an activity you have access to, you must have the project security privilege to Add/Edit Activities Except Relationships and access to the activity. Activity access is based on the OBS security settings. ","To assign or remove a secure EPS-level activity code to or from an EPS in the Activity Codes dictionary, you must have the Add/Edit Activities Except Relationships project security privilege, and the Assign Secure Codes global security privilege. ","Global and project privileges for EPS-level activity code security (P6 Professional Only)","eps_activity_code_security.htm");
var PageCount=116;


/*
Date: 1/6/2026 3:28 PM
Source: EPPM_26_dev
BookID: 97636
PubProduct: PRIMAVERA_P6_PRO
BookTitle: Administration Guide
Version: Version 26
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
