define(
{
    
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-70A1C5DA-8016-40E2-BE77-BDE69B6DDDDB"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Java Core Libraries",
                    "href":"java-core-libraries1.html#GUID-C6BE8117-F73E-4BE6-98AA-681A0CD4EEA9"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Serialization Filtering",
                    "href":"serialization-filtering1.html",
                    "topics":[
                        {
                            "title":"Addressing Deserialization Vulnerabilities",
                            "href":"addressing-serialization-vulnerabilities.html"
                        },
                        {
                            "title":"Java Serialization Filters",
                            "href":"java-serialization-filters.html"
                        },
                        {
                            "title":"Filter Factories",
                            "href":"filter-factories.html"
                        },
                        {
                            "title":"Allow-Lists and Reject-Lists",
                            "href":"allow-lists-and-reject-lists.html"
                        },
                        {
                            "title":"Creating Pattern-Based Filters",
                            "href":"creating-pattern-based-filters.html"
                        },
                        {
                            "title":"Creating Custom Filters",
                            "href":"creating-custom-filters.html",
                            "topics":[
                                {
                                    "title":"Reading a Stream of Serialized Objects",
                                    "href":"reading-stream-serialized-objects.html"
                                },
                                {
                                    "title":"Setting a Custom Filter for an Individual Stream",
                                    "href":"setting-custom-filter-individual-stream.html"
                                },
                                {
                                    "title":"Setting a JVM-Wide Custom Filter",
                                    "href":"setting-jvm-wide-custom-filter.html"
                                },
                                {
                                    "title":"Setting a Custom Filter Using a Pattern",
                                    "href":"setting-custom-filter-using-pattern.html"
                                },
                                {
                                    "title":"Setting a Custom Filter as a Class",
                                    "href":"setting-custom-filter-class.html"
                                },
                                {
                                    "title":"Setting a Custom Filter as a Method",
                                    "href":"setting-custom-filter-method.html"
                                },
                                {
                                    "title":"Creating a Filter with ObjectInputFilter Methods",
                                    "href":"creating-filter-objectinputfilter-methods.html"
                                }
                            ]
                        },
                        {
                            "title":"Setting a Filter Factory",
                            "href":"setting-filter-factory.html",
                            "topics":[
                                {
                                    "title":"Setting a Filter Factory with setSerialFilterFactory",
                                    "href":"setting-filter-factory-setserialfilterfactory.html"
                                },
                                {
                                    "title":"Specifying a Filter Factory in a System or Security Property",
                                    "href":"specifying-filter-factory-system-or-security-property.html"
                                }
                            ]
                        },
                        {
                            "title":"Built-in Filters",
                            "href":"built-filters.html"
                        },
                        {
                            "title":"Logging Filter Actions",
                            "href":"logging-filter-actions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Enhanced Deprecation",
                    "href":"enhanced-deprecation1.html",
                    "topics":[
                        {
                            "title":"Deprecation in the JDK",
                            "href":"deprecation-jdk.html"
                        },
                        {
                            "title":"How to Deprecate APIs",
                            "href":"how-deprecate-apis.html"
                        },
                        {
                            "title":"Notifications and Warnings",
                            "href":"notifications-and-warnings.html"
                        },
                        {
                            "title":"Running jdeprscan",
                            "href":"running-jdeprscan.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> XML Catalog API",
                    "href":"xml-catalog-api1.html",
                    "topics":[
                        {
                            "title":"Purpose of XML Catalog API",
                            "href":"purpose-xml-catalogs.html"
                        },
                        {
                            "title":"XML Catalog API Interfaces",
                            "href":"xml-catalog-api-interfaces.html"
                        },
                        {
                            "title":"Using the XML Catalog API",
                            "href":"using-catalog-api.html",
                            "topics":[
                                {
                                    "title":"System Reference",
                                    "href":"system-reference.html"
                                },
                                {
                                    "title":"Public Reference",
                                    "href":"public-reference.html"
                                },
                                {
                                    "title":"URI Reference",
                                    "href":"uri-reference.html"
                                }
                            ]
                        },
                        {
                            "title":"Java XML Processors Support",
                            "href":"java-xml-processors-support.html",
                            "topics":[
                                {
                                    "title":"Enable Catalog Support",
                                    "href":"enable-catalog-support.html"
                                },
                                {
                                    "title":"Use Catalog with XML Processors",
                                    "href":"use-catalog-xml-processors.html"
                                }
                            ]
                        },
                        {
                            "title":"Calling Order for Resolvers",
                            "href":"order-invocation-resolvers.html"
                        },
                        {
                            "title":"Detecting Errors",
                            "href":"detecting-errors.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Java Collections Framework",
                    "href":"java-collections-framework.html",
                    "topics":[
                        {
                            "title":"Creating Unmodifiable Lists, Sets, and Maps",
                            "href":"creating-immutable-lists-sets-and-maps.html#GUID-DD066F67-9C9B-444E-A3CB-820503735951"
                        },
                        {
                            "title":"Creating Sequenced Collections, Sets, and Maps",
                            "href":"creating-sequenced-collections-sets-and-maps.html#GUID-DCFE1D88-A0F5-47DE-A816-AEDA50B97523"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Process API",
                    "href":"process-api1.html",
                    "topics":[
                        {
                            "title":"Process API Classes and Interfaces",
                            "href":"process-api-classes-and-interfaces.html",
                            "topics":[
                                {
                                    "title":"ProcessBuilder Class",
                                    "href":"attributes-that-processbuilder-manages.html"
                                },
                                {
                                    "title":"Process Class",
                                    "href":"methods-process-class.html"
                                },
                                {
                                    "title":"ProcessHandle Interface",
                                    "href":"methods-process-handle-class.html"
                                },
                                {
                                    "title":"ProcessHandle.Info Interface",
                                    "href":"methods-processhandle-info-interface.html"
                                }
                            ]
                        },
                        {
                            "title":"Creating a Process",
                            "href":"creating-process.html"
                        },
                        {
                            "title":"Getting Information About a Process",
                            "href":"getting-information-process.html"
                        },
                        {
                            "title":"Redirecting Output from a Process",
                            "href":"redirecting-output-process.html"
                        },
                        {
                            "title":"Filtering Processes with Streams",
                            "href":"filter-processes-streams.html"
                        },
                        {
                            "title":"Handling Processes When They Terminate with the onExit Method",
                            "href":"managing-processes-asynchronously-onexit-method.html"
                        },
                        {
                            "title":"Controlling Access to Sensitive Process Information",
                            "href":"sensitive-process-information.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Preferences API",
                    "href":"preferences-api1.html",
                    "topics":[
                        {
                            "title":"Comparing the Preferences API to Other Mechanisms",
                            "href":"comparing-preferences-api-other-mechanisms.html"
                        },
                        {
                            "title":"Usage Notes",
                            "href":"usage-notes.html",
                            "topics":[
                                {
                                    "title":"Obtain Preferences Objects for an Enclosing Class",
                                    "href":"obtain-preferences-objects-enclosing-class.html"
                                },
                                {
                                    "title":"Obtain Preferences Objects for a Static Method",
                                    "href":"obtain-preferences-objects-static-methods.html"
                                },
                                {
                                    "title":"Atomic Updates",
                                    "href":"atomic-updates.html"
                                },
                                {
                                    "title":"Determine Backing Store Status",
                                    "href":"determine-backing-store-status.html"
                                }
                            ]
                        },
                        {
                            "title":"Design FAQ",
                            "href":"design-faq.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Java Logging Overview",
                    "href":"java-logging-overview.html#GUID-B83B652C-17EA-48D9-93D2-563AE1FF8EDA"
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Java NIO",
                    "href":"java-nio.html",
                    "topics":[
                        {
                            "title":"Grep NIO Example",
                            "href":"grep-nio-example.html"
                        },
                        {
                            "title":"Checksum NIO Example",
                            "href":"checksum-nio-example.html"
                        },
                        {
                            "title":"Time Query NIO Example",
                            "href":"time-query-nio-example.html"
                        },
                        {
                            "title":"Time Server NIO Example",
                            "href":"time-server-nio-example.html"
                        },
                        {
                            "title":"Non-Blocking Time Server NIO Example",
                            "href":"non-blocking-time-server-nio-example.html"
                        },
                        {
                            "title":"Internet Protocol and UNIX Domain Sockets NIO Example",
                            "href":"internet-protocol-and-unix-domain-sockets-nio-example.html"
                        },
                        {
                            "title":"Chmod File NIO Example",
                            "href":"chmod-file-nio-example.html"
                        },
                        {
                            "title":"Copy File NIO Example",
                            "href":"copy-file-nio-example.html"
                        },
                        {
                            "title":"Disk Usage File NIO Example",
                            "href":"disk-usage-file-nio-example.html"
                        },
                        {
                            "title":"User-Defined File Attributes File NIO Example",
                            "href":"user-defined-file-attributes-file-nio-example.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Java Networking",
                    "href":"java-networking.html#GUID-82A738CB-2A1C-4AC8-B9DA-C4543D398B51"
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Pseudorandom Number Generators",
                    "href":"pseudorandom-number-generators.html",
                    "topics":[
                        {
                            "title":"Characteristics of PRNGs",
                            "href":"characteristics-prngs.html"
                        },
                        {
                            "title":"Generating Pseudorandom Numbers with RandomGenerator Interface",
                            "href":"generating-pseudorandom-numbers.html"
                        },
                        {
                            "title":"Generating Pseudorandom Numbers in Multithreaded Applications",
                            "href":"generating-pseudorandom-numbers-multithreaded-applications.html",
                            "topics":[
                                {
                                    "title":"Dynamically Creating New Generators",
                                    "href":"dynamically-creating-new-generators.html"
                                },
                                {
                                    "title":"Creating Stream of Generators",
                                    "href":"creating-stream-generators.html"
                                }
                            ]
                        },
                        {
                            "title":"Choosing a PRNG Algorithm",
                            "href":"choosing-prng-algorithm.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Foreign Function and Memory API",
                    "href":"foreign-function-and-memory-api.html",
                    "topics":[
                        {
                            "title":"On-Heap and Off-Heap Memory",
                            "href":"heap-and-heap-memory.html"
                        },
                        {
                            "title":"Memory Segments and Arenas",
                            "href":"memory-segments-and-arenas.html#GUID-01CE34E8-7BCB-4540-92C4-E127C1F62711"
                        },
                        {
                            "title":"Calling a C Library Function with the Foreign Function and Memory API",
                            "href":"calling-c-library-function-foreign-function-and-memory-api.html#GUID-E7255CE9-5A95-437C-B37A-276B6C9B5F4D"
                        },
                        {
                            "title":"Upcalls: Passing Java Code as a Function Pointer to a Foreign Function",
                            "href":"upcalls-passing-java-code-function-pointer-foreign-function.html#GUID-908061BA-DC97-4524-A390-8FCEF7C5978F"
                        },
                        {
                            "title":"Foreign Functions That Return Pointers",
                            "href":"foreign-functions-that-return-pointers.html"
                        },
                        {
                            "title":"Memory Layouts and Structured Access",
                            "href":"memory-layouts-and-structured-access.html"
                        },
                        {
                            "title":"Backing a Memory Segment with a Memory Region Inside a File",
                            "href":"backing-memory-segment-memory-region-file.html"
                        },
                        {
                            "title":"Checking for Native Errors Using errno",
                            "href":"checking-native-errors-using-errno.html"
                        },
                        {
                            "title":"Slicing Allocators and Slicing Memory Segments",
                            "href":"slicing-allocators-and-slicing-memory-segments.html#GUID-1BA7C6C3-2090-4202-8EC9-330EAE8BBB9B"
                        },
                        {
                            "title":"Restricted Methods",
                            "href":"restricted-methods.html"
                        },
                        {
                            "title":"Calling Native Functions with jextract",
                            "href":"call-native-functions-jextract.html#GUID-114722F4-A13C-466C-B6EA-D9E7B8A8FF76"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Scoped Values",
                    "href":"scoped-values.html#GUID-9A4565C5-82AE-4F03-A476-3EAA9CDEB0F6"
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Concurrency",
                    "href":"concurrency.html",
                    "topics":[
                        {
                            "title":"Virtual Threads",
                            "href":"virtual-threads.html#GUID-DC4306FC-D6C1-4BCC-AECE-48C32C1A8DAA"
                        },
                        {
                            "title":"Structured Concurrency",
                            "href":"structured-concurrency.html#GUID-AA992944-AABA-4CBC-8039-DE5E17DE86DB"
                        },
                        {
                            "title":"Thread-Local Variables",
                            "href":"thread-local-variables.html#GUID-2CEB9041-3DF7-43DA-868F-E0596F4B63FD"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Stream Gatherers",
                    "href":"stream-gatherers.html#GUID-A8BF409A-A4F5-4A1E-98D8-62F2829A1399"
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Stable Values",
                    "href":"stable-values.html#GUID-E90D8D85-C08C-4A63-89CC-2B164294400E"
                }
            ]
        }
    ]
});