define(
{
    "toc":[
        {
            "heading":"Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface-header.html#Preface-015E90CC"
                }
            ]
        },
        {
            "heading":"1 What’s New in This Release",
            "topics":[
                {
                    "title":"What’s New in Siebel VB Language Reference Guide, Siebel CRM 20.1 Update",
                    "href":"c-Whats-New-In-Siebel-VB-Language-Reference-Guide-Siebel-CRM-20.1-Update.html#WhatsNewInSiebelVBLanguageReference-A7FA3063"
                },
                {
                    "title":"What’s New in Siebel VB Language Reference Guide, Siebel CRM 19.1 Update",
                    "href":"c-Whats-New-In-Siebel-VB-Language-Reference-Guide-Siebel-CRM-19.1-Update.html#c_Whats_New_In_Siebel_VB_Language_R-FB1C98F7"
                }
            ]
        },
        {
            "heading":"2 About Siebel Visual Basic",
            "topics":[
                {
                    "title":"About Siebel Visual Basic",
                    "href":"c-Overview.html#overview"
                },
                {
                    "title":"Overview of Siebel Visual Basic",
                    "href":"c-Overview-of-Siebel-Visual-Basic-ac1008624.html#ac1008624",
                    "topics":[
                        {
                            "title":"Siebel VB and Unicode",
                            "href":"c-Siebel-VB-and-Unicode-ac1010553.html#ac1010553"
                        },
                        {
                            "title":"Typographic Conventions That This Book Uses",
                            "href":"c-Typographic-Conventions-That-This-Book-Uses-ac1008664.html#ac1008664"
                        }
                    ]
                },
                {
                    "title":"About Functions and Methods",
                    "href":"c-About-Functions-and-Methods-ac1011019.html#ac1011019"
                },
                {
                    "title":"Siebel VB and Other Versions of Visual Basic Programming Languages",
                    "href":"c-Siebel-VB-and-Other-Versions-of-Visual-Basic-Programming-Languages-ac1009406.html#ac1009406",
                    "topics":[
                        {
                            "title":"Differences Between Siebel VB and Earlier Versions of Visual Basic",
                            "href":"c-Differences-Between-Siebel-VB-and-Earlier-Versionsof-Visual-Basic-ac1009400.html#ac1009400",
                            "topics":[
                                {
                                    "title":"Line Numbers and Labels",
                                    "href":"c-Line-Numbers-and-Labels-ac1009079.html#ac1009079"
                                },
                                {
                                    "title":"Subroutines and Modularity",
                                    "href":"c-Subroutines-and-Modularity-ac1009086.html#ac1009086"
                                },
                                {
                                    "title":"How Declaring a Variable Affects Variable Scope",
                                    "href":"c-How-Declaring-a-Variable-Affects-Variable-Scope-ac1010048.html#ac1010048"
                                },
                                {
                                    "title":"Data Types",
                                    "href":"c-Data-Types-ac1009115.html#ac1009115"
                                },
                                {
                                    "title":"Financial Methods",
                                    "href":"c-Financial-Methods-ac1009122.html#ac1009122"
                                },
                                {
                                    "title":"Date and Time Methods",
                                    "href":"c-Date-and-Time-Methods-ac1009127.html#ac1009127"
                                },
                                {
                                    "title":"Methods to Access Other Applications",
                                    "href":"c-Methods-to-Access-Other-Applications-ac1009133.html#ac1009133"
                                },
                                {
                                    "title":"Environment Control",
                                    "href":"c-Environment-Control-ac1009139.html#ac1009139"
                                }
                            ]
                        },
                        {
                            "title":"Differences Between Siebel VB and Visual Basic",
                            "href":"c-Differences-Between-Siebel-VB-and-Visual-Basic-ac1009145.html#ac1009145",
                            "topics":[
                                {
                                    "title":"Boolean Data Type",
                                    "href":"c-Boolean-Data-Type-ac1010650.html#ac1010650"
                                },
                                {
                                    "title":"User Interface and Control Objects",
                                    "href":"c-User-Interface-and-Control-Objects-ac1009161.html#ac1009161"
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        {
            "heading":"3 Using Siebel VB",
            "topics":[
                {
                    "title":"Using Siebel VB",
                    "href":"c-Using-Siebel-VB.html#using_siebel_vb",
                    "topics":[
                        {
                            "title":"Guidelines for Using Siebel VB",
                            "href":"c-Guidelines-for-Using-Siebel-VB-ad1019975.html#ad1019975",
                            "topics":[
                                {
                                    "title":"Pass Values Through Reference",
                                    "href":"c-Pass-Values-Through-Reference-ad1028512.html#ad1028512",
                                    "topics":[
                                        {
                                            "title":"Passing a Value Through a Reference",
                                            "href":"c-Passing-a-Value-Through-a-Reference-ad1028720.html#ad1028720"
                                        },
                                        {
                                            "title":"Passing a Value Through a Variable",
                                            "href":"c-Passing-a-Value-Through-a-Variable-ad1028698.html#ad1028698"
                                        }
                                    ]
                                },
                                {
                                    "title":"Give Each Argument a Name",
                                    "href":"c-Give-Each-Argument-a-Name-ad1028768.html#ad1028768",
                                    "topics":[
                                        {
                                            "title":"Format That You Can Use to Name an Argument",
                                            "href":"c-Format-That-You-Can-Use-to-Name-an-Argument-ad1028925.html#ad1028925"
                                        },
                                        {
                                            "title":"Naming an Argument With More Complex Formats",
                                            "href":"c-Naming-an-Argument-With-More-Complex-Formats-ad1029072.html#ad1029072"
                                        },
                                        {
                                            "title":"Where You Can Name an Argument",
                                            "href":"c-Where-You-Can-Name-an-Argument-ad1028796.html#ad1028796"
                                        }
                                    ]
                                },
                                {
                                    "title":"Other Guidelines",
                                    "href":"c-Other-Guidelines-ad1035687.html#ad1035687"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"About Data Types",
                    "href":"c-About-Data-Types-ad1035685.html#ad1035685",
                    "topics":[
                        {
                            "title":"Overview of Data Types",
                            "href":"c-Overview-of-Data-Types-ad1029360.html#ad1029360"
                        },
                        {
                            "title":"Arrays",
                            "href":"c-Arrays-ad1038597.html#ad1038597",
                            "topics":[
                                {
                                    "title":"Dynamic Arrays",
                                    "href":"c-Dynamic-Arrays-ad1028341.html#ad1028341"
                                }
                            ]
                        },
                        {
                            "title":"Numeric Data Types That Siebel VB Uses",
                            "href":"c-Numeric-Data-Types-That-Siebel-VB-Uses-ad1004307.html#ad1004307"
                        },
                        {
                            "title":"Records",
                            "href":"c-Records-ad1004379.html#ad1004379"
                        },
                        {
                            "title":"Strings",
                            "href":"c-Strings-ad1004387.html#ad1004387"
                        },
                        {
                            "title":"Variants",
                            "href":"c-Variants-ad1026112.html#ad1026112"
                        },
                        {
                            "title":"Type Characters",
                            "href":"c-Type-Characters-ad1004399.html#ad1004399"
                        },
                        {
                            "title":"How Siebel VB Converts Data Types",
                            "href":"c-How-Siebel-VB-Converts-Data-Types-ad1004442.html#ad1004442",
                            "topics":[
                                {
                                    "title":"Numeric Conversion",
                                    "href":"c-bNumeric-Conversionb-ad1004446.html#ad1004446"
                                },
                                {
                                    "title":"String Conversion",
                                    "href":"c-bString-Conversionb-ad1004449.html#ad1004449"
                                },
                                {
                                    "title":"Variant Conversion",
                                    "href":"c-bVariant-Conversionb-ad1004452.html#ad1004452"
                                }
                            ]
                        },
                        {
                            "title":"Comments",
                            "href":"c-Comments-ad1028045.html#ad1028045"
                        }
                    ]
                },
                {
                    "title":"About Expressions",
                    "href":"c-About-Expressions-ad1004562.html#ad1004562",
                    "topics":[
                        {
                            "title":"Numeric Operators",
                            "href":"c-Numeric-Operators-ad1004585.html#ad1004585"
                        },
                        {
                            "title":"String Operators",
                            "href":"c-String-Operators-ad1004620.html#ad1004620"
                        },
                        {
                            "title":"Comparison Operators",
                            "href":"c-Comparison-Operators-ad1004639.html#ad1004639"
                        },
                        {
                            "title":"Logical Operators",
                            "href":"c-Logical-Operators-ad1031420.html#ad1031420"
                        }
                    ]
                },
                {
                    "title":"About Object Handling",
                    "href":"c-About-Object-Handling-ad1004724.html#ad1004724",
                    "topics":[
                        {
                            "title":"Example of Declaring an Object As a Siebel CRM Object Type",
                            "href":"c-Example-of-Declaring-an-Object-As-a-Siebel-CRM-Object-Type-ad1031990.html#ad1031990"
                        },
                        {
                            "title":"Creating an Object Variable to Access an Object",
                            "href":"c-Creating-an-Object-Variable-to-Access-an-Object-ad1033508.html#ad1033508"
                        },
                        {
                            "title":"Using Methods and Properties to Manipulate an Object",
                            "href":"c-Using-Methods-and-Properties-to-Manipulate-an-Object-ad1032093.html#ad1032093"
                        }
                    ]
                },
                {
                    "title":"Declaring Procedures and Variables",
                    "href":"c-Declaring-Procedures-and-Variables-ad1034082.html#ad1034082",
                    "topics":[
                        {
                            "title":"Declaring a Procedure",
                            "href":"c-Declaring-a-Procedure-ad1034158.html#ad1034158",
                            "topics":[
                                {
                                    "title":"Specifying the Data Type",
                                    "href":"c-Specifying-the-Data-Type-ad1034087.html#ad1034087"
                                },
                                {
                                    "title":"Sequence Determines How You Must Declare Code",
                                    "href":"c-Sequence-Determines-How-You-Must-Declare-Code-ad1034096.html#ad1034096"
                                },
                                {
                                    "title":"Calling External DLL Code",
                                    "href":"c-Calling-External-DLL-Code-ad1034104.html#ad1034104"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Declaring Variables",
                    "href":"c-Declaring-Variables-ad1033598.html#ad1033598",
                    "topics":[
                        {
                            "title":"Determining Variable Scope",
                            "href":"c-Determining-Variable-Scope-ad1033635.html#ad1033635"
                        },
                        {
                            "title":"Specifying the Type When You Declare a Variable",
                            "href":"c-Specifying-the-Type-When-You-Declare-a-Variable-ad1033647.html#ad1033647"
                        },
                        {
                            "title":"Declaring an Array Variable",
                            "href":"c-Declaring-an-Array-Variable-ad1033664.html#ad1033664"
                        },
                        {
                            "title":"Declaring a Number Variable",
                            "href":"c-Declaring-a-Number-Variable-ad1033700.html#ad1033700"
                        },
                        {
                            "title":"Declaring a Record Variable",
                            "href":"c-Declaring-a-Record-Variable-ad1038773.html#ad1038773"
                        },
                        {
                            "title":"Declaring a String Variable",
                            "href":"c-Declaring-a-String-Variable-ad1033717.html#ad1033717"
                        },
                        {
                            "title":"Declaring a Variant Variable",
                            "href":"c-Declaring-a-Variant-Variable-ad1033729.html#ad1033729"
                        },
                        {
                            "title":"Declaring an Object Variable",
                            "href":"c-Declaring-an-Object-Variable-ad1033744.html#ad1033744"
                        },
                        {
                            "title":"Caution About Declaring Multiple Variables on One Line",
                            "href":"c-Caution-About-Declaring-Multiple-Variables-on-One-Line-ad1033891.html#ad1033891"
                        },
                        {
                            "title":"Shared Keyword Allows Backward Compatibility",
                            "href":"c-Shared-Keyword-Allows-Backward-Compatibility-ad1033895.html#ad1033895"
                        }
                    ]
                },
                {
                    "title":"About Formatting Strings",
                    "href":"c-About-Formatting-Strings-ad1034370.html#ad1034370",
                    "topics":[
                        {
                            "title":"Numeric Formats",
                            "href":"c-Numeric-Formats-ad1034377.html#ad1034377",
                            "topics":[
                                {
                                    "title":"Predefined Numeric Formats",
                                    "href":"c-Predefined-Numeric-Formats-ad1034382.html#ad1034382"
                                },
                                {
                                    "title":"Custom Numeric Formats",
                                    "href":"c-Custom-Numeric-Formats-ad1034427.html#ad1034427"
                                },
                                {
                                    "title":"Scaling Numbers",
                                    "href":"c-Scaling-Numbers-ad1034508.html#ad1034508"
                                },
                                {
                                    "title":"Inserting Characters In Number Formats",
                                    "href":"c-Inserting-Characters-In-Number-Formats-ad1034547.html#ad1034547"
                                },
                                {
                                    "title":"Scientific Notation Formats",
                                    "href":"c-Scientific-Notation-Formats-ad1034582.html#ad1034582"
                                },
                                {
                                    "title":"Using Sections In a Numeric Format",
                                    "href":"c-Using-Sections-In-a-Numeric-Format-ad1034621.html#ad1034621"
                                }
                            ]
                        },
                        {
                            "title":"Date and Time Formats",
                            "href":"c-Date-and-Time-Formats-ad1034679.html#ad1034679",
                            "topics":[
                                {
                                    "title":"Predefined Date and Time Formats",
                                    "href":"c-Predefined-Date-and-Time-Formats-ad1034685.html#ad1034685"
                                },
                                {
                                    "title":"Custom Date Formats",
                                    "href":"c-Custom-Date-Formats-ad1034724.html#ad1034724"
                                },
                                {
                                    "title":"Specifying Individual Parts of a Custom Date Format",
                                    "href":"c-Specifying-Individual-Parts-of-a-Custom-Date-Format-ad1034752.html#ad1034752"
                                },
                                {
                                    "title":"Using a 12 Hour Format",
                                    "href":"c-Using-a-12-Hour-Format-ad1034845.html#ad1034845"
                                }
                            ]
                        },
                        {
                            "title":"Other Formatting Options",
                            "href":"c-Other-Formatting-Options-ad1034883.html#ad1034883",
                            "topics":[
                                {
                                    "title":"Changing Formatting Sequence",
                                    "href":"c-Changing-Formatting-Sequence-ad1035063.html#ad1035063"
                                },
                                {
                                    "title":"Changing Case",
                                    "href":"c-Changing-Case-ad1034887.html#ad1034887"
                                },
                                {
                                    "title":"Handling Spaces That Occur in the Input String",
                                    "href":"c-Handling-Spaces-That-Occur-in-the-Input-String-ad1034890.html#ad1034890"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"About Error Handling",
                    "href":"c-About-Error-Handling-ad1004772.html#ad1004772",
                    "topics":[
                        {
                            "title":"Overview of Error Handling",
                            "href":"c-Overview-of-Error-Handling-ad1025921.html#ad1025921"
                        },
                        {
                            "title":"Handling Errors That Siebel VB Returns",
                            "href":"c-Handling-Errors-That-Siebel-VB-Returns--ad1032842.html#ad1032842",
                            "topics":[
                                {
                                    "title":"Using the Body of the Code to Handle Siebel VB Errors",
                                    "href":"c-Using-the-Body-of-the-Code-to-Handle-Siebel-VBErrors-ad1004808.html#ad1004808"
                                },
                                {
                                    "title":"Using an Error Handler to Handle Siebel VB Errors",
                                    "href":"c-Using-an-Error-Handler-to-Handle-Siebel-VB-Errors-ad1032311.html#ad1032311"
                                }
                            ]
                        },
                        {
                            "title":"Handling Custom Errors",
                            "href":"c-Handling-Custom-Errors-ad1004828.html#ad1004828",
                            "topics":[
                                {
                                    "title":"Using the Body of the Code to Handle Custom Errors",
                                    "href":"c-Using-the-Body-of-the-Code-to-Handle-Custom-Errors--ad1032705.html#ad1032705"
                                },
                                {
                                    "title":"Using a Label to Handle Custom Errors",
                                    "href":"c-Using-a-Label-to-Handle-Custom-Errors--ad1032979.html#ad1032979"
                                }
                            ]
                        },
                        {
                            "title":"Handling Errors That a Siebel VB Method Returns",
                            "href":"c-Handling-Errors-That-a-Siebel-VB-Method-Returns--ad1004847.html#ad1004847"
                        },
                        {
                            "title":"Error Code and Error Text for Siebel VB Errors",
                            "href":"c-Error-Code-and-Error-Text-for-Siebel-VB-Errors-ad1025400.html#ad1025400"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"4 Methods Reference for Siebel VB",
            "topics":[
                {
                    "title":"Methods Reference for Siebel VB",
                    "href":"c-Language-Reference.html#language_reference"
                },
                {
                    "title":"Overview of Siebel VB Language Reference",
                    "href":"c-Overview-of-Siebel-VB-Language-Reference-ae1206642.html#ae1206642",
                    "topics":[
                        {
                            "title":"Usage of the Dollar Sign",
                            "href":"c-Usage-of-the-Dollar-Sign-ae1272448.html#ae1272448"
                        },
                        {
                            "title":"Methods, Functions, and Statements Described in Siebel Object Interfaces Reference",
                            "href":"c-Methods-Functions-and-Statements-Obj-Intph-ae1187530.html#ae1187530"
                        }
                    ]
                },
                {
                    "title":"Disk and Directory Control Methods",
                    "href":"c-Disk-and-Directory-Control-Methods-ae1273628.html#ae1273628",
                    "topics":[
                        {
                            "title":"Change Directory Method",
                            "href":"c-Change-Directory-Method-ae1296631.html#ae1296631"
                        },
                        {
                            "title":"Change Drive Method",
                            "href":"c-Change-Drive-Method-ae1273714.html#ae1273714"
                        },
                        {
                            "title":"Create Directory Method",
                            "href":"c-Create-Directory-Method-ae1273759.html#ae1273759"
                        },
                        {
                            "title":"Get Current Directory Method",
                            "href":"c-Get-Current-Directory-Method-ae1273807.html#ae1273807"
                        },
                        {
                            "title":"Remove Directory Method",
                            "href":"c-Remove-Directory-Method-ae1273843.html#ae1273843"
                        }
                    ]
                },
                {
                    "title":"File Control Methods",
                    "href":"c-File-Control-Methods-ae1273904.html#ae1273904",
                    "topics":[
                        {
                            "title":"Close All Files Method",
                            "href":"c-Close-All-Files-Method-ae1273988.html#ae1273988"
                        },
                        {
                            "title":"Close File Method",
                            "href":"c-Close-File-Method-ae1274005.html#ae1274005"
                        },
                        {
                            "title":"Copy File Method",
                            "href":"c-Copy-File-Method-ae1274042.html#ae1274042"
                        },
                        {
                            "title":"Delete File Method",
                            "href":"c-Delete-File-Method-ae1274096.html#ae1274096"
                        },
                        {
                            "title":"Get File Attributes Method",
                            "href":"c-Get-File-Attributes-Method-ae1274145.html#ae1274145"
                        },
                        {
                            "title":"Get File Date Method",
                            "href":"c-Get-File-Date-Method-ae1274213.html#ae1274213"
                        },
                        {
                            "title":"Get File Length Method",
                            "href":"c-Get-File-Length-Method-ae1274241.html#ae1274241"
                        },
                        {
                            "title":"Get File Length 2 Method",
                            "href":"c-Get-File-Length-2-Method-ae1274279.html#ae1274279"
                        },
                        {
                            "title":"Get File Mode Method",
                            "href":"c-Get-File-Mode-Method-ae1274313.html#ae1274313"
                        },
                        {
                            "title":"Get File Names Method",
                            "href":"c-Get-File-Names-Method-ae1274373.html#ae1274373"
                        },
                        {
                            "title":"Get Free File Number Method",
                            "href":"c-Get-Free-File-Number-Method-ae1274460.html#ae1274460"
                        },
                        {
                            "title":"Lock File Method",
                            "href":"c-Lock-File-Method-ae1274477.html#ae1274477"
                        },
                        {
                            "title":"Open File Method",
                            "href":"c-Open-File-Method-ae1274532.html#ae1274532"
                        },
                        {
                            "title":"Rename File Method",
                            "href":"c-Rename-File-Method-ae1274689.html#ae1274689"
                        },
                        {
                            "title":"Set File Attributes Method",
                            "href":"c-Set-File-Attributes-Method-ae1274743.html#ae1274743"
                        },
                        {
                            "title":"Unlock File Method",
                            "href":"c-Unlock-File-Method-ae1274805.html#ae1274805"
                        }
                    ]
                },
                {
                    "title":"File Input and Output Methods",
                    "href":"c-File-Input-and-Output-Methods-ae1275756.html#ae1275756",
                    "topics":[
                        {
                            "title":"End of File Method",
                            "href":"c-End-of-File-Method-ae1275816.html#ae1275816"
                        },
                        {
                            "title":"Get Characters From File Method",
                            "href":"c-Get-Characters-From-File-Method-ae1275871.html#ae1275871"
                        },
                        {
                            "title":"Get File Contents Method",
                            "href":"c-Get-File-Contents-Method-ae1275913.html#ae1275913"
                        },
                        {
                            "title":"Get File Offset Method",
                            "href":"c-Get-File-Offset-Method-ae1275982.html#ae1275982"
                        },
                        {
                            "title":"Get File Position Method",
                            "href":"c-Get-File-Position-Method-ae1276017.html#ae1276017"
                        },
                        {
                            "title":"Get Line From File Method",
                            "href":"c-Get-Line-From-File-Method-ae1276062.html#ae1276062"
                        },
                        {
                            "title":"Parse File Contents Method",
                            "href":"c-Parse-File-Contents-Method-ae1276112.html#ae1276112"
                        },
                        {
                            "title":"Print Spaces Method",
                            "href":"c-Print-Spaces-Method-ae1276161.html#ae1276161"
                        },
                        {
                            "title":"Print Data to File Method",
                            "href":"c-Print-Data-to-File-Method-ae1276206.html#ae1276206"
                        },
                        {
                            "title":"Set File Position Method",
                            "href":"c-Set-File-Position-Method-ae1276263.html#ae1276263"
                        },
                        {
                            "title":"Set File Width Method",
                            "href":"c-Set-File-Width-Method-ae1276309.html#ae1276309"
                        },
                        {
                            "title":"Set Print Position Method",
                            "href":"c-Set-Print-Position-Method-ae1276344.html#ae1276344"
                        },
                        {
                            "title":"Write Data to File Method",
                            "href":"c-Write-Data-to-File-Method-ae1276390.html#ae1276390"
                        },
                        {
                            "title":"Write Variable to File Method",
                            "href":"c-Write-Variable-to-File-Method-ae1276434.html#ae1276434"
                        }
                    ]
                },
                {
                    "title":"Code Setup and Control Methods",
                    "href":"c-Code-Setup-and-Control-Methods-ae1256094.html#ae1256094",
                    "topics":[
                        {
                            "title":"Call Application Method",
                            "href":"c-Call-Application-Method-ae1256185.html#ae1256185"
                        },
                        {
                            "title":"Call Subroutine Method",
                            "href":"c-Call-Subroutine-Method-ae1256229.html#ae1256229"
                        },
                        {
                            "title":"Create Subroutine Method",
                            "href":"c-Create-Subroutine-Method-ae1256280.html#ae1256280"
                        },
                        {
                            "title":"Create Function Method",
                            "href":"c-Create-Function-Method-ae1256369.html#ae1256369"
                        },
                        {
                            "title":"Declare Custom Data Type Method",
                            "href":"c-Declare-Custom-Data-Type-Method-ae1278945.html#ae1278945"
                        },
                        {
                            "title":"Declare Procedure Method",
                            "href":"c-Declare-Procedure-Method-ae1256533.html#ae1256533"
                        },
                        {
                            "title":"Declare Symbolic Constant Method",
                            "href":"c-Declare-Symbolic-Constant-Method-ae1279031.html#ae1279031"
                        },
                        {
                            "title":"Get Environment Setting Method",
                            "href":"c-Get-Environment-Setting-Method-ae1256851.html#ae1256851"
                        },
                        {
                            "title":"Remove Object Method",
                            "href":"c-Remove-Object-Method-ae1257107.html#ae1257107"
                        },
                        {
                            "title":"Send Keystrokes Method",
                            "href":"c-Send-Keystrokes-Method-ae1257205.html#ae1257205"
                        },
                        {
                            "title":"Use Clipboard Methods",
                            "href":"c-Use-Clipboard-Methods-ae1257408.html#ae1257408"
                        }
                    ]
                },
                {
                    "title":"Code Control Statements",
                    "href":"c-Code-Control-Statements-ae1279313.html#ae1279313",
                    "topics":[
                        {
                            "title":"Do Loop Statement",
                            "href":"c-Do-Loop-Statement-ae1279895.html#ae1279895"
                        },
                        {
                            "title":"Exit Statement",
                            "href":"c-Exit-Statement-ae1279943.html#ae1279943"
                        },
                        {
                            "title":"For Next Statement",
                            "href":"c-For-Next-Statement-ae1279982.html#ae1279982"
                        },
                        {
                            "title":"Go To Statement",
                            "href":"c-Go-To-Statement-ae1280144.html#ae1280144"
                        },
                        {
                            "title":"If Then Else Statement",
                            "href":"c-If-Then-Else-Statement-ae1280194.html#ae1280194"
                        },
                        {
                            "title":"Go To Label Statement",
                            "href":"c-Go-To-Label-Statement-ae1280251.html#ae1280251"
                        },
                        {
                            "title":"Me Statement",
                            "href":"c-Me-Statement-ae1280284.html#ae1280284"
                        },
                        {
                            "title":"Rem Statement",
                            "href":"c-Rem-Statement-ae1280338.html#ae1280338"
                        },
                        {
                            "title":"Select Case Statement",
                            "href":"c-Select-Case-Statement-ae1280398.html#ae1280398"
                        },
                        {
                            "title":"Stop Statement",
                            "href":"c-Stop-Statement-ae1280646.html#ae1280646"
                        },
                        {
                            "title":"While Wend Statement",
                            "href":"c-While-Wend-Statement-ae1280704.html#ae1280704"
                        }
                    ]
                },
                {
                    "title":"Variable Manipulation Methods",
                    "href":"c-Variable-Manipulation-Methods-ae1261457.html#ae1261457",
                    "topics":[
                        {
                            "title":"Assign Expression to Variable Statement",
                            "href":"c-Assign-Expression-to-Variable-Statement-ae1261496.html#ae1261496"
                        },
                        {
                            "title":"Declare Variable Statement",
                            "href":"c-Declare-Variable-Statement-ae1282147.html#ae1282147"
                        },
                        {
                            "title":"Declare Global Variable Statement",
                            "href":"c-Declare-Global-Variable-Statement-ae1282239.html#ae1282239"
                        },
                        {
                            "title":"Declare Static Variable Statement",
                            "href":"c-Declare-Static-Variable-Statement-ae1282340.html#ae1282340"
                        },
                        {
                            "title":"Modify Variable Statement",
                            "href":"c-Modify-Variable-Statement-ae1282393.html#ae1282393"
                        },
                        {
                            "title":"Force Explicit Declaration Statement",
                            "href":"c-Force-Explicit-Declaration-Statement-ae1261827.html#ae1261827"
                        },
                        {
                            "title":"Get Variant Type Method",
                            "href":"c-Get-Variant-Type-Method-ae1282551.html#ae1282551"
                        },
                        {
                            "title":"Set Variable Data Type Statement",
                            "href":"c-Set-Variable-Data-Type-Statement-ae1261918.html#ae1261918"
                        },
                        {
                            "title":"Set Variant Variable to Null Method",
                            "href":"c-Set-Variant-Variable-to-Null-Method-ae1261968.html#ae1261968"
                        }
                    ]
                },
                {
                    "title":"String Methods",
                    "href":"c-String-Methods-ae1262849.html#ae1262849",
                    "topics":[
                        {
                            "title":"Compare Strings Method",
                            "href":"c-Compare-Strings-Method-ae1262941.html#ae1262941"
                        },
                        {
                            "title":"Compare Strings Operator",
                            "href":"c-Compare-Strings-Operator-ae1262986.html#ae1262986"
                        },
                        {
                            "title":"Convert Number to String Method",
                            "href":"c-Convert-Number-to-String-Method-ae1263074.html#ae1263074"
                        },
                        {
                            "title":"Convert String to Lowercase Method",
                            "href":"c-Convert-String-to-Lowercase-Method-ae1283460.html#ae1283460"
                        },
                        {
                            "title":"Convert String to Uppercase Method",
                            "href":"c-Convert-String-to-Uppercase-Method-ae1263114.html#ae1263114"
                        },
                        {
                            "title":"Copy String Method",
                            "href":"c-Copy-String-Method-ae1263149.html#ae1263149"
                        },
                        {
                            "title":"Get a String of Spaces Method",
                            "href":"c-Get-a-String-of-Spaces-Method-ae1263193.html#ae1263193"
                        },
                        {
                            "title":"Get ANSI String Method",
                            "href":"c-Get-ANSI-String-Method-ae1263228.html#ae1263228"
                        },
                        {
                            "title":"Get First Number From String Method",
                            "href":"c-Get-First-Number-From-String-Method-ae1283057.html#ae1283057"
                        },
                        {
                            "title":"Get Left String Method",
                            "href":"c-Get-Left-String-Method-ae1263344.html#ae1263344"
                        },
                        {
                            "title":"Get Repeated Character String Method",
                            "href":"c-Get-Repeated-Character-String-Method-ae1271752.html#ae1271752"
                        },
                        {
                            "title":"Get Right String Method",
                            "href":"c-Get-Right-String-Method-ae1263484.html#ae1263484"
                        },
                        {
                            "title":"Get String Length Method",
                            "href":"c-Get-String-Length-Method-ae1263543.html#ae1263543"
                        },
                        {
                            "title":"Get Substring Method",
                            "href":"c-Get-Substring-Method-ae1263654.html#ae1263654"
                        },
                        {
                            "title":"Get Substring Position Method",
                            "href":"c-Get-Substring-Position-Method-ae1283661.html#ae1283661"
                        },
                        {
                            "title":"Remove Spaces From String Method",
                            "href":"c-Remove-Spaces-From-String-Method-ae1263717.html#ae1263717"
                        },
                        {
                            "title":"Replace String Method",
                            "href":"c-Replace-String-Method-ae1263766.html#ae1263766"
                        },
                        {
                            "title":"Right-Justify String Method",
                            "href":"c-RightJustify-String-Method-ae1263836.html#ae1263836"
                        },
                        {
                            "title":"Set String Comparison Method",
                            "href":"c-Set-String-Comparison-Method-ae1263870.html#ae1263870"
                        },
                        {
                            "title":"Set String Format Method",
                            "href":"c-Set-String-Format-Method-ae1263900.html#ae1263900"
                        },
                        {
                            "title":"Trim Spaces From String Method",
                            "href":"c-Trim-Spaces-From-String-Method-ae1263997.html#ae1263997"
                        },
                        {
                            "title":"Trim Trailing Spaces From String Method",
                            "href":"c-Trim-Trailing-Spaces-From-String-Method-ae1264050.html#ae1264050"
                        }
                    ]
                },
                {
                    "title":"Array Methods",
                    "href":"c-Array-Methods-ae1271827.html#ae1271827",
                    "topics":[
                        {
                            "title":"Declare Array Method",
                            "href":"c-Declare-Array-Method-ae1271854.html#ae1271854"
                        },
                        {
                            "title":"Erase Array Method",
                            "href":"c-Erase-Array-Method-ae1272282.html#ae1272282"
                        },
                        {
                            "title":"Get Array Lower Boundary Method",
                            "href":"c-Get-Array-Lower-Boundary-Method-ae1272304.html#ae1272304"
                        },
                        {
                            "title":"Get Array Upper Boundary Method",
                            "href":"c-Get-Array-Upper-Boundary-Method-ae1272032.html#ae1272032"
                        },
                        {
                            "title":"Set Array Lower Boundary Method",
                            "href":"c-Set-Array-Lower-Boundary-Method-ae1272084.html#ae1272084"
                        }
                    ]
                },
                {
                    "title":"Mathematical Methods",
                    "href":"c-Mathematical-Methods-ae1182045.html#ae1182045",
                    "topics":[
                        {
                            "title":"Overview of Mathematical Methods",
                            "href":"c-Overview-of-Mathematical-Methods-ae1209449.html#ae1209449"
                        },
                        {
                            "title":"How Some Math Methods Handle the Data Type",
                            "href":"c-How-Some-Math-Methods-Handle-the-Data-Type-ae1211083.html#ae1211083"
                        },
                        {
                            "title":"Trigonometric Methods",
                            "href":"c-Trigonometric-Methods-ae1208029.html#ae1208029"
                        },
                        {
                            "title":"Exponential Method",
                            "href":"c-Exponential-Method-ae1211012.html#ae1211012"
                        },
                        {
                            "title":"Get Absolute Value Method",
                            "href":"c-Get-Absolute-Value-Method-ae1187489.html#ae1187489"
                        },
                        {
                            "title":"Get ANSI Integer Method",
                            "href":"c-Get-ANSI-Integer-Method-ae1179630.html#ae1179630"
                        },
                        {
                            "title":"Get Arctangent Method",
                            "href":"c-Get-Arctangent-Method-ae1004285.html#ae1004285"
                        },
                        {
                            "title":"Get Cosine Method",
                            "href":"c-Get-Cosine-Method-ae1188091.html#ae1188091"
                        },
                        {
                            "title":"Get Hexadecimal Method",
                            "href":"c-Get-Hexadecimal-Method-ae1192984.html#ae1192984"
                        },
                        {
                            "title":"Get Integer Method",
                            "href":"c-Get-Integer-Method-ae1239989.html#ae1239989"
                        },
                        {
                            "title":"Get Rounded Integer Method",
                            "href":"c-Get-Rounded-Integer-Method-ae1207854.html#ae1207854"
                        },
                        {
                            "title":"Get Logarithm Method",
                            "href":"c-Get-Logarithm-Method-ae1194841.html#ae1194841"
                        },
                        {
                            "title":"Get Octal Method",
                            "href":"c-Get-Octal-Method-ae1284372.html#ae1284372"
                        },
                        {
                            "title":"Get Number Sign Method",
                            "href":"c-Get-Number-Sign-Method-ae1199826.html#ae1199826"
                        },
                        {
                            "title":"Get Random Number Method",
                            "href":"c-Get-Random-Number-Method-ae1210884.html#ae1210884"
                        },
                        {
                            "title":"Get Sine Method",
                            "href":"c-Get-Sine-Method-ae1284451.html#ae1284451"
                        },
                        {
                            "title":"Get Square Root Method",
                            "href":"c-Get-Square-Root-Method-ae1201314.html#ae1201314"
                        },
                        {
                            "title":"Get Tangent Method",
                            "href":"c-Get-Tangent-Method-ae1201915.html#ae1201915"
                        },
                        {
                            "title":"Randomize Method",
                            "href":"c-Randomize-Method-ae1210965.html#ae1210965"
                        }
                    ]
                },
                {
                    "title":"Date and Time Methods",
                    "href":"c-Date-and-Time-Methods-ae1264958.html#ae1264958",
                    "topics":[
                        {
                            "title":"Convert Number to Date Method",
                            "href":"c-Convert-Number-to-Date-Method-ae1265035.html#ae1265035"
                        },
                        {
                            "title":"Convert Serial Number to Date Method",
                            "href":"c-Convert-Serial-Number-to-Date-Method-ae1265112.html#ae1265112"
                        },
                        {
                            "title":"Convert String to Date Method",
                            "href":"c-Convert-String-to-Date-Method-ae1265176.html#ae1265176"
                        },
                        {
                            "title":"Convert String to Time Method",
                            "href":"c-Convert-String-to-Time-Method-ae1265244.html#ae1265244"
                        },
                        {
                            "title":"Extract Day From Date-Time Value Method",
                            "href":"c-Extract-Day-From-DateTime-Value-Method-ae1265294.html#ae1265294"
                        },
                        {
                            "title":"Extract Hour From Date-Time Value Method",
                            "href":"c-Extract-Hour-From-DateTime-Value-Method-ae1265343.html#ae1265343"
                        },
                        {
                            "title":"Extract Minute From Date-Time Value Method",
                            "href":"c-Extract-Minute-From-DateTime-Value-Method-ae1284775.html#ae1284775"
                        },
                        {
                            "title":"Extract Month From Date-Time Value Method",
                            "href":"c-Extract-Month-From-DateTime-Value-Method-ae1265477.html#ae1265477"
                        },
                        {
                            "title":"Extract Second From Date-Time Value Method",
                            "href":"c-Extract-Second-From-DateTime-Value-Method-ae1265542.html#ae1265542"
                        },
                        {
                            "title":"Extract Weekday From Date-Time Value Method",
                            "href":"c-Extract-Weekday-From-DateTime-Value-Method-ae1265608.html#ae1265608"
                        },
                        {
                            "title":"Extract Year From Date-Time Value Method",
                            "href":"c-Extract-Year-From-DateTime-Value-Method-ae1265664.html#ae1265664"
                        },
                        {
                            "title":"Get Current Date Method",
                            "href":"c-Get-Current-Date-Method-ae1265716.html#ae1265716"
                        },
                        {
                            "title":"Get Current Date and Time Method",
                            "href":"c-Get-Current-Date-and-Time-Method-ae1265761.html#ae1265761"
                        },
                        {
                            "title":"Get Current Time Method",
                            "href":"c-Get-Current-Time-Method-ae1265810.html#ae1265810"
                        },
                        {
                            "title":"Get Current Seconds Method",
                            "href":"c-Get-Current-Seconds-Method-ae1265852.html#ae1265852"
                        },
                        {
                            "title":"Get Serial Time Method",
                            "href":"c-Get-Serial-Time-Method-ae1265872.html#ae1265872"
                        },
                        {
                            "title":"Set Date Method",
                            "href":"c-Set-Date-Method-ae1265924.html#ae1265924"
                        },
                        {
                            "title":"Set Time Method",
                            "href":"c-Set-Time-Method-ae1265990.html#ae1265990"
                        }
                    ]
                },
                {
                    "title":"ODBC Methods",
                    "href":"c-ODBC-Methods-ae1272681.html#ae1272681",
                    "topics":[
                        {
                            "title":"Overview of ODBC Methods",
                            "href":"c-Overview-of-ODBC-Methods-ae1267727.html#ae1267727"
                        },
                        {
                            "title":"ODBC Close Connection Method",
                            "href":"c-ODBC-Close-Connection-Method-ae1267735.html#ae1267735"
                        },
                        {
                            "title":"ODBC Get Errors Method",
                            "href":"c-ODBC-Get-Errors-Method-ae1267769.html#ae1267769"
                        },
                        {
                            "title":"ODBC Get Query Results Method",
                            "href":"c-ODBC-Get-Query-Results-Method-ae1267826.html#ae1267826"
                        },
                        {
                            "title":"ODBC Get Schema Method",
                            "href":"c-ODBC-Get-Schema-Method-ae1267898.html#ae1267898"
                        },
                        {
                            "title":"ODBC Open Connection Method",
                            "href":"c-ODBC-Open-Connection-Method-ae1268017.html#ae1268017"
                        },
                        {
                            "title":"ODBC Run Query Method",
                            "href":"c-ODBC-Run-Query-Method-ae1272756.html#ae1272756"
                        },
                        {
                            "title":"ODBC Run Query and Get Results Method",
                            "href":"c-ODBC-Run-Query-and-Get-Results-Method-ae1268119.html#ae1268119"
                        },
                        {
                            "title":"ODBC Save Results to File Method",
                            "href":"c-ODBC-Save-Results-to-File-Method-ae1268181.html#ae1268181"
                        }
                    ]
                },
                {
                    "title":"Object Querying Methods",
                    "href":"c-Object-Querying-Methods-ae1268258.html#ae1268258",
                    "topics":[
                        {
                            "title":"Compare Object Expressions Operator",
                            "href":"c-Compare-Object-Expressions-Operator-ae1268290.html#ae1268290"
                        },
                        {
                            "title":"Is Expression a Date Method",
                            "href":"c-Is-Expression-a-Date-Method-ae1268333.html#ae1268333"
                        },
                        {
                            "title":"Is Object Of Class Method",
                            "href":"c-Is-Object-Of-Class-Method-ae1268379.html#ae1268379"
                        },
                        {
                            "title":"Is Optional Argument Missing Method",
                            "href":"c-Is-Optional-Argument-Missing-Method-ae1268427.html#ae1268427"
                        },
                        {
                            "title":"Is Variable Null Method",
                            "href":"c-Is-Variable-Null-Method-ae1268456.html#ae1268456"
                        },
                        {
                            "title":"Is Variable Numeric Method",
                            "href":"c-Is-Variable-Numeric-Method-ae1268494.html#ae1268494"
                        },
                        {
                            "title":"Is Variable Set Method",
                            "href":"c-Is-Variable-Set-Method-ae1268533.html#ae1268533"
                        }
                    ]
                },
                {
                    "title":"Financial Methods",
                    "href":"c-Financial-Methods-ae1266914.html#ae1266914",
                    "topics":[
                        {
                            "title":"Overview of Financial Methods",
                            "href":"c-Overview-of-Financial-Methods-ae1266953.html#ae1266953",
                            "topics":[
                                {
                                    "title":"Arguments You Can Use with Financial Methods",
                                    "href":"c-Arguments-You-Can-Use-with-Financial-Methods-ae1266956.html#ae1266956"
                                },
                                {
                                    "title":"How Some Financial Methods Use the Rate Argument",
                                    "href":"c-How-Some-Financial-Methods-Use-the-Rate-Argument-ae1267017.html#ae1267017"
                                }
                            ]
                        },
                        {
                            "title":"Calculate Future Value Method",
                            "href":"c-Calculate-Future-Value-Method-ae1267022.html#ae1267022"
                        },
                        {
                            "title":"Calculate Interest Method",
                            "href":"c-Calculate-Interest-Method-ae1267059.html#ae1267059"
                        },
                        {
                            "title":"Calculate Interest Rate Method",
                            "href":"c-Calculate-Interest-Rate-Method-ae1267097.html#ae1267097"
                        },
                        {
                            "title":"Calculate Internal Rate of Return Method",
                            "href":"c-Calculate-Internal-Rate-of-Return-Method-ae1267135.html#ae1267135"
                        },
                        {
                            "title":"Calculate Net Present Value Method",
                            "href":"c-Calculate-Net-Present-Value-Method-ae1267173.html#ae1267173"
                        },
                        {
                            "title":"Calculate Payment Method",
                            "href":"c-Calculate-Payment-Method-ae1267212.html#ae1267212"
                        },
                        {
                            "title":"Calculate Principal Method",
                            "href":"c-Calculate-Principal-Method-ae1267250.html#ae1267250"
                        },
                        {
                            "title":"Calculate Present Value Method",
                            "href":"c-Calculate-Present-Value-Method-ae1267288.html#ae1267288"
                        }
                    ]
                },
                {
                    "title":"Conversion Methods",
                    "href":"c-Conversion-Methods-ae1004579.html#ae1004579",
                    "topics":[
                        {
                            "title":"Argument That You Can Use with Conversion Methods",
                            "href":"c-Argument-That-You-Can-Use-with-Conversion-Methods-ae1225782.html#ae1225782"
                        },
                        {
                            "title":"Convert Expression to Currency Method",
                            "href":"c-Convert-Expression-to-Currency-Method-ae1225883.html#ae1225883"
                        },
                        {
                            "title":"Convert Expression to Double-Precision Method",
                            "href":"c-Convert-Expression-to-DoublePrecision-Method-ae1240375.html#ae1240375"
                        },
                        {
                            "title":"Convert Expression to Integer Method",
                            "href":"c-Convert-Expression-to-Integer-Method-ae1187688.html#ae1187688"
                        },
                        {
                            "title":"Convert Expression to Long Method",
                            "href":"c-Convert-Expression-to-Long-Method-ae1187771.html#ae1187771"
                        },
                        {
                            "title":"Convert Expression to Single-Precision Method",
                            "href":"c-Convert-Expression-to-SinglePrecision-Method-ae1188273.html#ae1188273"
                        },
                        {
                            "title":"Convert Expression to String Method",
                            "href":"c-Convert-Expression-to-String-Method-ae1188324.html#ae1188324"
                        },
                        {
                            "title":"Convert Expression to Variant Method",
                            "href":"c-Convert-Expression-to-Variant-Method-ae1188520.html#ae1188520"
                        }
                    ]
                },
                {
                    "title":"COM Methods",
                    "href":"c-COM-Methods-ae1270182.html#ae1270182",
                    "topics":[
                        {
                            "title":"Assign COM Object Statement",
                            "href":"c-Assign-COM-Object-Statement-ae1272827.html#ae1272827"
                        },
                        {
                            "title":"COM Object Class",
                            "href":"c-COM-Object-Class-ae1272929.html#ae1272929"
                        },
                        {
                            "title":"Create COM Object Method",
                            "href":"c-Create-COM-Object-Method-ae1270206.html#ae1270206"
                        },
                        {
                            "title":"Get COM Object Method",
                            "href":"c-Get-COM-Object-Method-ae1270263.html#ae1270263"
                        },
                        {
                            "title":"Initialize COM Object Method",
                            "href":"c-Initialize-COM-Object-Method-ae1270334.html#ae1270334"
                        }
                    ]
                },
                {
                    "title":"Error Handling Methods",
                    "href":"c-Error-Handling-Methods-ae1255825.html#ae1255825",
                    "topics":[
                        {
                            "title":"Get Error Code Method",
                            "href":"c-Get-Error-Code-Method-ae1006463.html#ae1006463"
                        },
                        {
                            "title":"Get Error Code Line Method",
                            "href":"c-Get-Error-Code-Line-Method-ae1255664.html#ae1255664"
                        },
                        {
                            "title":"Get Error Message Method",
                            "href":"c-Get-Error-Message-Method-ae1006579.html#ae1006579"
                        },
                        {
                            "title":"On Error Method",
                            "href":"c-On-Error-Method-ae1197159.html#ae1197159"
                        },
                        {
                            "title":"Resume Statement",
                            "href":"c-Resume-Statement-ae1198634.html#ae1198634"
                        },
                        {
                            "title":"Set Error Code Method",
                            "href":"c-Set-Error-Code-Method-ae1255598.html#ae1255598"
                        },
                        {
                            "title":"Simulate Error Method",
                            "href":"c-Simulate-Error-Method-ae1255525.html#ae1255525"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"5 Quick Reference for Siebel VB Methods",
            "topics":[
                {
                    "title":"Quick Reference for Siebel VB Methods",
                    "href":"c-Quick-Reference.html#quick_reference"
                },
                {
                    "title":"Disk and Directory Control Quick Reference",
                    "href":"c-Disk-and-Directory-Control-Quick-Reference-af1024268.html#af1024268"
                },
                {
                    "title":"File Control Quick Reference",
                    "href":"c-File-Control-Quick-Reference-af1024617.html#af1024617"
                },
                {
                    "title":"File Input and Output Quick Reference",
                    "href":"c-File-Input-and-Output-Quick-Reference-af1025836.html#af1025836"
                },
                {
                    "title":"Code Setup and Control Quick Reference",
                    "href":"c-Code-Setup-and-Control-Quick-Reference-af1025832.html#af1025832"
                },
                {
                    "title":"Code Control Statements Quick Reference",
                    "href":"c-Code-Control-Statements-Quick-Reference-af1026891.html#af1026891"
                },
                {
                    "title":"Variable Manipulation Quick Reference",
                    "href":"c-Variable-Manipulation-Quick-Reference-af1026887.html#af1026887"
                },
                {
                    "title":"Strings Quick Reference",
                    "href":"c-Strings-Quick-Reference-af1021365.html#af1021365"
                },
                {
                    "title":"Arrays Quick Reference",
                    "href":"c-Arrays-Quick-Reference-af1021035.html#af1021035"
                },
                {
                    "title":"Math Operations Quick Reference",
                    "href":"c-Math-Operations-Quick-Reference-af1022073.html#af1022073"
                },
                {
                    "title":"Date and Time Quick Reference",
                    "href":"c-Date-and-Time-Quick-Reference-af1019840.html#af1019840"
                },
                {
                    "title":"ODBC Quick Reference",
                    "href":"c-ODBC-Quick-Reference-af1022538.html#af1022538"
                },
                {
                    "title":"Object Querying Quick Reference",
                    "href":"c-Object-Querying-Quick-Reference-af1022705.html#af1022705"
                },
                {
                    "title":"Financials Quick Reference",
                    "href":"c-Financials-Quick-Reference-af1023052.html#af1023052"
                },
                {
                    "title":"Conversions Quick Reference",
                    "href":"c-Conversions-Quick-Reference-af1023271.html#af1023271"
                },
                {
                    "title":"COM Object Quick Reference",
                    "href":"c-COM-Object-Quick-Reference-af1004567.html#af1004567"
                },
                {
                    "title":"Error Handling Quick Reference",
                    "href":"c-Error-Handling-Quick-Reference-af1026133.html#af1026133"
                }
            ]
        }
    ]
});