define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface-header.html#Preface-015E90CC"
                }
            ]
        },
        {
            "heading":"1 What’s New in This Release",
            "topics":[
                {
                    "title":"What’s New in Siebel Enterprise Integration Manager Administration Guide, Siebel CRM 21.11 Update",
                    "href":"c-Whats-New-in-Siebel-EIM-Admin-Guide-21-11-Update.html#WhatsNewInSiebelEnterpriseIntegrati-AE3AEF4B"
                },
                {
                    "title":"What’s New in Siebel Enterprise Integration Manager Administration Guide, Siebel CRM 20.1 Update",
                    "href":"c-Whats-New-in-Siebel-Enterprise-Integration-Manager-Administration-Guide-Siebel-CRM-20-1-Update.html#WhatsNewInSiebelEnterpriseIntegrati-AE3AEF4B"
                },
                {
                    "title":"What’s New in Siebel Enterprise Integration Manager Administration Guide, Siebel CRM 19.1 Update",
                    "href":"c-Whats-New-in-Siebel-Enterprise-Integration-Manager-Administration-Guide-Siebel-CRM-19-1-Update.html#im1014365"
                }
            ]
        },
        {
            "heading":"2 Siebel Enterprise Integration Manager: an Overview",
            "topics":[
                {
                    "title":"Siebel Enterprise Integration Manager: an Overview",
                    "href":"c-EIMAdm-Overview.html#eimadm_overview"
                },
                {
                    "title":"About Siebel Enterprise Integration Manager",
                    "href":"c-About-Siebel-Enterprise-Integration-Manager-in1016410.html#in1016410"
                },
                {
                    "title":"EIM Functions",
                    "href":"c-EIM-Functions-in1005269.html#in1005269",
                    "topics":[
                        {
                            "title":"Import New and Revised Data into Siebel Base Tables",
                            "href":"c-Import-New-and-Revised-Data-into-Siebel-Base-Tables-in1005272.html#in1005272"
                        },
                        {
                            "title":"Export Data from Siebel Base Tables",
                            "href":"c-Export-Data-from-Siebel-Base-Tables-in1005285.html#in1005285"
                        },
                        {
                            "title":"Delete Data from Siebel Base Tables",
                            "href":"c-Delete-Data-from-Siebel-Base-Tables-in1005294.html#in1005294"
                        },
                        {
                            "title":"Merge Data in Siebel Base Tables",
                            "href":"c-Merge-Data-in-Siebel-Base-Tables-in1005303.html#in1005303"
                        }
                    ]
                },
                {
                    "title":"Process Flow Between EIM and Other Databases",
                    "href":"c-Process-Flow-Between-EIM-and-Other-Databases-in1005312.html#in1005312"
                },
                {
                    "title":"Mobile Web Client Requirements",
                    "href":"c-Mobile-Web-Client-Requirements-in1005348.html#in1005348"
                }
            ]
        },
        {
            "heading":"3 Siebel EIM Tables",
            "topics":[
                {
                    "title":"Siebel EIM Tables",
                    "href":"c-EIMAdm-SiebelIFTables.html#eimadm_siebeliftables"
                },
                {
                    "title":"EIM Tables Overview",
                    "href":"c-EIM-Tables-Overview-is1020810.html#is1020810",
                    "topics":[
                        {
                            "title":"Preparing EIM Tables for Merge, Update, or Import Processes",
                            "href":"c-Preparing-EIM-Tables-for-Merge-Update-or-Import-Processes--is1005264.html#is1005264"
                        },
                        {
                            "title":"EIM Table Naming Conventions",
                            "href":"c-EIM-Table-Naming-Conventions-is1005273.html#is1005273"
                        }
                    ]
                },
                {
                    "title":"EIM Table Columns",
                    "href":"c-EIM-Table-Columns-is1005291.html#is1005291",
                    "topics":[
                        {
                            "title":"Mandatory Columns for EIM Processing",
                            "href":"c-Mandatory-Columns-for-EIM-Processing-is1005313.html#is1005313"
                        },
                        {
                            "title":"File Attachment Columns",
                            "href":"c-File-Attachment-Columns-is1005347.html#is1005347"
                        },
                        {
                            "title":"Organization Columns",
                            "href":"c-Organization-Columns-is1005424.html#is1005424"
                        }
                    ]
                },
                {
                    "title":"EIM Table and Column Mappings",
                    "href":"c-EIM-Table-and-Column-Mappings-is1005435.html#is1005435",
                    "topics":[
                        {
                            "title":"Database Extensibility and EIM",
                            "href":"c-Database-Extensibility-and-EIM-is1005454.html#is1005454"
                        },
                        {
                            "title":"EIM Table Mappings Provided as Common Parents to Nontarget EIM Table Mappings",
                            "href":"c-EIM-Table-Mappings-Provided-as-Common-Parents-to-Nontarget-EIM-Table-Mappings-is1005463.html#is1005463",
                            "topics":[
                                {
                                    "title":"Parameters to Set",
                                    "href":"c-Parameters-to-Set-is1005472.html#is1005472"
                                },
                                {
                                    "title":"Exception to Recommended Parameter Settings",
                                    "href":"c-Exception-to-Recommended-Parameter-Settings-is1005477.html#is1005477"
                                }
                            ]
                        },
                        {
                            "title":"Creating New EIM Table Mappings to Existing Base Tables",
                            "href":"c-Creating-New-EIM-Table-Mappings-to-Existing-Base-Tables-is1005486.html#is1005486"
                        },
                        {
                            "title":"About Explicit Primary Mappings",
                            "href":"c-About-Explicit-Primary-Mappings-is1033516.html#is1033516"
                        },
                        {
                            "title":"Setting Explicit Primary Mappings",
                            "href":"c-Setting-Explicit-Primary-Mappings-is1005527.html#is1005527"
                        },
                        {
                            "title":"Setting Explicit Primaries for Many-to-Many Relationships",
                            "href":"c-Setting-Explicit-Primaries-for-ManytoMany-Relationships-is1005542.html#is1005542"
                        },
                        {
                            "title":"About Viewing EIM Table Mappings",
                            "href":"c-About-Viewing-EIM-Table-Mappings-is1005557.html#is1005557"
                        },
                        {
                            "title":"Verifying Your Object Explorer View Settings",
                            "href":"c-Verifying-Your-Object-Explorer-View-Settings-is1016395.html#is1016395"
                        },
                        {
                            "title":"Viewing EIM Table Mappings to Base Tables",
                            "href":"c-Viewing-EIM-Table-Mappings-to-Base-Tables-is1016368.html#is1016368"
                        },
                        {
                            "title":"Viewing Interface Column Mappings to Base Tables",
                            "href":"c-Viewing-Interface-Column-Mappings-to-Base-Tables-is1005598.html#is1005598"
                        },
                        {
                            "title":"Viewing Base Table Mappings to EIM Tables",
                            "href":"c-Viewing-Base-Table-Mappings-to-EIM-Tables-is1005637.html#is1005637"
                        },
                        {
                            "title":"Generating EIM Table Mapping Reports",
                            "href":"c-Generating-EIM-Table-Mapping-Reports--is1031973.html#is1031973"
                        },
                        {
                            "title":"About the Second Row Property on EIM Table Mapping Objects",
                            "href":"c-About-the-Second-Row-Property-on-EIM-Table-Mapping-Objects-is1015489.html#is1015489"
                        },
                        {
                            "title":"EIM Table Mappings to Base Tables Without User Keys",
                            "href":"c-EIM-Table-Mappings-to-Base-Tables-Without-User-Keys-is1005715.html#is1005715",
                            "topics":[
                                {
                                    "title":"EIM Tables and Base Tables Without User Keys",
                                    "href":"c-EIM-Tables-and-Base-Tables-Without-User-Keys-is1005723.html#is1005723"
                                },
                                {
                                    "title":"Process Issues for Base Tables Without User Keys",
                                    "href":"c-Process-Issues-for-Base-Tables-Without-User-Keys-is1005865.html#is1005865"
                                }
                            ]
                        },
                        {
                            "title":"Deleting EIM Table Rows",
                            "href":"c-Deleting-EIM-Table-Rows-is1005879.html#is1005879"
                        },
                        {
                            "title":"Finding Differences in EIM Tables Between Repositories",
                            "href":"c-Finding-Differences-in-EIM-Tables-Between-Repositories-is1005894.html#is1005894"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"4 EIM Configuration File",
            "topics":[
                {
                    "title":"EIM Configuration File",
                    "href":"c-EIMAdm-Config.html#eimadm_config"
                },
                {
                    "title":"Using the EIM Configuration File to Define a Process",
                    "href":"c-Using-the-EIM-Configuration-File-to-Define-a-Process-it1005260.html#it1005260"
                },
                {
                    "title":"Defining EIM Configuration File Parameters",
                    "href":"c-Defining-EIM-Configuration-File-Parameters-it1005278.html#it1005278",
                    "topics":[
                        {
                            "title":"EIM Configuration File Parameters",
                            "href":"c-EIM-Configuration-File-Parameters-it1005299.html#it1005299"
                        },
                        {
                            "title":"Header Section Parameters Generic to All EIM Processes",
                            "href":"c-Header-Section-Parameters-Generic-to-All-EIM-Processes-it1005335.html#it1005335"
                        },
                        {
                            "title":"Process Section Parameters Generic to All EIM Processes",
                            "href":"c-Process-Section-Parameters-Generic-to-All-EIM-Processes-it1005396.html#it1005396"
                        },
                        {
                            "title":"Inheritance Rules for Configuration Parameters",
                            "href":"c-Inheritance-Rules-for-Configuration-Parameters-it1005542.html#it1005542"
                        },
                        {
                            "title":"Setting EIM Configuration Parameters",
                            "href":"c-Setting-EIM-Configuration-Parameters-it1005555.html#it1005555",
                            "topics":[
                                {
                                    "title":"Setting EIM Configuration File Header Parameters",
                                    "href":"c-Setting-EIM-Configuration-File-Header-Parameters-it1005578.html#it1005578"
                                },
                                {
                                    "title":"Setting EIM Configuration File Process Parameters",
                                    "href":"c-Setting-EIM-Configuration-File-Process-Parameters-it1005588.html#it1005588"
                                },
                                {
                                    "title":"Required Keywords for Process Parameters",
                                    "href":"c-Required-Keywords-for-Process-Parameters-it1005600.html#it1005600"
                                },
                                {
                                    "title":"Optional Keywords for Process Parameters",
                                    "href":"c-Optional-Keywords-for-Process-Parameters-it1005612.html#it1005612"
                                },
                                {
                                    "title":"TRANSACTION SQL Parameter",
                                    "href":"c-TRANSACTION-SQL-Parameter-it1005635.html#it1005635"
                                }
                            ]
                        },
                        {
                            "title":"Setting Extended EIM Configuration Parameters",
                            "href":"c-Setting-Extended-EIM-Configuration-Parameters-it1005668.html#it1005668",
                            "topics":[
                                {
                                    "title":"User-Defined Extended Parameters",
                                    "href":"c-UserDefined-Extended-Parameters-it1005672.html#it1005672"
                                },
                                {
                                    "title":"Predefined Extended Parameters",
                                    "href":"c-Predefined-Extended-Parameters-it1005720.html#it1005720"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Sample SQL Scripts",
                    "href":"c-Sample-SQL-Scripts-it1017576.html#it1017576",
                    "topics":[
                        {
                            "title":"DB2 Sample SQL Script",
                            "href":"c-DB2-Sample-SQL-Script-it1005868.html#it1005868"
                        },
                        {
                            "title":"MS SQL Sample SQL Script",
                            "href":"c-MS-SQL-Sample-SQL-Script-it1005879.html#it1005879"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"5 Importing Data",
            "topics":[
                {
                    "title":"Importing Data",
                    "href":"c-EIMAdm-ImportData.html#eimadm_importdata"
                },
                {
                    "title":"EIM Import Process",
                    "href":"c-EIM-Import-Process-io1005300.html#io1005300"
                },
                {
                    "title":"Import Data Process Flow",
                    "href":"c-Import-Data-Process-Flow-io1005369.html#io1005369"
                },
                {
                    "title":"Importing Legacy Data",
                    "href":"c-Importing-Legacy-Data--io1005454.html#io1005454",
                    "topics":[
                        {
                            "title":"Recommended Import Order for Importing Legacy Data",
                            "href":"c-Recommended-Import-Order-for-Importing-Legacy-Data-io1005458.html#io1005458"
                        },
                        {
                            "title":"Importing an Initial Batch of Legacy Data",
                            "href":"c-Importing-an-Initial-Batch-of-Legacy-Data-io1005495.html#io1005495"
                        },
                        {
                            "title":"Importing Large Databases",
                            "href":"c-Importing-Large-Databases-io1005539.html#io1005539",
                            "topics":[
                                {
                                    "title":"Memory Resources Needed for EIM",
                                    "href":"c-Memory-Resources-Needed-for-EIM-io1005544.html#io1005544"
                                },
                                {
                                    "title":"Database Resources Needed for EIM",
                                    "href":"c-Database-Resources-Needed-for-EIM-io1005547.html#io1005547"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Updating the Siebel Database",
                    "href":"c-Updating-the-Siebel-Database-io1005560.html#io1005560",
                    "topics":[
                        {
                            "title":"Updating Siebel Database for Batches with Both an Insert and Update to the Same Record",
                            "href":"c-Updating-Siebel-Database-for-Batches-with-Bothan-Insert-and-Update-to-the-Same-Record-io1005588.html#io1005588"
                        },
                        {
                            "title":"Fields That Cannot Be Updated",
                            "href":"c-Fields-That-Cannot-Be-Updated-io1005603.html#io1005603"
                        }
                    ]
                },
                {
                    "title":"Preparing the EIM Tables for Import Processing",
                    "href":"c-Preparing-the-EIM-Tables-for-Import-Processing-io1005629.html#io1005629",
                    "topics":[
                        {
                            "title":"Required Initial Values for Special Columns",
                            "href":"c-Required-Initial-Values-for-Special-Columns-io1114642.html#io1114642"
                        },
                        {
                            "title":"Required Initial Values for File Attachment Columns",
                            "href":"c-Required-Initial-Values-for-File-Attachment-Columns-io1005671.html#io1005671"
                        },
                        {
                            "title":"Adjusting the Case of Values",
                            "href":"c-Adjusting-the-Case-of-Values-io1005688.html#io1005688"
                        }
                    ]
                },
                {
                    "title":"Editing the Configuration File for Import Processing",
                    "href":"c-Editing-the-Configuration-File-for-Import-Processing-io1121558.html#io1121558",
                    "topics":[
                        {
                            "title":"Header Section Parameters Used for Imports",
                            "href":"c-Header-Section-Parameters-Used-for-Imports-io1005721.html#io1005721"
                        },
                        {
                            "title":"Process Section Parameters Used for Imports",
                            "href":"c-Process-Section-Parameters-Used-for-Imports-io1005731.html#io1005731"
                        },
                        {
                            "title":"Parameters Used for Imports in Both the Header and Process Sections",
                            "href":"c-Parameters-Used-for-Imports-in-Both-the-Headerand-Process-Sections-io1005814.html#io1005814",
                            "topics":[
                                {
                                    "title":"NET CHANGE Parameter",
                                    "href":"c-NET-CHANGE-Parameter-io1005956.html#io1005956"
                                },
                                {
                                    "title":"MISC SQL Parameter",
                                    "href":"c-MISC-SQL-Parameter-io1005990.html#io1005990"
                                },
                                {
                                    "title":"INSERT ROWS and UPDATE ROWS Parameters",
                                    "href":"c-INSERT-ROWS-and-UPDATE-ROWS-Parameters-io1006281.html#io1006281"
                                }
                            ]
                        },
                        {
                            "title":"Running an Import Process",
                            "href":"c-Running-an-Import-Process-io1006992.html#io1006992"
                        },
                        {
                            "title":"Checking Import Results",
                            "href":"c-Checking-Import-Results-io1007004.html#io1007004",
                            "topics":[
                                {
                                    "title":"Viewing a List of Imported Rows",
                                    "href":"c-Viewing-a-List-of-Imported-Rows-io1007026.html#io1007026"
                                },
                                {
                                    "title":"Troubleshooting Import Processing Failures",
                                    "href":"c-Troubleshooting-Import-Processing-Failures-io1007154.html#io1007154"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Special Considerations for Imports",
                    "href":"c-Special-Considerations-for-Imports-io1006299.html#io1006299",
                    "topics":[
                        {
                            "title":"Suppressing Data When Updating Existing Databases",
                            "href":"c-Suppressing-Data-When-Updating-Existing-Databases-io1006395.html#io1006395",
                            "topics":[
                                {
                                    "title":"Suppressing Inserts",
                                    "href":"c-Suppressing-Inserts-io1006400.html#io1006400"
                                },
                                {
                                    "title":"Suppressing Updates",
                                    "href":"c-Suppressing-Updates-io1006413.html#io1006413"
                                }
                            ]
                        },
                        {
                            "title":"Importing Customizable Products",
                            "href":"c-Importing-Customizable-Products-io1006449.html#io1006449"
                        },
                        {
                            "title":"Importing Opportunities and Revenues",
                            "href":"c-Importing-Opportunities-and-Revenues-io1006459.html#io1006459"
                        },
                        {
                            "title":"Maintaining Denormalized Columns",
                            "href":"c-Maintaining-Denormalized-Columns-io1006468.html#io1006468"
                        },
                        {
                            "title":"Importing Marketing Responses",
                            "href":"c-Importing-Marketing-Responses-io1006480.html#io1006480"
                        },
                        {
                            "title":"Importing Contacts",
                            "href":"c-Importing-Contacts-io1006489.html#io1006489",
                            "topics":[
                                {
                                    "title":"ASGN_* Flags",
                                    "href":"c-ASGN--Flags-io1052394.html#io1052394"
                                },
                                {
                                    "title":"S_POSTN_CON.ROW_STATUS Flag",
                                    "href":"c-S-POSTN-CONROW-STATUS-Flag-io1006499.html#io1006499"
                                }
                            ]
                        },
                        {
                            "title":"Importing Private Contacts",
                            "href":"c-Importing-Private-Contacts-io1006505.html#io1006505"
                        },
                        {
                            "title":"Importing Contacts to Make Them Visible in the Contact List",
                            "href":"c-Importing-Contacts-to-Make-Them-Visible-in-the-Contact-List-io1006524.html#io1006524"
                        },
                        {
                            "title":"Troubleshooting the Unique Constraint Error When Importing Accounts or Contacts",
                            "href":"c-Troubleshooting-the-Unique-Constraint-Error-When-Importing-Accounts-or-Contacts-io1075127.html#io1075127"
                        },
                        {
                            "title":"Importing Party Records",
                            "href":"c-Importing-Party-Records-io1075109.html#io1075109"
                        },
                        {
                            "title":"Importing Solutions",
                            "href":"c-Importing-Solutions-io1006586.html#io1006586"
                        },
                        {
                            "title":"Importing Call Lists and Catalogs",
                            "href":"c-Importing-Call-Lists-io1006601.html#io1006601"
                        },
                        {
                            "title":"Importing Positions and Employees",
                            "href":"c-Importing-Positions-and-Employees-io1006635.html#io1006635",
                            "topics":[
                                {
                                    "title":"Activating Position Hierarchy",
                                    "href":"c-Activating-Position-Hierarchy-io1006698.html#io1006698"
                                },
                                {
                                    "title":"Generating Reporting Relationships",
                                    "href":"c-Generating-Reporting-Relationships-io1006747.html#io1006747"
                                }
                            ]
                        },
                        {
                            "title":"Importing Data with Parent and Child Relationships",
                            "href":"c-Importing-Data-with-Parent-and-Child-Relationships-io1006770.html#io1006770"
                        },
                        {
                            "title":"Importing Industry Codes",
                            "href":"c-Importing-Industry-Codes-io1006782.html#io1006782"
                        },
                        {
                            "title":"Importing File Attachments",
                            "href":"c-Importing-File-Attachments-io1006794.html#io1006794"
                        },
                        {
                            "title":"Updating File Attachments",
                            "href":"c-Updating-File-Attachments-io1006820.html#io1006820"
                        },
                        {
                            "title":"Importing Organizations That Contain the BU_ID Column",
                            "href":"c-Importing-Organizations-That-Contain-the-BU-IDColumn-io1006842.html#io1006842"
                        },
                        {
                            "title":"Importing Accounts Containing Multiple Team Members",
                            "href":"c-Importing-Accounts-Containing-Multiple-Team-Members-io1006862.html#io1006862"
                        },
                        {
                            "title":"Importing Multiline Fields",
                            "href":"c-Importing-Multiline-Fields-io1006870.html#io1006870"
                        },
                        {
                            "title":"Importing Exported Rows Into Target and Secondary Tables",
                            "href":"c-Importing-Exported-Rows-Into-Target-and-Secondary-Tables-io1006879.html#io1006879"
                        },
                        {
                            "title":"Importing International Phone Numbers Using EIM",
                            "href":"c-Importing-International-Phone-Numbers-Using-EIM-io1006890.html#io1006890"
                        },
                        {
                            "title":"Importing URL Links into the S_LIT Base Table",
                            "href":"c-Importing-URL-Links-Into-the-S-LIT-Base-Table-io1006899.html#io1006899"
                        },
                        {
                            "title":"Importing LOVs Using EIM",
                            "href":"c-Importing-LOVs-Using-EIM.html#u30011978"
                        },
                        {
                            "title":"Importing LOV and MLOV Data into Base Tables",
                            "href":"c-Importing-LOV-and-MLOV-Data-io1006908.html#u30011977"
                        },
                        {
                            "title":"EIM Imports and Audit Trail",
                            "href":"c-EIM-and-Audit-Trail-io1006981.html#io1006981"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"6 Exporting Data",
            "topics":[
                {
                    "title":"Exporting Data",
                    "href":"c-EIMAdm-ExportData.html#eimadm_exportdata"
                },
                {
                    "title":"Overview of EIM Export Processing",
                    "href":"c-Overview-of-EIM-Export-Processing-ip1005271.html#ip1005271"
                },
                {
                    "title":"EIM Export Process",
                    "href":"c-EIM-Export-Process-ip1005306.html#ip1005306"
                },
                {
                    "title":"Preparing the EIM Tables for Export Processing",
                    "href":"c-Preparing-the-EIM-Tables-for-Export-Processing-ip1005321.html#ip1005321",
                    "topics":[
                        {
                            "title":"Checking Existing Rows Batch Numbers",
                            "href":"c-Checking-Existing-Rows-Batch-Numbers-ip1005333.html#ip1005333"
                        },
                        {
                            "title":"Preserved Column Values",
                            "href":"c-Preserved-Column-Values-ip1005342.html#ip1005342"
                        },
                        {
                            "title":"EIM Tables Not Supported for Export Processes",
                            "href":"c-EIM-Tables-Not-Supported-for-Export-Processes-ip1005352.html#ip1005352"
                        }
                    ]
                },
                {
                    "title":"Editing the Configuration File for Export Processing",
                    "href":"c-Editing-the-Configuration-File-for-Export-Processing-ip1005372.html#ip1005372",
                    "topics":[
                        {
                            "title":"Header Section Parameters Used for Exports",
                            "href":"c-Header-Section-Parameters-Used-for-Exports-ip1005406.html#ip1005406"
                        },
                        {
                            "title":"Process Section Parameters Used for Exports",
                            "href":"c-Process-Section-Parameters-Used-for-Exports-ip1005414.html#ip1005414"
                        },
                        {
                            "title":"Parameters Used for Exports in Both the Header and Process Sections",
                            "href":"c-Parameters-Used-for-Exports-in-Both-the-Headerand-Process-Sections-ip1005427.html#ip1005427",
                            "topics":[
                                {
                                    "title":"EXPORT MATCHES Parameter",
                                    "href":"c-EXPORT-MATCHES-Parameter-ip1005482.html#ip1005482"
                                }
                            ]
                        },
                        {
                            "title":"Exporting All Data Rows",
                            "href":"c-Exporting-All-Data-Rows-ip1005524.html#ip1005524"
                        },
                        {
                            "title":"Exporting Selected Data Rows",
                            "href":"c-Exporting-Selected-Data-Rows-ip1005534.html#ip1005534"
                        },
                        {
                            "title":"Exporting Recursive Relationships",
                            "href":"c-Exporting-Recursive-Relationships-ip1005550.html#ip1005550"
                        },
                        {
                            "title":"Exporting LOV and MLOV Data",
                            "href":"c-Exporting-LOV-and-MLOV-Data-ip1005559.html#ip1005559"
                        }
                    ]
                },
                {
                    "title":"Running an Export Process",
                    "href":"c-Running-an-Export-Process-ip1005574.html#ip1005574"
                },
                {
                    "title":"Checking Export Results",
                    "href":"c-Checking-Export-Results-ip1005597.html#ip1005597",
                    "topics":[
                        {
                            "title":"Viewing a List of Exported Rows",
                            "href":"c-Viewing-a-List-of-Exported-Rows-ip1005603.html#ip1005603"
                        },
                        {
                            "title":"Extracting Data from the EIM Tables",
                            "href":"c-Extracting-Data-from-the-EIM-Tables-ip1005616.html#ip1005616"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"7 Deleting Data",
            "topics":[
                {
                    "title":"Deleting Data",
                    "href":"c-EIMAdm-DeleteData.html#eimadm_deletedata"
                },
                {
                    "title":"EIM Delete Process",
                    "href":"c-EIM-Delete-Process-iq1005267.html#iq1005267",
                    "topics":[
                        {
                            "title":"Deletion Methods Supported",
                            "href":"c-Deletion-Methods-Supported-iq1005376.html#iq1005376"
                        },
                        {
                            "title":"Delete Process Flow",
                            "href":"c-Delete-Process-Flow-iq1005387.html#iq1005387"
                        }
                    ]
                },
                {
                    "title":"Preparing the EIM Tables for Delete Processing",
                    "href":"c-Preparing-the-EIM-Tables-for-Delete-Processing-iq1005421.html#iq1005421"
                },
                {
                    "title":"Editing the Configuration File for Delete Processing",
                    "href":"c-Editing-the-Configuration-File-for-Delete-Processing-iq1005448.html#iq1005448",
                    "topics":[
                        {
                            "title":"Header Section Parameters Used for Deletes",
                            "href":"c-Header-Section-Parameters-Used-for-Deletes-iq1005485.html#iq1005485"
                        },
                        {
                            "title":"Process Section Parameters Used for Deletes",
                            "href":"c-Process-Section-Parameters-Used-for-Deletes-iq1005493.html#iq1005493"
                        },
                        {
                            "title":"Parameters Used for Deletes in Both the Header and Process Sections",
                            "href":"c-Parameters-Used-for-Deletes-in-Both-the-Headerand-Process-Sections-iq1005505.html#iq1005505",
                            "topics":[
                                {
                                    "title":"DELETE EXACT Parameter",
                                    "href":"c-DELETE-EXACT-Parameter-iq1005604.html#iq1005604"
                                },
                                {
                                    "title":"DELETE MATCHES Parameter",
                                    "href":"c-DELETE-MATCHES-Parameter-iq1005621.html#iq1005621"
                                },
                                {
                                    "title":"DELETE ALL ROWS Parameter",
                                    "href":"c-DELETE-ALL-ROWS-Parameter-iq1005633.html#iq1005633"
                                }
                            ]
                        },
                        {
                            "title":"Deleting All Data Rows",
                            "href":"c-Deleting-All-Data-Rows-iq1005644.html#iq1005644"
                        },
                        {
                            "title":"Deleting Data Rows Identified by User Key Values",
                            "href":"c-Deleting-Data-Rows-Identified-by-User-Key-Values-iq1005657.html#iq1005657"
                        },
                        {
                            "title":"Deleting from Base Tables Other Than the Target Base Table",
                            "href":"c-Deleting-from-Base-Tables-Other-Than-the-Target-Base-Table-iq1005678.html#iq1005678"
                        },
                        {
                            "title":"Deleting Rows from Extension Tables",
                            "href":"c-Deleting-Rows-from-Extension-Tables-iq1005707.html#iq1005707"
                        },
                        {
                            "title":"Deleting File Attachments",
                            "href":"c-Deleting-File-Attachments-iq1005717.html#iq1005717"
                        },
                        {
                            "title":"Handling Aborts of EIM Delete Processing",
                            "href":"c-Handling-Aborts-of-EIM-Delete-Processing-iq1005733.html#iq1005733"
                        }
                    ]
                },
                {
                    "title":"Running a Delete Process",
                    "href":"c-Running-a-Delete-Process-iq1005745.html#iq1005745"
                },
                {
                    "title":"Checking Delete Results",
                    "href":"c-Checking-Delete-Results-iq1005758.html#iq1005758"
                }
            ]
        },
        {
            "heading":"8 Merging Data",
            "topics":[
                {
                    "title":"Merging Data",
                    "href":"c-EIMAdm-MergeData.html#eimadm_mergedata"
                },
                {
                    "title":"Overview of EIM Merge Processing",
                    "href":"c-Overview-of-EIM-Merge-Processing-ir1005298.html#ir1005298"
                },
                {
                    "title":"EIM Merge Process",
                    "href":"c-EIM-Merge-Process-ir1005312.html#ir1005312"
                },
                {
                    "title":"Preparing the EIM Tables for Merge Processing",
                    "href":"c-Preparing-the-EIM-Tables-for-Merge-Processing-ir1005349.html#ir1005349"
                },
                {
                    "title":"Editing the Configuration File for Merge Processing",
                    "href":"c-Editing-the-Configuration-File-for-Merge-Processing-ir1005427.html#ir1005427",
                    "topics":[
                        {
                            "title":"Header Section Parameters Used for Merges",
                            "href":"c-Header-Section-Parameters-Used-for-Merges-ir1005455.html#ir1005455"
                        },
                        {
                            "title":"Process Section Parameters Used for Merges",
                            "href":"c-Process-Section-Parameters-Used-for-Merges-ir1005461.html#ir1005461"
                        },
                        {
                            "title":"Parameters Used for Merges in Both the Header and Process Sections",
                            "href":"c-Parameters-Used-for-Merges-in-Both-the-Header-and-Process-Sections-ir1005476.html#ir1005476",
                            "topics":[
                                {
                                    "title":"SET BASED LOGGING Parameter",
                                    "href":"c-SET-BASED-LOGGING-Parameter-ir1005516.html#ir1005516"
                                }
                            ]
                        },
                        {
                            "title":"Updating Affected Rows",
                            "href":"c-Updating-Affected-Rows-ir1005523.html#ir1005523"
                        },
                        {
                            "title":"Avoiding Aborts of EIM Merge Processing",
                            "href":"c-Avoiding-Aborts-of-EIM-Merge-Processing-ir1005531.html#ir1005531"
                        },
                        {
                            "title":"Enabling Transaction Logging for Merge Processing",
                            "href":"c-Enabling-Transaction-Logging-for-Merge-Processing-ir1005543.html#ir1005543"
                        },
                        {
                            "title":"Specifying Remaining Records for Merge Processes",
                            "href":"c-Specifying-Survivor-Records-for-Merge-Processes-ir1005558.html#ir1005558"
                        }
                    ]
                },
                {
                    "title":"Running a Merge Process",
                    "href":"c-Running-a-Merge-Process-ir1005565.html#ir1005565"
                },
                {
                    "title":"Checking Merge Results",
                    "href":"c-Checking-Merge-Results-ir1005576.html#ir1005576"
                }
            ]
        },
        {
            "heading":"9 Running EIM",
            "topics":[
                {
                    "title":"Running EIM",
                    "href":"c-EIMAdm-RunningEIM.html#eimadm_runningeim"
                },
                {
                    "title":"Preparing to Run an EIM Process",
                    "href":"c-Preparing-to-Run-an-EIM-Process-iu1005272.html#iu1005272"
                },
                {
                    "title":"Running an EIM Process",
                    "href":"c-Running-an-EIM-Process-iu1005286.html#iu1005286",
                    "topics":[
                        {
                            "title":"Running an EIM Process Using the Graphical User Interface",
                            "href":"c-Running-an-EIM-Process-Using-the-Graphical-User-Interface-iu1005301.html#iu1005301"
                        },
                        {
                            "title":"Running an EIM Process Using the Command-Line Interface",
                            "href":"c-Running-an-EIM-Process-Using-the-CommandLine-Interface-iu1005448.html#iu1005448"
                        }
                    ]
                },
                {
                    "title":"Viewing the EIM Log File",
                    "href":"c-Viewing-the-EIM-Log-File-iu1034372.html#iu1034372",
                    "topics":[
                        {
                            "title":"Using Trace Flags, SQL Trace Flags, and Error Flags",
                            "href":"c-Using-Trace-Flags-SQL-Trace-Flags-and-Error-Flags-iu1005492.html#iu1005492",
                            "topics":[
                                {
                                    "title":"Error Flags",
                                    "href":"c-Error-Flags-iu1020712.html#iu1020712"
                                },
                                {
                                    "title":"SQL Trace Flags",
                                    "href":"c-SQL-Trace-Flags-iu1005515.html#iu1005515"
                                },
                                {
                                    "title":"Trace Flags",
                                    "href":"c-Trace-Flags-iu1005527.html#iu1005527"
                                }
                            ]
                        },
                        {
                            "title":"Setting Event Logging from the Graphical User Interface",
                            "href":"c-Setting-Event-Logging-from-the-Graphical-User-Interface-iu1020595.html#iu1020595"
                        },
                        {
                            "title":"Setting Event Logging from the Command-Line Interface",
                            "href":"c-Setting-Event-Logging-from-the-CommandLine-Interface-iu1017474.html#iu1017474"
                        },
                        {
                            "title":"Trace Flag Settings",
                            "href":"c-Trace-Flag-Settings-iu1005566.html#iu1005566",
                            "topics":[
                                {
                                    "title":"Trace Flag 1",
                                    "href":"c-Trace-Flag-1-iu1020946.html#iu1020946"
                                },
                                {
                                    "title":"Trace Flag 2",
                                    "href":"c-Trace-Flag-2--iu1005615.html#iu1005615"
                                },
                                {
                                    "title":"Trace Flag 4",
                                    "href":"c-Trace-Flag-4--iu1005646.html#iu1005646"
                                },
                                {
                                    "title":"Trace Flag 8",
                                    "href":"c-Trace-Flag-8--iu1005661.html#iu1005661"
                                },
                                {
                                    "title":"Trace Flag 32",
                                    "href":"c-Trace-Flag-32--iu1005677.html#iu1005677"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Optimizing EIM Performance",
                    "href":"c-Optimizing-EIM-Performance-iu1005719.html#iu1005719",
                    "topics":[
                        {
                            "title":"Table Optimization for EIM",
                            "href":"c-Table-Optimization-for-EIM-iu1005727.html#iu1005727",
                            "topics":[
                                {
                                    "title":"Configuration Parameters",
                                    "href":"c-Configuration-Parameters-iu1005736.html#iu1005736"
                                },
                                {
                                    "title":"Indexes",
                                    "href":"c-Indexes-iu1005749.html#iu1005749"
                                },
                                {
                                    "title":"Maintenance of EIM Tables",
                                    "href":"c-Maintenance-of-EIM-Tables-iu1005773.html#iu1005773"
                                }
                            ]
                        },
                        {
                            "title":"Batch Processing Optimization for EIM",
                            "href":"c-Batch-Processing-Optimization-for-EIM-iu1005784.html#iu1005784",
                            "topics":[
                                {
                                    "title":"Limiting the Number of Records and Rows for Merge Processes",
                                    "href":"c-Limiting-the-Number-of-Records-and-Rows-for-Merge-Processes-iu1005793.html#iu1005793"
                                },
                                {
                                    "title":"Using Batch Ranges",
                                    "href":"c-Using-Batch-Ranges--iu1005812.html#iu1005812"
                                }
                            ]
                        },
                        {
                            "title":"Run-Time Optimization for EIM",
                            "href":"c-RunTime-Optimization-for-EIM-iu1005820.html#iu1005820",
                            "topics":[
                                {
                                    "title":"Parallel Processing",
                                    "href":"c-Parallel-Processing-iu1005827.html#iu1005827"
                                },
                                {
                                    "title":"Transaction Logging",
                                    "href":"c-Transaction-Logging-iu1005849.html#iu1005849"
                                }
                            ]
                        },
                        {
                            "title":"Parameter Settings Optimization for EIM",
                            "href":"c-Parameter-Settings-Optimization-for-EIM-iu1005857.html#iu1005857",
                            "topics":[
                                {
                                    "title":"USING SYNONYMS Parameter for Optimizing EIM",
                                    "href":"c-USING-SYNONYMS-Parameter-for-Optimizing-EIM-iu1005865.html#iu1005865"
                                },
                                {
                                    "title":"Trace Flag Settings for Optimizing EIM",
                                    "href":"c-Trace-Flag-Settings-for-Optimizing-EIM-iu1005869.html#iu1005869"
                                }
                            ]
                        },
                        {
                            "title":"Database Server Optimization for EIM",
                            "href":"c-Database-Server-Optimization-for-EIM-iu1005875.html#iu1005875"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"10 EIM: Examples of Common Usage",
            "topics":[
                {
                    "title":"EIM: Examples of Common Usage",
                    "href":"c-EIMAdm-UsageScen.html#enter-id-to-match-title"
                },
                {
                    "title":"EIM Import Process Examples",
                    "href":"c-EIM-Import-Process-Examples-iv1005266.html#iv1005266",
                    "topics":[
                        {
                            "title":"Example of Importing from Multiple EIM Tables in a Single .IFB File",
                            "href":"c-Example-of-Importing-from-Multiple-EIM-Tables-ina-Single-IFB-File-iv1057917.html#iv1057917"
                        },
                        {
                            "title":"Example of Updating a Table in a One-to-One Relationship with Its Parent",
                            "href":"c-Example-of-Updating-a-Table-in-a-OnetoOne-Relationshipwith-Its-Parent-iv1005277.html#iv1005277"
                        },
                        {
                            "title":"Example of Updating Columns When There Are Two Records with the Same User Key in a Single Batch",
                            "href":"c-Example-of-Updating-Columns-When-There-Are-Two-Records-with-the-Same-User-Key-in-a-Single-Batch-iv1005283.html#iv1005283"
                        },
                        {
                            "title":"Example of Updating Columns When There Are Two Non-Target Base Tables Mapped to One EIM Table",
                            "href":"c-Example-of-Updating-Columns-When-There-Are-Two-NonTarget-Base-Tables-Mapped-to-One-EIM-Table-iv1026752.html#iv1026752"
                        },
                        {
                            "title":"Example of Importing Primary Keys",
                            "href":"c-Example-of-Importing-Primary-Keys-iv1005335.html#iv1005335"
                        },
                        {
                            "title":"Example of Setting a Primary",
                            "href":"c-Example-of-Setting-a-Primary-iv1005423.html#iv1005423"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Party Objects",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Party-Objects-iv1005438.html#iv1005438"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Accounts",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Accounts-iv1005448.html#iv1005448"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Contacts",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Contacts-iv1005504.html#iv1005504"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Employees",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Employees-iv1005557.html#iv1005557"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Opportunities",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Opportunities-iv1005635.html#iv1005635"
                        },
                        {
                            "title":"Visibility of Fields: Example of Importing Assets",
                            "href":"c-Visibility-of-Fields-Example-of-Importing-Assets-iv1005706.html#iv1005706"
                        },
                        {
                            "title":"Example of Troubleshooting the Import of Extension Columns",
                            "href":"c-Example-of-Troubleshooting-the-Import-of-Extension-Columns-iv1027027.html#iv1027027",
                            "topics":[
                                {
                                    "title":"Checking the Repository",
                                    "href":"c-Checking-the-Repository-iv1051651.html#iv1051651"
                                }
                            ]
                        },
                        {
                            "title":"Example of Troubleshooting the Unique Constraint Error when Importing Accounts or Contacts",
                            "href":"c-Example-of-Troubleshooting-the-Unique-Constraint-Error-when-Importing-Accounts-or-Contacts-iv1035829.html#iv1035829",
                            "topics":[
                                {
                                    "title":"Example of Troubleshooting the Import of EIM Contact Data into the S_CONTACT Table",
                                    "href":"c-Example-of-Troubleshooting-the-Import-of-EIM-Contact-Data-into-the-S-CONTACT-Table-iv1040106.html#iv1040106"
                                },
                                {
                                    "title":"Example of Troubleshooting the Import of EIM Account Data into the S_ORG_EXT Table",
                                    "href":"c-Example-of-Troubleshooting-the-Import-of-EIM-Account-Data-into-the-S-ORG-EXT-Table-iv1040352.html#iv1040352"
                                }
                            ]
                        },
                        {
                            "title":"Example of Importing and Exporting Hierarchical LOVs",
                            "href":"c-Example-of-Importing-and-Exporting-Hierarchical-LOVs-iv1035827.html#iv1035827"
                        }
                    ]
                },
                {
                    "title":"EIM Merge Process Example",
                    "href":"c-EIM-Merge-Process-Example-iv1005778.html#iv1005778",
                    "topics":[
                        {
                            "title":"Example of Running a Merge with Custom Columns",
                            "href":"c-Example-of-Running-a-Merge-with-Custom-Columns-iv1005782.html#iv1005782"
                        }
                    ]
                },
                {
                    "title":"EIM Delete Process Examples",
                    "href":"c-EIM-Delete-Process-Examples-iv1005818.html#iv1005818",
                    "topics":[
                        {
                            "title":"Example: Using DELETE MATCHES to Delete Data from S_PARTY Extension Tables",
                            "href":"c-Example-Using-DELETE-MATCHES-to-Delete-Data-from-S-PARTY-Extension-Tables-iv1005820.html#iv1005820"
                        },
                        {
                            "title":"Example: Using DELETE MATCHES to Delete Data from non-S_PARTY Extension Tables",
                            "href":"c-Example-Using-DELETE-MATCHES-to-Delete-Data-fromnonS-PARTY-Extension-Tables-iv1005850.html#iv1005850"
                        },
                        {
                            "title":"Example of Using DELETE EXACT",
                            "href":"c-Example-of-Using-DELETE-EXACT-iv1005873.html#iv1005873"
                        },
                        {
                            "title":"Example of Deleting Specific Positions from Accounts",
                            "href":"c-Example-of-Deleting-Specific-Positions-from-Accounts-iv1005920.html#iv1005920"
                        }
                    ]
                },
                {
                    "title":"Examples of Resolving Foreign Keys",
                    "href":"c-Examples-of-Resolving-Foreign-Keys-iv1027205.html#iv1027205",
                    "topics":[
                        {
                            "title":"Example 1: Resolving the Foreign Key Value",
                            "href":"c-Resolution-iv1034437.html#iv1034437"
                        },
                        {
                            "title":"Example 2: Resolving the Foreign Key for Position Division",
                            "href":"c-Example-2-Resolving-the-Foreign-Key-for-Position-Division-iv1027338.html#iv1027338"
                        },
                        {
                            "title":"Example 3: Resolving the Foreign Key Using a Special User Key",
                            "href":"c-Example-3-Resolving-the-Foreign-Key-Using-a-Special-User-Key-iv1048575.html#iv1048575"
                        }
                    ]
                },
                {
                    "title":"Other Examples",
                    "href":"c-Other-Examples-iv1035676.html#iv1035676",
                    "topics":[
                        {
                            "title":"Example of Setting Explicit Primary Mappings",
                            "href":"c-Example-of-Setting-Explicit-Primary-Mappings-iv1006138.html#iv1006138"
                        },
                        {
                            "title":"Example of Setting Explicit Primary Mappings for Many-to-Many Relationships",
                            "href":"c-Example-of-Setting-Explicit-Primary-Mappings-for-ManytoMany-Relationships-iv1006486.html#iv1006486"
                        },
                        {
                            "title":"Example of Creating Mappings for Extension Columns",
                            "href":"c-Example-of-Creating-Mappings-for-Extension-Columns-iv1088008.html#iv1088008"
                        },
                        {
                            "title":"Example of Improving Performance by Dropping Indexes",
                            "href":"c-Example-of-Improving-Performance-by-Dropping-Indexes-iv1006563.html#iv1006563"
                        },
                        {
                            "title":"Foreign Key Column Values: NO MATCH ROW ID versus NULL versus a Valid ROW_ID",
                            "href":"c-Foreign-Key-Column-Values-NO-MATCH-ROW-ID-versus-NULL-versus-a-Valid-ROW-ID-iv1006573.html#iv1006573"
                        },
                        {
                            "title":"Example of Using the NUM_IFTABLE_LOAD_CUTOFF Parameter",
                            "href":"c-Example-of-Using-the-NUM-IFTABLE-LOAD-CUTOFF-Parameter-iv1006603.html#iv1006603"
                        },
                        {
                            "title":"Example: Transaction Logging with Row-by-row Processing versus Set-based Processing",
                            "href":"c-Example-Transaction-Logging-with-Rowbyrow-Processingversus-Setbased-Processing-iv1027520.html#iv1027520",
                            "topics":[
                                {
                                    "title":"LOG TRANSACTIONS and SET BASED LOGGING Parameters",
                                    "href":"c-LOG-TRANSACTIONS-and-SET-BASED-LOGGING-Parameters-iv1035451.html#iv1035451"
                                },
                                {
                                    "title":"Logging Locations for LOG TRANSACTIONS and LOG TRANSACTIONS TO FILE",
                                    "href":"c-Logging-Locations-for-LOG-TRANSACTIONS-and-LOG-TRANSACTIONS-TOFILE-iv1031875.html#iv1031875"
                                },
                                {
                                    "title":"When to Use Row-by-Row Processing",
                                    "href":"c-When-to-Use-RowbyRow-Processing-iv1035526.html#iv1035526"
                                },
                                {
                                    "title":"Advantages and Disadvantages of Using RBR Logging",
                                    "href":"c-Advantages-and-Disadvantages-of-Using-RBR-Logging-iv1031918.html#iv1031918"
                                }
                            ]
                        },
                        {
                            "title":"Example of Implementing a Multi-Organization Hierarchy",
                            "href":"c-Example-of-Implementing-a-MultiOrganization-Hierarchy-iv1088037.html#iv1088037"
                        },
                        {
                            "title":"Example of Adding a Position to a Party Table",
                            "href":"c-Example-of-Adding-a-Position-to-a-Party-Table-iv1057864.html#iv1057864"
                        },
                        {
                            "title":"Example of Using the EIM_ASSET Interface Table",
                            "href":"c-Example-of-Using-the-EIM-ASSET-Interface-Table-iv1006699.html#iv1006699"
                        }
                    ]
                }
            ]
        }
    ]
});