define(
{
    "toc":[
        {
            "heading":"Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface-header.html#Preface-015E90CC"
                }
            ]
        },
        {
            "heading":"1 What's New in This Release",
            "topics":[
                {
                    "title":"What’s New in Oracle CRM On Demand JavaScript API Developer’s Guide, Release 45",
                    "href":"c-Whats-New-in--akc1027223.html#akc1027223"
                }
            ]
        },
        {
            "heading":"2 Overview of the JavaScript API",
            "topics":[
                {
                    "title":"Overview of the JavaScript API",
                    "href":"c-OnDemJavaDev-Overview.html#ondemjavadev_overview"
                },
                {
                    "title":"Overview of Customizing Buttons",
                    "href":"c-Overview-of-Customizing-Buttons-akd1027010.html#akd1027010",
                    "topics":[
                        {
                            "title":"Creating Custom Buttons",
                            "href":"c-Creating-Custom-Buttons-akd1024511.html#akd1024511"
                        },
                        {
                            "title":"Examples of Uses for Custom Buttons",
                            "href":"c-Examples-of-Uses-for-Custom-Buttons-akd1025735.html#akd1025735"
                        },
                        {
                            "title":"Hiding and Disabling Buttons",
                            "href":"c-Hiding-and-Disabling-Buttons-akd1025293.html#akd1025293"
                        },
                        {
                            "title":"Creating Tooltips for Buttons",
                            "href":"c-Creating-Tooltips-for-Buttons-akd1026141.html#akd1026141"
                        },
                        {
                            "title":"Changing the Look and Feel of a Button",
                            "href":"c-Changing-the-Look-and-Feel-of-a-Button-akd1025469.html#akd1025469"
                        },
                        {
                            "title":"Changing the Behavior of Buttons",
                            "href":"c-Changing-the-Behavior-of-Buttons-akd1024602.html#akd1024602",
                            "topics":[
                                {
                                    "title":"Getting and Setting On-Screen Values",
                                    "href":"c-Getting-and-Setting-OnScreen-Values-akd1024491.html#akd1024491"
                                },
                                {
                                    "title":"Creating, Reading, Updating, and Deleting Records",
                                    "href":"c-Creating-Reading-Updating-and-Deleting-Records-akd1024800.html#akd1024800"
                                }
                            ]
                        },
                        {
                            "title":"Error Handling",
                            "href":"c-Error-Handling-akd1025089.html#akd1025089"
                        }
                    ]
                },
                {
                    "title":"Contexts in Which You Can Customize Buttons",
                    "href":"c-Contexts-in-Which-You-Can-Customize-Buttons-akd1024389.html#akd1024389"
                },
                {
                    "title":"Color Coding of Fields and Rows",
                    "href":"c-Color-Coding-of-Fields-and-Rows-akd1026491.html#akd1026491",
                    "topics":[
                        {
                            "title":"Color Coding of Fields in Detail and Edit Pages",
                            "href":"c-Color-Coding-of-Fields-in-Detail-and-Edit-Pages-akd1026633.html#akd1026633"
                        },
                        {
                            "title":"Color Coding of Fields and Rows in Lists",
                            "href":"c-Color-Coding-of-Fields-and-Rows-in-Lists-akd1026637.html#akd1026637"
                        },
                        {
                            "title":"Restrictions That Apply to Color Coding of Fields",
                            "href":"c-Restrictions-That-Apply-to-Color-Coding-of-Fields-akd1026602.html#akd1026602"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"3 Getting Started with the JavaScript API",
            "topics":[
                {
                    "title":"Getting Started with the JavaScript API",
                    "href":"c-OnDemJavaDev-Start.html#ondemjavadev_start"
                },
                {
                    "title":"Overview of Using Custom JavaScript Code",
                    "href":"c-Overview-of-Using-Custom-Java-Script-Code-ake1024297.html#ake1024297"
                },
                {
                    "title":"Privileges Required",
                    "href":"c-Privileges-Required-ake1024298.html#ake1024298"
                },
                {
                    "title":"Uploading JavaScript Libraries",
                    "href":"c-Uploading-Java-Script-Libraries-ake1024299.html#ake1024299"
                },
                {
                    "title":"Guidelines for Uploading Client-Side Extensions",
                    "href":"c-Guidelines-for-Uploading-ClientSide-Extensions-ake1024986.html#ake1024986"
                },
                {
                    "title":"Managing HTML Head Additions",
                    "href":"c-Managing-HTML-Head-Additions-ake1024302.html#ake1024302"
                },
                {
                    "title":"Guidelines for Managing HTML Head Additions",
                    "href":"c-Guidelines-for-Managing-HTML-Head-Additions-ake1024997.html#ake1024997"
                },
                {
                    "title":"About Enabling and Disabling Customized Code in Oracle CRM On Demand",
                    "href":"c-About-Enabling-and-Disabling-Customized-Code-in-Oracle-CRM-On-Demand-ake1027502.html#ake1027502"
                },
                {
                    "title":"Security Considerations",
                    "href":"c-Security-Considerations-ake1025014.html#ake1025014"
                }
            ]
        },
        {
            "heading":"4 JavaScript API Reference",
            "topics":[
                {
                    "title":"JavaScript API Reference",
                    "href":"c-OnDemJavaDev-APIRef.html#ondemjavadev_apiref"
                },
                {
                    "title":"Classes Exposed",
                    "href":"c-Classes-Exposed-akf1024284.html#akf1024284",
                    "topics":[
                        {
                            "title":"TitleBar Class",
                            "href":"c-Title-Bar-Class-akf1045726.html#akf1045726"
                        },
                        {
                            "title":"Button Class",
                            "href":"c-Button-Class-akf1024298.html#akf1024298"
                        },
                        {
                            "title":"Context Class",
                            "href":"c-Context-Class-akf1024304.html#akf1024304"
                        }
                    ]
                },
                {
                    "title":"JavaScript API",
                    "href":"c-Java-Script-API-akf1026077.html#akf1026077",
                    "topics":[
                        {
                            "title":"Chaining of Methods",
                            "href":"c-Java-Script-API-akf1026077.html#akf1028840"
                        }
                    ]
                },
                {
                    "title":"Methods for the oraclecrmod Object",
                    "href":"c-Methods-for-the-oraclecrmod-Object-akf1024361.html#akf1024361",
                    "topics":[
                        {
                            "title":"Considerations for Specifying Tooltips with HTML Formatting",
                            "href":"c-Considerations-for-Specifying-Tooltips-with-HTML-Formatting-akf1037617.html#akf1037617"
                        }
                    ]
                },
                {
                    "title":"Methods for the TitleBar Object",
                    "href":"c-Methods-for-the-Title-Bar-Object-akf1036862.html#akf1036862"
                },
                {
                    "title":"Methods for the Button Object",
                    "href":"c-Methods-for-the-Button-Object-akf1032041.html#akf1032041",
                    "topics":[
                        {
                            "title":"Defining an Event Handler for a Button",
                            "href":"c-Defining-an-Event-Handler-for-a-Button-akf1028230.html#akf1028230"
                        },
                        {
                            "title":"Identifying the IDs of Buttons and TitleBars",
                            "href":"c-Identifying-the-IDs-of-Buttons-and-Title-Bars-akf1024745.html#akf1024745"
                        }
                    ]
                },
                {
                    "title":"Methods for the Field Object",
                    "href":"c-Methods-for-the-Field-Object-akf1041387.html#akf1041387",
                    "topics":[
                        {
                            "title":"Finding Field Names",
                            "href":"c-Finding-Field-Names-akf1042197.html#akf1042197"
                        },
                        {
                            "title":"Getting and Setting Screen Values",
                            "href":"c-Getting-and-Setting-Screen-Values-akf1042194.html#akf1042194",
                            "topics":[
                                {
                                    "title":"Limitations When Using the setValue() Method",
                                    "href":"c-Limitations-When-Using-the-set-Value-Method-akf1044363.html#akf1044363"
                                },
                                {
                                    "title":"Support for Address Fields When Using the setValue() Method",
                                    "href":"c-Support-for-Address-Fields-When-Using-the-set-ValueMethod-akf1044478.html#akf1044478"
                                }
                            ]
                        },
                        {
                            "title":"Guidelines for Setting Screen Values",
                            "href":"c-Guidelines-for-Setting-Screen-Values-akf1042129.html#akf1042129"
                        },
                        {
                            "title":"Getting and Setting LIC Values of Picklists",
                            "href":"c-Getting-and-Setting-LIC-Values-of-Picklists-akf1041157.html#akf1041157"
                        },
                        {
                            "title":"Color Values for JSONObjects",
                            "href":"c-Color-Values-for-JSONObjects-akf1042174.html#akf1042174"
                        }
                    ]
                },
                {
                    "title":"Methods for the Form Object",
                    "href":"c-Methods-for-the-Form-Object-akf1041543.html#akf1041543",
                    "topics":[
                        {
                            "title":"Example of a Custom Handler for a Form Object",
                            "href":"c-Example-of-a-Custom-Handler-for-a-Form-Object-akf1039803.html#akf1039803"
                        },
                        {
                            "title":"Callback Handler for the commitValues() Method",
                            "href":"c-Callback-Handler-for-the-commit-Values-Method-akf1043807.html#akf1043807"
                        }
                    ]
                },
                {
                    "title":"Methods for the List Object",
                    "href":"c-Methods-for-the-List-Object-akf1041695.html#akf1041695",
                    "topics":[
                        {
                            "title":"About the Custom Handler for a List Object",
                            "href":"c-About-the-Custom-Handler-for-a-List-Object-akf1040741.html#akf1040741"
                        },
                        {
                            "title":"Finding List Names",
                            "href":"c-Finding-List-Names-akf1041987.html#akf1041987"
                        }
                    ]
                },
                {
                    "title":"Methods for the ListRow Object",
                    "href":"c-Methods-for-the-List-Row-Object-akf1041706.html#akf1041706"
                },
                {
                    "title":"Methods for the Context Object",
                    "href":"c-Methods-for-the-Context-Object-akf1038142.html#akf1038142"
                },
                {
                    "title":"Methods for CRUD Operations",
                    "href":"c-Methods-for-CRUD-Operations-akf1025611.html#akf1025611",
                    "topics":[
                        {
                            "title":"Parameters and Return Values for CRUD Methods",
                            "href":"c-Parameters-and-Return-Values-for-CRUD-Methods-akf1029547.html#akf1029547"
                        },
                        {
                            "title":"Finding Record Type Names",
                            "href":"c-Finding-Record-Type-Names-akf1033962.html#akf1033962"
                        },
                        {
                            "title":"Guidelines for Performing CRUD Operations",
                            "href":"c-Guidelines-for-Performing-CRUD-Operations-akf1033967.html#akf1033967"
                        },
                        {
                            "title":"User-Defined Callback Function",
                            "href":"c-UserDefined-Callback-Function-akf1026494.html#akf1026494"
                        },
                        {
                            "title":"Helper Functions for Callback Functions",
                            "href":"c-Helper-Functions-for-Callback-Functions-akf1025168.html#akf1025168"
                        },
                        {
                            "title":"Sample Code for Callback Function",
                            "href":"c-Sample-Code-for-Callback-Function-akf1026214.html#akf1026214"
                        }
                    ]
                },
                {
                    "title":"Method for Setting the Search Specification for the Solutions Popup Window Associated with Service Requests",
                    "href":"c-Method-for-Setting-the-Search-Specification-forthe-Solutions-Popup-Window-Associated-with-Service-Requests-akf1035684.html#akf1035684"
                },
                {
                    "title":"Errors and Error Handling",
                    "href":"c-Errors-and-Error-Handling-akf1035704.html#akf1035704",
                    "topics":[
                        {
                            "title":"Example Code of How to Deal with the Error Object",
                            "href":"c-Example-Code-of-How-to-Deal-with-the-Error-Object-akf1029414.html#akf1029414"
                        },
                        {
                            "title":"CRUD Error Codes and Messages",
                            "href":"c-CRUD-Error-Codes-and-Messages-akf1031694.html#akf1031694"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"5 JavaScript API Code Samples",
            "topics":[
                {
                    "title":"JavaScript API Code Samples",
                    "href":"c-OnDemJavaDev-Samples.html#OnDemJavaDev_Samples"
                },
                {
                    "title":"Getting Started with the Code Samples",
                    "href":"c-Getting-Started-with-the-Code-Samples-akg1029128.html#akg1029128"
                },
                {
                    "title":"Code Sample 1 for Creating a Custom Button for Validation",
                    "href":"c-Code-Sample-1-for-Creating-a-Custom-Button-for-Validation-akg1024800.html#akg1024800"
                },
                {
                    "title":"Code Sample 2 for Creating a Custom Button for Validation",
                    "href":"c-Code-Sample-2-for-Creating-a-Custom-Button-for-Validation-akg1026808.html#akg1026808"
                },
                {
                    "title":"Code Sample for a Custom Button That Creates a Record",
                    "href":"c-Code-Sample-for-a-Custom-Button-That-Creates-a-Record-akg1024554.html#akg1024554"
                },
                {
                    "title":"Code Sample for a Custom Button That Creates a Child Record",
                    "href":"c-Code-Sample-for-a-Custom-Button-That-Creates-a-Child-Record-akg1028872.html#akg1028872"
                },
                {
                    "title":"Code Sample for a Custom Button That Updates a Record",
                    "href":"c-Code-Sample-for-a-Custom-Button-That-Updates-a-Record-akg1026189.html#akg1026189"
                },
                {
                    "title":"Code Sample for a Custom Button That Gets a Shipping Address to Pass to an External Site",
                    "href":"c-Code-Sample-for-a-Custom-Button-That-Gets-a-Shipping-Address-to-Pass-to-an-External-Site-akg1025186.html#akg1025186"
                },
                {
                    "title":"Code Sample for a Custom Button That Creates a Task",
                    "href":"c-Code-Sample-for-a-Custom-Button-That-Creates-a-Task-akg1028001.html#akg1028001"
                },
                {
                    "title":"Code Sample for Hiding a Button",
                    "href":"c-Code-Sample-for-Hiding-a-Button-akg1029091.html#akg1029091"
                },
                {
                    "title":"Code Sample for Changing the Behavior of a Save Button",
                    "href":"c-Code-Sample-for-Changing-the-Behavior-of-a-Save-Button-akg1024809.html#akg1024809"
                },
                {
                    "title":"Code Sample for a Read Operation on an Account Record",
                    "href":"c-Code-Sample-for-a-Read-Operation-on-an-Account-Record-akg1027623.html#akg1027623"
                },
                {
                    "title":"Code Sample for Color Coding of Fields and Rows",
                    "href":"c-Code-Sample-for-Color-Coding-of-Fields-and-Rows-akg1030260.html#akg1030260"
                }
            ]
        }
    ]
});