<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:template match="TutorialPage">
		<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>	
		<xsl:variable name="baseDir"><xsl:value-of select="@baseDir"/></xsl:variable>
		<xsl:variable name="singleTopic"><xsl:value-of select="@singleTopic"/></xsl:variable>
		<xsl:variable name="totalThisLesson"><xsl:value-of select="@totalThisLesson"/></xsl:variable>

<html>
<head>
	<title>
		<xsl:value-of select="Topic"/>
	</title>
	<link rel="stylesheet" type="text/css" href="{$baseDir}/tutorial/engine/master.css"/>		

	<script language="JavaScript" src="../../strings.js"></script>
	
	<script language="JavaScript">
		var sT = "<xsl:value-of select="$singleTopic"/>";
		var singleTopic = true; // this var will hold a boolean indicating if a topic is launched as a single topic [true] or as part of a 'lesson' [false]
		if (sT != "1"){
 			singleTopic = false;
		}
	</script>

	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions.js"></script>
	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions3.js"></script>

	<script language="JavaScript">
		topicInt = <xsl:value-of select="$currTopic"/>;
		titleString = "<xsl:value-of select="Topic"/>";
		totalPagesThisTopic = <xsl:value-of select="$totalThisLesson"/>;
		var str = pageName.split("_");
		topicName = str[0];
		thisTopicNumber = str[1];
		setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

		function init() { 
			hide('loading');
			paint('background','introText');

				<xsl:for-each select="HotSpot">
					<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
					<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
					<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>					
					put("<xsl:value-of select="$ID"/>", "<xsl:value-of select="$x"/>"/, "<xsl:value-of select="$y"/>");
				</xsl:for-each>

				<xsl:for-each select="PopUp">
					<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
					<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
					<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
					put("<xsl:value-of select="$ID"/>", "<xsl:value-of select="$x"/>", "<xsl:value-of select="$y"/>");
				</xsl:for-each>

				<xsl:for-each select="PopUp">
					<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>
					<xsl:variable name="puX"><xsl:value-of select="@puX"/></xsl:variable>
					<xsl:variable name="puY"><xsl:value-of select="@puY"/></xsl:variable>
					put("<xsl:value-of select="$puID"/>", "<xsl:value-of select="$puX"/>", "<xsl:value-of select="$puY"/>");
				</xsl:for-each>
		}
	</script> 
</head>

<body onLoad="init();window.focus()">
<!--<div id="idText" class="lesIdentifier">Topic Homepage</div>-->
<div id="introText" class="colText">

<!-- Do not edit table tags-->
	<table width= "680" height = "368">
		<TR valign="top">
			<td width="2%">&#160;</td>

			<!-- left-hand column. 1260 maximum characters per column, including white space, no paragraph breaks-->
			<td class="stepsMenuText" width="46%">
				<div id="getIntro"></div>
				<script language="JavaScript">
					var valText = "<xsl:value-of select="Intro"/>";
					document.getElementById("getIntro").innerHTML += valText;
				</script>
				<br/><br/>
				<span class="texttitle">
				<div id="getNavInstructions"></div>
				<script language="JavaScript">
					var valText = "<xsl:value-of select="NavInstructions"/>";
					document.getElementById("getNavInstructions").innerHTML += valText;
				</script>
				</span>
			</td>
			<!-- the next line is a spacer. Do not edit -->
			<td width="4%">&#160;</td>

			<td class="stepsMenuText" width="46%">
				<table>
					<xsl:for-each select="Text">
						<tr>
							<td valign="top">
								<img src="../../../../base/tutorial/images/blue_arrow.gif" border="0"/>
							</td>
							<td class="lessonTableLink">								
								<a href="{@url}"><xsl:value-of select="."/></a>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</td>
			<td width="2%">&#160;</td>
		</TR>
	</table>
</div>


<!-- do not edit below this line -->

<div id="loading" class="loading">&#160;Loading&#160;<img src="{$baseDir}../../base/tutorial/images/loading.gif" width="80" height="17" border="0" align="middle" alt="loading..."/>&#160;</div>

<div id="background" class="background"><img src="{$baseDir}../../base/tutorial/images/background.gif" width="700" height="615" border="0" align="middle"/></div>

<div id="pic" class="colGr"><img src="{$baseDir}../../base/tutorial/images/clear.gif" width="310" height="373" border ="0" id="scrn" name="scrn"/></div>


<xsl:for-each select="HotSpot">
	<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
	<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>
	<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
	<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>

	<DIV id="{$ID}" class="hotspotC" Style="position:absolute; width:'{$width}'; height:'{$height}'">
		<A HREF="#"  onmouseover = "status = ' ';  return true;" onmouseout = "status = defaultStatus; return true" onclick="loader(topicName+'_{$stepNum}.xml'); return false">
			<IMG SRC="../{$baseDir}/images/clear.gif" border="0"  width="{$width}" height="{$height}"/>
		</A>
	</DIV>
</xsl:for-each>

<xsl:for-each select="PopUp">
	<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
	<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>
	<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
	<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>
	<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>

	<DIV id="{$ID}" class="hotspotC" Style="position:absolute; width:'{$width}'; height:'{$height}'">
		<A HREF="#"  onmouseover = "show_hide('{$puID}'); status = ' ';  return true;" onmouseout = "show_hide('{$puID}'); status = defaultStatus; return true" onclick="loader(topicName+'_{$stepNum}.xml'); return false">
			<IMG SRC="../{$baseDir}/images/clear.gif" border="0"  width="{$width}" height="{$height}"/>
		</A>
	</DIV>
</xsl:for-each>

<xsl:for-each select="PopUp">
	<xsl:variable name="ID"><xsl:value-of select="@puId"/></xsl:variable>
	<xsl:variable name="title"><xsl:value-of select="Title"/></xsl:variable>
	<!--<xsl:variable name="text"><xsl:value-of select="Text"/></xsl:variable>-->

	<div id="{$ID}" class="popUpClass">
	<table width="220" border="0" cellspacing="0" cellpadding="1">
		<tr class="hdr" valign="top">
			<td class="hdr" width="2%">&#160;</td>
			<td colspan="2" class="hdr" width="96%">
				<B><xsl:value-of select="$title"/></B>
			</td>
			<td class="hdr" width="2%">&#160;</td>
		</tr>
		<xsl:for-each select="child::Text">
			<tr valign="top" height="2">
				<td width="2%"></td>
				<td colspan="2" width="96%"></td>
				<td width="2%"></td>
			</tr>
			<tr valign="top">
				<td width="2%">&#160;</td>
				<td width="95%">
					<xsl:choose>
						<xsl:when test="@url!=''">
							<a href="@url"><xsl:value-of select="."/></a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td width="2%">&#160;</td>
			</tr>
		</xsl:for-each>
	</table>
	</div>
</xsl:for-each>

	<div id="temp"></div>
	<script type="text/javascript">document.getElementById("temp").innerHTML=getLocInfo();</script>

</body>
</html>
</xsl:template>
</xsl:stylesheet>