<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:template match="TutorialPage">
<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>
<xsl:variable name="baseDir"><xsl:value-of select="@baseDir"/></xsl:variable>
<xsl:variable name="singleTopic"><xsl:value-of select="@singleTopic"/></xsl:variable>
<xsl:variable name="totalThisLesson"><xsl:value-of select="@totalThisLesson"/></xsl:variable>

<html>
<head>
<title>
<xsl:value-of select="Topic"/>
</title>

<link rel="stylesheet" type="text/css" href="{$baseDir}/tutorial/engine/master.css" />

<script type="text/javascript">
var sT = "<xsl:value-of select="$singleTopic"/>";
var singleTopic = true;// this var will hold a boolean indicating if a topic is launched as a single topic [true] or as part of a 'lesson' [false]
if (sT != "1")
{
   singleTopic = false;
}
</script>

<script type="text/javascript" src="../../strings.js"></script>
<script type="text/javascript" src="{$baseDir}/tutorial/engine/actions.js"></script>
<script type="text/javascript" src="{$baseDir}/tutorial/engine/actions3.js"></script>

<script type="text/javascript">
topicInt = <xsl:value-of select="$currTopic"/>;
titleString = "<xsl:value-of select="Topic"/>";
totalPagesThisTopic = <xsl:value-of select="$totalThisLesson"/>;

// ************* do not edit the scripts below this line  *****************************/
var imgFilePath = "graphics/"+pageName+"_01.png";
preload(imgFilePath);
var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() { 
  hide('loading'); 
  paint('dropShadow','screen','background','steps');
  swapStep('01');
}
</script>

</head>

<body onLoad="init(); window.focus()">
<div id="steps" class="stepsMenu">

<!-- Do not edit table tags-->
<table width= "230">
   <TR>
      <td width="1%">&#160;</td>
      <td width="98%" class="stepsMenuText"><xsl:value-of select="child::Intro"/><br/></td>
      <td width="1%">&#160;</td>
   </TR>
   <xsl:if test="child::Intro/child::*[name()='link']">
      <xsl:for-each select="child::Intro/child::*[name()='link']">
         <tr>
            <td width="1%">&#160;</td>
            <td width="98%" class="stepsMenuText"><xsl:call-template name="linkTempl"/></td>
            <td width="1%">&#160;</td>
         </tr>
      </xsl:for-each>
   </xsl:if>
</table>
<table width= "230">

<xsl:for-each select="Text">
		<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>

<!-- the next block [<TR> to </TR>] creates a complete step. -->
<TR valign="top">
<td width="2%">&#160;</td>
<td width="15%"><A href="javascript:swapStep('{$stepNum}')">
<img src="../../../../base/tutorial/images/step_{$stepNum}_up.gif" border="0" id="stepNum{$stepNum}" name="stepNum{$stepNum}"/></A></td>
<td class="stepsMenuText" width="80%"><A href="javascript:swapStep('{$stepNum}')">
<xsl:value-of select="text()"/>
</A><br/>
<xsl:for-each select="descendant-or-self::*[name()='link']">
<xsl:call-template name="linkTempl"/>
</xsl:for-each>
</td>
<!-- the next line is a spacer. Do not edit -->
<td width="3%">&#160;</td></TR>

</xsl:for-each>
	
</table></div>
<xsl:call-template name="helpLinks"/>

<div id="loading" class="loading">&#160;Loading&#160;<img src="../../../../base/tutorial/images/loading.gif" width="80" height="17" border="0" align="middle" alt="loading..."/>&#160;</div>

<div id="background" class="background"><img src="../../../../base/tutorial/images/background.gif" width="700" height="615" border="0" align="middle"/></div>

<div id="screen" class="screenShot"><img src="../../../../base/tutorial/images/clear.gif" width="436" height="378" border ="0" id="scrn" name="scrn"/></div>

<div id = "dropShadow" class="dropS"><img src="../../../../base/tutorial/images/drop_shadow_small.gif" width="700" height="413"/></div>

<div id="temp"></div>
<script type="text/javascript">document.getElementById("temp").innerHTML=getLocInfo();</script>


</body>
</html>
	</xsl:template>

		<xsl:template name="linkTempl">
		<xsl:variable name="url"><xsl:value-of select="@url"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="@newWindow='true'">
			<xsl:choose>
				<xsl:when test="@winH">
					<a href="#" onclick="javascript:window.open('{$url}','','toolbar=no,menubar=no,status=no,scrollbars=no,resizable=no,width=@winW,height=@winH,left=100,top=60')"  style="color:blue">
						<xsl:value-of select="."/>
					</a>
				</xsl:when>
				
				<xsl:otherwise> 
					<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')"  style="color:blue">
						<xsl:value-of select="."/>
					</a>
				</xsl:otherwise>
			</xsl:choose>
				<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')" style="color:blue">
					<xsl:value-of select="."/>
				</a>
			</xsl:when>

			<xsl:otherwise>
			   <a href = "{$url}" style="color:blue">
					<xsl:value-of select="."/>
				</a>
			</xsl:otherwise>
		</xsl:choose>
		<br/>
	</xsl:template>

<xsl:template name="helpLinks" match="//helpLinks">
	<xsl:variable name="url"><xsl:value-of select="@url"/></xsl:variable>
	<div id="helpLinks" class="hLinks">
	<table>
	<xsl:for-each select="child::helpLinks/child::link">
	<tr>
	<xsl:variable name="target"><xsl:value-of select="$url"/></xsl:variable>
	<td width="3%"></td><td>
	<a href="#" onClick = "helpLaunch('{$target}')">
	<img src="../../../../base/tutorial/images/help.gif" border="0" width="50" height="24"/>
	</a></td><td class='hLinksText'><a href="#" onClick = "helpLaunch('{$target}')" style="color:#0066CC">
	<xsl:value-of select="."/>
	</a></td>
	</tr>
</xsl:for-each>
</table></div>
</xsl:template>


</xsl:stylesheet>

