<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes"/>
	<xsl:template match="TutorialPage">
		<xsl:text><![CDATA[
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title>]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[</title>
	<link rel="stylesheet" type="text/css" href="../master.css">	
<script language="JavaScript" src="../strings.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions2.js"></script>

<script language="JavaScript">

totalPagesThisTopic = "1";
var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() {]]></xsl:text> <xsl:variable name="locPath"><xsl:choose><xsl:when test="child::*[name()='Image']/@mustBeLocalized = 'true'">../images</xsl:when><xsl:otherwise>../../base/tutorial/images</xsl:otherwise></xsl:choose></xsl:variable>
<xsl:if test="//Image">swap('scrn', '<xsl:value-of select="$locPath"/>/<xsl:value-of select="child::*[name()='Image']/@fileName"/>', 'pic')</xsl:if><xsl:text><![CDATA[
  hide('loading');
  paint('background','introText']]></xsl:text><xsl:if test="//Image">,'pic'</xsl:if><xsl:text><![CDATA[);]]></xsl:text>
	<xsl:for-each select="HotSpot">
		<xsl:variable name="id"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
		<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
		<xsl:variable name="puId"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="puX"><xsl:value-of select="@puX"/></xsl:variable>
		<xsl:variable name="puY"><xsl:value-of select="@puY"/></xsl:variable>
<xsl:text><![CDATA[
 put(']]></xsl:text><xsl:value-of select="$id"/><xsl:text><![CDATA[',]]></xsl:text><xsl:value-of select="$y"/><xsl:text><![CDATA[,]]></xsl:text><xsl:value-of select="$x"/><xsl:text><![CDATA[);
 ]]></xsl:text>
 		<xsl:if test="$puId!=''">
 <xsl:text><![CDATA[
 put(']]></xsl:text><xsl:value-of select="$puId"/><xsl:text><![CDATA[',]]></xsl:text><xsl:value-of select="$puY"/><xsl:text><![CDATA[,]]></xsl:text><xsl:value-of select="$puX"/><xsl:text><![CDATA[); ]]></xsl:text>
 		</xsl:if>
 	</xsl:for-each>
 	<xsl:if test="//Image">
 <xsl:text>put('pic',</xsl:text><xsl:value-of select="child::*[name()='Image']/@y"/><xsl:text>,</xsl:text><xsl:value-of select="child::*[name()='Image']/@x"/><xsl:text>);</xsl:text> 
 	</xsl:if>
<xsl:text><![CDATA[
}
</script> 
</head>

<body onLoad="init();window.focus()">



<!-- the following block contains the text and icon links for steps in the page -->

<!--<div id="idText" class="lesIdentifier">Lesson Homepage</div>-->

<div id="introText" class="colText">

<!-- Do not edit table tags-->
<table width= "680" height = "368">

<!-- the next block [<TR> to </TR>] creates a complete step. -->
<TR valign="top">
<td width="2%">&nbsp;</td>

<!-- left-hand column. 1260 maximum characters per column, including white space, no paragraph breaks-->
<td class="stepsMenuText" width="46%">]]></xsl:text><xsl:value-of select="Intro"/><xsl:text><![CDATA[<br><br><span class="texttitle">]]></xsl:text><xsl:value-of select="NavInstructions"/><xsl:text><![CDATA[</span></td>

<td width="4%">&nbsp;</td>


<td class="stepsMenuText" width="46%"><table>]]></xsl:text><xsl:for-each select="Text"><xsl:text><![CDATA[<tr><td valign="top"><img src="../../../base/tutorial/images/green_arrow.gif" border="0"/></td><td class="lessonTableLink"><a href="]]></xsl:text><xsl:choose><xsl:when test="@newWindow = 'true'">javascript:launchPage('<xsl:value-of select="@url"/>'<xsl:choose><xsl:when test="@winW !=''">,<xsl:value-of select="@winW"/>,<xsl:value-of select="@winH"/></xsl:when></xsl:choose>)</xsl:when><xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise></xsl:choose><xsl:text><![CDATA[">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a></td></tr>]]></xsl:text><xsl:if test="@lineBar='true'"><xsl:text disable-output-escaping="yes">&lt;tr&gt;&lt;td colspan="2" height="4"  width="100%" &gt; &lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td colspan="2" height="1"  width="100%" style="background-color:000066"&gt; &lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td colspan="2" height="4"  width="100%" &gt; &lt;/td&gt;&lt;/tr&gt;</xsl:text></xsl:if></xsl:for-each><xsl:text><![CDATA[ </table>
</td>
<td width="2%">&nbsp;</td>
</TR>

</table>
</div>


<div id="loading" class="loading">&nbsp;Loading&nbsp;<img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/loading.gif" width=80 height=17 border=0 align="middle" alt="loading...">&nbsp;</div>

<div id="background" class="background"><img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/background.gif" width=700 height=615 border=0 align="middle"></div>]]></xsl:text>

<xsl:if test="//Image"><xsl:text><![CDATA[<div id="pic" class="colGr"><img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/clear.gif" border ="0" width="290" height="166" id="scrn" name="scrn"></div>
]]></xsl:text></xsl:if>

	<xsl:for-each select="HotSpot">
		<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="stepNum"><xsl:value-of select="@url"/></xsl:variable>
		<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
		<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>
		<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "show(']]></xsl:text><xsl:value-of select="$puID"/><xsl:text><![CDATA[');status = ' ';  return true;" onmouseout = "hide(']]></xsl:text><xsl:value-of select="$puID"/><xsl:text><![CDATA[');status = defaultStatus; return true" onclick="loader(']]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA['); return false"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
	</xsl:for-each>
<xsl:for-each select="HotSpot">
		<xsl:variable name="ID"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="title"><xsl:value-of select="Title"/></xsl:variable>
		<!--<xsl:variable name="text"><xsl:value-of select="Text"/></xsl:variable>-->
<xsl:text><![CDATA[
<div id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="popUpClass">
  <table width='220' border='0' cellspacing='0' cellpadding='1'>
	<tr class="hdr" valign='top'>
		<td class="hdr" width='2%'>&nbsp;</td>
		<td colspan="2" class="hdr" width='96%'>
		<B>]]></xsl:text><xsl:value-of select="$title"/><xsl:text><![CDATA[</B></td>
		<td class="hdr" width='2%'>&nbsp;</td></tr>]]></xsl:text>
		<xsl:for-each select="child::Text"><xsl:text><![CDATA[
		<tr valign='top' height=2>
		<td width='2%'></td>
		<td colspan="2" width='96%'></td>
		<td width='2%'></td></tr>
	<tr valign='top'>
		<td width='2%'>&nbsp;</td>
		<td width='95%'>]]></xsl:text><xsl:choose>
			<xsl:when test="@url!=''"><xsl:text><![CDATA[<a href="]]></xsl:text><xsl:choose>
				<xsl:when test="@newWindow = 'true'">javascript:launchPage('<xsl:value-of select="@url"/>')</xsl:when><xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
			</xsl:choose><xsl:text><![CDATA[">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a>]]></xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
		</xsl:choose><xsl:text><![CDATA[</td>
		<td width='2%'>&nbsp;</td></tr>]]></xsl:text>
		</xsl:for-each>
<xsl:text><![CDATA[
  </table>
</div>
]]></xsl:text>
	</xsl:for-each>

<xsl:text><![CDATA[
<!-- the following divs are utilities. Delete when page is finished -->

<script language="JavaScript" src="../../../base/tutorial/engine/devDrag.js"></script>

<div id="gen" class="locator">
 <form name="hotspot"><textarea name="spot" cols=100 rows=5 wrap="virtual"></textarea><br>Hotspot Builder. Press Ctl + C to copy.</form></div>
 
<div id="box" class="find">
 <!--<img src="images/clear.gif" width="20" height="20">-->
</div>

<!-- end utilities -->
<script language="JavaScript">document.write(getLocInfo());</script>
</body>
</html>]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>