<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes"/>
	<xsl:template match="TutorialPage">
<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>
		<xsl:text><![CDATA[
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title>]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[</title>
	<link rel="stylesheet" type="text/css" href="../../master.css">		
<script language="JavaScript" src="../../strings.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions3.js"></script>

<script language="JavaScript">
topicInt="]]></xsl:text><xsl:value-of select="$currTopic"/><xsl:text><![CDATA[";
titleString = "]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[";
totalPagesThisTopic = "]]></xsl:text><xsl:value-of select="@totalThisLesson"/><xsl:text><![CDATA[";

// ************* do not edit the scripts below this line  *****************************/
hasImage = ]]></xsl:text><xsl:value-of select="@hasImage"/><xsl:text><![CDATA[;// every lesson home page has an image, so keep set at 1
var imgFilePath = "graphics/"+pageName+"_01.png";
(hasImage==1 || hasImage==2 || hasImage==3)?preload(imgFilePath):'';
var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() { 
  hide('loading');
  (hasImage == 1 || hasImage == 2)?swap('scrn',imgFilePath,'pic'):''; 
  (hasImage == 3)?swap('scrn',imgFilePath,'screen'):''; 

]]></xsl:text>
	<xsl:if test="@hasImage='0'">
<xsl:text><![CDATA[
 put('pic',126,0);
 paint('background','steps');
 show('pic');
]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='1'">
<xsl:text><![CDATA[
 put('pic',126,0);
 paint('background','steps');
 show('pic');
]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='2'">
<xsl:text><![CDATA[
 put('pic',147,370);
 paint('background','steps');
 show('pic');
 ]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='3'">
<xsl:text><![CDATA[
 paint('dropShadow','screen','background','steps');

 ]]></xsl:text>
	</xsl:if>
<xsl:text><![CDATA[

}
</script> 
</head>

<body onLoad="init();window.focus()">
<div id="steps" class="colText">
<table width= "680" height = "368">
<TR valign="top">
<td width="2%">&nbsp;</td>
<td class="stepsMenuText" width="46%">
]]></xsl:text>
	<xsl:for-each select="Text">
		<xsl:variable name="column"><xsl:value-of select="@column"/></xsl:variable>
		<xsl:if test="$column='left'">
			<xsl:variable name="type"><xsl:value-of select="@type"/></xsl:variable>
			<xsl:if test="$type='text'">
<xsl:text><![CDATA[
				]]></xsl:text><xsl:value-of select="."/>
			</xsl:if>
			<xsl:if test="$type='bullet'">
<xsl:text><![CDATA[
<table width= "320" >
<TR valign="top">
<td width="4%"><img src="../../../../base/tutorial/images/text_bullet.gif" border="0"></td>
<td class="stepsMenuText" width="96%">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</td>
</tr>
</table>
]]></xsl:text>		
			</xsl:if>
			<xsl:if test="$type='linkImage'">
<xsl:text><![CDATA[
<br><br><span class="texttitle"><img src="]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[" width="118" height="17" border="0" alt="related documents"></span>
]]></xsl:text>		
			</xsl:if>
			<xsl:if test="$type='link'">
<xsl:text><![CDATA[
<table width= "320" >
<TR valign="top">
<td width="4%"><img src="../../../../base/tutorial/images/related_doc.gif" border="0"></td>
<td class="stepsMenuText" width="96%"><A href="#" onclick="javascript:window.open(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=0,top=0')">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a>
</td>
</TR>
</table>
]]></xsl:text>	
			</xsl:if>
		</xsl:if>
	</xsl:for-each>
<xsl:text><![CDATA[
<td width="4%">&nbsp;</td>
<td class="stepsMenuText" width="46%">
]]></xsl:text>
	<xsl:for-each select="Text">
		<xsl:variable name="column"><xsl:value-of select="@column"/></xsl:variable>
		<xsl:if test="$column='right'">
			<xsl:variable name="type"><xsl:value-of select="@type"/></xsl:variable>
			<xsl:if test="$type='text'">
<xsl:text><![CDATA[
				]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[
]]></xsl:text>		
			</xsl:if>
			<xsl:if test="$type='bullet'">
<xsl:text><![CDATA[
<table width= "320" >
<TR valign="top">
<td width="4%"><img src="../../../../base/tutorial/images/text_bullet.gif" border="0"></td>
<td class="stepsMenuText" width="96%">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</td>
</tr>
</table>
]]></xsl:text>		
			</xsl:if>
			<xsl:if test="$type='linkImage'">
<xsl:text><![CDATA[
<span class="texttitle"><img src="]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[" width="118" height="17" border="0" alt="related documents"></span>
]]></xsl:text>		
			</xsl:if>
			<xsl:if test="$type='link'">
<xsl:text><![CDATA[
<table width= "320" >
<TR valign="top">
<td width="4%"><img src="../../../../base/tutorial/images/related_doc.gif" border="0"></td>
<td class="stepsMenuText" width="96%"><A href="#" onclick="javascript:window.open(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=0,top=0')">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a>
</td>
</TR>
</table>
]]></xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:for-each>
<xsl:text><![CDATA[

</td>
<td width="4%">&nbsp;</td>
<td class="stepsMenuText" width="46%">
</td>
<td width="2%">&nbsp;</td>
</TR>
</table>
</div>
<div id="loading" class="loading">&nbsp;Loading&nbsp;<img src="../../../../base/tutorial/images/loading.gif" width=80 height=17 border=0 align="middle" alt="loading...">&nbsp;</div>

<div id="background" class="background"><img src="../../../../base/tutorial/images/background.gif" width=700 height=615 border=0 align="middle"></div>

]]></xsl:text>
	<xsl:if test="@hasImage='0'">
<xsl:text><![CDATA[
<div id="pic" class="colGr"><img src="../../../../base/tutorial/images/clear.gif" width="700" height="434" border ="0" id="scrn" name="scrn"></div>
]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='1'">
<xsl:text><![CDATA[
<div id="pic" class="colGr"><img src="../../../../base/tutorial/images/clear.gif" width="700" height="434" border ="0" id="scrn" name="scrn"></div>
]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='2'">
<xsl:text><![CDATA[
<div id="pic" class="colGr"><img src="../../../../base/tutorial/images/clear.gif" width="310" height="373" border ="0" id="scrn" name="scrn"></div>
]]></xsl:text>
	</xsl:if>
	<xsl:if test="@hasImage='3'">
<xsl:text><![CDATA[
<div id="screen" class="screenShotBg"><img src="../../../../base/tutorial/images/clear.gif" width="678" height="378" border ="0" id="scrn" name="scrn"></div>
<div id = "dropShadow" class="dropSBg"><img src="../../../../base/tutorial/images/drop_shadow_big.gif" width="700" height="413"></div>
]]></xsl:text>
	</xsl:if>
<xsl:text><![CDATA[
	
<script language="JavaScript">document.write(getLocInfo());</script>

</body>
</html>]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>