<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:template match="TutorialPage">
		<xsl:variable name="baseDir"><xsl:value-of select="@baseDir"/></xsl:variable>
		<xsl:variable name="singleTopic"><xsl:value-of select="@singleTopic"/></xsl:variable>


<html>
<head>
	<title>
		<xsl:value-of select="Topic"/>
	</title>
	<link rel="stylesheet" type="text/css" href="{$baseDir}/tutorial/engine/master.css"/>	

	<script language="JavaScript" src="../strings.js"></script>
	<script language="JavaScript">
		var sT = "<xsl:value-of select="$singleTopic"/>";
		var singleTopic = true; // this var will hold a boolean indicating if a topic is launched as a single topic [true] or as part of a 'lesson' [false]
		if (sT != "1"){
 			singleTopic = false;
		}
	</script>

	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions.js"></script>
	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions2.js"></script>

	<script language="JavaScript">
		totalPagesThisTopic = "1";
		var str = pageName.split("_");
		topicName = str[0];
		thisTopicNumber = str[1];
		setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

		function init() {
			<xsl:variable name="locPath">
				<xsl:choose>
					<xsl:when test="child::*[name()='Image']/@mustBeLocalized = 'true'">../images</xsl:when>
					<xsl:otherwise>../../base/tutorial/images</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="//Image">
				swap('scrn', '<xsl:value-of select="$locPath"/>/<xsl:value-of select="child::*[name()='Image']/@fileName"/>', 'pic')
			</xsl:if>
			hide('loading');

			<xsl:choose>
				<xsl:when test="//Image">
					paint('background','introText','pic');
				</xsl:when>
				<xsl:otherwise>
					paint('background','introText');
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:for-each select="HotSpot">
				<xsl:variable name="id"><xsl:value-of select="@id"/></xsl:variable>
				<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
				<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
				<xsl:variable name="puId"><xsl:value-of select="@puId"/></xsl:variable>
				<xsl:variable name="puX"><xsl:value-of select="@puX"/></xsl:variable>
				<xsl:variable name="puY"><xsl:value-of select="@puY"/></xsl:variable>
				
				put("<xsl:value-of select="$id"/>", "<xsl:value-of select="$y"/>", "<xsl:value-of select="$x"/>");

 				<xsl:if test="$puId!=''"> 
					put("<xsl:value-of select="$puId"/>", "<xsl:value-of select="$puY"/>", "<xsl:value-of select="$puX"/>");
 				</xsl:if>
			</xsl:for-each>
 			<xsl:if test="//Image">
				put('pic',<xsl:value-of select="child::*[name()='Image']/@y"/>,<xsl:value-of select="child::*[name()='Image']/@x"/>);
 			</xsl:if>
		}
	</script> 
</head>

<body onLoad="init();window.focus()">



<!-- the following block contains the text and icon links for steps in the page -->

<!--<div id="idText" class="lesIdentifier">Lesson Homepage</div>-->

<div id="introText" class="colText">

	<!-- Do not edit table tags-->
	<table width= "680" height = "368">

		<!-- the next block [<TR> to </TR>] creates a complete step. -->
		<tr valign="top">
			<td width="2%">&#160;</td>

			<!-- left-hand column. 1260 maximum characters per column, including white space, no paragraph breaks-->
			<td class="stepsMenuText" width="46%">
				<div id="getIntro"></div>
				<script language="JavaScript">
					var valText = "<xsl:value-of select="Intro"/>";
					document.getElementById("getIntro").innerHTML += valText;
				</script>
				
				<br/><br/>
				<span class="texttitle">
					<xsl:value-of select="NavInstructions"/>
				</span>
			</td>

			<td width="4%">&#160;</td>

			<td class="stepsMenuText" width="46%">
				<table>
					<xsl:for-each select="Text">
						<tr>
							<td valign="top"><img src="../../../base/tutorial/images/green_arrow.gif" border="0"/></td>
							<td class="lessonTableLink">
								<xsl:variable name="parseURL">
									<xsl:choose>
										<xsl:when test="@newWindow = 'true'">
											javascript:launchPage('
											<xsl:value-of select="@url"/>'
											<xsl:choose>
												<xsl:when test="@winW !=''">,
													<xsl:value-of select="@winW"/>,
													<xsl:value-of select="@winH"/>
												</xsl:when>
											</xsl:choose>)
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@url"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
									
								<a href="{$parseURL}"><xsl:value-of select="."/></a>
								</td>
						</tr>
						
						<xsl:if test="@lineBar='true'">
							<tr>
								<td colspan="2" height="4" width="100%"></td>
							</tr>
							<tr>
								<td colspan="2" height="1"  width="100%" style="background-color:000066"> </td>
							</tr>
							<tr>
								<td colspan="2" height="4"  width="100%"> </td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</table>
			</td>
			<td width="2%">&#160;</td>
		</tr>
	</table>
</div>


<div id="loading" class="loading">&#160;Loading&#160;<img src="{$baseDir}../../base/tutorial/images/loading.gif" width="80" height="17" border="0" align="middle" alt="loading..."/>&#160;</div>

<div id="background" class="background"><img src="{$baseDir}../../base/tutorial/images/background.gif" width="700" height="615" border="0" align="middle"/></div>

<xsl:if test="//Image">
	<div id="pic" class="colGr">
		<img src="{$baseDir}../../base/tutorial/images/clear.gif" border ="0" width="290" height="166" id="scrn" name="scrn"/>
	</div>
</xsl:if>

<xsl:for-each select="HotSpot">
	<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
	<xsl:variable name="stepNum"><xsl:value-of select="@url"/></xsl:variable>
	<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
	<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>
	<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>

	<div id="{$ID}" class="hotspotC"  Style="position:absolute; width:{$width}; height:{$height}">
		<a href="#"  onmouseover = "show('{$puID}'); status = ' '; return true;" onmouseout = "hide('{$puID}'); status = defaultStatus; return true" onclick="loader('{$stepNum}'); return false">
			<img src="{$baseDir}/tutorial/images/clear.gif" border="0" width="{$width}" height="{$height}"/>
		</a>
	</div>
</xsl:for-each>

<xsl:for-each select="HotSpot">
	<xsl:variable name="ID"><xsl:value-of select="@puId"/></xsl:variable>
	<xsl:variable name="title"><xsl:value-of select="Title"/></xsl:variable>
	<!--<xsl:variable name="text"><xsl:value-of select="Text"/></xsl:variable>-->

	<div id="{$ID}" class="popUpClass">
		<table width="220" border="0" cellspacing="0" cellpadding="1">
			<tr class="hdr" valign="top">
				<td class="hdr" width="2%">&#160;</td>
				<td colspan="2" class="hdr" width="96%">
					<b><xsl:value-of select="$title"/></b>
				</td>
				<td class="hdr" width="2%">&#160;</td>
			</tr>
		
			<xsl:for-each select="child::Text">
				<tr valign="top" height="2">
					<td width="2%"></td>
					<td colspan="2" width="96%"></td>
					<td width="2%"></td>
				</tr>
				<tr valign="top">
					<td width="2%">&#160;</td>
					<td width="95%">
						<xsl:choose>
							<xsl:when test="@url!=''">
								<xsl:variable name="parseURL2">
									<xsl:choose>
										<xsl:when test="@newWindow = 'true'">
											javascript:launchPage('<xsl:value-of select="@url"/>')
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@url"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								
								<a href="{$parseURL2}">
									<xsl:value-of select="."/>
								</a>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td width="2%">&#160;</td>
				</tr>
			</xsl:for-each>
		</table>
	</div>
</xsl:for-each>

<!-- 
the following divs are utilities. Delete when page is finished 
<script language="JavaScript" src="../../../base/tutorial/engine/devDrag.js"></script>

<div id="gen" class="locator">
	<form name="hotspot">
		<textarea name="spot" cols="100" rows="5" wrap="virtual"></textarea>
		<br/>Hotspot Builder. Press Ctl + C to copy.
	</form>
</div>
 
<div id="box" class="find">
</div>
-->


<!-- end utilities -->

<div id="temp"></div>
	<script type="text/javascript">document.getElementById("temp").innerHTML += getLocInfo();</script>

</body>
</html>
	
</xsl:template>
</xsl:stylesheet>