define(
{
    "toc":[
        {
            "heading":"Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface-header.html#Preface-015E90CC"
                }
            ]
        },
        {
            "heading":"1 What's New in This Release",
            "topics":[
                {
                    "title":"What's New in Oracle Web Services On Demand Guide, Release 45",
                    "href":"c-OnDemWebSvcs-WhatsNew.html#ondemwebsvcs_whatsnew"
                }
            ]
        },
        {
            "heading":"2 Overview of Web Services On Demand",
            "topics":[
                {
                    "title":"Overview of Web Services On Demand",
                    "href":"c-OnDemWebSvcs-OverviewSuppt.html#ondemwebsvcs_overviewsuppt"
                },
                {
                    "title":"About Web Services",
                    "href":"c-About-Web-Services-akv1006661.html#akv1006661",
                    "topics":[
                        {
                            "title":"Web Services Core Technologies",
                            "href":"c-Web-Services-Core-Technologies-akv1010365.html#akv1010365"
                        },
                        {
                            "title":"Oracle CRM On Demand Web Services Toolkit",
                            "href":"c-Oracle-CRM-On-Demand-Web-Services-Toolkit-akv1010378.html#akv1010378"
                        }
                    ]
                },
                {
                    "title":"Oracle CRM On Demand Web Services and Integration with Oracle CRM On Demand",
                    "href":"c-CRMOD-Web-Services-and-Integration-akv1044049.html#akv1044049",
                    "topics":[
                        {
                            "title":"Web Services Security",
                            "href":"c-Web-Services-Security-akv1015812.html#akv1015812"
                        },
                        {
                            "title":"Web Services Reliability",
                            "href":"c-Web-Services-Reliability-akv1049590.html#akv1049590"
                        }
                    ]
                },
                {
                    "title":"Web Services and the Oracle CRM On Demand Objects",
                    "href":"c-Web-Services-and-the-CRM-On-Demand-Objects-akv1020416.html#akv1020416",
                    "topics":[
                        {
                            "title":"Web Service APIs",
                            "href":"c-Web-Service-APIs-akv1050090.html#akv1050090"
                        },
                        {
                            "title":"About Parent-Child Relationships",
                            "href":"c-About-ParentChild-Relationships-akv1046072.html#akv1046072"
                        },
                        {
                            "title":"Web Services On Demand and Custom Fields",
                            "href":"c-Web-Services-On-Demand-and-Custom-Fields-akv1032960.html#akv1032960"
                        }
                    ]
                },
                {
                    "title":"Field Types Supported by Oracle CRM On Demand",
                    "href":"c-Field-Types-Supported-by-CRM-On-Demand-akv1032963.html#akv1032963",
                    "topics":[
                        {
                            "title":"Web Services v1.0",
                            "href":"c-Web-Services-v10-akv1047072.html#akv1047072"
                        },
                        {
                            "title":"Web Services v2.0",
                            "href":"c-Web-Services-v20-akv1046806.html#akv1046806"
                        },
                        {
                            "title":"Special Search Fields",
                            "href":"c-Special-Search-Fields-akv1066233.html#akv1066233"
                        },
                        {
                            "title":"Support for Multi-Select Picklists",
                            "href":"c-Support-for-MultiSelect-Picklists-akv1042565.html#akv1042565"
                        },
                        {
                            "title":"Locale-Dependent Access to Oracle CRM On Demand",
                            "href":"c-LocaleDependent-Access-to-CRM-On-Demand-akv1014942.html#akv1014942"
                        },
                        {
                            "title":"Validation of Email Fields",
                            "href":"c-Validation-of-Email-Fields-akv1044334.html#akv1044334"
                        },
                        {
                            "title":"Mapping Primary Address Fields Using Web Services",
                            "href":"c-Mapping-Primary-Address-Fields-Using-Web-Services-akv1069046.html#akv1069046"
                        },
                        {
                            "title":"Support for Web Link Fields",
                            "href":"c-Support-for-Web-Link-Fields-akv1066578.html#akv1066578"
                        },
                        {
                            "title":"Support for Concatenated Fields",
                            "href":"c-Support-for-Concatenated-Fields-akv1066576.html#akv1066576"
                        },
                        {
                            "title":"Support for Maskable Fields",
                            "href":"c-Support-for-Maskable-Fields-akv1068541.html#akv1068541"
                        }
                    ]
                },
                {
                    "title":"Web Services Utilization",
                    "href":"c-Web-Services-Utilization-akv1064660.html#akv1064660"
                },
                {
                    "title":"Web Service Client Name Identification",
                    "href":"c-Web-Service-Client-Name-Identification-akv1056225.html#akv1056225",
                    "topics":[
                        {
                            "title":"Supported Client Name Characters and Usage",
                            "href":"c-Supported-Client-Name-Characters-and-Usage-akv1057177.html#akv1057177"
                        },
                        {
                            "title":"Sending the Client Name in Stateless Web Services Requests",
                            "href":"c-Sending-the-Client-Name-in-Stateless-Web-Services-Requests-akv1056243.html#akv1056243"
                        },
                        {
                            "title":"Sending the Client Name in Stateful Web Services",
                            "href":"c-Sending-the-Client-Name-in-Stateful-Web-Services-akv1056697.html#akv1056697"
                        },
                        {
                            "title":"Web Services R16 Compatibility Mode",
                            "href":"c-Web-Services-R16-Compatibility-Mode-akv1056330.html#akv1056330"
                        }
                    ]
                },
                {
                    "title":"About Service Allotments",
                    "href":"c-About-Service-Allotments-akv1060851.html#akv1060851",
                    "topics":[
                        {
                            "title":"Determining Current Usage",
                            "href":"c-Determining-Current-Usage-akv1061392.html#akv1061392"
                        },
                        {
                            "title":"Determining Historical Allotment Usage",
                            "href":"c-Determining-Historical-Allotment-Usage-akv1061229.html#akv1061229"
                        },
                        {
                            "title":"When a Service Allotment Is Reached",
                            "href":"c-When-a-Service-Allotment-Is-Reached-akv1060869.html#akv1060869"
                        },
                        {
                            "title":"Calculation of Allotment Usage",
                            "href":"c-Calculation-of-Allotment-Usage-akv1061034.html#akv1061034"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"3 Getting Started with Web Services",
            "topics":[
                {
                    "title":"Getting Started with Web Services",
                    "href":"c-OnDemWebSvcs-GettingStarted.html#ondemwebsvcs_gettingstarted"
                },
                {
                    "title":"Accessing Data in Oracle CRM On Demand",
                    "href":"c-Accessing-Data-in-CRM-On-Demand-akx1015624.html#akx1015624"
                },
                {
                    "title":"Requesting Web Services Integration",
                    "href":"c-Requesting-Web-Services-Integration-akx1027135.html#akx1027135",
                    "topics":[
                        {
                            "title":"Web Services Privileges",
                            "href":"c-Web-Services-Privileges-akx1030087.html#akx1030087"
                        },
                        {
                            "title":"Enabling Stateless Web Services Support",
                            "href":"c-Enabling-Stateless-Web-Services-Support-akx1029057.html#akx1029057"
                        }
                    ]
                },
                {
                    "title":"Downloading WSDL Files and Schema Files",
                    "href":"c-Downloading-WSDL-Files-and-Schema-Files-akx1027146.html#akx1027146",
                    "topics":[
                        {
                            "title":"Downloading WSDL Files",
                            "href":"c-Downloading-WSDL-Files-akx1030091.html#akx1030091"
                        },
                        {
                            "title":"Downloading Schema Files",
                            "href":"c-Downloading-Schema-Files-akx1031458.html#akx1031458"
                        }
                    ]
                },
                {
                    "title":"Incorporating WSDL Files into the Development Environment",
                    "href":"c-Incorporating-WSDL-Files-into-the-Development-Environment-akx1027222.html#akx1027222"
                }
            ]
        },
        {
            "heading":"4 Establishing and Managing the Web Services Session",
            "topics":[
                {
                    "title":"Establishing and Managing the Web Services Session",
                    "href":"c-OnDemWebSvcs-EstablishSessions.html#ondemwebsvcs_establishsessions",
                    "topics":[
                        {
                            "title":"About Establishing and Managing the Web Services Session",
                            "href":"c-About-Establishing-and-Managing-the-Web-Services-Session-akw1027244.html#akw1027244",
                            "topics":[
                                {
                                    "title":"Oracle CRM On Demand Stateful and Stateless Request Support",
                                    "href":"c-CRM-On-Demand-Stateful-and-Stateless-Request-Support-akw1031377.html#akw1031377"
                                }
                            ]
                        },
                        {
                            "title":"Using Stateless Web Service Requests",
                            "href":"c-Using-Stateless-Web-Service-Requests-akw1029830.html#akw1029830",
                            "topics":[
                                {
                                    "title":"Enabling Support for Stateless Requests",
                                    "href":"c-Enabling-Support-for-Stateless-Requests-akw1031533.html#akw1031533"
                                },
                                {
                                    "title":"Oracle CRM On Demand Stateless Authentication Mechanisms",
                                    "href":"c-CRM-On-Demand-Stateless-Authentication-Mechanisms-akw1034105.html#akw1034105"
                                },
                                {
                                    "title":"Stateless Server Affinity Support",
                                    "href":"c-Stateless-Server-Affinity-Support-akw1034473.html#akw1034473"
                                },
                                {
                                    "title":"Maintenance of a Stateless Java Session",
                                    "href":"c-Maintenance-of-a-Stateless-Java-Session-akw1037078.html#akw1037078"
                                }
                            ]
                        },
                        {
                            "title":"Using Stateful Web Services Requests",
                            "href":"c-Using-Stateful-Web-Services-Requests-akw1031860.html#akw1031860",
                            "topics":[
                                {
                                    "title":"Oracle CRM On Demand Stateful Authentication Mechanisms",
                                    "href":"c-CRM-On-Demand-Stateful-Authentication-Mechanisms-akw1029392.html#akw1029392"
                                },
                                {
                                    "title":"Logout of the Web Services Session",
                                    "href":"c-Logout-of-the-Web-Services-Session-akw1036074.html#akw1036074"
                                }
                            ]
                        },
                        {
                            "title":"Integration Requests for the Web Services Session",
                            "href":"c-Integration-Requests-for-the-Web-Services-Session-akw1032119.html#akw1032119"
                        },
                        {
                            "title":"Comparison of Stateless Versus Stateful Web Services Transactions",
                            "href":"c-Comparison-of-Stateless-Versus-Stateful-Web-Services-Transactions-akw1031869.html#akw1031869"
                        },
                        {
                            "title":"Single Sign-On",
                            "href":"c-Single-SignOn-akw1034167.html#akw1034167",
                            "topics":[
                                {
                                    "title":"Outbound SSO",
                                    "href":"c-Outbound-SSO-akw1034221.html#akw1034221"
                                },
                                {
                                    "title":"SSO Token Validation",
                                    "href":"c-SSO-Token-Validation-akw1034275.html#akw1034275"
                                },
                                {
                                    "title":"Inbound SSO",
                                    "href":"c-Inbound-SSO-akw1034286.html#akw1034286"
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        {
            "heading":"5 Best Practices for Designing Client Application",
            "topics":[
                {
                    "title":"Best Practices for Designing Client Application",
                    "href":"c-OnDemWebSvcs-BestPractices.html#ondemwebsvcs_bestpractices"
                },
                {
                    "title":"Best Practices for Integration Design",
                    "href":"c-Best-Practices-for-Integration-Design-aky1031089.html#aky1031089",
                    "topics":[
                        {
                            "title":"Sending of Web Services Requests to Oracle CRM On Demand",
                            "href":"c-Sending-of-Web-Services-Requests-to-CRM-On-Demand-aky1031144.html#aky1031144"
                        },
                        {
                            "title":"Flushing of Caches",
                            "href":"c-Flushing-of-Caches-aky1031251.html#aky1031251"
                        },
                        {
                            "title":"Using Stateless Web Services",
                            "href":"c-Using-Stateless-Web-Services-aky1031109.html#aky1031109",
                            "topics":[
                                {
                                    "title":"Use Sort Criteria when Using QueryPage",
                                    "href":"Use-Sort-Criteria-When-Using-Query-Page.html#Use_Sort_Criteria_When_Using_Query_-2B81158E"
                                }
                            ]
                        },
                        {
                            "title":"Setting and Querying Blank Values",
                            "href":"c-Setting-and-Querying-Blank-Values-aky1031317.html#aky1031317"
                        },
                        {
                            "title":"Working with Opportunity Product Revenue Records",
                            "href":"c-Working-with-Opportunity-Product-Revenue-Records-aky1031195.html#aky1031195"
                        },
                        {
                            "title":"Error Handling and Logging",
                            "href":"c-Error-Handling-and-Logging-aky1031237.html#aky1031237"
                        },
                        {
                            "title":"Handling Outages and Failures",
                            "href":"c-Handling-Outages-and-Failures-aky1037248.html#aky1037248"
                        },
                        {
                            "title":"Understanding Web Services Transactions",
                            "href":"c-Understanding-Web-Services-Transactions-aky1038544.html#aky1038544"
                        },
                        {
                            "title":"Best Practices for Generating Web Services Proxy Classes in Java Environments",
                            "href":"c-Best-Practices-for-Generating-Web-Services-Proxy-Classes-in-Java-Environments-aky1032997.html#aky1032997"
                        },
                        {
                            "title":"Avoiding Proxy Class Compilation Failure Due to the Java 64KB Limit",
                            "href":"c-Avoiding-Proxy-Class-Compilation-Failure-Due-tothe-Java-64KB-Limit-aky1032556.html#aky1032556"
                        },
                        {
                            "title":"Entering Telephone Number Values through Web Services",
                            "href":"c-Entering-Telephone-Number-Values-through-Web-Services-aky1033823.html#aky1033823"
                        },
                        {
                            "title":"Best Practices for Adhering to Web Service Allotments",
                            "href":"c-Best-Practices-for-Adhering-to-Web-Service-Allotments-aky1035941.html#aky1035941"
                        },
                        {
                            "title":"Working with Record Ownership Modes",
                            "href":"c-Working-with-Record-Ownership-Modes-aky1037436.html#aky1037436"
                        },
                        {
                            "title":"Considerations when Rejecting Leads",
                            "href":"c-Considerations-when-Rejecting-Leads-aky1041073.html#aky1041073"
                        }
                    ]
                },
                {
                    "title":"Best Practices for Integration Performance",
                    "href":"c-Best-Practices-for-Integration-Performance-aky1033879.html#aky1033879",
                    "topics":[
                        {
                            "title":"Batch Processing",
                            "href":"c-Batch-Processing-aky1028211.html#aky1028211"
                        },
                        {
                            "title":"Session Management and Pooling",
                            "href":"c-Session-Management-and-Pooling-aky1028223.html#aky1028223"
                        },
                        {
                            "title":"API Calls",
                            "href":"c-API-Calls-aky1030655.html#aky1030655"
                        },
                        {
                            "title":"Handling Bad Events in Integration Event Queues",
                            "href":"c-Handling-Bad-Events-in-Integration-Event-Queues-aky1037138.html#aky1037138"
                        }
                    ]
                },
                {
                    "title":"Best Practices for Integration Management",
                    "href":"c-Best-Practices-for-Integration-Management-aky1031204.html#aky1031204",
                    "topics":[
                        {
                            "title":"Moving Customers Between Pods",
                            "href":"c-Moving-Customers-Between-Pods-aky1029280.html#aky1029280"
                        },
                        {
                            "title":"Handling Outages",
                            "href":"c-Handling-Outages-aky1028465.html#aky1028465"
                        },
                        {
                            "title":"Maintaining SSL Certificates",
                            "href":"c-Maintaining-SSL-Certificates-aky1032190.html#aky1032190"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"6 Web Services On Demand API Calls",
            "topics":[
                {
                    "title":"Web Services On Demand API Calls",
                    "href":"c-OnDemWebSvcs-SiebelAPICalls.html#ondemwebsvcs_siebelapicalls"
                },
                {
                    "title":"Web Services On Demand API Calls",
                    "href":"c-Web-Services-On-Demand-API-Calls-akt1093449.html#akt1093449",
                    "topics":[
                        {
                            "title":"Considerations When Deleting Child Records",
                            "href":"c-Considerations-When-Deleting-Child-Records-akt1190357.html#akt1190357"
                        }
                    ]
                },
                {
                    "title":"Web Services v1.0 API Calls",
                    "href":"c-Web-Services-v10-API-Calls-akt1017856.html#akt1017856",
                    "topics":[
                        {
                            "title":"User Keys",
                            "href":"c-User-Keys-akt1050450.html#akt1050450"
                        },
                        {
                            "title":"The Echo Argument",
                            "href":"c-The-Echo-Argument-akt1040966.html#akt1040966"
                        },
                        {
                            "title":"Delete",
                            "href":"c-Delete-akt1064832.html#akt1064832"
                        },
                        {
                            "title":"DeleteChild",
                            "href":"c-Delete-Child-akt1034134.html#akt1034134"
                        },
                        {
                            "title":"Insert",
                            "href":"c-Insert-akt1033866.html#akt1033866"
                        },
                        {
                            "title":"InsertChild",
                            "href":"c-Insert-Child-akt1034238.html#akt1034238"
                        },
                        {
                            "title":"InsertOrUpdate",
                            "href":"c-Insert-Or-Update-akt1035106.html#akt1035106"
                        },
                        {
                            "title":"QueryPage",
                            "href":"c-Query-Page--akt1020548.html#akt1020548"
                        },
                        {
                            "title":"Update",
                            "href":"c-Update--akt1052318.html#akt1052318"
                        },
                        {
                            "title":"UpdateChild",
                            "href":"c-Update-Child-akt1033380.html#akt1033380"
                        }
                    ]
                },
                {
                    "title":"Web Services v2.0 API Calls",
                    "href":"c-Web-Services-v20-API-Calls-akt1044879.html#akt1044879",
                    "topics":[
                        {
                            "title":"The Echo Argument",
                            "href":"c-The-Echo-Argument-akt1048237.html#akt1048237"
                        },
                        {
                            "title":"The ViewMode Argument",
                            "href":"c-The-View-Mode-Argument-akt1047437.html#akt1047437"
                        },
                        {
                            "title":"The LOVLanguageMode Argument",
                            "href":"c-The-LOVLanguage-Mode-Argument-akt1046293.html#akt1046293"
                        },
                        {
                            "title":"The Field-level Replace Operation",
                            "href":"c-The-Fieldlevel-Replace-Operation-akt1197365.html#akt1197365"
                        },
                        {
                            "title":"Delete",
                            "href":"c-Delete-akt1218025.html#akt1218025"
                        },
                        {
                            "title":"Execute",
                            "href":"c-Execute-akt1045455.html#akt1045455"
                        },
                        {
                            "title":"Insert",
                            "href":"c-Insert--akt1064823.html#akt1064823"
                        },
                        {
                            "title":"QueryPage",
                            "href":"c-Query-Page-akt1045223.html#akt1045223",
                            "topics":[
                                {
                                    "title":"Using the pagesize, startrownum, and recordcountneeded Arguments",
                                    "href":"Using-The-Pagesize,Startrownum,And-Record-countneeded-Arguments.html#Using_The_PagesizeStartrownumAnd_Re-2B77BF0F"
                                },
                                {
                                    "title":"Using Search Specifications",
                                    "href":"c-Using-Search-Specifications.html#c_Using_Search_Specifications-2CB772A9"
                                },
                                {
                                    "title":"Query Syntax",
                                    "href":"c-Query-Syntax.html#c_Query_Syntax-2CB81E32",
                                    "topics":[
                                        {
                                            "title":"Using Shadow Fields for Better Search Performance",
                                            "href":"Using-Shadow-FieldsForBetter-Search-Performance.html#Using_Shadow_FieldsForBetter_Search-2B6C5302"
                                        },
                                        {
                                            "title":"The EXISTS and NOT EXISTS Operators",
                                            "href":"The-EXISTS-And-NOT-EXISTS-Operators.html#The_EXISTS_And_NOT_EXISTS_Operators-2B80BDB8"
                                        }
                                    ]
                                },
                                {
                                    "title":"Specifying the Sort Order and Sort Sequence",
                                    "href":"Specifying-The-Sort-Order-And-Sort-Sequence.html#Specifying_The_Sort_Order_And_Sort_-2B815E18"
                                },
                                {
                                    "title":"Specifying Books in Queries",
                                    "href":"c-Specifying-Books-in-Queries.html#c_Specifying_Books_in_Queries-2CB923CE"
                                },
                                {
                                    "title":"Querying Lists",
                                    "href":"c-Querying-Lists.html#c_Querying_Lists-2CBC0EE5"
                                },
                                {
                                    "title":"Specifying Proximity Search Parameters",
                                    "href":"c-Specifying-Proximity-Search-Parameters.html#c_Specifying_Proximity_Search_Param-2CBC41C1"
                                },
                                {
                                    "title":"QueryPage Arguments",
                                    "href":"c-QueryPage-Arguments.html#c_QueryPage_Arguments-2CBC7236"
                                },
                                {
                                    "title":"QueryPage Return Value of the Call",
                                    "href":"c-QueryPage-Return-Value-Of-The-Call.html#c_QueryPage_Return_Value_Of_The_Cal-2CBCAA61"
                                },
                                {
                                    "title":"QueryPage Sample SOAP Requests",
                                    "href":"c-QueryPage-Sample-SOAP-Requests.html#c_QueryPage_Sample_SOAP_Requests-2CBCDB88"
                                }
                            ]
                        },
                        {
                            "title":"Update",
                            "href":"c-Update-akt1113695.html#akt1113695"
                        }
                    ]
                },
                {
                    "title":"Service API Calls",
                    "href":"c-Service-API-Calls-akt1015168.html#akt1015168",
                    "topics":[
                        {
                            "title":"AuditTrailQueryPage",
                            "href":"c-Audit-Trail-QueryPage-akt1211152.html#akt1211152"
                        },
                        {
                            "title":"AuthAuthorizationUser",
                            "href":"c-Auth-Authorization-User-akt1211025.html#akt1211025"
                        },
                        {
                            "title":"DeletedItemQueryPage",
                            "href":"c-Deleted-Item-QueryPage-akt1084212.html#akt1084212",
                            "topics":[
                                {
                                    "title":"Sample SOAP Request - DeletedItemQueryPage",
                                    "href":"Sample-SOAP-Request-Deleted-Item-Query-Page.html#Sample_SOAP_Request-Deleted_Item_Qu-2B7FF269"
                                }
                            ]
                        },
                        {
                            "title":"DeleteEvents",
                            "href":"c-Delete-Events-akt1101474.html#akt1101474"
                        },
                        {
                            "title":"ExportWebServiceCreateExportRequest",
                            "href":"c-Export-Web-ServiceCreateExportRequest-akt1150050.html#akt1150050"
                        },
                        {
                            "title":"ExportWebServiceMonitorExportRequest",
                            "href":"c-Export-Web-ServiceMonitorExportRequest-akt1150125.html#akt1150125"
                        },
                        {
                            "title":"ExportWebServiceRetrieveExportAttachment",
                            "href":"c-Export-Web-ServiceRetrieveExportAttachment-akt1150228.html#akt1150228"
                        },
                        {
                            "title":"GetEvents",
                            "href":"c-Get-Events-akt1110273.html#akt1110273",
                            "topics":[
                                {
                                    "title":"Preparing the Integration Event WSDL File and Schema Files",
                                    "href":"c-Preparing-The-Integration-Event-WSDL-File-And-Schema-Files.html#PreparingTheIntegrationEventWSDLFil-2B7FA621"
                                }
                            ]
                        },
                        {
                            "title":"GetLists",
                            "href":"c-Get-Lists-akt1085962.html#akt1085962"
                        },
                        {
                            "title":"GetMapping",
                            "href":"c-Get-Mapping-akt1038577.html#akt1038577"
                        },
                        {
                            "title":"GetPicklistValues",
                            "href":"c-Get-Picklist-Values-akt1034320.html#akt1034320"
                        },
                        {
                            "title":"GetServerTime",
                            "href":"c-Get-Server-Time-akt1035593.html#akt1035593"
                        },
                        {
                            "title":"HistoryDelete",
                            "href":"c-History-Delete-akt1317658.html#akt1317658"
                        },
                        {
                            "title":"HistoryInsertOrUpdate",
                            "href":"c-History-Insert-OrUpdate-akt1320746.html#akt1320746"
                        },
                        {
                            "title":"HistoryQueryPage",
                            "href":"c-History-Query-Page-akt1317583.html#akt1317583"
                        },
                        {
                            "title":"LeadConvert",
                            "href":"c-Lead-Convert-akt1316798.html#akt1316798"
                        },
                        {
                            "title":"LoginHistoryQueryPage",
                            "href":"c-Login-History-QueryPage-akt1041854.html#akt1041854"
                        },
                        {
                            "title":"MergeRecords",
                            "href":"c-Merge-Records-akt1046400.html#akt1046400"
                        },
                        {
                            "title":"MetadataChangeSummaryQueryPage",
                            "href":"c-Metadata-Change-SummaryQueryPage-akt1057819.html#akt1057819"
                        },
                        {
                            "title":"SetPassword",
                            "href":"c-Set-Password-akt1063154.html#akt1063154"
                        },
                        {
                            "title":"SetSessionTimeZone",
                            "href":"c-Set-Session-TimeZone-akt1110624.html#akt1110624"
                        },
                        {
                            "title":"UpdatePicklist",
                            "href":"c-Update-Picklist-akt1041299.html#akt1041299"
                        },
                        {
                            "title":"UpdateCascadingPicklists",
                            "href":"c-Update-Cascading-Picklists-akt1111689.html#akt1111689"
                        },
                        {
                            "title":"UserUsageQueryPage",
                            "href":"c-User-Usage-QueryPage-akt1041685.html#akt1041685"
                        }
                    ]
                },
                {
                    "title":"Administrative Services API Calls",
                    "href":"c-Administrative-Services-API-Calls-akt1053502.html#akt1053502",
                    "topics":[
                        {
                            "title":"Access to the Administrative Services APIs for Nonadministrative Users",
                            "href":"c-Access-to-the-Administrative-Services-APIs-for-Nonadministrative-Users-akt1086741.html#akt1086741"
                        },
                        {
                            "title":"Record Ownership Mode",
                            "href":"c-Record-Ownership-Mode-akt1183400.html#akt1183400"
                        },
                        {
                            "title":"AccessProfileRead",
                            "href":"c-Access-Profile-Read-akt1184628.html#akt1184628"
                        },
                        {
                            "title":"AccessProfileReadAll",
                            "href":"c-Access-Profile-ReadAll-akt1055527.html#akt1055527"
                        },
                        {
                            "title":"AccessProfileUpsert",
                            "href":"c-Access-Profile-Upsert-akt1055528.html#akt1055528"
                        },
                        {
                            "title":"ActionBarCustomWebAppletRead",
                            "href":"c-Action-Bar-CustomWebAppletRead-akt1144011.html#akt1144011"
                        },
                        {
                            "title":"ActionBarCustomWebAppletReadAll",
                            "href":"c-Action-Bar-CustomWebAppletReadAll-akt1133232.html#akt1133232"
                        },
                        {
                            "title":"ActionBarCustomWebAppletUpsert",
                            "href":"c-Action-Bar-CustomWebAppletUpsert-akt1133286.html#akt1133286"
                        },
                        {
                            "title":"ActionBarLayoutReadAll",
                            "href":"c-Action-Bar-LayoutReadAll-akt1126946.html#akt1126946"
                        },
                        {
                            "title":"ActionBarLayoutUpsert",
                            "href":"c-Action-Bar-LayoutUpsert-akt1228122.html#akt1228122"
                        },
                        {
                            "title":"AssignmentRuleRead",
                            "href":"c-Assignment-Rule-Read-akt1291602.html#akt1291602"
                        },
                        {
                            "title":"AssignmentRuleReadAll",
                            "href":"c-Assignment-Rule-ReadAll-akt1291466.html#akt1291466"
                        },
                        {
                            "title":"AssignmentRuleUpsert",
                            "href":"c-Assignment-Rule-Upsert-akt1291519.html#akt1291519"
                        },
                        {
                            "title":"AssignmentRuleGroupRead",
                            "href":"c-Assignment-Rule-GroupRead-akt1291773.html#akt1291773"
                        },
                        {
                            "title":"AssignmentRuleGroupReadAll",
                            "href":"c-Assignment-Rule-GroupReadAll-akt1291831.html#akt1291831"
                        },
                        {
                            "title":"AssignmentRuleGroupUpsert",
                            "href":"c-Assignment-Rule-GroupUpsert-akt1291884.html#akt1291884"
                        },
                        {
                            "title":"CascadingPicklistRead",
                            "href":"c-Cascading-Picklist-Read-akt1060105.html#akt1060105"
                        },
                        {
                            "title":"CascadingPicklistReadAll",
                            "href":"c-Cascading-Picklist-ReadAll-akt1060168.html#akt1060168"
                        },
                        {
                            "title":"CascadingPicklistUpsert",
                            "href":"c-Cascading-Picklist-Upsert-akt1291757.html#akt1291757"
                        },
                        {
                            "title":"ClientSideExtensionRead",
                            "href":"c-clientsideextensionread.html#c_clientsideextensionread"
                        },
                        {
                            "title":"ClientSideExtensionReadAll",
                            "href":"c-clientsideextensionreadall.html#clientsideextensionreadall"
                        },
                        {
                            "title":"ClientSideExtensionUpsert",
                            "href":"c-clientsideextensionupsert.html#c_clientsideextensionupsert"
                        },
                        {
                            "title":"ConcatenatedFieldRead",
                            "href":"c-Concatenated-Field-Read-akt1223013.html#akt1223013"
                        },
                        {
                            "title":"ConcatenatedFieldReadAll",
                            "href":"c-Concatenated-Field-ReadAll-akt1223076.html#akt1223076"
                        },
                        {
                            "title":"ConcatenatedFieldUpsert",
                            "href":"c-Concatenated-Field-Upsert-akt1223130.html#akt1223130"
                        },
                        {
                            "title":"CurrencyRead",
                            "href":"c-Currency-Read-akt1079240.html#akt1079240"
                        },
                        {
                            "title":"CurrencyReadAll",
                            "href":"c-Currency-Read-All-akt1079304.html#akt1079304"
                        },
                        {
                            "title":"CurrencyUpsert",
                            "href":"c-Currency-Upsert-akt1079358.html#akt1079358"
                        },
                        {
                            "title":"CurrentOrganizationRead",
                            "href":"c-Current-Organization-Read-akt1094008.html#akt1094008"
                        },
                        {
                            "title":"CustomHTMLHeadTagRead",
                            "href":"c-Custom-HTMLHead-TagRead-akt1269906.html#akt1269906"
                        },
                        {
                            "title":"CustomHTMLHeadTagUpsert",
                            "href":"c-Custom-HTMLHead-TagUpsert-akt1270130.html#akt1270130"
                        },
                        {
                            "title":"CustomRecordTypeRead",
                            "href":"c-Custom-Record-TypeRead-akt1270150.html#akt1270150"
                        },
                        {
                            "title":"CustomRecordTypeReadAll",
                            "href":"c-Custom-Record-TypeReadAll-akt1060500.html#akt1060500"
                        },
                        {
                            "title":"CustomRecordTypeUpsert",
                            "href":"c-Custom-Record-TypeUpsert-akt1060554.html#akt1060554"
                        },
                        {
                            "title":"CustomWebLinkRead",
                            "href":"c-Custom-Web-LinkRead-akt1074656.html#akt1074656"
                        },
                        {
                            "title":"CustomWebLinkReadAll",
                            "href":"c-Custom-Web-LinkReadAll-akt1070983.html#akt1070983"
                        },
                        {
                            "title":"CustomWebLinkUpsert",
                            "href":"c-Custom-Web-LinkUpsert-akt1071053.html#akt1071053"
                        },
                        {
                            "title":"CustomWebTabDelete",
                            "href":"c-Custom-Web-TabDelete-akt1062055.html#akt1062055"
                        },
                        {
                            "title":"CustomWebTabRead",
                            "href":"c-Custom-Web-TabRead-akt1060776.html#akt1060776"
                        },
                        {
                            "title":"CustomWebTabReadAll",
                            "href":"c-Custom-Web-TabReadAll-akt1060839.html#akt1060839"
                        },
                        {
                            "title":"CustomWebTabUpsert",
                            "href":"c-Custom-Web-TabUpsert-akt1060893.html#akt1060893"
                        },
                        {
                            "title":"DetailPageCustomWebAppletRead",
                            "href":"c-Detail-Page-CustomWebAppletRead-akt1152684.html#akt1152684"
                        },
                        {
                            "title":"DetailPageCustomWebAppletReadAll",
                            "href":"c-Detail-Page-CustomWebAppletReadAll-akt1152748.html#akt1152748"
                        },
                        {
                            "title":"DetailPageCustomWebAppletUpsert",
                            "href":"c-Detail-Page-CustomWebAppletUpsert-akt1152802.html#akt1152802"
                        },
                        {
                            "title":"DynamicLayoutRead",
                            "href":"c-Dynamic-Layout-Read-akt1243868.html#akt1243868"
                        },
                        {
                            "title":"DynamicLayoutReadAll",
                            "href":"c-Dynamic-Layout-ReadAll-akt1243934.html#akt1243934"
                        },
                        {
                            "title":"DynamicLayoutUpsert",
                            "href":"c-Dynamic-Layout-Upsert-akt1244027.html#akt1244027"
                        },
                        {
                            "title":"EnableModificationTrackingRead",
                            "href":"c-Enable-Modification-TrackingRead-akt1290344.html#akt1290344"
                        },
                        {
                            "title":"EnableModificationTrackingReadAll",
                            "href":"c-Enable-Modification-TrackingReadAll-akt1290407.html#akt1290407"
                        },
                        {
                            "title":"EnableModificationTrackingUpsert",
                            "href":"c-Enable-Modification-TrackingUpsert-akt1290459.html#akt1290459"
                        },
                        {
                            "title":"FieldAuditSetupRead",
                            "href":"c-Field-Audit-SetupRead-akt1282943.html#akt1282943"
                        },
                        {
                            "title":"FieldAuditSetupReadAll",
                            "href":"c-Field-Audit-SetupReadAll-akt1283004.html#akt1283004"
                        },
                        {
                            "title":"FieldAuditSetupUpsert",
                            "href":"c-Field-Audit-SetupUpsert-akt1283054.html#akt1283054"
                        },
                        {
                            "title":"FieldManagementCreate",
                            "href":"c-Field-Management-Create-akt1062147.html#akt1062147"
                        },
                        {
                            "title":"FieldManagementRead",
                            "href":"c-Field-Management-Read-akt1061787.html#akt1061787"
                        },
                        {
                            "title":"FieldManagementReadAll",
                            "href":"c-Field-Management-ReadAll-akt1061177.html#akt1061177"
                        },
                        {
                            "title":"FieldManagementUpsert",
                            "href":"c-Field-Management-Upsert-akt1061231.html#akt1061231"
                        },
                        {
                            "title":"HomepageLayoutReadAll",
                            "href":"c-Homepage-Layout-ReadAll-akt1070592.html#akt1070592"
                        },
                        {
                            "title":"HomepageLayoutUpsert",
                            "href":"c-Homepage-Layout-Upsert-akt1099858.html#akt1099858"
                        },
                        {
                            "title":"HomepageCustomWebAppletRead",
                            "href":"c-Homepage-Custom-WebAppletRead-akt1152311.html#akt1152311"
                        },
                        {
                            "title":"HomepageCustomWebAppletReadAll",
                            "href":"c-Homepage-Custom-WebAppletReadAll-akt1152375.html#akt1152375"
                        },
                        {
                            "title":"HomepageCustomWebAppletUpsert",
                            "href":"c-Homepage-Custom-WebAppletUpsert-akt1152429.html#akt1152429"
                        },
                        {
                            "title":"HomeTabCustomWebAppletRead",
                            "href":"c-Home-Tab-CustomWebAppletRead-akt1148017.html#akt1148017"
                        },
                        {
                            "title":"HomeTabCustomWebAppletReadAll",
                            "href":"c-Home-Tab-CustomWebAppletReadAll-akt1148078.html#akt1148078"
                        },
                        {
                            "title":"HomeTabCustomWebAppletUpsert",
                            "href":"c-Home-Tab-CustomWebAppletUpsert-akt1148131.html#akt1148131"
                        },
                        {
                            "title":"IndustryRead",
                            "href":"c-Industry-Read-akt1081677.html#akt1081677"
                        },
                        {
                            "title":"IndustryReadAll",
                            "href":"c-Industry-Read-All-akt1081741.html#akt1081741"
                        },
                        {
                            "title":"IntegrationEventQueueRead",
                            "href":"c-Integration-Event-QueueRead-akt1299676.html#akt1299676"
                        },
                        {
                            "title":"IntegrationEventQueueReadAll",
                            "href":"c-Integration-Event-QueueReadAll-akt1299739.html#akt1299739"
                        },
                        {
                            "title":"IntegrationEventQueueUpsert",
                            "href":"c-Integration-Event-QueueUpsert-akt1299791.html#akt1299791"
                        },
                        {
                            "title":"LeadConversionMappingRead",
                            "href":"c-leadconversionmappingread.html#c_leadconversionmappingread"
                        },
                        {
                            "title":"LeadConversionMappingReadAll",
                            "href":"c-leadconversionmappingreadall.html#c_leadconversionmappingreadall"
                        },
                        {
                            "title":"LeadConversionMappingUpsert",
                            "href":"c-leadconversionmappingupsert.html#c_leadconversionmappingupsert"
                        },
                        {
                            "title":"ListRead",
                            "href":"c-List-Read-akt1310703.html#akt1310703"
                        },
                        {
                            "title":"ListReadAll",
                            "href":"c-List-Read-All-akt1310766.html#akt1310766"
                        },
                        {
                            "title":"ListUpsert",
                            "href":"c-listupsert.html#c_listupsert"
                        },
                        {
                            "title":"ListAccessAndOrderRead",
                            "href":"c-List-Access-AndOrderRead-akt1290913.html#akt1290913"
                        },
                        {
                            "title":"ListAccessAndOrderReadAll",
                            "href":"c-List-Access-AndOrderReadAll-akt1290978.html#akt1290978"
                        },
                        {
                            "title":"ListAccessAndOrderUpsert",
                            "href":"c-List-Access-AndOrderUpsert-akt1291070.html#akt1291070"
                        },
                        {
                            "title":"PageLayoutFieldRead",
                            "href":"c-Page-Layout-FieldRead-akt1076014.html#akt1076014"
                        },
                        {
                            "title":"PageLayoutFieldReadAll",
                            "href":"c-Page-Layout-FieldReadAll-akt1071366.html#akt1071366"
                        },
                        {
                            "title":"PageLayoutFieldUpsert",
                            "href":"c-Page-Layout-FieldUpsert-akt1071436.html#akt1071436"
                        },
                        {
                            "title":"PageLayoutRelatedInformationRead",
                            "href":"c-Page-Layout-RelatedInformationRead-akt1081589.html#akt1081589"
                        },
                        {
                            "title":"PageLayoutRelatedInformationReadAll",
                            "href":"c-Page-Layout-RelatedInformationReadAll-akt1072606.html#akt1072606"
                        },
                        {
                            "title":"PageLayoutRelatedInformationUpsert",
                            "href":"c-Page-Layout-RelatedInformationUpsert-akt1072754.html#akt1072754"
                        },
                        {
                            "title":"PageLayoutSectionReadAll",
                            "href":"c-Page-Layout-SectionReadAll-akt1099983.html#akt1099983"
                        },
                        {
                            "title":"PageLayoutSectionUpsert",
                            "href":"c-Page-Layout-SectionUpsert-akt1099964.html#akt1099964"
                        },
                        {
                            "title":"PicklistRead",
                            "href":"c-Picklist-Read-akt1061791.html#akt1061791"
                        },
                        {
                            "title":"PicklistReadAll",
                            "href":"c-Picklist-Read-All-akt1061515.html#akt1061515"
                        },
                        {
                            "title":"PicklistUpsert",
                            "href":"c-Picklist-Upsert-akt1061569.html#akt1061569"
                        },
                        {
                            "title":"PicklistValueGroupRead",
                            "href":"c-Picklist-Value-GroupRead-akt1191751.html#akt1191751"
                        },
                        {
                            "title":"PicklistValueGroupReadAll",
                            "href":"c-Picklist-Value-GroupReadAll-akt1191816.html#akt1191816"
                        },
                        {
                            "title":"PicklistValueGroupUpsert",
                            "href":"c-Picklist-Value-GroupUpsert-akt1191880.html#akt1191880"
                        },
                        {
                            "title":"ProcessAdministrationRead",
                            "href":"c-Process-Administration-Read-akt1293587.html#akt1293587"
                        },
                        {
                            "title":"ProcessAdministrationReadAll",
                            "href":"c-Process-Administration-ReadAll-akt1293650.html#akt1293650"
                        },
                        {
                            "title":"ProcessAdministrationUpsert",
                            "href":"c-Process-Administration-Upsert-akt1294421.html#akt1294421"
                        },
                        {
                            "title":"ProcessAdministrationTransitionStateRead",
                            "href":"c-processadministrationtransitionstateread.html#c_processadministrationtransitionstateread"
                        },
                        {
                            "title":"ProcessAdministrationTransitionStateReadAll",
                            "href":"c-processadministrationtransitionstatereadall.html#c_processadministrationtransitionstatereadall"
                        },
                        {
                            "title":"ProcessAdministrationTransitionStateUpsert",
                            "href":"c-processadministrationstateupsert.html#c_processadministrationstateupsert"
                        },
                        {
                            "title":"ProcessAdministrationTransitionStateDelete",
                            "href":"c-processadministrationstatedelete.html#c_processadministrationstatedelete"
                        },
                        {
                            "title":"RelatedInformationLayoutRead",
                            "href":"c-Related-Information-LayoutRead-akt1122643.html#akt1122643"
                        },
                        {
                            "title":"RelatedInformationLayoutReadAll",
                            "href":"c-Related-Information-LayoutReadAll-akt1122710.html#akt1122710"
                        },
                        {
                            "title":"RelatedInformationLayoutUpsert",
                            "href":"c-Related-Information-LayoutUpsert-akt1122785.html#akt1122785"
                        },
                        {
                            "title":"ReportFolderRead",
                            "href":"c-Report-Folder-Read-akt1289144.html#akt1289144"
                        },
                        {
                            "title":"ReportFolderReadAll",
                            "href":"c-Report-Folder-ReadAll-akt1289207.html#akt1289207"
                        },
                        {
                            "title":"ReportFolderUpsert",
                            "href":"c-Report-Folder-Upsert-akt1289259.html#akt1289259"
                        },
                        {
                            "title":"RoleRead",
                            "href":"c-Role-Read-akt1078080.html#akt1078080"
                        },
                        {
                            "title":"RoleReadAll",
                            "href":"c-Role-Read-All-akt1068507.html#akt1068507"
                        },
                        {
                            "title":"RoleUpsert",
                            "href":"c-Role-Upsert-akt1068561.html#akt1068561"
                        },
                        {
                            "title":"SalesAssessmentTemplateRead",
                            "href":"c-Sales-Assessment-TemplateRead-akt1090701.html#akt1090701"
                        },
                        {
                            "title":"SalesAssessmentTemplateReadAll",
                            "href":"c-Sales-Assessment-TemplateReadAll-akt1090766.html#akt1090766"
                        },
                        {
                            "title":"SalesAssessmentTemplateUpsert",
                            "href":"c-Sales-Assessment-TemplateUpsert-akt1171629.html#akt1171629"
                        },
                        {
                            "title":"SalesCategoryRead",
                            "href":"c-Sales-Category-Read-akt1277052.html#akt1277052"
                        },
                        {
                            "title":"SalesCategoryReadAll",
                            "href":"c-Sales-Category-ReadAll-akt1277116.html#akt1277116"
                        },
                        {
                            "title":"SalesCategoryUpsert",
                            "href":"c-Sales-Category-Upsert-akt1277574.html#akt1277574"
                        },
                        {
                            "title":"SalesProcessQueryPage",
                            "href":"c-salesprocessread.html#c_salesprocessread"
                        },
                        {
                            "title":"SalesProcessInsertOrUpdate",
                            "href":"c-salesprocessinsertorupdate.html#c_salesprocessinsertorupdate"
                        },
                        {
                            "title":"SalesStageQueryPage",
                            "href":"c-salesstagequerypage.html#c_salesstagequerypage"
                        },
                        {
                            "title":"SalesStageInsertOrUpdate",
                            "href":"c-salesstageinsertorupdate.html#c_salesstageinsertorupdate"
                        },
                        {
                            "title":"SearchLayoutRead",
                            "href":"c-Search-Layout-Read-akt1289842.html#akt1289842"
                        },
                        {
                            "title":"SearchLayoutReadAll",
                            "href":"c-Search-Layout-ReadAll-akt1289905.html#akt1289905"
                        },
                        {
                            "title":"SearchLayoutUpsert",
                            "href":"c-Search-Layout-Upsert-akt1289958.html#akt1289958"
                        },
                        {
                            "title":"SSOTokenRead",
                            "href":"c-SSOToken-Read-akt1277570.html#akt1277570"
                        },
                        {
                            "title":"WorkflowActionSetRead",
                            "href":"c-Workflow-Action-SetRead-akt1112447.html#akt1112447"
                        },
                        {
                            "title":"WorkflowActionSetReadForRuleSet",
                            "href":"c-Workflow-Action-SetReadForRuleSet-akt1122499.html#akt1122499"
                        },
                        {
                            "title":"WorkflowActionSetUpsert",
                            "href":"c-Workflow-Action-SetUpsert-akt1122241.html#akt1122241"
                        },
                        {
                            "title":"WorkflowActionSetInsertOrUpdate",
                            "href":"c-Workflow-Action-SetInsertOrUpdate-akt1269630.html#akt1269630"
                        },
                        {
                            "title":"WorkflowRuleSetDelete",
                            "href":"c-Workflow-Rule-SetDelete-akt1109375.html#akt1109375"
                        },
                        {
                            "title":"WorkflowRuleSetRead",
                            "href":"c-Workflow-Rule-SetRead-akt1109868.html#akt1109868"
                        },
                        {
                            "title":"WorkflowRuleSetReadAll",
                            "href":"c-Workflow-Rule-SetReadAll-akt1109439.html#akt1109439"
                        },
                        {
                            "title":"WorkflowRuleSetUpsert",
                            "href":"c-Workflow-Rule-SetUpsert-akt1109659.html#akt1109659"
                        },
                        {
                            "title":"WorkflowRuleSetInsertOrUpdate",
                            "href":"c-Workflow-Rule-SetInsertOrUpdate-akt1249955.html#akt1249955"
                        },
                        {
                            "title":"WorkflowUserSetInsertOrUpdate",
                            "href":"c-Workflow-User-SetInsertOrUpdate-akt1322252.html#akt1322252"
                        },
                        {
                            "title":"WorkflowUserSetReadForRuleSet",
                            "href":"c-Workflow-User-SetReadForRuleSet-akt1322468.html#akt1322468"
                        },
                        {
                            "title":"WorkflowUserSetDelete",
                            "href":"c-Workflow-User-SetDelete-akt1322909.html#akt1322909"
                        }
                    ]
                },
                {
                    "title":"Data Loader API Calls",
                    "href":"c-Data-Loader-API-Calls-akt1055058.html#akt1055058",
                    "topics":[
                        {
                            "title":"BulkOpImportCreateRequest",
                            "href":"c-Bulk-Op-ImportCreateRequest-akt1053778.html#akt1053778"
                        },
                        {
                            "title":"BulkOpImportSendData",
                            "href":"c-Bulk-Op-ImportSendData-akt1053592.html#akt1053592"
                        },
                        {
                            "title":"BulkOpImportGetRequestDetail",
                            "href":"c-Bulk-Op-ImportGetRequestDetail-akt1054624.html#akt1054624"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"7 Oracle CRM On Demand Objects Accessible Through Web Services",
            "topics":[
                {
                    "title":"Oracle CRM On Demand Objects Accessible Through Web Services",
                    "href":"c-OnDemWebSvcs-WebSvcsDetail.html#ondemwebsvcs_websvcsdetail"
                },
                {
                    "title":"Reference Information About the Parent Objects",
                    "href":"c-Reference-Information-About-the-Parent-Objects-aku1695517.html#aku1695517",
                    "topics":[
                        {
                            "title":"Field Names in WSDL Files",
                            "href":"c-Field-Names-in-WSDL-Files-aku2165086.html#aku2165086"
                        },
                        {
                            "title":"Required and Read-Only Fields",
                            "href":"c-Required-and-ReadOnly-Fields-aku2430273.html#aku2430273"
                        },
                        {
                            "title":"Oracle CRM On Demand User Keys",
                            "href":"c-CRM-On-Demand-User-Keys-aku2165080.html#aku2165080"
                        },
                        {
                            "title":"Audit Fields",
                            "href":"c-Audit-Fields-aku1252063.html#aku1252063"
                        },
                        {
                            "title":"Oracle CRM On Demand Status Keys",
                            "href":"c-CRM-On-Demand-Status-Keys-aku1255543.html#aku1255543"
                        },
                        {
                            "title":"Oracle CRM On Demand Pick Maps",
                            "href":"c-CRM-On-Demand-Pick-Maps-aku1255553.html#aku1255553"
                        },
                        {
                            "title":"Filterable Fields",
                            "href":"c-Filterable-Fields-aku1255540.html#aku1255540"
                        }
                    ]
                },
                {
                    "title":"Core Parent Objects (Web Services v1.0)",
                    "href":"c-Core-Parent-Objects-Web-Services-v10-aku1255374.html#aku1255374",
                    "topics":[
                        {
                            "title":"Account",
                            "href":"c-Account-aku1283188.html#aku1283188"
                        },
                        {
                            "title":"Activity",
                            "href":"c-Activity-aku1171496.html#aku1171496"
                        },
                        {
                            "title":"Asset",
                            "href":"c-Asset-aku1248939.html#aku1248939"
                        },
                        {
                            "title":"Book",
                            "href":"c-Book-aku1287808.html#aku1287808"
                        },
                        {
                            "title":"Campaign",
                            "href":"c-Campaign-aku1171493.html#aku1171493"
                        },
                        {
                            "title":"Contact",
                            "href":"c-Contact-aku1288500.html#aku1288500"
                        },
                        {
                            "title":"Current User",
                            "href":"c-Current-User-aku1089698.html#aku1089698"
                        },
                        {
                            "title":"CustomObject1 - CustomObject3",
                            "href":"c-Custom-Object1--Custom-Object3-aku1238276.html#aku1238276"
                        },
                        {
                            "title":"Lead",
                            "href":"c-Lead-aku1078123.html#aku1078123"
                        },
                        {
                            "title":"Note",
                            "href":"c-Note-aku1273087.html#aku1273087"
                        },
                        {
                            "title":"Opportunity",
                            "href":"c-Opportunity--aku1258024.html#aku1258024"
                        },
                        {
                            "title":"Product",
                            "href":"c-Product-aku1728222.html#aku1728222"
                        },
                        {
                            "title":"Product Category",
                            "href":"c-Product-Category-aku1089336.html#aku1089336"
                        },
                        {
                            "title":"Service Request",
                            "href":"c-Service-Request-aku1078310.html#aku1078310"
                        },
                        {
                            "title":"Solution",
                            "href":"c-Solution-aku1078408.html#aku1078408"
                        },
                        {
                            "title":"Territory",
                            "href":"c-Territory-aku1177925.html#aku1177925"
                        },
                        {
                            "title":"User",
                            "href":"c-User-aku1089667.html#aku1089667"
                        },
                        {
                            "title":"User Group",
                            "href":"c-User-Group-aku1178522.html#aku1178522"
                        }
                    ]
                },
                {
                    "title":"Life Sciences Edition Parent Objects (Web Services v1.0)",
                    "href":"c-Life-Sciences-Edition-Parent-Objects-Web-Servicesv10-aku1725945.html#aku1725945",
                    "topics":[
                        {
                            "title":"Event",
                            "href":"c-Event-aku1726046.html#aku1726046"
                        }
                    ]
                },
                {
                    "title":"Financial Services Edition Parent Objects (Web Services v1.0)",
                    "href":"c-Financial-Services-Edition-Parent-Objects-Web-Services-v10-aku1725868.html#aku1725868",
                    "topics":[
                        {
                            "title":"Household",
                            "href":"c-Household-aku1726483.html#aku1726483"
                        },
                        {
                            "title":"Portfolio",
                            "href":"c-Portfolio-aku1727214.html#aku1727214"
                        }
                    ]
                },
                {
                    "title":"Automotive Edition Parent Objects (Web Services v1.0)",
                    "href":"c-Automotive-Edition-Parent-Objects-Web-Servicesv10-aku1726013.html#aku1726013",
                    "topics":[
                        {
                            "title":"Dealer",
                            "href":"c-Dealer-aku1729007.html#aku1729007"
                        },
                        {
                            "title":"Vehicle",
                            "href":"c-Vehicle-aku1728575.html#aku1728575"
                        }
                    ]
                },
                {
                    "title":"Child Objects (Web Services v1.0)",
                    "href":"c-Child-Objects-Web-Services-v10-aku1083118.html#aku1083118",
                    "topics":[
                        {
                            "title":"Address",
                            "href":"c-Address-aku1121787.html#aku1121787"
                        },
                        {
                            "title":"Attachment",
                            "href":"c-Attachment-aku1293899.html#aku1293899"
                        },
                        {
                            "title":"Audit Trail",
                            "href":"c-Audit-Trail-aku1273687.html#aku1273687"
                        },
                        {
                            "title":"BookUser",
                            "href":"c-Book-User-aku1290891.html#aku1290891"
                        },
                        {
                            "title":"Competitor",
                            "href":"c-Competitor-aku1122674.html#aku1122674"
                        },
                        {
                            "title":"DelegatedUser",
                            "href":"c-Delegated-User-aku1562493.html#aku1562493"
                        },
                        {
                            "title":"HouseholdTeam",
                            "href":"c-Household-Team-aku1259514.html#aku1259514"
                        },
                        {
                            "title":"Interests",
                            "href":"c-Interests-aku1259461.html#aku1259461"
                        },
                        {
                            "title":"Invitee",
                            "href":"c-Invitee-aku1259756.html#aku1259756"
                        },
                        {
                            "title":"Login History",
                            "href":"c-Login-History-aku1186021.html#aku1186021"
                        },
                        {
                            "title":"Multiple Contact Roles",
                            "href":"c-Multiple-Contact-Roles-aku1197130.html#aku1197130"
                        },
                        {
                            "title":"OpportunityTeam",
                            "href":"c-Opportunity-Team-aku1259490.html#aku1259490"
                        },
                        {
                            "title":"PortfolioTeam",
                            "href":"c-Portfolio-Team-aku1259192.html#aku1259192"
                        },
                        {
                            "title":"ProductsDetailed",
                            "href":"c-Products-Detailed-aku1259779.html#aku1259779"
                        },
                        {
                            "title":"PromotionalItemsDropped",
                            "href":"c-Promotional-Items-Dropped-aku1908005.html#aku1908005"
                        },
                        {
                            "title":"Quota",
                            "href":"c-Quota-aku1259776.html#aku1259776"
                        },
                        {
                            "title":"Recipient",
                            "href":"c-Recipient-aku1252298.html#aku1252298"
                        },
                        {
                            "title":"Related Account",
                            "href":"c-Related-Account-aku1185933.html#aku1185933"
                        },
                        {
                            "title":"Related Contact",
                            "href":"c-Related-Contact-aku1185895.html#aku1185895"
                        },
                        {
                            "title":"Revenue",
                            "href":"c-Revenue-aku1245202.html#aku1245202"
                        },
                        {
                            "title":"SampleDropped",
                            "href":"c-Sample-Dropped-aku1260008.html#aku1260008"
                        },
                        {
                            "title":"Shared Address",
                            "href":"c-Shared-Address-aku1909444.html#aku1909444"
                        },
                        {
                            "title":"SubBook",
                            "href":"c-Sub-Book-aku1140603.html#aku1140603"
                        },
                        {
                            "title":"Team",
                            "href":"c-Team-aku1290879.html#aku1290879"
                        }
                    ]
                },
                {
                    "title":"Core Parent Objects (Web Services v2.0)",
                    "href":"c-Core-Parent-Objects-Web-Services-v20-aku1326053.html#aku1326053",
                    "topics":[
                        {
                            "title":"Account",
                            "href":"c-Account-aku1335297.html#aku1335297",
                            "topics":[
                                {
                                    "title":"Adding and Updating Account Addresses",
                                    "href":"Adding-And-Updating-Account-Addresses.html#Adding_And_Updating_Account_Address-2C02A37C"
                                }
                            ]
                        },
                        {
                            "title":"Account Event",
                            "href":"c-account-event-parent.html#c_account_event"
                        },
                        {
                            "title":"Activity",
                            "href":"c-Activity-aku1335621.html#aku1335621"
                        },
                        {
                            "title":"Address",
                            "href":"c-Address-aku1790203.html#aku1790203",
                            "topics":[
                                {
                                    "title":"Converting Unshared Addresses to Shared Addresses",
                                    "href":"Converting-Unshared-Addresses-To-Shared-Addresses.html#Converting_Unshared_Addresses_To_Sh-2B86BCD2"
                                }
                            ]
                        },
                        {
                            "title":"Address Location",
                            "href":"c-Address-Location-aku2047278.html#aku2047278"
                        },
                        {
                            "title":"Allotment Usage",
                            "href":"c-Allotment-Usage-aku2047267.html#aku2047267"
                        },
                        {
                            "title":"Asset",
                            "href":"c-Asset-aku1729801.html#aku1729801"
                        },
                        {
                            "title":"Book",
                            "href":"c-Book-aku1340438.html#aku1340438"
                        },
                        {
                            "title":"Campaign",
                            "href":"c-Campaign--aku1340837.html#aku1340837"
                        },
                        {
                            "title":"Category",
                            "href":"c-Category-aku1366236.html#aku1366236"
                        },
                        {
                            "title":"Contact",
                            "href":"c-Contact--aku2031429.html#aku2031429",
                            "topics":[
                                {
                                    "title":"Adding and Updating Contact Addresses",
                                    "href":"c-Adding-And-Updating-Contact-Addresses.html#c_Adding_And_Updating_Contact_Addre-2CC28EA8"
                                }
                            ]
                        },
                        {
                            "title":"CustomObject",
                            "href":"c-Custom-Object-aku1339038.html#aku1339038"
                        },
                        {
                            "title":"Division",
                            "href":"c-Division-aku2166118.html#aku2166118"
                        },
                        {
                            "title":"Exchange Rate",
                            "href":"c-Exchange-Rate-aku2166111.html#aku2166111"
                        },
                        {
                            "title":"Group",
                            "href":"c-Group-aku1724513.html#aku1724513"
                        },
                        {
                            "title":"Lead",
                            "href":"c-Lead--aku1350627.html#aku1350627"
                        },
                        {
                            "title":"Lead Event",
                            "href":"c-lead-event-parent.html#c_lead_event_parent"
                        },
                        {
                            "title":"Modification Tracking",
                            "href":"c-Modification-Tracking-aku2165726.html#aku2165726"
                        },
                        {
                            "title":"Note",
                            "href":"c-Note-aku2165723.html#aku2165723"
                        },
                        {
                            "title":"Opportunity",
                            "href":"c-Opportunity-aku1502398.html#aku1502398"
                        },
                        {
                            "title":"Opportunity Event",
                            "href":"c-opportunity-event-parent.html#c_opportunity_event_parent"
                        },
                        {
                            "title":"Period",
                            "href":"c-Period-aku2432215.html#aku2432215"
                        },
                        {
                            "title":"Product",
                            "href":"c-Product-aku2431862.html#aku2431862"
                        },
                        {
                            "title":"Service Allotment",
                            "href":"c-Service-Allotment-aku1729555.html#aku1729555"
                        },
                        {
                            "title":"Service Request",
                            "href":"c-Service-Request-aku1729549.html#aku1729549"
                        },
                        {
                            "title":"Social Media",
                            "href":"c-Social-Media-aku2033717.html#aku2033717"
                        },
                        {
                            "title":"Social Profile",
                            "href":"c-Social-Profile-aku2033952.html#aku2033952"
                        },
                        {
                            "title":"Solution",
                            "href":"c-Solution-aku1994316.html#aku1994316"
                        },
                        {
                            "title":"Territory",
                            "href":"c-Territory--aku1367272.html#aku1367272"
                        },
                        {
                            "title":"User",
                            "href":"c-User--aku1367462.html#aku1367462"
                        }
                    ]
                },
                {
                    "title":"Partner Relationship Management Edition Objects (Web Services v2.0)",
                    "href":"c-Partner-Relationship-Management-Edition-ObjectsWeb-Services-v20-aku1499574.html#aku1499574",
                    "topics":[
                        {
                            "title":"Accreditation",
                            "href":"c-Accreditation-aku1690408.html#aku1690408"
                        },
                        {
                            "title":"Accreditation Request",
                            "href":"c-Accreditation-Request-aku1690919.html#aku1690919"
                        },
                        {
                            "title":"Application",
                            "href":"c-Application-aku1690886.html#aku1690886"
                        },
                        {
                            "title":"Certification",
                            "href":"c-Certification-aku1691378.html#aku1691378"
                        },
                        {
                            "title":"Certification Request",
                            "href":"c-Certification-Request-aku1691569.html#aku1691569"
                        },
                        {
                            "title":"Course",
                            "href":"c-Course-aku1692091.html#aku1692091"
                        },
                        {
                            "title":"Course Enrollment",
                            "href":"c-Course-Enrollment-aku1692282.html#aku1692282"
                        },
                        {
                            "title":"Deal Registration",
                            "href":"c-Deal-Registration-aku1691371.html#aku1691371"
                        },
                        {
                            "title":"Exam",
                            "href":"c-Exam-aku1693018.html#aku1693018"
                        },
                        {
                            "title":"Exam Registration",
                            "href":"c-Exam-Registration-aku1693225.html#aku1693225"
                        },
                        {
                            "title":"Fund",
                            "href":"c-Fund-aku1693010.html#aku1693010"
                        },
                        {
                            "title":"MDF Request",
                            "href":"c-MDF-Request-aku1532493.html#aku1532493"
                        },
                        {
                            "title":"Partner",
                            "href":"c-Partner-aku1519904.html#aku1519904"
                        },
                        {
                            "title":"Price List",
                            "href":"c-Price-List-aku1545760.html#aku1545760"
                        },
                        {
                            "title":"Price List Line Item",
                            "href":"c-Price-List-Line-Item-aku1547332.html#aku1547332"
                        },
                        {
                            "title":"Special Pricing Product",
                            "href":"c-Special-Pricing-Product-aku1548091.html#aku1548091"
                        },
                        {
                            "title":"Special Pricing Request",
                            "href":"c-Special-Pricing-Request-aku1908390.html#aku1908390"
                        }
                    ]
                },
                {
                    "title":"Life Sciences Edition Parent Objects (Web Services v2.0)",
                    "href":"c-Life-Sciences-Edition-Parent-Objects-Web-Servicesv20-aku1575470.html#aku1575470",
                    "topics":[
                        {
                            "title":"Allocation",
                            "href":"c-Allocation-aku1596087.html#aku1596087"
                        },
                        {
                            "title":"Blocked Product",
                            "href":"c-Blocked-Product-aku1944215.html#aku1944215"
                        },
                        {
                            "title":"Business Plan",
                            "href":"c-Business-Plan-aku1944211.html#aku1944211"
                        },
                        {
                            "title":"Call Activity History",
                            "href":"c-Call-Activity-History-aku1993966.html#aku1993966"
                        },
                        {
                            "title":"Call Product Detail",
                            "href":"c-Call-Product-Detail-aku2152397.html#aku2152397"
                        },
                        {
                            "title":"Contact Best Times",
                            "href":"c-Contact-Best-Times-aku2114229.html#aku2114229"
                        },
                        {
                            "title":"Contact State License",
                            "href":"c-Contact-State-License-aku2130428.html#aku2130428"
                        },
                        {
                            "title":"Event",
                            "href":"c-Event-aku2165020.html#aku2165020"
                        },
                        {
                            "title":"HCP Contact Allocation",
                            "href":"c-HCP-Contact-Allocation-aku2164717.html#aku2164717"
                        },
                        {
                            "title":"Inventory Audit Report",
                            "href":"c-Inventory-Audit-Report-aku1504090.html#aku1504090"
                        },
                        {
                            "title":"Inventory Period",
                            "href":"c-Inventory-Period-aku1504897.html#aku1504897"
                        },
                        {
                            "title":"Message Response",
                            "href":"c-Message-Response-aku1506296.html#aku1506296"
                        },
                        {
                            "title":"Messaging Plan",
                            "href":"c-Messaging-Plan-aku1505609.html#aku1505609"
                        },
                        {
                            "title":"Messaging Plan Item",
                            "href":"c-Messaging-Plan-Item-aku1546171.html#aku1546171"
                        },
                        {
                            "title":"Messaging Plan Item Relation",
                            "href":"c-Messaging-Plan-Item-Relation-aku1546953.html#aku1546953"
                        },
                        {
                            "title":"Objective",
                            "href":"c-Objective-aku1562615.html#aku1562615"
                        },
                        {
                            "title":"Order",
                            "href":"c-Order-aku1803383.html#aku1803383"
                        },
                        {
                            "title":"Order Item",
                            "href":"c-Order-Item-aku1803855.html#aku1803855"
                        },
                        {
                            "title":"Plan Account",
                            "href":"c-Plan-Account-aku1837756.html#aku1837756"
                        },
                        {
                            "title":"Plan Contact",
                            "href":"c-Plan-Contact-aku1502601.html#aku1502601"
                        },
                        {
                            "title":"Plan Opportunity",
                            "href":"c-Plan-Opportunity-aku1502793.html#aku1502793"
                        },
                        {
                            "title":"Product Indication",
                            "href":"c-Product-Indication-aku2046402.html#aku2046402"
                        },
                        {
                            "title":"Related Disclaimer",
                            "href":"c-Related-Disclaimer-aku2046398.html#aku2046398"
                        },
                        {
                            "title":"Sample Disclaimer",
                            "href":"c-Sample-Disclaimer-aku1910071.html#aku1910071"
                        },
                        {
                            "title":"Sample Inventory",
                            "href":"c-Sample-Inventory-aku1545779.html#aku1545779"
                        },
                        {
                            "title":"Sample Lot",
                            "href":"c-Sample-Lot-aku1505183.html#aku1505183"
                        },
                        {
                            "title":"Sample Request",
                            "href":"c-Sample-Request-aku1905824.html#aku1905824"
                        },
                        {
                            "title":"Sample Request Item",
                            "href":"c-Sample-Request-Item-aku1906003.html#aku1906003"
                        },
                        {
                            "title":"Sample Transaction",
                            "href":"c-Sample-Transaction-aku1905815.html#aku1905815"
                        },
                        {
                            "title":"Signature",
                            "href":"c-Signature-aku1577029.html#aku1577029"
                        },
                        {
                            "title":"Transaction Item",
                            "href":"c-Transaction-Item-aku1576663.html#aku1576663"
                        }
                    ]
                },
                {
                    "title":"Financial Services Edition Parent Objects (Web Services v2.0)",
                    "href":"c-Financial-Services-Edition-Parent-Objects-Web-Services-v20-aku1499581.html#aku1499581",
                    "topics":[
                        {
                            "title":"Claim",
                            "href":"c-Claim-aku1521010.html#aku1521010"
                        },
                        {
                            "title":"Coverage",
                            "href":"c-Coverage-aku1521242.html#aku1521242"
                        },
                        {
                            "title":"Damage",
                            "href":"c-Damage-aku1576199.html#aku1576199"
                        },
                        {
                            "title":"Financial Account",
                            "href":"c-Financial-Account-aku1521945.html#aku1521945"
                        },
                        {
                            "title":"Financial Account Holder",
                            "href":"c-Financial-Account-Holder-aku1522170.html#aku1522170"
                        },
                        {
                            "title":"Financial Account Holding",
                            "href":"c-Financial-Account-Holding-aku1522393.html#aku1522393"
                        },
                        {
                            "title":"Financial Plan",
                            "href":"c-Financial-Plan-aku1522602.html#aku1522602"
                        },
                        {
                            "title":"Financial Product",
                            "href":"c-Financial-Product-aku1522827.html#aku1522827"
                        },
                        {
                            "title":"Financial Transaction",
                            "href":"c-Financial-Transaction-aku1523048.html#aku1523048"
                        },
                        {
                            "title":"Household",
                            "href":"c-Household-aku1523437.html#aku1523437"
                        },
                        {
                            "title":"Insurance Property",
                            "href":"c-Insurance-Property-aku1523713.html#aku1523713"
                        },
                        {
                            "title":"Involved Party",
                            "href":"c-Involved-Party-aku1523909.html#aku1523909"
                        },
                        {
                            "title":"Policy",
                            "href":"c-Policy-aku1527940.html#aku1527940"
                        },
                        {
                            "title":"Policy Holder",
                            "href":"c-Policy-Holder-aku1528150.html#aku1528150"
                        },
                        {
                            "title":"Portfolio",
                            "href":"c-Portfolio-aku1528352.html#aku1528352"
                        }
                    ]
                },
                {
                    "title":"Automotive Edition Parent Objects (Web Services v2.0)",
                    "href":"c-Automotive-Edition-Parent-Objects-Web-Servicesv20-aku1499575.html#aku1499575",
                    "topics":[
                        {
                            "title":"Dealer",
                            "href":"c-Dealer-aku2454032.html#aku2454032"
                        },
                        {
                            "title":"Vehicle",
                            "href":"c-Vehicle-aku1531824.html#aku1531824"
                        }
                    ]
                },
                {
                    "title":"Child Objects (Web Services v2.0)",
                    "href":"c-Child-Objects-Web-Services-v20-aku1415990.html#aku1415990",
                    "topics":[
                        {
                            "title":"Account",
                            "href":"c-Account-aku1496494.html#aku1496494"
                        },
                        {
                            "title":"Account Contact",
                            "href":"c-Account-Contact-aku1724036.html#aku1724036"
                        },
                        {
                            "title":"Account Event",
                            "href":"c-account-event-child.html#c_account_event_child"
                        },
                        {
                            "title":"Account Opportunity",
                            "href":"c-Account-Opportunity-aku1737290.html#aku1737290"
                        },
                        {
                            "title":"Activity",
                            "href":"c-Activity-aku1722922.html#aku1722922"
                        },
                        {
                            "title":"Address",
                            "href":"c-Address-aku2031403.html#aku2031403"
                        },
                        {
                            "title":"Asset",
                            "href":"c-Asset-aku1723617.html#aku1723617"
                        },
                        {
                            "title":"Assigned Books",
                            "href":"c-Assigned-Book.html#c_AssignedBook-8F158F7B"
                        },
                        {
                            "title":"Attachment",
                            "href":"c-Attachment-aku1486004.html#aku1486004"
                        },
                        {
                            "title":"Attendee Call",
                            "href":"c-Attendee-Call-aku1871066.html#aku1871066"
                        },
                        {
                            "title":"Audit Trail",
                            "href":"c-Audit-Trail-Child.html#c_Audit_Trail_Child-337B302C"
                        },
                        {
                            "title":"Book",
                            "href":"c-Book-aku1993101.html#aku1993101"
                        },
                        {
                            "title":"Book User",
                            "href":"c-Book-User-aku1993107.html#aku1993107"
                        },
                        {
                            "title":"Campaign",
                            "href":"c-Campaign-aku1993653.html#aku1993653"
                        },
                        {
                            "title":"Competitor",
                            "href":"c-Competitor-aku1838027.html#aku1838027"
                        },
                        {
                            "title":"Contact",
                            "href":"c-Contact-aku1722637.html#aku1722637"
                        },
                        {
                            "title":"Contact Role",
                            "href":"c-Contact-Role-aku1751456.html#aku1751456"
                        },
                        {
                            "title":"Custom Object 1 through 3",
                            "href":"c-Custom-Object-1-through-3-aku2063299.html#aku2063299"
                        },
                        {
                            "title":"Custom Object 4 through 15",
                            "href":"c-Custom-Object-4-through-15-aku1736874.html#aku1736874"
                        },
                        {
                            "title":"Custom Object 1 Child",
                            "href":"c-Custom-Object-1-Child-aku2431650.html#aku2431650"
                        },
                        {
                            "title":"Custom Web Applet",
                            "href":"c-Custom-Web-Applet-aku2431643.html#aku2431643"
                        },
                        {
                            "title":"Delegated User",
                            "href":"c-Delegated-User-aku2431182.html#aku2431182"
                        },
                        {
                            "title":"Exchange Rate History",
                            "href":"c-Exchange-Rate-History-aku1736603.html#aku1736603"
                        },
                        {
                            "title":"Image",
                            "href":"c-Image-aku2430722.html#aku2430722"
                        },
                        {
                            "title":"Interests",
                            "href":"c-Interests-aku2430519.html#aku2430519"
                        },
                        {
                            "title":"Invitee",
                            "href":"c-Invitee-aku2430339.html#aku2430339"
                        },
                        {
                            "title":"Lead",
                            "href":"c-Lead-aku1694021.html#aku1694021"
                        },
                        {
                            "title":"Lead Event",
                            "href":"c-lead-event-child.html#c_lead_event_child"
                        },
                        {
                            "title":"Note",
                            "href":"c-Note-aku1491244.html#aku1491244"
                        },
                        {
                            "title":"Opportunity",
                            "href":"c-Opportunity-aku1750794.html#aku1750794"
                        },
                        {
                            "title":"Opportunity Child",
                            "href":"c-Opportunity-Child-aku1724844.html#aku1724844"
                        },
                        {
                            "title":"Opportunity Event",
                            "href":"c-opportunity-event-child.html#c_opportunity_event_child"
                        },
                        {
                            "title":"Products Detailed",
                            "href":"c-Products-Detailed-aku1723117.html#aku1723117"
                        },
                        {
                            "title":"Promotional Items Dropped",
                            "href":"c-Promotional-Items-Dropped-aku1577055.html#aku1577055"
                        },
                        {
                            "title":"Recipient",
                            "href":"c-Recipient-aku1577052.html#aku1577052"
                        },
                        {
                            "title":"Related Contact",
                            "href":"c-Related-Contact-aku1493713.html#aku1493713"
                        },
                        {
                            "title":"Revenue",
                            "href":"c-Revenue-aku1493984.html#aku1493984"
                        },
                        {
                            "title":"Sales Assessment",
                            "href":"c-Sales-Assessment-aku1905069.html#aku1905069"
                        },
                        {
                            "title":"Sales Assessment Value",
                            "href":"c-Sales-Assessment-Value-aku1905137.html#aku1905137"
                        },
                        {
                            "title":"Sample Dropped",
                            "href":"c-Sample-Dropped-aku1905066.html#aku1905066"
                        },
                        {
                            "title":"Service Request",
                            "href":"c-Service-Request-aku1492098.html#aku1492098"
                        },
                        {
                            "title":"Shared Address",
                            "href":"c-Shared-Address-aku1904049.html#aku1904049"
                        },
                        {
                            "title":"Subbook",
                            "href":"c-Subbook-aku1993719.html#aku1993719"
                        },
                        {
                            "title":"Team",
                            "href":"c-Team-aku2046949.html#aku2046949"
                        },
                        {
                            "title":"User",
                            "href":"c-User-aku2046939.html#aku2046939"
                        },
                        {
                            "title":"User Default Book Per Type",
                            "href":"c-User-Default-Book-Per-Type-aku1944873.html#aku1944873"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"8 Using Attachments with Web Services On Demand",
            "topics":[
                {
                    "title":"Using Attachments with Web Services On Demand",
                    "href":"c-OnDemWebSvcs-Attachments.html#enter-id-to-match-title",
                    "topics":[
                        {
                            "title":"About Attachments",
                            "href":"c-About-Attachments-akz1022457.html#akz1022457"
                        },
                        {
                            "title":"About The Attachment Element",
                            "href":"c-About-The-Attachment-Element-akz1022461.html#akz1022461"
                        },
                        {
                            "title":"Specifying File Attachment Content",
                            "href":"c-Specifying-File-Attachment-Content-akz1022467.html#akz1022467",
                            "topics":[
                                {
                                    "title":"Attaching Binary Data",
                                    "href":"c-Attaching-Binary-Data-akz1022471.html#akz1022471"
                                },
                                {
                                    "title":"Attaching a Text File",
                                    "href":"c-Attaching-a-Text-File-akz1022570.html#akz1022570"
                                }
                            ]
                        },
                        {
                            "title":"Attaching a File to Multiple Records",
                            "href":"c-Attaching-a-File-to-Multiple-Records-akz1022637.html#akz1022637"
                        }
                    ]
                },
                {
                    "title":"Retrieving or Querying File Attachments",
                    "href":"c-Retrieving-or-Querying-File-Attachments--akz1022663.html#akz1022663"
                },
                {
                    "title":"Specifying URL Attachments",
                    "href":"c-Specifying-URL-Attachments-akz1025474.html#akz1025474"
                }
            ]
        },
        {
            "heading":"9 Mapping of Display Names to Service API Object Names",
            "topics":[
                {
                    "title":"Mapping of Display Names to Service API Object Names",
                    "href":"c-OnDemWebSvcs-ObjectMapping.html#enter-id-to-match-title"
                },
                {
                    "title":"Mapping of Display Names",
                    "href":"c-Mapping-of-Display-Names-ama1027109.html#ama1027109"
                }
            ]
        },
        {
            "heading":"10 Web Services On Demand Limiters",
            "topics":[
                {
                    "title":"Web Services On Demand Limiters",
                    "href":"c-OnDemWebSvcs-Limiters.html#enter-id-to-match-title"
                },
                {
                    "title":"Web Services On Demand Limiters",
                    "href":"c-Web-Services-On-Demand-Limiters-amb1027502.html#amb1027502"
                },
                {
                    "title":"Web Services Request Rate",
                    "href":"c-Web-Services-Request-Rate--amb1025272.html#amb1025272"
                }
            ]
        }
    ]
});