<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes"/>
	<xsl:template match="TutorialPage">
<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>

		<xsl:text><![CDATA[
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><html>
<head>
	<title>]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[</title>
	<link rel="stylesheet" type="text/css" href="../../master.css">		
<script language="JavaScript" src="../../strings.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions3.js"></script>

<script language="JavaScript">
topicInt="]]></xsl:text><xsl:value-of select="$currTopic"/><xsl:text><![CDATA[";
titleString = "]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[";
totalPagesThisTopic = "]]></xsl:text><xsl:value-of select="@totalThisLesson"/><xsl:text><![CDATA[";
var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() { 
  hide('loading');
  paint('background','introText');

]]></xsl:text>
	<xsl:for-each select="HotSpot">
		<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
		<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
<xsl:text><![CDATA[
  put(']]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[',]]></xsl:text><xsl:value-of select="$x"/><xsl:text><![CDATA[,]]></xsl:text><xsl:value-of select="$y"/><xsl:text><![CDATA[);
]]></xsl:text>
	</xsl:for-each>
	<xsl:for-each select="PopUp">
		<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
		<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
<xsl:text><![CDATA[
  put(']]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[',]]></xsl:text><xsl:value-of select="$x"/><xsl:text><![CDATA[,]]></xsl:text><xsl:value-of select="$y"/><xsl:text><![CDATA[);
]]></xsl:text>
	</xsl:for-each>
	<xsl:for-each select="PopUp">
		<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="puX"><xsl:value-of select="@puX"/></xsl:variable>
		<xsl:variable name="puY"><xsl:value-of select="@puY"/></xsl:variable>
<xsl:text><![CDATA[
  put(']]></xsl:text><xsl:value-of select="$puID"/><xsl:text><![CDATA[',]]></xsl:text><xsl:value-of select="$puX"/><xsl:text><![CDATA[,]]></xsl:text><xsl:value-of select="$puY"/><xsl:text><![CDATA[);
]]></xsl:text>
	</xsl:for-each>
<xsl:text><![CDATA[
}
</script> 
</head>

<body onLoad="init();window.focus()">
<!--<div id="idText" class="lesIdentifier">Topic Homepage</div>-->
<div id="introText" class="colText">

<!-- Do not edit table tags-->
<table width= "680" height = "368">
<TR valign="top">
<td width="2%">&nbsp;</td>

<!-- left-hand column. 1260 maximum characters per column, including white space, no paragraph breaks-->
<td class="stepsMenuText" width="46%">]]></xsl:text><xsl:value-of select="Intro"/><xsl:text><![CDATA[<br><br><span class="texttitle">]]></xsl:text><xsl:value-of select="NavInstructions"/><xsl:text><![CDATA[</span></td>
<!-- the next line is a spacer. Do not edit -->
<td width="4%">&nbsp;</td>

<td class="stepsMenuText" width="46%"><table>]]></xsl:text><xsl:for-each select="Text"><xsl:text><![CDATA[<tr><td valign="top"><img src="../../../../base/tutorial/images/blue_arrow.gif" border="0"/></td><td class="lessonTableLink"><a href="]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a></td></tr>]]></xsl:text></xsl:for-each><xsl:text><![CDATA[ </table>
 
</td>
<td width="2%">&nbsp;</td>
</TR>
</table>
</div>



<!-- do not edit below this line -->

<div id="loading" class="loading">&nbsp;Loading&nbsp;<img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/loading.gif" width=80 height=17 border=0 align="middle" alt="loading...">&nbsp;</div>


<div id="background" class="background"><img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/background.gif" width=700 height=615 border=0 align="middle"></div>


<div id="pic" class="colGr"><img src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[../../base/tutorial/images/clear.gif" width="310" height="373" border ="0" id="scrn" name="scrn"></div>

]]></xsl:text>
	<xsl:for-each select="HotSpot">
		<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>
		<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
		<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "status = ' ';  return true;" onmouseout = "status = defaultStatus; return true" onclick="loader(topicName+'_]]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA[.xml'); return false"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
	</xsl:for-each>
	<xsl:for-each select="PopUp">
		<xsl:variable name="ID"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>
		<xsl:variable name="width"><xsl:value-of select="@width"/></xsl:variable>
		<xsl:variable name="height"><xsl:value-of select="@height"/></xsl:variable>
		<xsl:variable name="puID"><xsl:value-of select="@puId"/></xsl:variable>
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "show_hide(']]></xsl:text><xsl:value-of select="$puID"/><xsl:text><![CDATA[');status = ' ';  return true;" onmouseout = "show_hide(']]></xsl:text><xsl:value-of select="$puID"/><xsl:text><![CDATA[');status = defaultStatus; return true" onclick="loader(topicName+'_]]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA[.xml'); return false"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="$width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="$height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
	</xsl:for-each>
	<xsl:for-each select="PopUp">
		<xsl:variable name="ID"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="title"><xsl:value-of select="Title"/></xsl:variable>
		<!--<xsl:variable name="text"><xsl:value-of select="Text"/></xsl:variable>-->
<xsl:text><![CDATA[
<div id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="popUpClass">
  <table width='220' border='0' cellspacing='0' cellpadding='1'>
	<tr class="hdr" valign='top'>
		<td class="hdr" width='2%'>&nbsp;</td>
		<td colspan="2" class="hdr" width='96%'>
		<B>]]></xsl:text><xsl:value-of select="$title"/><xsl:text><![CDATA[</B></td>
		<td class="hdr" width='2%'>&nbsp;</td></tr>]]></xsl:text>
		<xsl:for-each select="child::Text"><xsl:text><![CDATA[
		<tr valign='top' height=2>
		<td width='2%'></td>
		<td colspan="2" width='96%'></td>
		<td width='2%'></td></tr>
	<tr valign='top'>
		<td width='2%'>&nbsp;</td>
		<td width='95%'>]]></xsl:text><xsl:choose>
			<xsl:when test="@url!=''"><xsl:text><![CDATA[<a href="]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a>]]></xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
		</xsl:choose><xsl:text><![CDATA[</td>
		<td width='2%'>&nbsp;</td></tr>]]></xsl:text>
		</xsl:for-each>
<xsl:text><![CDATA[
  </table>
</div>
]]></xsl:text>
	</xsl:for-each>
<xsl:text><![CDATA[

<script language="JavaScript">document.write(getLocInfo());</script>
</body>
</html>]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>