<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:template match="TutorialPage">

<xsl:variable name="baseDir"><xsl:value-of select="@baseDir"/></xsl:variable>

<html>
<head>
	<title>
		<xsl:value-of select="Topic"/>
	</title>
	<link rel="stylesheet" type="text/css" href="{$baseDir}/tutorial/engine/master.css">	

<script language="JavaScript" src="strings.js"></script>
<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions.js"></script>
<script language="JavaScript">
// ************* do not edit the scripts below this line  *****************************/
var pth = document.location.toString();
var ar = pth.split('/');
flNm = ar[ar.length-1];
var ar2 = flNm.split(".");
pageName = ar2[0]; 
totalPagesThisTopic = "1";

var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() { 
	<xsl:for-each select="HotSpot">
		<xsl:variable name="id"><xsl:value-of select="@id"/></xsl:variable>
		<xsl:variable name="x"><xsl:value-of select="@x"/></xsl:variable>
		<xsl:variable name="y"><xsl:value-of select="@y"/></xsl:variable>
		<xsl:variable name="puId"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="puX"><xsl:value-of select="@puX"/></xsl:variable>
		<xsl:variable name="puY"><xsl:value-of select="@puY"/></xsl:variable>

		put("<xsl:value-of select="$id"/>","<xsl:value-of select="$y"/>","<xsl:value-of select="$x"/>");
 		<xsl:if test="$puId!=''">
			put("<xsl:value-of select="$puId"/>","<xsl:value-of select="$puY"/>","<xsl:value-of select="$puX"/>");
 		</xsl:if>
 	</xsl:for-each>
 
	put('navMap',127, 0);  
	hide('loading');//
	paint('hotspotc1','navMap','background','introText');//
}

parent.document.title = document.title;
</script> 
</head>

<body onLoad="init();window.focus()">

<div id="topicName" class="topicName">
<table width='400'>
	<tr align='left'>
		<td class='topicNameText'>
			<xsl:value-of select="Topic"/>
		</td>
	</tr>
</table>
</div>

<div id="loading" class="loading">&#160;Loading&#160;<img src="{$baseDir}/images/loading.gif" width="80" height="17" border="0" align="middle" alt="loading..."/>&#160;</div>

<div id="introText" class="colText">

<!-- Do not edit table tags-->
<table width= "680" height = "368">
	<tr valign="top">
		<td width="2%">&#160;</td>
		<td width="96%" class="stepsMenuText"><xsl:value-of select="//Intro"/></td>
		<!-- the next line is a spacer. Do not edit -->
		<td width="2%">&#160;</td>
	<tr>
</table>
</div>

<div id="background" class="background">
<img src="{$baseDir}../base/tutorial/images/background.gif" width="700" height="615" border="0"/></div>

	<div id="navMap" class="pic"><img src="images/
	BUSTED
	<xsl:value-of select="@image"/>
		<xsl:text><![CDATA[" width="700" height="436" border ="0" id="scrn" name="scrn"></div>

]]></xsl:text>
		<xsl:for-each select="HotSpot">
		<xsl:if test="@puId!=''">
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="@id"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "show(']]></xsl:text><xsl:value-of select="@puId"/><xsl:text><![CDATA[');status = ' ';  return true;" onmouseout = "hide(']]></xsl:text><xsl:value-of select="@puId"/><xsl:text><![CDATA[');status = defaultStatus; return true" onclick="loader(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA['); return false"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[tutorial/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
		</xsl:if>
		<xsl:if test="@puId=''">
			<xsl:if test="@newWindow='false'">
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="@id"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "show(']]></xsl:text><xsl:value-of select="@puId"/><xsl:text><![CDATA[');status = ' ';  return true;" onmouseout = "hide(']]></xsl:text><xsl:value-of select="@puId"/><xsl:text><![CDATA[');status = defaultStatus; return true" onclick="loader(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA['); return false"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[tutorial/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
			</xsl:if>
			<xsl:if test="@newWindow='true'">
<xsl:text><![CDATA[
<DIV id="]]></xsl:text><xsl:value-of select="@id"/><xsl:text><![CDATA[" class="hotspotC"  Style="position:absolute; width:]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[; height:]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["><A HREF="#"  onmouseover = "status = ' ';  return true;" onmouseout = "status = defaultStatus; return true" onclick="javascript:window.open(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=0,top=0')"><IMG SRC="]]></xsl:text><xsl:value-of select="../@baseDir"/><xsl:text><![CDATA[tutorial/images/clear.gif" border="0"  width="]]></xsl:text><xsl:value-of select="@width"/><xsl:text><![CDATA[" height="]]></xsl:text><xsl:value-of select="@height"/><xsl:text><![CDATA["></A></DIV>
]]></xsl:text>
			</xsl:if>
		</xsl:if>
		</xsl:for-each>

<xsl:for-each select="HotSpot">
		<xsl:variable name="ID"><xsl:value-of select="@puId"/></xsl:variable>
		<xsl:variable name="title"><xsl:value-of select="Title"/></xsl:variable>
		<!--<xsl:variable name="text"><xsl:value-of select="Text"/></xsl:variable>-->
<xsl:text><![CDATA[
<div id="]]></xsl:text><xsl:value-of select="$ID"/><xsl:text><![CDATA[" class="popUpClass">
  <table width='220' border='0' cellspacing='0' cellpadding='1'>
	<tr class="hdr" valign='top'>
		<td class="hdr" width='2%'>&#160;</td>
		<td colspan="2" class="hdr" width='96%'>
		<B>]]></xsl:text><xsl:value-of select="$title"/><xsl:text><![CDATA[</B></td>
		<td class="hdr" width='2%'>&#160;</td></tr>]]></xsl:text>
		<xsl:for-each select="child::Text"><xsl:text><![CDATA[
		<tr valign='top' height=2>
		<td width='2%'></td>
		<td colspan="2" width='96%'></td>
		<td width='2%'></td></tr>
	<tr valign='top'>
		<td width='2%'>&#160;</td>
		<td width='95%'>]]></xsl:text><xsl:choose>
			<xsl:when test="@url!=''"><xsl:text><![CDATA[<a href="]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[">]]></xsl:text><xsl:value-of select="."/><xsl:text><![CDATA[</a>]]></xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
		</xsl:choose><xsl:text><![CDATA[</td>
		<td width='2%'>&#160;</td></tr>]]></xsl:text>
		</xsl:for-each>
<xsl:text><![CDATA[
  </table>
</div>
]]></xsl:text>
	</xsl:for-each>

		<xsl:text><![CDATA[
<!-- the following divs are utilities. Delete when page is finished -->

<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/devDrag.js"></script>

<div id="gen" class="locator">
 <form name="hotspot"><textarea name="spot" cols=100 rows=5 wrap="virtual"></textarea><br>Hotspot Builder. Press Ctl + C to copy.</form></div>
 
<div id="box" class="find">
 <!--<img src="images/clear.gif" width="20" height="20">-->
</div>

<!-- end utilities -->
<script language="JavaScript">document.write(getLocInfo());</script>

</body>
</html>]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>
