<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:template match="TutorialPage">
		<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>
		<xsl:variable name="baseDir"><xsl:value-of select="@baseDir"/></xsl:variable>
		<xsl:variable name="singleTopic"><xsl:value-of select="@singleTopic"/></xsl:variable>
		<xsl:variable name="totalThisLesson"><xsl:value-of select="@totalThisLesson"/></xsl:variable>
		<xsl:variable name="hasImage"><xsl:value-of select="@hasImage"/></xsl:variable>
		<xsl:variable name="url"><xsl:value-of select="@url"/></xsl:variable>


<html>
<head>
	<title>
		<xsl:value-of select="Topic"/>
	</title>
	<link rel="stylesheet" type="text/css" href="{$baseDir}/tutorial/engine/master.css"/>		

	<script language="JavaScript" src="../../strings.js"></script>

	<script language="JavaScript">
		var sT = <xsl:value-of select="$singleTopic"/>;
		var singleTopic = true; // this var will hold a boolean indicating if a topic is launched as a single topic [true] or as part of a 'lesson' [false]
		if (sT != "1"){
 			singleTopic = false;
		}
	</script>

	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions.js"></script>
	<script language="JavaScript" src="{$baseDir}/tutorial/engine/actions3.js"></script>

	<script language="JavaScript">
		topicInt = <xsl:value-of select="$currTopic"/>;
		titleString = "<xsl:value-of select="Topic"/>";
		totalPagesThisTopic = <xsl:value-of select="$totalThisLesson"/>;

		// ************* do not edit the scripts below this line  *****************************/
		hasImage = <xsl:value-of select="$hasImage"/>; // every lesson home page has an image, so keep set at 1
		var imgFilePath = "graphics/"+pageName+"_01.png";
		(hasImage==1 || hasImage==2 || hasImage==3)?preload(imgFilePath):'';
		var str = pageName.split("_");
		topicName = str[0];
		thisTopicNumber = str[1];
		setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

		function init() { 
			hide('loading');
			(hasImage == 1 || hasImage == 2)?swap('scrn',imgFilePath,'pic'):''; 
			(hasImage == 3)?swap('scrn',imgFilePath,'screen'):''; 

			<xsl:if test="$hasImage='0'">
				put('pic',126,0);
				paint('background','steps');
				show('pic');
			</xsl:if>
			<xsl:if test="$hasImage='1'">
				put('pic',126,0);
				paint('background','steps');
				show('pic');
			</xsl:if>
			<xsl:if test="$hasImage='2'">
				put('pic',147,370);
				paint('background','steps');
				show('pic');
			</xsl:if>
			<xsl:if test="$hasImage='3'">
				paint('dropShadow','screen','background','steps');
			</xsl:if>
		}
	</script> 
</head>

<body onLoad="init();window.focus()">
	<div id="steps" class="colText">
		<table width= "680" height = "368">
			<tr valign="top">
				<td width="2%">&#160;</td>
				<td class="stepsMenuText" width="46%">
					
					<xsl:for-each select="Text">
						<xsl:variable name="column"><xsl:value-of select="@column"/></xsl:variable>
						<xsl:if test="$column='left'">
							<xsl:variable name="type"><xsl:value-of select="@type"/></xsl:variable>
							
							<xsl:if test="$type='text'">
								<div id="tempText"></div>
								<script language="JavaScript">
									var valText = "<xsl:value-of select="text()"/>";
									document.getElementById("tempText").innerHTML += valText;
								</script>
															

								<xsl:for-each select="descendant-or-self::*[name()='link']">
									<xsl:call-template name="linkTempl"/>
								</xsl:for-each>

							</xsl:if>
							<xsl:if test="$type='bullet'">
								<table width= "320" >
									<tr valign="top">
										<td width="4%"><img src="../../../../base/tutorial/images/text_bullet.gif" border="0"/></td>
										<td class="stepsMenuText" width="96%">
											<xsl:value-of select="text()"/>
											<xsl:for-each select="descendant-or-self::*[name()='link']">
												<xsl:call-template name="linkTempl"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</xsl:if>
							<xsl:if test="$type='linkImage'">
								<br/><br/>
								<span class="texttitle">
									<img src="{$url}" width="118" height="17" border="0" alt="related documents"/>
								</span>
							</xsl:if>
							<xsl:if test="$type='link'">						
								<table width= "320" >
									<tr valign="top">
										<td width="4%"><img src="../../../../base/tutorial/images/related_doc.gif" border="0"/></td>
										<td class="stepsMenuText" width="96%">
											<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=0,top=0')">
												<xsl:value-of select="."/>
											</a>
										</td>
									</tr>
								</table>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</td>

				<td width="4%">&#160;</td>
				<td class="stepsMenuText" width="46%">
					<xsl:for-each select="Text">
						<xsl:variable name="column"><xsl:value-of select="@column"/></xsl:variable>
						<xsl:if test="$column='right'">
							<xsl:variable name="type"><xsl:value-of select="@type"/></xsl:variable>
							<xsl:if test="$type='text'">
								<xsl:value-of select="text()"/>
								<xsl:for-each select="descendant-or-self::*[name()='link']">
									<xsl:call-template name="linkTempl"/>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="$type='bullet'">
								<table width= "320" >
									<tr valign="top">
										<td width="4%"><img src="../../../../base/tutorial/images/text_bullet.gif" border="0"/></td>
										<td class="stepsMenuText" width="96%"><xsl:value-of select="text()"/>
											<xsl:for-each select="descendant-or-self::*[name()='link']">
											<xsl:call-template name="linkTempl"/>
											</xsl:for-each>	
										</td>
									</tr>
								</table>
							</xsl:if>
							<xsl:if test="$type='linkImage'">
								<span class="texttitle"><img src="{$url}" width="118" height="17" border="0" alt="related documents"/></span>
							</xsl:if>
							<xsl:if test="$type='link'">						
								<table width= "320" >
									<tr valign="top">
										<td width="4%"><img src="../../../../base/tutorial/images/related_doc.gif" border="0"/></td>
										<td class="stepsMenuText" width="96%">
											<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=0,top=0')">
												<xsl:value-of select="."/>
											</a>
										</td>
									</tr>
								</table>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td width="4%">&#160;</td>
				<td class="stepsMenuText" width="46%"></td>
				<td width="2%">&#160;</td>
			</tr>
		</table>
		<xsl:call-template name="helpLinks"/>
	</div>

	<div id="loading" class="loading">&#160;Loading&#160;<img src="../../../../base/tutorial/images/loading.gif" width="80" height="17" border="0" align="middle" alt="loading..."/>&#160;</div>

	<div id="background" class="background"><img src="../../../../base/tutorial/images/background.gif" width="700" height="615" border="0" align="middle"/></div>

	<xsl:if test="$hasImage='0'">				
		<div id="pic" class="colGr">
			<img src="../../../../base/tutorial/images/clear.gif" width="700" height="434" border ="0" id="scrn" name="scrn"/>
		</div>
	</xsl:if>
	<xsl:if test="$hasImage='1'">
		<div id="pic" class="colGr">
			<img src="../../../../base/tutorial/images/clear.gif" width="700" height="434" border ="0" id="scrn" name="scrn"/>
		</div>
	</xsl:if>
	<xsl:if test="$hasImage='2'">
		<div id="pic" class="colGr">
			<img src="../../../../base/tutorial/images/clear.gif" width="310" height="373" border ="0" id="scrn" name="scrn"/>
		</div>
	</xsl:if>
	<xsl:if test="$hasImage='3'">
		<div id="screen" class="screenShotBg">
			<img src="../../../../base/tutorial/images/clear.gif" width="678" height="378" border ="0" id="scrn" name="scrn"/>
		</div>
		<div id = "dropShadow" class="dropSBg">
			<img src="../../../../base/tutorial/images/drop_shadow_big.gif" width="700" height="413"/>
		</div>
	</xsl:if>
		
	<div id="temp"></div>
	<script type="text/javascript">document.getElementById("temp").innerHTML=getLocInfo();</script>
</body>
</html>
</xsl:template>

	<xsl:template name="linkTempl" match="link">
	<xsl:variable name="url"><xsl:value-of select="@url"/></xsl:variable>
	<xsl:choose>
		<xsl:when test="@newWindow='true'">
			<xsl:choose>
				<xsl:when test="@winH">
					<a href="#" onclick="javascript:window.open('{$url}','','toolbar=no,menubar=no,status=no,scrollbars=no,resizable=no,width=@winW,height=@winH,left=100,top=60')" style="color:blue">
						<xsl:value-of select="."/>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')" style="color:blue">
						<xsl:value-of select="."/>
					</a>
				</xsl:otherwise>
			</xsl:choose>
			<a href="#" onclick="javascript:window.open('{$url}','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')" style="color:blue">
				<xsl:value-of select="."/>
			</a>
		</xsl:when>
		<xsl:otherwise>
			<a href = "{$url}" style="color:blue">
				<xsl:value-of select="."/>
			</a>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>

	<xsl:template name="helpLinks" match="//helpLinks">
	<div id="helpLinks">
		<table width="100%" border="0">
			<xsl:for-each select="child::helpLinks/child::link">
				<tr>
					<xsl:variable name="target">../../../help/<xsl:value-of select="./@url"/></xsl:variable>
					<td width="73%"></td>
					<td width="10%" align = "right">
						<a href="#" onClick = "helpLaunch('{$target}')">
							<img src="../../../../base/tutorial/images/help.gif" border="0" width="50" height="24"/>
						</a>
					</td>
					<td class='hLinksText' width="15%" align="left">
						<a href="#" onClick = "helpLaunch('{$target}')" style="color:#0066CC">
							<xsl:value-of select="."/>
						</a>
					</td>
					<td width="2"></td>
				</tr>
			</xsl:for-each>
		</table>
	</div>
	</xsl:template>
</xsl:stylesheet>
