/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.sections;

import com.jrockit.mc.console.ui.actions.RemoveAction;
import com.jrockit.mc.console.ui.sections.ISectionPartManagerListener;
import com.jrockit.mc.console.ui.sections.SectionPartManagerEvent;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.ui.MCToolBarManager;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public class SectionPartManager {
    private final IManagedForm m_managedForm;
    private final AttributeVisualizerBuilder m_guiBuilder;
    private final String m_name;
    private final List m_sectionPartManagerListeners;

    public SectionPartManager(String name, IManagedForm managedForm, AttributeVisualizerBuilder guiBuilder) {
        this.m_name = name;
        this.m_managedForm = managedForm;
        this.m_guiBuilder = guiBuilder;
        this.m_sectionPartManagerListeners = new ArrayList();
    }

    public boolean add(MCSectionPart part) throws IllegalArgumentException {
        if (this.countPart(part) != 1) {
            throw new IllegalArgumentException("Section part not added exactly one time to the managed form!");
        }
        part.getMCToolBarManager().add((IAction)new RemoveAction(this, part), MCToolBarManager.ALIGN_RIGHT);
        part.refresh();
        this.m_managedForm.reflow(true);
        this.fireSectionPartManagerEvent(new SectionPartManagerEvent(this, part, 1));
        return true;
    }

    private int countPart(MCSectionPart part) {
        int count = 0;
        IFormPart[] parts = this.m_managedForm.getParts();
        int i = 0;
        while (i < parts.length) {
            if (parts[i] == part) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getName() {
        return this.m_name;
    }

    public List getParts() {
        ArrayList<IFormPart> list = new ArrayList<IFormPart>();
        list.addAll(Arrays.asList(this.m_managedForm.getParts()));
        return Collections.unmodifiableList(list);
    }

    public boolean remove(MCSectionPart part) {
        if (this.countPart(part) == 1) {
            this.destroyPart(part);
            return true;
        }
        return false;
    }

    public void destroyAllParts() {
        while (this.m_managedForm.getParts().length > 0) {
            this.destroyPart((MCSectionPart)this.m_managedForm.getParts()[0]);
        }
        this.m_managedForm.getForm().setFocus();
    }

    public void destroyPart(MCSectionPart part) {
        this.m_managedForm.removePart((IFormPart)part);
        part.getSection().dispose();
        part.dispose();
        this.m_managedForm.reflow(true);
        this.fireSectionPartManagerEvent(new SectionPartManagerEvent(this, part, 0));
    }

    public AttributeVisualizerBuilder getGuiBuilder() {
        return this.m_guiBuilder;
    }

    public IManagedForm getManagementForm() {
        return this.m_managedForm;
    }

    public static String createUniqueSectionPartTitle(String title, List list) {
        int n = 1;
        title = String.valueOf(title) + " ";
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            SectionPart part = (SectionPart)iter.next();
            String s = part.getSection().getText();
            if (!s.startsWith(title)) continue;
            try {
                int chartNum = Integer.parseInt(s.substring(title.length()));
                if (chartNum < n) continue;
                n = chartNum + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return String.valueOf(title) + Integer.toString(n);
    }

    public void addSetionPartManagerListener(ISectionPartManagerListener sectionPartManagerListener) {
        this.m_sectionPartManagerListeners.add(sectionPartManagerListener);
    }

    public void removeSectionPartManagerListener(ISectionPartManagerListener sectionPartManagerListener) {
        this.m_sectionPartManagerListeners.remove(sectionPartManagerListener);
    }

    protected void fireSectionPartManagerEvent(SectionPartManagerEvent event) {
        Iterator iter = this.m_sectionPartManagerListeners.iterator();
        while (iter.hasNext()) {
            ISectionPartManagerListener listener = (ISectionPartManagerListener)iter.next();
            switch (event.getOperationType()) {
                case 1: {
                    listener.sectionPartAdded(event);
                    break;
                }
                case 0: {
                    listener.sectionPartRemoved(event);
                }
            }
        }
    }

    public void dispose() {
        this.m_sectionPartManagerListeners.clear();
    }
}

