/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.misc;

import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.IOException;
import java.io.Serializable;

public final class ClassProxy
implements Serializable {
    private static final long serialVersionUID = -130261219774069135L;
    private IMBeanService m_mbeanService;
    private String m_className;
    private MethodIdentifier[] m_methodCache;

    private ClassProxy(IMBeanService mbeanService) {
        this.m_mbeanService = mbeanService;
    }

    public static ClassProxy forName(String className, IMBeanService mbeanService) throws IOException, ClassNotFoundException {
        ClassProxy newProxy = new ClassProxy(mbeanService);
        newProxy.lookUp(className);
        return newProxy;
    }

    public static boolean isThrowable(String className, IMBeanService mbeanService) throws IOException {
        return mbeanService.getProxyOperations().isThrowable(className);
    }

    private void lookUp(String className) throws IOException, ClassNotFoundException {
        this.m_methodCache = this.getMBeanService().getProxyOperations().getMethods(className);
        this.m_className = className;
    }

    private IMBeanService getMBeanService() {
        return this.m_mbeanService;
    }

    public MethodIdentifier[] getMethodIdentifiers() {
        return this.m_methodCache;
    }

    public String getClassName() {
        return this.m_className;
    }
}

