/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.editor.ConsoleEditorInput;
import com.jrockit.mc.console.ui.editor.Messages;
import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.core.formpage.internal.MCFormPage;
import com.jrockit.mc.core.misc.TemporaryMessage;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ConsoleTab
extends MCFormPage {
    protected static final String ATTRIBUTE_UID = "uid";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConsoleTab() {
        super(null, "", "");
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public IMBeanService getMBeanService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMBeanService)iConnectionHandle.getService((Class)clazz);
    }

    public IConnectionHandle getConnectionHandle() {
        return ((ConsoleEditor)this.getEditor()).getConnectionHandle();
    }

    public ConsoleEditorInput getConsoleEditorInput() {
        if (this.getEditorInput() instanceof ConsoleEditorInput) {
            return (ConsoleEditorInput)this.getEditorInput();
        }
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.setInput((Object)this.getConsoleEditorInput().getConnectionHandle());
        if (!this.getConsoleEditorInput().getConnectionHandle().isConnected()) {
            this.showConnectionLostMessage();
        }
        super.createFormContent(managedForm);
    }

    protected boolean initTabFromStore(IPreferenceStore store, String preferenceKey, XmlEnabled valueToInit) {
        String s = store.getString(this.getPrefKeyWithVersion(preferenceKey));
        if (s != null && s.trim().length() > 0) {
            try {
                Document doc = XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(s)));
                List l = XmlToolkit.getChildNodesByTag((Node)doc.getDocumentElement(), (String)valueToInit.getComponentTag());
                boolean hasDataForThisUID = false;
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    Element e = (Element)iter.next();
                    if (!e.getAttribute(ATTRIBUTE_UID).equals(this.getMBeanService().getConnectionDescriptor().getGUID())) continue;
                    hasDataForThisUID = true;
                    valueToInit.initializeFromXml(e);
                }
                return hasDataForThisUID;
            }
            catch (Exception e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Problem initializing tab.", e);
            }
        }
        return false;
    }

    protected void exportTabToStore(IPreferenceStore store, String preferenceKey, XmlEnabled valueToStore) {
        String s = store.getString(this.getPrefKeyWithVersion(preferenceKey));
        IConnectionHandle handle = this.getConnectionHandle();
        if (handle == null) {
            return;
        }
        try {
            Document doc = s != null && s.trim().length() > 0 ? XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(s))) : XmlToolkit.createNewDocument();
            Iterator iter = XmlToolkit.getChildNodesByTag((Node)doc.getDocumentElement(), (String)valueToStore.getComponentTag()).iterator();
            while (iter.hasNext()) {
                Element valueElem = (Element)iter.next();
                if (!valueElem.getAttribute(ATTRIBUTE_UID).equals(handle.getDescriptor().getGUID())) continue;
                doc.getDocumentElement().removeChild(valueElem);
            }
            valueToStore.exportToXml(doc.getDocumentElement());
            String value = XmlToolkit.prettyPrint((Element)doc.getDocumentElement());
            store.setValue(this.getPrefKeyWithVersion(preferenceKey), value);
        }
        catch (Exception e) {
            if (!handle.isConnected()) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not export tab to store. The connection was unavailable.", e);
            }
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not export tab to store.", e);
        }
    }

    private String getPrefKeyWithVersion(String preferenceKey) {
        return String.valueOf(preferenceKey) + "_" + MCVersion.getFullVersion();
    }

    protected void safeInitialize(XmlEnabled xmlEnabled, Element node) {
        try {
            xmlEnabled.initializeFromXml(node);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not initiate settings from XML!", e);
        }
    }

    private void showConnectionLostMessage() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.forms.IMessageManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMessageManager manager = (IMessageManager)this.getAdapter(clazz);
        this.showMessage(manager, Messages.ConsoleEditor_CONNECTION_LOST);
    }

    private void showMessage(IMessageManager manager, String stringMessage) {
        TemporaryMessage message = new TemporaryMessage(stringMessage, 3);
        message.setDelay(Integer.MAX_VALUE);
        message.show(manager, this.getSite().getShell().getDisplay());
    }
}

