/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.Messages;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.ui.security.SecurityToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class ConsoleEditorInput
implements IEditorInput {
    public static String EDITOR_ID = "com.jrockit.mc.console.ui.editor";
    private final IConnectionDescriptor connectionDescriptor;
    private IConnectionHandle connectionHandle;
    private static Map m_preferences = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConsoleEditorInput(IConnectionDescriptor descriptor) {
        this.connectionDescriptor = descriptor;
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.connectionDescriptor;
    }

    public IMBeanService getMBeanService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMBeanService)iConnectionHandle.getService((Class)clazz);
    }

    public synchronized IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS");
    }

    public String getName() {
        if (this.connectionDescriptor != null) {
            return this.connectionDescriptor.getName();
        }
        return Messages.ConsoleEditorInput_EDITOR_INPUT_NO_DESCRIPTOR;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        try {
            return this.connectionDescriptor.createJMXServiceURL().toString();
        }
        catch (IOException e) {
            return this.connectionDescriptor.getName();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getMBeanService();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.jrockit.mc.rjmx.IConnectionDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getConnectionDescriptor();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof ConsoleEditorInput) {
            return this.connectionDescriptor.equals(((ConsoleEditorInput)o).connectionDescriptor);
        }
        return false;
    }

    void addListener() {
    }

    public String getGlobalPreference(String subSystem) {
        return ConsolePlugin.getDefault().getPreferenceStore().getString(this.getGlobalIdentifier(subSystem));
    }

    public void setGlobalPreference(String subSystem, String value) {
        this.setPreference(this.getGlobalIdentifier(subSystem), value);
    }

    public void addGloballListener(String subSystem, PreferenceListener listener) {
        this.addListener(this.getGlobalIdentifier(subSystem), listener);
    }

    public void removeGlobalListener(String subSystem, PreferenceListener listener) {
        this.removeListenerByIdentifier(this.getGlobalIdentifier(subSystem), listener);
    }

    public void setLocalPreference(String subSystem, String value) {
        this.setPreference(this.getLocalIdentifier(subSystem), value);
    }

    public void addLocalListener(String subSystem, PreferenceListener listener) {
        this.addListener(this.getLocalIdentifier(subSystem), listener);
    }

    public String getLocalPreference(String subSystem) {
        return ConsolePlugin.getDefault().getPreferenceStore().getString(this.getLocalIdentifier(subSystem));
    }

    public void removeLocalListener(String subSystem, PreferenceListener listener) {
        this.removeListenerByIdentifier(this.getLocalIdentifier(subSystem), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String identfier, PreferenceListener listener) {
        Map map = m_preferences;
        synchronized (map) {
            ArrayList<PreferenceListener> l = (ArrayList<PreferenceListener>)m_preferences.get(identfier);
            if (l == null) {
                l = new ArrayList<PreferenceListener>();
                m_preferences.put(identfier, l);
            }
            l.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListenerByIdentifier(String identfier, PreferenceListener listener) {
        Map map = m_preferences;
        synchronized (map) {
            List l = (List)m_preferences.get(identfier);
            if (l != null) {
                l.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreference(String id, String value) {
        Map map = m_preferences;
        synchronized (map) {
            ConsolePlugin.getDefault().getPreferenceStore().setValue(id, value);
            List l = (List)m_preferences.get(id);
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    ((PreferenceListener)i.next()).onChange(value);
                }
            }
        }
    }

    private String getPreferenceId() {
        if (this.connectionDescriptor != null) {
            return this.connectionDescriptor.getGUID();
        }
        ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "ConnectionDescriptor == null when getting preference ID in ConsoleEditor");
        return "Unknown_descriptor";
    }

    private String getLocalIdentifier(String subSystem) {
        return String.valueOf(subSystem) + "." + this.getPreferenceId();
    }

    private String getGlobalIdentifier(String subSystem) {
        return String.valueOf(subSystem) + "." + "common";
    }

    public void intializeConnectionHandle(Shell shell) throws IOException {
        if (this.connectionHandle != null) {
            throw new IOException("Handle already initialized!");
        }
        this.connectionHandle = SecurityToolkit.establishConnection((Shell)shell, (IConnectionDescriptor)this.connectionDescriptor);
    }

    public void releaseConnectionHandle() {
        try {
            if (this.connectionHandle != null) {
                RJMXPlugin.getDefault().getConnectionManager().disconnect(this.connectionHandle);
                this.connectionHandle = null;
            }
        }
        catch (ConnectionException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not destroy connection handle!");
        }
    }

    public static interface PreferenceListener {
        public void onChange(String var1);
    }
}

