/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.common.debug.Debug;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditorInput;
import com.jrockit.mc.console.ui.editor.ConsoleSelectorPart;
import com.jrockit.mc.console.ui.editor.Messages;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContributionFactory;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.IFormPageSelectorPart;
import com.jrockit.mc.core.formpage.internal.AccessibilityToolbarPart;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import com.jrockit.mc.core.formpage.internal.ToolbarFormEditor;
import com.jrockit.mc.core.misc.TemporaryMessage;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.rjmx.ConnectionHandleEvent;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IConnectionHandleFilter;
import com.jrockit.mc.rjmx.IConnectionHandleStateListener;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionHandler;
import com.jrockit.mc.rjmx.core.internal.DefaultMBeanService;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.services.IServiceLocator;

public class ConsoleEditor
extends ToolbarFormEditor
implements IConnectionHandler,
ISaveablePart2 {
    private List m_sectionPartManagers = new ArrayList();
    private IConnectionHandleStateListener m_connectionHandleStateChangeListener;
    private List m_contributions;
    private volatile boolean m_isNiceCloseDown = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void initFormPageContributions(IEditorSite site, Object input) throws PartInitException {
        FormPageContributionFactory factory = new FormPageContributionFactory((IServiceLocator)site, site.getId());
        this.m_contributions = factory.createFormPageContributionsFromMenuContribution("menu:" + site.getId() + ".tabs");
        FormPageContributionToolkit.initializeContributionsWithEditor((List)this.m_contributions, (FormEditor)this);
    }

    private void setupToolbarSelector(List freshPageContributions) {
        Object ifsp = CorePlugin.getDefault().getAccessibilityMode() ? new AccessibilityToolbarPart() : new ConsoleSelectorPart();
        this.setSelector((IFormPageSelectorPart)ifsp);
        ifsp.setSelection((ISelection)new StructuredSelection(freshPageContributions));
        this.setSelectorVisible(!CorePlugin.getDefault().getAccessibilityMode());
    }

    public ConsoleEditor() {
        this.setNavigatorPosition("left");
        this.setTabPosition("bottom");
    }

    public List getFlattenedContributions() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.core.formpage.FormPageContributionItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return FormPageContributionToolkit.flatten((Collection)this.m_contributions, (Class)clazz, (int)Integer.MAX_VALUE, (boolean)true);
    }

    protected void initializeFormPageContributions() {
        Iterator it = this.getFlattenedContributions().iterator();
        while (it.hasNext()) {
            FormPageContributionItem item = (FormPageContributionItem)it.next();
            try {
                this.addFormPageContributionItem(item, this.getEditorInput());
            }
            catch (PartInitException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not initialize FormPageContribution item.", e);
            }
        }
        this.show((ISelection)((IStructuredSelection)this.getSelectorPart().getSelection()), true);
    }

    public List getSectionPartManagers() {
        return this.m_sectionPartManagers;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getHandlerName() {
        return MessageFormat.format(Messages.ConsoleEditor_MANAGEMNT_CONSOLE_TITLE_X, this.getTitle());
    }

    public boolean isConnected() {
        return this.getConnectionHandle() != null && this.getConnectionHandle().isConnected();
    }

    public void shutDown(boolean hardDisconnect) {
        if (hardDisconnect) {
            this.close(!hardDisconnect);
        }
    }

    public void dispose() {
        super.dispose();
        this.m_isNiceCloseDown = true;
        this.disposeFormPageContributions();
        if (Debug.isMemoryLeakTest()) {
            this.disposeSectionManagers();
        }
        this.cleanUpCurrentConnection();
    }

    private void disposeFormPageContributions() {
        FormPageContributionToolkit.disposeFormPageContributions((List)this.m_contributions);
        this.m_contributions.clear();
    }

    private void disposeSectionManagers() {
        Iterator iter = this.m_sectionPartManagers.iterator();
        while (iter.hasNext()) {
            SectionPartManager manager = (SectionPartManager)iter.next();
            manager.dispose();
        }
        this.m_sectionPartManagers.clear();
    }

    private void cleanUpCurrentConnection() {
        ConnectionDescriptorNode node;
        ConsoleEditorInput input = (ConsoleEditorInput)this.getEditorInput();
        if (input == null) {
            return;
        }
        IConnectionHandle handle = input.getConnectionHandle();
        if (handle != null) {
            if (this.m_connectionHandleStateChangeListener != null) {
                RJMXPlugin.getDefault().getConnectionManager().removeConnectionHandleStateListener(this.m_connectionHandleStateChangeListener);
                this.m_connectionHandleStateChangeListener = null;
            }
            ((ConsoleEditorInput)this.getEditorInput()).releaseConnectionHandle();
        }
        if ((node = ConnectionDescriptorNode.getConnectionNodeFor((Object)input)) != null) {
            node.removeConnectionHandler((IConnectionHandler)this);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ConsoleEditorInput)) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Got wierd input to editor: " + input);
            throw new PartInitException("Invalid Input: Must be ConsoleEditorInput");
        }
        ConsoleEditorInput consoleInput = (ConsoleEditorInput)input;
        try {
            consoleInput.getConnectionDescriptor().createJMXServiceURL();
        }
        catch (IOException e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        this.cleanUpCurrentConnection();
        super.init(site, input);
        this.setPartName(input.getName());
        try {
            ConsoleEditorInput cei = (ConsoleEditorInput)input;
            cei.intializeConnectionHandle(this.getEditorSite().getShell());
            DefaultMBeanService is = new DefaultMBeanService(cei.getConnectionHandle());
            IConnectionHandle iConnectionHandle = is.getConnectionHandle();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iConnectionHandle.registerService((Class)clazz, (Object)is);
            this.m_connectionHandleStateChangeListener = new IConnectionHandleStateListener(){

                public void onConnectionHandleStateChange(ConnectionHandleEvent e) {
                    if (e.getState() == ConnectionHandleEvent.State.PreDisconnect || e.getState() == ConnectionHandleEvent.State.PostDisconnect) {
                        ConnectionDescriptorNode.getConnectionNodeFor((Object)ConsoleEditor.this.getEditorInput()).removeConnectionHandler((IConnectionHandler)ConsoleEditor.this);
                        if (!ConsoleEditor.this.m_isNiceCloseDown) {
                            ConsoleEditor.this.showDisconnectedMessageInUI();
                        }
                    }
                }
            };
            RJMXPlugin.getDefault().getConnectionManager().addConnectionHandleStateListener(this.m_connectionHandleStateChangeListener, new IConnectionHandleFilter(){

                public boolean accept(IConnectionHandle handle) {
                    return handle == ConsoleEditor.this.getConnectionHandle();
                }
            });
            ConnectionDescriptorNode node = ConnectionDescriptorNode.getConnectionNodeFor((Object)input);
            if (node != null) {
                node.addConnectionHandler((IConnectionHandler)this);
            }
            this.initializeGraphRegistry(is);
        }
        catch (Exception e3) {
            throw new PartInitException(e3.getMessage(), (Throwable)e3);
        }
        this.initFormPageContributions(site, input);
        this.setupToolbarSelector(this.m_contributions);
    }

    private void showDisconnectedMessageInUI() {
        DisplayToolkit.safeAsyncExec((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                this.showDisconnectedMessageInTabs();
            }

            private void showDisconnectedMessageInTabs() {
                int count = ((FormEditor)ConsoleEditor.this).pages.size();
                int i = 0;
                while (i < count) {
                    this.showConnectionLostMessage((IFormPage)((FormEditor)ConsoleEditor.this).pages.get(i));
                    ++i;
                }
            }

            private void showConnectionLostMessage(IFormPage page) {
                IMessageManager manager;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.ui.forms.IMessageManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((manager = (IMessageManager)page.getAdapter((Class)clazz)) != null) {
                    this.showMessage(manager, Messages.ConsoleEditor_CONNECTION_LOST);
                }
            }

            private void showMessage(IMessageManager manager, String stringMessage) {
                TemporaryMessage message = new TemporaryMessage(stringMessage, 3);
                message.setDelay(Integer.MAX_VALUE);
                message.show(manager, ConsoleEditor.this.getSite().getShell().getDisplay());
            }
        });
    }

    private void initializeGraphRegistry(DefaultMBeanService service) {
        GraphSettingRegistry registry;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (GraphSettingRegistry)service.getService((Class)clazz)) == null) {
            registry = new GraphSettingRegistry(service.getConnectionDescriptor().getGUID(), service.getAttributeInfoService());
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            service.storeService((Class)clazz2, (Object)registry);
        }
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public IConnectionHandle getConnectionHandle() {
        return ((ConsoleEditorInput)this.getEditorInput()).getConnectionHandle();
    }

    public void addSectionManager(SectionPartManager spm) {
        this.m_sectionPartManagers.add(spm);
    }
}

