/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.actions;

import com.jrockit.mc.console.ui.actions.Messages;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.core.layout.ReflowExpansionListener;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.IExpansionListener;

public abstract class NewVisualizerAction
extends Action {
    protected final SectionPartManager m_sectionPartManager;
    protected final List m_attributeDescriptors;

    public static NewVisualizerAction createAddChartAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddChartActionWithAttributeDescriptors(spm, new ArrayList());
    }

    public static NewVisualizerAction createAddChartActionWithAttributeDescriptors(SectionPartManager spm, List attributes) {
        return new NewVisualizerAction(spm, attributes){

            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                IAttributeVisualizer adv = builder.createChart();
                SimpleLayoutData sd = new SimpleLayoutData();
                sd.setMinSize(150);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    public static NewVisualizerAction createAddTableAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddTableActionWithAttributeDescriptors(spm, new ArrayList());
    }

    public static NewVisualizerAction createAddTableActionWithAttributeDescriptors(SectionPartManager spm, List attributes) {
        return new NewVisualizerAction(spm, attributes){

            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                IAttributeVisualizer adv = builder.createTable();
                SimpleLayoutData sd = new SimpleLayoutData();
                sd.setMinSize(150);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    public static NewVisualizerAction createAddDialDashboardAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddDialDashboardActionWithAttributeDescriptors(spm, new ArrayList());
    }

    public static NewVisualizerAction createAddDialDashboardActionWithAttributeDescriptors(SectionPartManager spm, List attributes) {
        return new NewVisualizerAction(spm, attributes){

            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                IAttributeVisualizer adv = builder.createDialDashboard();
                SimpleLayoutData sd = new SimpleLayoutData();
                GC tempGc = new GC((Drawable)adv.getControl());
                int fontHeight = tempGc.getFontMetrics().getHeight();
                sd.setMinSize(147 + 3 * fontHeight);
                sd.setMaxSize(147 + 3 * fontHeight);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    private NewVisualizerAction(SectionPartManager spm, List attributes) {
        super(Messages.NewVisualizerAction_ADD_CHART_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
        this.setToolTipText(Messages.NewVisualizerAction_ADD_CHART_TEXT);
        this.m_sectionPartManager = spm;
        this.m_attributeDescriptors = attributes;
    }

    public void run() {
        String title = SectionPartManager.createUniqueSectionPartTitle(Messages.NewVisualizerAction_MY_CHART_X_TEXT, this.m_sectionPartManager.getParts());
        String identifier = "visualizer." + System.currentTimeMillis();
        AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
        builder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)title);
        builder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)identifier);
        IAttributeVisualizer adv = this.createVisualizer(builder);
        this.m_sectionPartManager.add((MCSectionPart)adv);
        Iterator it = this.m_attributeDescriptors.iterator();
        while (it.hasNext()) {
            adv.add((AttributeDescriptor)it.next());
        }
    }

    protected abstract IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder var1);

    /* synthetic */ NewVisualizerAction(SectionPartManager sectionPartManager, List list, NewVisualizerAction newVisualizerAction) {
        this(sectionPartManager, list);
    }
}

