/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.actions;

import com.jrockit.mc.console.ui.actions.Messages;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ui.IRefreshable;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoListener;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.subscription.internal.DefaultAttributeInfoService;
import org.eclipse.jface.action.Action;

public final class MBeanAutomaticRefreshAction
extends Action {
    private final IMBeanService m_mbeanService;
    private final IRefreshable m_refreshable;
    private final IAttributeInfoListener m_mbeanListener;

    public MBeanAutomaticRefreshAction(IMBeanService mbeanService, IRefreshable refreshable) {
        super("", 2);
        this.setText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TEXT);
        this.setToolTipText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TOOLTIP);
        this.setChecked(true);
        this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
        this.setDisabledImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("refresh_tab_grey.gif"));
        this.m_mbeanService = mbeanService;
        this.m_refreshable = refreshable;
        this.m_mbeanListener = this.createListener();
        this.setChecked(true);
        this.enabledStructuralMBeanUpdates();
    }

    private IAttributeInfoListener createListener() {
        return new IAttributeInfoListener(){

            public void attributeInfoChanged() {
                MBeanAutomaticRefreshAction.this.refresh();
            }
        };
    }

    public void run() {
        if (this.isChecked()) {
            this.enabledStructuralMBeanUpdates();
            this.refresh();
        } else {
            this.disableStructuralMBeanUpdates();
        }
    }

    private void refresh() {
        this.m_refreshable.refresh();
    }

    private void disableStructuralMBeanUpdates() {
        ((DefaultAttributeInfoService)this.getAttributeInfoService()).removeAttributeInfoListener(this.m_mbeanListener);
    }

    private void enabledStructuralMBeanUpdates() {
        ((DefaultAttributeInfoService)this.getAttributeInfoService()).addAttributeInfoListener(this.m_mbeanListener);
    }

    private IAttributeInfoService getAttributeInfoService() {
        return this.m_mbeanService.getAttributeInfoService();
    }
}

