/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.jdp;

import com.jrockit.common.jdp.ClientJDPPacket;
import com.jrockit.common.util.NativeToolkit;
import com.jrockit.console.jdp.DiscoveryHandler;
import com.jrockit.console.jdp.IgnoreListEvent;
import com.jrockit.console.jdp.IgnoreListListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JDPClient
implements Runnable {
    public static final String PROPERTY_KEY_JDP_PORT = "com.jrockit.console.preferences.jdp.port";
    public static final String PROPERTY_KEY_JDP_ADDRESS = "com.jrockit.console.preferences.jdp.address";
    private static final int BUFFER_LENGTH = 4096;
    private List m_exceptionHandlers = new LinkedList();
    protected List m_discoveryHandlers = Collections.synchronizedList(new LinkedList());
    private List m_ignoreListListeners = Collections.synchronizedList(new LinkedList());
    private boolean m_shutdown = false;
    private HashSet m_ignoreSet = new HashSet();

    public void run() {
        block5: {
            byte[] b = new byte[4096];
            DatagramPacket dgram = null;
            try {
                MulticastSocket socket = new MulticastSocket(this.getPort());
                dgram = new DatagramPacket(b, b.length);
                socket.joinGroup(InetAddress.getByName(this.getAddress()));
                while (!this.m_shutdown) {
                    socket.receive(dgram);
                    byte[] dgramData = dgram.getData();
                    short dataLength = NativeToolkit.getShortFromByteArray((byte[])dgramData, (int)0);
                    if (dataLength > 5 && dataLength < 4096) {
                        byte[] jdpPacketData = new byte[dgramData.length - 2];
                        System.arraycopy(dgramData, 2, jdpPacketData, 0, jdpPacketData.length);
                        ClientJDPPacket packet = new ClientJDPPacket(jdpPacketData);
                        if (packet.isComplete()) {
                            this.dispatchJDPPacket(packet);
                        }
                    }
                    dgram.setLength(b.length);
                    Thread.yield();
                }
            }
            catch (IOException e) {
                Iterator iter = this.m_exceptionHandlers.iterator();
                if (!iter.hasNext()) break block5;
                ExceptionHandler handler = (ExceptionHandler)iter.next();
                this.m_shutdown = true;
                handler.onException(e, "The JRockit Discovery Protocol Client has been disabled. Please ensure that you are connected to a network.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchJDPPacket(ClientJDPPacket jdpPacket) {
        if (this.isIgnored(jdpPacket)) {
            return;
        }
        List list = this.m_discoveryHandlers;
        synchronized (list) {
            Iterator iter = this.m_discoveryHandlers.iterator();
            while (iter.hasNext()) {
                DiscoveryHandler handler = (DiscoveryHandler)iter.next();
                handler.handleDiscovery(jdpPacket);
            }
        }
    }

    public void addDiscoveryHandler(DiscoveryHandler dh) {
        this.m_discoveryHandlers.add(dh);
    }

    public void addIgnoreListListener(IgnoreListListener ill) {
        this.m_ignoreListListeners.add(ill);
    }

    public void addExceptionHandler(ExceptionHandler eh) {
        this.m_exceptionHandlers.add(eh);
    }

    public void removeExceptionHandler(ExceptionHandler eh) {
        this.m_exceptionHandlers.remove(eh);
    }

    public void removeDiscoveryHandler(DiscoveryHandler dh) {
        this.m_discoveryHandlers.remove(dh);
    }

    public void removeIgnoreListListener(IgnoreListListener ill) {
        this.m_ignoreListListeners.remove(ill);
    }

    private int getPort() {
        String port = System.getProperty(PROPERTY_KEY_JDP_PORT, String.valueOf(7095));
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            return 7095;
        }
    }

    private String getAddress() {
        return System.getProperty(PROPERTY_KEY_JDP_ADDRESS, "232.192.1.212");
    }

    public void shutDown() {
        this.m_shutdown = true;
    }

    public boolean isIgnored(ClientJDPPacket packet) {
        return this.m_ignoreSet.contains(packet);
    }

    public void addToIgnoreList(ClientJDPPacket packet) {
        this.m_ignoreSet.add(packet);
        this.fireIgnoreListEvent(new IgnoreListEvent(0, packet));
    }

    public void addToIgnoreList(ClientJDPPacket packet, Object metadata) {
        this.m_ignoreSet.add(packet);
        this.fireIgnoreListEvent(new IgnoreListEvent(0, packet, metadata));
    }

    public void removeFromIgnoreList(ClientJDPPacket packet) {
        this.m_ignoreSet.remove(packet);
        this.fireIgnoreListEvent(new IgnoreListEvent(1, packet));
    }

    public void clearIgnoreList() {
        this.m_ignoreSet.clear();
        this.fireIgnoreListEvent(new IgnoreListEvent(2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIgnoreListEvent(IgnoreListEvent e) {
        List list = this.m_ignoreListListeners;
        synchronized (list) {
            Iterator iter = this.m_ignoreListListeners.iterator();
            while (iter.hasNext()) {
                IgnoreListListener ignoreListener = (IgnoreListListener)iter.next();
                ignoreListener.ignoreListChanged(e);
            }
        }
    }

    public static String getDottedAddress(String hostName) {
        try {
            if ("localhost".equals(hostName) || "127.0.0.1".equals(hostName)) {
                return JDPClient.getCanonicalLocalHost();
            }
            InetAddress addr = InetAddress.getByName(hostName);
            return addr.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getCanonicalLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected boolean checkAgainstCanonicalLocal(String address) {
        return address.equals(JDPClient.getCanonicalLocalHost());
    }

    public boolean isShutDown() {
        return this.m_shutdown;
    }

    public static interface ExceptionHandler {
        public void onException(Throwable var1, String var2);
    }
}

