/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.PersistentDataChart;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Widget;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.DateXAxis;
import se.hirt.greychart.impl.DefaultXYGreyChart;

public class UpdateChart
extends Job {
    private final long m_startTime;
    private final long m_endTime;
    private final PersistentDataChart m_chart;
    private final TracingDataProvider<ITimestampedData> m_provider;

    public UpdateChart(long startTime, long endTime, PersistentDataChart chart) {
        super("Updating chart for Historical Data");
        this.m_startTime = startTime;
        this.m_endTime = endTime;
        this.m_chart = chart;
        this.m_provider = chart.getChartModel().getDataProvider();
    }

    public IStatus run(IProgressMonitor monitor) {
        DisplayToolkit.safeSyncExec((Widget)this.m_chart, (Runnable)new Runnable(){

            public void run() {
                long margin = (UpdateChart.this.m_endTime - UpdateChart.this.m_startTime) / 50L;
                UpdateChart.this.m_provider.setDisplayedXRange(UpdateChart.this.m_endTime - UpdateChart.this.m_startTime + margin);
                UpdateChart.this.m_provider.setDisplayOffset(0L);
                UpdateChart.this.m_chart.updateMultipliersAndPaints();
                DefaultXYGreyChart xyChart = (DefaultXYGreyChart)UpdateChart.this.m_chart.getChartPanel().getChart();
                ((DateXAxis)xyChart.getXAxis()).setRange(UpdateChart.this.m_provider.getMinX(), UpdateChart.this.m_provider.getMaxX());
                UpdateChart.this.m_chart.redraw();
            }
        });
        return StatusFactory.createOk((String)"Historical Data chart updated successfully.");
    }
}

