/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataSeries;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.persistence.internal.PersistedEvent;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.TimestampedDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDataProvider
extends TimestampedDataProvider
implements TracingDataProvider<ITimestampedData> {
    private long displayOffset;
    private long displayedXRange;
    private PersistedData currentData;
    private PersistenceContext persistenceContext;
    private Range totalRange;
    private HashMap multiplierMap;
    private double[] multipliers;
    private final ArrayList<DataChangeListener> dataChangeListeners = new ArrayList();
    private final Map<AttributeDescriptor, DataSeries<ITimestampedData>> attributeToSeriesMap = new LinkedHashMap<AttributeDescriptor, DataSeries<ITimestampedData>>();
    private final DataChangeEvent structureChanged;

    public PersistentDataProvider(PersistenceContext context) {
        this.persistenceContext = context;
        this.totalRange = new Range();
        this.totalRange.update((Number)new Long(0L));
        this.multiplierMap = new HashMap();
        this.structureChanged = new DataChangeEvent((DataProvider)this, DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED);
    }

    public long getDisplayOffset() {
        return this.displayOffset;
    }

    public long getDisplayedXRange() {
        return this.displayedXRange;
    }

    public void setDisplayOffset(long offset) {
        this.displayOffset = offset;
        this.readData();
    }

    public void setDisplayedXRange(long range) {
        this.displayedXRange = range;
        this.readData();
    }

    private void readData() {
        long MAX_SCREEN_SIZE = 4000L;
        Number maxX = this.getMaxX();
        if (maxX == null) {
            return;
        }
        long to = maxX.longValue() - this.getDisplayOffset();
        long from = to - this.getDisplayedXRange();
        int resolution = (int)(this.displayedXRange / (MAX_SCREEN_SIZE * 2L));
        if (resolution < 1) {
            resolution = 1;
        }
        this.currentData = this.persistenceContext.readData(from, to, resolution);
        AttributeDescriptor[] descriptors = this.persistenceContext.getAttributeDescriptors();
        this.multipliers = new double[descriptors.length];
        this.totalRange = new Range();
        int i = 0;
        while (i < descriptors.length) {
            this.multipliers[i] = this.multiplierMap.containsKey(descriptors[i]) ? (Double)this.multiplierMap.get(descriptors[i]) : 1.0;
            List l = this.currentData.getAttributeEvents(descriptors[i]);
            PersistentDataSeries newSeries = new PersistentDataSeries(l, this.multipliers[i]);
            if (!this.attributeToSeriesMap.keySet().contains(descriptors[i])) {
                this.addDataSeries(newSeries);
                this.attributeToSeriesMap.put(descriptors[i], newSeries);
            }
            Range yRange = new Range();
            for (AttributeValueEvent evt : l) {
                Number multipliedValue = this.getMultipliedValue((Number)evt.getValue(), i);
                yRange.update(multipliedValue);
            }
            this.totalRange.update(yRange.getMaxValue());
            this.totalRange.update(yRange.getMinValue());
            ++i;
        }
        this.notifyDataChangeListeners(this.structureChanged);
    }

    private Number getMultipliedValue(Number valueToMultiply, int seriesNum) {
        if (valueToMultiply == null) {
            return null;
        }
        if (valueToMultiply instanceof Long) {
            return new Long((long)(valueToMultiply.doubleValue() * this.multipliers[seriesNum]));
        }
        return new Double(valueToMultiply.doubleValue() * this.multipliers[seriesNum]);
    }

    public void setTraceActive(boolean ignored) {
    }

    public boolean isTraceActive() {
        return true;
    }

    public Number getMaxX() {
        return this.persistenceContext.getLastTimestamp();
    }

    public Number getMaxY() {
        return this.totalRange.getMaxValue();
    }

    public Number getMinX() {
        return this.persistenceContext.getFirstTimestamp();
    }

    public Number getMinY() {
        return this.totalRange.getMinValue();
    }

    public int getSeriesValueCount(int series) {
        return this.currentData.getAttributeEvents(this.persistenceContext.getAttributeDescriptors()[series]).size();
    }

    public Number getXValue(int series, int index) {
        return new Long(((PersistedEvent)this.currentData.getAttributeEvents(this.persistenceContext.getAttributeDescriptors()[series]).get(index)).getTimestamp());
    }

    public Number getYValue(int series, int index) {
        return this.getMultipliedValue((Number)((PersistedEvent)this.currentData.getAttributeEvents(this.persistenceContext.getAttributeDescriptors()[series]).get(index)).getValue(), series);
    }

    public int getSeriesCount() {
        return this.persistenceContext.getAttributeDescriptors().length;
    }

    public String[] getSeriesNames() {
        String[] names = new String[this.getSeriesCount()];
        int i = 0;
        while (i < this.getSeriesCount()) {
            names[i] = this.persistenceContext.getAttributeDescriptors()[i].getAttributeName();
            ++i;
        }
        return names;
    }

    public int getNumberOfEntries() {
        int size = 0;
        int i = 0;
        while (i < this.getSeriesCount()) {
            size += this.getSeriesValueCount(i);
            ++i;
        }
        return size;
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.persistenceContext.getAttributeDescriptors();
    }

    public void setMultiplier(AttributeDescriptor descriptor, Double multiplier) {
        this.multiplierMap.put(descriptor, multiplier);
    }

    public DataSeries<ITimestampedData> getDataSeries(AttributeDescriptor attributeDescriptor) {
        return this.attributeToSeriesMap.get(attributeDescriptor);
    }

    public AttributeDescriptor getAttributeDescriptor(DataSeries<ITimestampedData> s) {
        for (AttributeDescriptor descriptor : this.attributeToSeriesMap.keySet()) {
            if (this.attributeToSeriesMap.get(descriptor) != s) continue;
            return descriptor;
        }
        return null;
    }

    public void addChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    private void notifyDataChangeListeners(DataChangeEvent event) {
        Iterator<DataChangeListener> iter = this.dataChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().onDataChange(event);
        }
    }
}

