/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.DisplayingAttributesDialog;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

class PersistentDataChart
extends ChartComposite {
    private PersistenceContextImpl contextImpl;
    private Button m_editButton;

    public PersistentDataChart(Composite parent, int style, FormToolkit toolkit, AttributeChartModel model, PersistenceContextImpl context) {
        super(parent, style, toolkit, model, null, new ChartComposite.IChartDataToolTipTextProvider(){

            public String getToolTipText(String seriesName, Number value, AttributeDescriptor attribute) {
                StringBuffer tooltip = new StringBuffer();
                tooltip.append(seriesName);
                tooltip.append(": ");
                tooltip.append(NumberField.formatNumber((Number)value));
                tooltip.append(" (");
                tooltip.append(MBeanPropertiesOrderer.getAttributePath((AttributeDescriptor)attribute));
                tooltip.append(")");
                return tooltip.toString();
            }
        });
        this.contextImpl = context;
        model.setAllowNegativeDisplayOffsets(true);
    }

    protected void createButtons(Composite parent, FormToolkit toolkit) {
        this.m_editButton = toolkit.createButton(parent, Messages.HistoricalDataPage_BUTTON_EDIT_TEXT, 0);
        this.m_editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayingAttributesDialog dialog = new DisplayingAttributesDialog(PersistentDataChart.this.m_editButton.getShell(), PersistentDataChart.this.getChartModel().getGraphSettingsRegistry());
                dialog.create();
                dialog.setAttributes(PersistentDataChart.this.contextImpl.getAllAttributeDescriptors(), PersistentDataChart.this.contextImpl.getAttributeDescriptors());
                if (dialog.open() == 0) {
                    PersistentDataChart.this.contextImpl.disableAttributes(dialog.getDisabledAttributes());
                    PersistentDataChart.this.getChartModel().setAttributeDescriptors(PersistentDataChart.this.contextImpl.getAttributeDescriptors());
                    PersistentDataChart.this.getChartModel().notifyObservers();
                }
            }
        });
        this.m_editButton.setEnabled(false);
    }

    protected void updateMultipliersAndPaints() {
        super.updateMultipliersAndPaints();
        this.getChartModel().getDataProvider().setDisplayOffset(this.getChartModel().getDataProvider().getDisplayOffset());
        this.redraw();
    }

    public void setEditButtonEnabled(boolean enabled) {
        this.m_editButton.setEnabled(enabled);
    }
}

