/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataChart;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceReadManager;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Display;

class PersistenceContextImpl
implements PersistenceContext {
    private final String connectionUid;
    private final File persistenceDirectory;
    private PersistedData lastReadData;
    private Set disabledAttributes;
    private Range lastReadRange;
    private PersistentDataChart chart;

    public PersistenceContextImpl(String uid, File directory) {
        this.persistenceDirectory = directory;
        this.connectionUid = uid;
        this.disabledAttributes = new HashSet();
    }

    protected void setChart(PersistentDataChart persistentChart) {
        this.chart = persistentChart;
    }

    AttributeDescriptor[] getAllAttributeDescriptors() {
        if (this.lastReadData == null) {
            return new AttributeDescriptor[0];
        }
        Set attributeDescriptors = this.lastReadData.getAttributeDescriptorSet();
        return attributeDescriptors.toArray(new AttributeDescriptor[attributeDescriptors.size()]);
    }

    void disableAttributes(AttributeDescriptor[] descriptors) {
        this.disabledAttributes.clear();
        int i = 0;
        while (i < descriptors.length) {
            this.disabledAttributes.add(descriptors[i]);
            ++i;
        }
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        if (this.lastReadData == null) {
            return new AttributeDescriptor[0];
        }
        HashSet attributeDescriptorsCopy = new HashSet(this.lastReadData.getAttributeDescriptorSet());
        attributeDescriptorsCopy.removeAll(this.disabledAttributes);
        return attributeDescriptorsCopy.toArray(new AttributeDescriptor[attributeDescriptorsCopy.size()]);
    }

    public PersistedData readData(long from, long to, int resolution) {
        try {
            this.lastReadData = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedData(from, to, (long)resolution);
            HashSet attributesToDisable = new HashSet(this.lastReadData.getAttributeDescriptorSet());
            attributesToDisable.removeAll((Collection)Arrays.asList(this.chart.getChartModel().getAttributesInTable()));
            this.disabledAttributes = new HashSet(attributesToDisable);
            return this.lastReadData;
        }
        catch (IOException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.HistoricalDataPage_ERROR_READING_HISTORICAL_DATA_TITLE, (String)Messages.HistoricalDataPage_ERROR_READING_HISTORICAL_DATA_TEXT, (Throwable)e);
            return new PersistedData(from, to, (long)resolution);
        }
    }

    public Number getFirstTimestamp() {
        if (this.lastReadRange == null) {
            return null;
        }
        return this.lastReadRange.getMinValue();
    }

    public Number getLastTimestamp() {
        if (this.lastReadRange == null) {
            return null;
        }
        return this.lastReadRange.getMaxValue();
    }

    public Range readPersistedRange() throws IOException {
        this.lastReadRange = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedRange();
        return this.lastReadRange;
    }

    public Range readRangeForAttributes(AttributeDescriptor[] attributes) {
        this.lastReadRange = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedRangeForAttributes(attributes);
        return this.lastReadRange;
    }
}

