/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.HistoricalData;
import com.jrockit.mc.console.historicaldata.editors.HistoricalDataEditorInput;
import com.jrockit.mc.console.historicaldata.editors.HistoricalDataTab;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.internal.MCFormEditor;
import java.io.File;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class HistoricalDataEditor
extends MCFormEditor {
    public static final String UNKNOWN_UID = "-1";
    private HistoricalDataTab historicalDataEditorPage;

    public int promptToSaveOnClose() {
        return 1;
    }

    protected void addPages() {
        try {
            File logFile = CorePlugin.getDefault().getIDESupport().getFileFromEditorInput(this.getEditorInput());
            if (logFile != null) {
                this.addPageFromFile(logFile);
            } else {
                if (this.getEditorInput() instanceof HistoricalDataEditorInput) {
                    this.addPageFromEditorInput((HistoricalDataEditorInput)this.getEditorInput());
                }
                HistoricalDataEditorInput input = (HistoricalDataEditorInput)this.getEditorInput();
                String uid = input.getUid();
                if (this.getPageCount() > 0) {
                    this.setPageImage(0, HistoricalData.getDefault().getImage("historic-data-16.gif"));
                }
            }
        }
        catch (PartInitException e) {
            HistoricalData.getDefault().getLogger().log(Level.SEVERE, "Could not create tab page");
        }
    }

    private void addPageFromEditorInput(HistoricalDataEditorInput input) throws PartInitException {
        File persistenceDirectory = input.getPersistenceDirectory();
        String uid = input.getUid();
        if (uid != null) {
            this.addPage(this.getHistoricalDataEditorPage(uid, persistenceDirectory));
        }
    }

    private void addPageFromFile(File logFile) throws PartInitException {
        String uid = this.extractUID(logFile.getName());
        if (uid != UNKNOWN_UID) {
            this.addPage(this.getHistoricalDataEditorPage(uid, logFile.getParentFile()));
        }
    }

    private String extractUID(String fileName) {
        int n = fileName.indexOf(95);
        if (n > 0) {
            return fileName.substring(0, n);
        }
        return UNKNOWN_UID;
    }

    private IFormPage getHistoricalDataEditorPage(String uid, File fileName) {
        if (this.historicalDataEditorPage == null) {
            this.historicalDataEditorPage = new HistoricalDataTab((FormEditor)this, uid, fileName);
        }
        return this.historicalDataEditorPage;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

