/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.actions;

import com.jrockit.mc.browser.views.JRockitBrowserToolkit;
import com.jrockit.mc.console.historicaldata.HistoricalData;
import com.jrockit.mc.console.historicaldata.editors.HistoricalDataEditorInput;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceFileManager;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenConnectionDataAction
implements IViewActionDelegate {
    private IViewPart viewPart;
    private ConnectionDescriptorNode selectedNode;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        this.viewPart.getViewSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorInput input = OpenConnectionDataAction.this.createEditorInput(OpenConnectionDataAction.this.viewPart.getViewSite().getWorkbenchWindow().getShell(), OpenConnectionDataAction.this.selectedNode);
                String editorId = OpenConnectionDataAction.this.getEditorId(OpenConnectionDataAction.this.viewPart.getViewSite().getWorkbenchWindow().getWorkbench());
                IWorkbenchPage page = OpenConnectionDataAction.this.viewPart.getViewSite().getWorkbenchWindow().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor(input, editorId);
                }
                catch (PartInitException e) {
                    HistoricalData.getDefault().getLogger().log(Level.WARNING, "Could not open Historical Data Editor.", e);
                }
            }
        });
    }

    private String getEditorId(IWorkbench workbench) {
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor("x" + PersistenceFileManager.getSuffix());
        if (descriptor == null) {
            HistoricalData.getDefault().getLogger().log(Level.SEVERE, "No default editor for " + PersistenceFileManager.getSuffix() + " files found");
            return "";
        }
        return descriptor.getId();
    }

    public IEditorInput createEditorInput(Shell shell, ConnectionDescriptorNode node) {
        return new HistoricalDataEditorInput(node);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Set s1;
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (s1 = JRockitBrowserToolkit.getAdaptedSelection((ISelection)selection, ConnectionDescriptorNode.class)).size() == 1) {
            action.setEnabled(true);
            this.selectedNode = (ConnectionDescriptorNode)s1.iterator().next();
            return;
        }
        this.selectedNode = null;
        action.setEnabled(false);
    }
}

