/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata;

import com.jrockit.mc.console.historicaldata.HistoricalData;
import com.jrockit.mc.console.historicaldata.Messages;
import com.jrockit.mc.core.MCPathEditorInput;
import com.jrockit.mc.core.idesupport.OpenHandler;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceFileManager;
import java.io.File;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class HistoricalDataFileOpener
extends OpenHandler {
    public void open(IWorkbenchWindow window, Object object) {
        Shell shell = window.getShell();
        assert (object instanceof File);
        if (object instanceof File) {
            File file = (File)object;
            if (file.exists()) {
                MCPathEditorInput input = new MCPathEditorInput((IPath)new Path(file.getAbsolutePath()), true);
                String editorId = HistoricalDataFileOpener.getEditorId(window.getWorkbench(), file);
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException e) {
                    HistoricalData.getDefault().getLogger().log(Level.WARNING, "Could not open Historical Data Editor.", e);
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)Messages.HistoricalDataToolkit_DIALOG_COULD_NOT_FIND_FILE_TITLE, (String)NLS.bind((String)Messages.HistoricalDataToolkit_DIALOG_COULD_NOT_FIND_FILE_TEXT, (Object)file.getPath()));
            }
        }
    }

    private static String getEditorId(IWorkbench workbench, File file) {
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor("x" + PersistenceFileManager.getSuffix());
        if (descriptor == null) {
            HistoricalData.getDefault().getLogger().log(Level.SEVERE, "No default editor for " + PersistenceFileManager.getSuffix() + " files found");
            return "";
        }
        return descriptor.getId();
    }
}

