/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.valueinfo;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.AttributeValueInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.management.openmbean.CompositeData;

public abstract class SingleValueInfo
extends AttributeValueInfo {
    private Object value;
    private final String description;
    private final boolean primitive;
    static /* synthetic */ Class class$0;

    public SingleValueInfo(Object parent, Object value) {
        this(parent, value, false);
    }

    public SingleValueInfo(Object parent, Object value, boolean primitive) {
        this(parent, value, primitive, "");
    }

    public SingleValueInfo(Object parent, Object value, String description) {
        this(parent, value, false, description);
    }

    public SingleValueInfo(Object parent, Object value, boolean primitive, String description) {
        super(parent);
        this.value = value;
        this.primitive = primitive;
        this.description = description;
    }

    public boolean hasChildren() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Collection) {
            return ((Collection)this.value).size() > 0;
        }
        if (this.value instanceof Map) {
            return ((Map)this.value).size() > 0;
        }
        if (this.value.getClass().isArray()) {
            return Array.getLength(this.value) > 0;
        }
        return this.value instanceof CompositeData;
    }

    public AttributeValueInfo[] getChildren() {
        return SingleValueInfo.buildAttributeValueInfos((Object)this, this.value);
    }

    public String getValueColumnText() {
        return TypeHandling.getValueString(this.value);
    }

    public String getTypeColumnText() {
        if (this.primitive) {
            return TypeHandling.getPrimitiveTypeName(this.value);
        }
        return TypeHandling.simplifyType(this.getType().getName());
    }

    public String getDescriptionColumnText() {
        return this.description;
    }

    public Class getType() {
        if (this.value == null) {
            Class type;
            Object parent = this.getParent();
            if (parent instanceof IAttributeInfo) {
                try {
                    type = TypeHandling.getClassWithName(((IAttributeInfo)parent).getAttributeType());
                }
                catch (ClassNotFoundException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    type = clazz;
                }
            } else {
                type = ((SingleValueInfo)parent).getType();
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return this.value.getClass();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object attributeValue, Object value) {
        this.value = value;
    }
}

