/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.valueinfo;

import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.ArrayPartValueInfo;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.LabeledValueInfo;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.NumberedValueInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public abstract class AttributeValueInfo {
    private static volatile int aggregateSize = RJMXUIPlugin.getDefault().getPreferenceStore().getInt("console.ui.mbeanbrowser.aggregateSize");
    private Object parent;

    public static void setAggregateSize(int aggregateSize) {
        AttributeValueInfo.aggregateSize = aggregateSize <= 1 ? 2 : (aggregateSize >= 10000 ? 10000 : aggregateSize);
    }

    private static AttributeValueInfo[] buildCompositeAttributeValueInfos(Object parent, Object array, int startIndex, int endIndex) {
        int length = endIndex - startIndex + 1;
        int size = 1;
        do {
            size *= aggregateSize;
        } while ((length /= aggregateSize) > aggregateSize);
        AttributeValueInfo[] valueInfos = new AttributeValueInfo[(endIndex - startIndex) / size + 1];
        int i = 0;
        while (i < valueInfos.length) {
            int thisStartIndex = startIndex + i * size;
            int thisEndIndex = Math.min(thisStartIndex + size - 1, endIndex);
            valueInfos[i] = new ArrayPartValueInfo(parent, array, thisStartIndex, thisEndIndex);
            ++i;
        }
        return valueInfos;
    }

    protected static AttributeValueInfo[] buildAttributeValueInfos(Object parent, Object array, int startIndex, int endIndex) {
        int length = endIndex - startIndex + 1;
        if (length > aggregateSize) {
            return AttributeValueInfo.buildCompositeAttributeValueInfos(parent, array, startIndex, endIndex);
        }
        if (array instanceof AttributeValueInfo[]) {
            AttributeValueInfo[] valueInfos = new AttributeValueInfo[endIndex - startIndex + 1];
            System.arraycopy(array, startIndex, valueInfos, 0, valueInfos.length);
            return valueInfos;
        }
        boolean primitive = array.getClass().getComponentType().isPrimitive();
        AttributeValueInfo[] valueInfos = new AttributeValueInfo[endIndex - startIndex + 1];
        int i = 0;
        while (i < valueInfos.length) {
            int valuesIndex = startIndex + i;
            valueInfos[i] = new NumberedValueInfo(parent, Array.get(array, valuesIndex), primitive, valuesIndex);
            ++i;
        }
        return valueInfos;
    }

    private static AttributeValueInfo[] buildAttributeValueInfos(Object parent, CompositeData data) {
        CompositeType type = data.getCompositeType();
        Set<String> keySet = type.keySet();
        AttributeValueInfo[] valueInfos = new AttributeValueInfo[keySet.size()];
        Iterator<String> iter = keySet.iterator();
        int n = 0;
        while (iter.hasNext()) {
            String key = iter.next();
            String description = type.getDescription(key);
            valueInfos[n] = new LabeledValueInfo(parent, data.get(key), description, "#" + key);
            ++n;
        }
        if (valueInfos.length > aggregateSize) {
            valueInfos = AttributeValueInfo.buildCompositeAttributeValueInfos(parent, valueInfos, 0, valueInfos.length - 1);
        }
        return valueInfos;
    }

    private static AttributeValueInfo[] buildAttributeValueInfos(Object parent, TabularData data) {
        AttributeValueInfo[] valueInfos = new AttributeValueInfo[data.size()];
        Iterator<?> iter = data.values().iterator();
        int n = 0;
        while (iter.hasNext()) {
            valueInfos[n] = new NumberedValueInfo(parent, iter.next(), n);
            ++n;
        }
        if (valueInfos.length > aggregateSize) {
            valueInfos = AttributeValueInfo.buildCompositeAttributeValueInfos(parent, valueInfos, 0, valueInfos.length - 1);
        }
        return valueInfos;
    }

    private static AttributeValueInfo[] buildAttributeValueInfos(Object parent, Map map) {
        Set entrySet = map.entrySet();
        AttributeValueInfo[] valueInfos = new AttributeValueInfo[entrySet.size()];
        Iterator iter = entrySet.iterator();
        int n = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            valueInfos[n] = new LabeledValueInfo(parent, entry.getValue(), entry.getKey().toString());
            ++n;
        }
        Arrays.sort(valueInfos, LabeledValueInfo.LABEL_COMPARATOR);
        if (valueInfos.length > aggregateSize) {
            valueInfos = AttributeValueInfo.buildCompositeAttributeValueInfos(parent, valueInfos, 0, valueInfos.length - 1);
        }
        return valueInfos;
    }

    public static AttributeValueInfo[] buildAttributeValueInfos(Object parent, Object value) {
        if (value.getClass().isArray()) {
            return AttributeValueInfo.buildAttributeValueInfos(parent, value, 0, Array.getLength(value) - 1);
        }
        if (value instanceof Collection) {
            return AttributeValueInfo.buildAttributeValueInfos(parent, ((Collection)value).toArray());
        }
        if (value instanceof CompositeData) {
            return AttributeValueInfo.buildAttributeValueInfos(parent, (CompositeData)value);
        }
        if (value instanceof TabularData) {
            return AttributeValueInfo.buildAttributeValueInfos(parent, (TabularData)value);
        }
        if (value instanceof Map) {
            return AttributeValueInfo.buildAttributeValueInfos(parent, (Map)value);
        }
        return null;
    }

    public AttributeValueInfo(Object parent) {
        if (!(parent instanceof IAttributeInfo) && !(parent instanceof AttributeValueInfo)) {
            throw new IllegalArgumentException("Parent is of illegal type " + parent.getClass());
        }
        this.parent = parent;
    }

    protected Object getParent() {
        return this.parent;
    }

    public abstract boolean hasChildren();

    public abstract AttributeValueInfo[] getChildren();

    public abstract String getNameColumnText();

    public abstract String getValueColumnText();

    public String getUpdateColumnText() {
        return "";
    }

    public abstract String getTypeColumnText();

    public String getDescriptionColumnText() {
        return "";
    }

    public IAttributeInfo getAttributeInfo() {
        Object parent = this.getParent();
        while (!(parent instanceof IAttributeInfo)) {
            parent = ((AttributeValueInfo)parent).getParent();
        }
        return (IAttributeInfo)parent;
    }

    public boolean isEditable(ValueEditorFactory factory) {
        return false;
    }
}

