/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tree;

import com.jrockit.mc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeFilter;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.ObjectNameProvider;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.sections.ViewerSectionPart;
import com.jrockit.mc.core.ui.IRefreshable;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeOrderRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanTreeSectionPart
extends ViewerSectionPart {
    private MBeanTreeFilter m_filter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MBeanTreeSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.MBeanTreeSectionPart_MBEAN_TREE_TITLE_TEXT);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializePart() {
        super.initializePart();
        if (!this.getConnectionHandle().isConnected()) {
            return;
        }
        this.m_filter = new MBeanTreeFilter((Job)new MBeanTreeRefreshJob((TreeViewer)this.m_viewer));
        this.getTreeViewer().setFilters(new ViewerFilter[]{this.m_filter});
        this.getTreeViewer().setInput((Object)this.getMBeanService());
        this.addRefreshAction();
        this.setupDoubleClickListener();
    }

    private void addRefreshAction() {
        this.getMCToolBarManager().add((IAction)new MBeanAutomaticRefreshAction(this.getMBeanService(), new IRefreshable(){

            public boolean refresh() {
                DisplayToolkit.safeAsyncExec((Widget)MBeanTreeSectionPart.this.getTreeViewer().getControl(), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).updateMBeanTreeStructure();
                    }
                });
                return true;
            }

            static /* synthetic */ MBeanTreeSectionPart access$0(1 var0) {
                return var0.MBeanTreeSectionPart.this;
            }
        }));
    }

    protected void updateMBeanTreeStructure() {
        this.updateMBeanTreeWithinOneSecond();
    }

    private void updateMBeanTreeWithinOneSecond() {
        MBeanTreeSectionPart channel = this;
        DisplayToolkit.safeWithinExec((Widget)this.getSection(), (int)1000, (Object)((Object)channel), (Runnable)new Runnable(){

            public void run() {
                new MBeanTreeOrderRefreshJob(MBeanTreeSectionPart.this.getTreeViewer()).schedule();
            }
        });
    }

    protected Composite createTopControl(FormToolkit toolkit, Composite parent) {
        Composite filterComposite = toolkit.createComposite(parent);
        toolkit.paintBordersFor(filterComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        filterComposite.setLayout((Layout)layout);
        Label filterLabel = toolkit.createLabel(filterComposite, Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        final Text filterText = toolkit.createText(filterComposite, new String());
        filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!filterText.isDisposed()) {
                    MBeanTreeSectionPart.this.m_filter.setFilterText(filterText.getText());
                }
            }
        });
        return filterComposite;
    }

    protected Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite container = formToolkit.createComposite(section, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Composite top = this.createTopControl(formToolkit, container);
        top.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        return container;
    }

    protected Viewer createViewer(Composite parent) {
        Tree tree = this.getFormToolkit().createTree(parent, 0);
        tree.setData("name", (Object)"mbeanbrowser.MBeanTree");
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, true));
        viewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(viewer));
        return viewer;
    }

    protected void setupSelectionListeners() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MBeanTreeSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)MBeanTreeSectionPart.this, new ObjectNameProvider(event.getSelectionProvider()).getSelection());
            }
        });
    }

    private void setupDoubleClickListener() {
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITreeNode elementNode = (ITreeNode)selection.getFirstElement();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.management.ObjectName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (elementNode.getAdapter((Class)clazz) == null) {
                    MBeanTreeSectionPart.this.getTreeViewer().setExpandedState((Object)elementNode, !MBeanTreeSectionPart.this.getTreeViewer().getExpandedState((Object)elementNode));
                }
            }
        });
    }

    private TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    private IMBeanService getMBeanService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMBeanService)iConnectionHandle.getService((Class)clazz);
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }
}

