/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.operations;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorDialog;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.operations.Messages;
import javax.management.MBeanParameterInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OperationParametersDialog
extends MessageDialog {
    private static final String[] BUTTONTEXTS = new String[]{Messages.OperationsParametersDialog_BUTTON_OK_TEXT, Messages.OperationsParametersDialog_BUTTON_CANCEL_TEXT};
    private final Object[] m_values;
    private final MBeanParameterInfo[] m_parameterInfos;

    public OperationParametersDialog(Shell parentShell, MBeanParameterInfo[] paramInfos) {
        super(parentShell, Messages.OperationsParametersDialog_DIALOG_ENTER_PARAMETER_VALUES_TITLE, null, null, 0, BUTTONTEXTS, 0);
        this.m_values = new Object[paramInfos.length];
        this.m_parameterInfos = paramInfos;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    protected Control createCustomArea(Composite parent) {
        try {
            return this.createInputWidgets(parent);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    private Control createInputWidgets(Composite parent) throws ClassNotFoundException {
        Composite container = new Composite(parent, 0);
        int index = 0;
        while (index < this.m_parameterInfos.length) {
            Class type = TypeHandling.getClassWithName(this.m_parameterInfos[index].getType());
            GridData gd1 = new GridData(0x1000000, 0x1000000, true, false);
            Label typeNameLabel = this.createTypeLabel(container, type);
            typeNameLabel.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(0x1000000, 0x1000000, true, false);
            Label separator = this.createNameLabel(container, this.m_parameterInfos[index]);
            separator.setLayoutData((Object)gd2);
            GridData gd3 = new GridData(4, 4, true, false);
            gd3.minimumWidth = 100;
            Button paramButton = this.createParameterButton(container, type, index);
            paramButton.setLayoutData((Object)gd3);
            ++index;
        }
        container.setLayout((Layout)new GridLayout(3, false));
        return container;
    }

    private Label createTypeLabel(Composite parent, Class type) {
        Label label = new Label(parent, 0);
        label.setText(TypeHandling.simplifyType(type.getName()));
        return label;
    }

    private Label createNameLabel(Composite parent, MBeanParameterInfo info) {
        Label label = new Label(parent, 0);
        label.setText(info.getName());
        if (info.getDescription() != null) {
            label.setToolTipText(info.getDescription());
        }
        return label;
    }

    private Button createParameterButton(final Composite parent, final Class type, final int index) {
        final Button button = new Button(parent, 0);
        button.setText(TypeHandling.simplifyType(type.getName()));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InspectorDialog editorDialog = new InspectorDialog(parent.getShell(), Messages.OperationsParametersDialog_DIALOG_ENTER_VALUE_TITLE, type, OperationParametersDialog.this.m_values[index], true);
                editorDialog.setValueChangeListener(new ValueChangedListener(this, index, editorDialog, button){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ InspectorDialog val$editorDialog;
                    private final /* synthetic */ Button val$button;
                    {
                        this.this$1 = var1_1;
                        this.val$index = n;
                        this.val$editorDialog = inspectorDialog;
                        this.val$button = button;
                    }

                    public void valueChanged(boolean changed) {
                        if (changed) {
                            OperationParametersDialog.access$0((OperationParametersDialog)1.access$0(this.this$1))[this.val$index] = this.val$editorDialog.getInspectedValue();
                            this.val$button.setText(TypeHandling.getValueString(OperationParametersDialog.access$0(1.access$0(this.this$1))[this.val$index]));
                        }
                    }
                });
                editorDialog.open();
            }

            static /* synthetic */ OperationParametersDialog access$0(1 var0) {
                return var0.OperationParametersDialog.this;
            }
        });
        return button;
    }
}

