/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.operations;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorDialog;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import com.jrockit.mc.console.ui.mbeanbrowser.operations.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.operations.OperationModel;
import com.jrockit.mc.console.ui.mbeanbrowser.operations.OperationParametersDialog;
import com.jrockit.mc.console.ui.mbeanbrowser.operations.TextResponseMessageDialog;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class InvokeOperationAction
extends Action {
    private final StructuredViewer m_structuredViewer;
    private final OperationModel m_model;
    static /* synthetic */ Class class$0;

    public InvokeOperationAction(StructuredViewer viewer, OperationModel model) {
        this.m_structuredViewer = viewer;
        this.m_model = model;
    }

    public StructuredViewer getViewer() {
        return this.m_structuredViewer;
    }

    public void run() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.m_structuredViewer.getSelection();
        if (!structuredSelection.isEmpty()) {
            ObjectName name = this.m_model.getMBean();
            MBeanOperationInfo operation = (MBeanOperationInfo)((IStructuredSelection)this.m_structuredViewer.getSelection()).getFirstElement();
            this.invokeMBeanOperation(name, operation);
        }
    }

    private void invokeMBeanOperation(ObjectName name, MBeanOperationInfo operation) {
        MBeanParameterInfo[] paramInfos = operation.getSignature();
        ValueEditorFactory factory = new ValueEditorFactory();
        Object response = null;
        if (paramInfos.length == 0) {
            response = this.m_model.invokeOperation(name, operation, new Object[0]);
        } else {
            int i = 0;
            while (i < paramInfos.length) {
                if (!factory.isTypeInspectable(paramInfos[i].getType())) {
                    DialogToolkit.showError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.InvokeOperationAction_DIALOG_UNABLE_TO_INVOKE_TITLE, (String)(String.valueOf(Messages.InvokeOperationAction_DIALOG_UNABLE_TO_INVOKE_TEXT) + paramInfos[i].getType()));
                    return;
                }
                ++i;
            }
            OperationParametersDialog d = new OperationParametersDialog(this.getViewer().getControl().getShell(), paramInfos);
            if (d.open() != 0) {
                return;
            }
            response = this.m_model.invokeOperation(name, operation, d.getValues());
        }
        if (response != OperationModel.OPERATION_FAILED) {
            if (!operation.getReturnType().equals(Void.TYPE.getName())) {
                this.presentResponseToUser(response);
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.InvokeOperationAction_DIALOG_INVOCATION_SUCCESS_TITLE, (String)Messages.InvokeOperationAction_DIALOG_INVOCATION_SUCCESS_TEXT);
            }
        }
    }

    private void presentResponseToUser(Object response) {
        if (response == null) {
            response = new String("null");
        }
        if (response.getClass().isArray() || response instanceof Collection || response instanceof CompositeData || response instanceof TabularData || response instanceof Map) {
            InspectorDialog d = new InspectorDialog(Display.getCurrent().getActiveShell(), Messages.InvokeOperationAction_DIALOG_OPERATION_RETURNED_TITLE, response.getClass(), response, false);
            d.open();
        } else {
            TextResponseMessageDialog dialog = new TextResponseMessageDialog(Display.getCurrent().getActiveShell(), Messages.InvokeOperationAction_DIALOG_OPERATION_RETURNED_TITLE, null, TypeHandling.getValueString(response), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
        }
    }
}

