/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.notifications;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationInfoSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationLogSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.core.sections.MCClientSectionPart;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NotificationSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private NotificationInfoSectionPart infoSectionPart;
    private NotificationLogSectionPart logSectionPart;
    private Object m_lastName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NotificationSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    protected Composite createClient(IManagedForm managedForm, FormToolkit formToolkit, Composite section) {
        SashForm sashForm = new SashForm(section, 512);
        this.infoSectionPart = new NotificationInfoSectionPart((Composite)sashForm, managedForm.getToolkit(), MCSectionPart.getAccessibilityDescriptionStyle(), "mbean.tab.details.information.tab.general");
        managedForm.addPart((IFormPart)this.infoSectionPart);
        this.infoSectionPart.refresh();
        this.logSectionPart = new NotificationLogSectionPart((Composite)sashForm, managedForm.getToolkit(), MCSectionPart.getAccessibilityDescriptionStyle(), "mbean.tab.details.information.tab.log");
        managedForm.addPart((IFormPart)this.logSectionPart);
        this.logSectionPart.refresh();
        sashForm.setWeights(new int[]{1, 3});
        return sashForm;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        block8: {
            IStructuredSelection structuredSelection;
            ObjectName objectName;
            if (part instanceof MBeanTreeSectionPart && !selection.isEmpty() && !(objectName = (ObjectName)(structuredSelection = (IStructuredSelection)selection).getFirstElement()).equals(this.m_lastName)) {
                this.m_lastName = objectName;
                try {
                    NotificationsModel model;
                    block10: {
                        if (AttributeValueToolkit.isSynthetic(objectName)) break block8;
                        model = null;
                        try {
                            model = new NotificationsModel(objectName, this.getMBeanServerConnection().getMBeanInfo(objectName), this.getConnectionHandle());
                        }
                        catch (InstanceNotFoundException e) {
                            IConnectionHandle iConnectionHandle = this.getConnectionHandle();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.subscription.IMBeanHelperService");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (((IMBeanHelperService)iConnectionHandle.getService((Class)clazz)).getMBeanInfo(objectName) == null) break block10;
                            throw e;
                        }
                    }
                    this.infoSectionPart.setFormInput(model);
                    this.logSectionPart.setFormInput(model);
                }
                catch (Exception e) {
                    DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.NotificationSectionPart_PROBLEM_GETTING_NOTIFICATION_INFO_TEXT, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void initializeSection(Section section) {
    }

    private MBeanServerConnection getMBeanServerConnection() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.management.MBeanServerConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MBeanServerConnection)iConnectionHandle.getService((Class)clazz);
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }
}

