/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorDialog;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationEvent;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ValueEditorFactory {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public void addValueInspectorMenuItem(MenuManager menuMgr, final StructuredViewer viewer, final InspectorContext context) {
        menuMgr.addMenuListener(new IMenuListener(){
            InspectorAction inspectAction;

            public void menuAboutToShow(IMenuManager mgr) {
                Class typeToInspect;
                if (context.canInspect() && ValueEditorFactory.this.isTypeInspectable(typeToInspect = context.getTypeToInspect())) {
                    boolean editable = context.canEdit() && ValueEditorFactory.this.isTypeEditable(typeToInspect);
                    String actionTitle = editable ? Messages.ValueEditorFactory_BUTTON_EDIT_TEXT : Messages.ValueEditorFactory_BUTTON_INSPECT_TEXT;
                    ValueChangedListener callback = new ValueChangedListener(this, context){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ InspectorContext val$context;
                        {
                            this.this$1 = var1_1;
                            this.val$context = inspectorContext;
                        }

                        public void valueChanged(boolean changed) {
                            if (changed) {
                                this.val$context.setValue(this.this$1.inspectAction.getValue());
                            }
                        }
                    };
                    this.inspectAction = new InspectorAction(actionTitle, ValueEditorFactory.getDialogTitle(editable), viewer, editable, typeToInspect, context.getValueToInspect());
                    this.inspectAction.setValueChangedListener(callback);
                    this.inspectAction.setEnabled(true);
                    mgr.prependToGroup("additions", (IAction)this.inspectAction);
                }
            }
        });
    }

    public boolean isTypeInspectable(String type) {
        try {
            return this.isTypeInspectable(TypeHandling.getClassWithName(type));
        }
        catch (ClassNotFoundException fallThrough) {
            return false;
        }
    }

    public boolean isTypeInspectable(Class c) {
        if (!this.isTypeEditable(c)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.management.openmbean.CompositeData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(c)) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("javax.management.openmbean.TabularData");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isAssignableFrom(c)) {
                    Class<?> clazz3 = class$3;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$3 = Class.forName("java.util.Collection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz3.isAssignableFrom(c)) {
                        Class<?> clazz4 = class$4;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$4 = Class.forName("java.util.Map");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz4.isAssignableFrom(c)) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean isTypeEditable(String type) {
        try {
            return this.isTypeEditable(TypeHandling.getClassWithName(type));
        }
        catch (ClassNotFoundException fallThrough) {
            return false;
        }
    }

    public boolean isTypeEditable(Class c) {
        if (!c.isPrimitive() && !c.isArray()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c != clazz) {
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (c != clazz2) {
                    Class<?> clazz3 = class$6;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$6 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (c != clazz3) {
                        Class<?> clazz4 = class$7;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$7 = Class.forName("java.lang.Number");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz4.isAssignableFrom(c)) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public ValueEditor createEditorForType(Composite parent, Class type, boolean editable, boolean editInDialog) {
        block49: {
            block59: {
                block58: {
                    block57: {
                        block56: {
                            block55: {
                                if (type == null) break block49;
                                Class<?> clazz = class$8;
                                if (clazz == null) {
                                    try {
                                        clazz = class$8 = Class.forName("com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory$NullValueType");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type == clazz) break block49;
                                if (type == Boolean.TYPE) break block55;
                                Class<?> clazz2 = class$5;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = class$5 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type != clazz2) break block56;
                            }
                            return new BooleanValueEditor(parent, editable, editInDialog);
                        }
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type == clazz) {
                            return new StringValueEditor(parent, editable, editInDialog);
                        }
                        if (type == Character.TYPE) break block57;
                        Class<?> clazz3 = class$6;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$6 = Class.forName("java.lang.Character");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type != clazz3) break block58;
                    }
                    return new CharacterValueEditor(parent, editable, editInDialog);
                }
                if (type.isPrimitive()) {
                    try {
                        return new NumberValueEditor(parent, TypeHandling.getClassWithName(type.getName()), editable, editInDialog);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break block49;
                    }
                }
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(type)) {
                    return new NumberValueEditor(parent, type, editable, editInDialog);
                }
                if (type.isArray()) {
                    return new ComplexDataEditor(type, editable);
                }
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("javax.management.openmbean.TabularData");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz4.isAssignableFrom(type)) break block59;
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("javax.management.openmbean.CompositeData");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5.isAssignableFrom(type)) break block59;
                Class<?> clazz6 = class$3;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$3 = Class.forName("java.util.Collection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz6.isAssignableFrom(type)) break block59;
                Class<?> clazz7 = class$4;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$4 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz7.isAssignableFrom(type)) break block49;
            }
            return new ComplexDataEditor(type, false);
        }
        return new ValueEditor(){

            public Control activateEditing() {
                return null;
            }

            public Object getValue() {
                return null;
            }

            public void setValue(Object value) {
            }

            public void setValueChangedCallback(ValueChangedListener listener) {
            }

            public boolean hasValidValue() {
                return true;
            }

            public void setModificationListener(ModificationListener listener) {
            }
        };
    }

    private static String getDialogTitle(boolean valueIsEditable) {
        if (valueIsEditable) {
            return Messages.ValueEditorFactory_DIALOG_EDIT_TITLE;
        }
        return Messages.ValueEditorFactory_DIALOG_INSPECT_TITLE;
    }

    static class BooleanValueEditor
    extends SimpleTypeEditor
    implements SelectionListener,
    KeyListener {
        private Control control;
        private CCombo dropdownList;

        public BooleanValueEditor(Composite parent, boolean editable, boolean editInDialog) {
            super(editable);
            this.createEditorControl(parent, editInDialog);
            if (!editInDialog) {
                this.dropdownList.addSelectionListener((SelectionListener)this);
                this.dropdownList.addKeyListener((KeyListener)this);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.callback != null) {
                this.callback.valueChanged(this.isEditable());
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\u001b' && this.callback != null) {
                this.callback.valueChanged(false);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public Control activateEditing() {
            return this.control;
        }

        private Control createEditorControl(Composite parent, boolean editInDialog) {
            if (editInDialog) {
                this.control = new Composite(parent, 2048);
                ((Composite)this.control).setLayout((Layout)new GridLayout(1, false));
                this.dropdownList = new CCombo((Composite)this.control, 0);
                this.dropdownList.setLayoutData((Object)new GridData(4, 128, true, false));
            } else {
                this.dropdownList = new CCombo(parent, 0);
                this.control = this.dropdownList;
            }
            this.dropdownList.add(Boolean.TRUE.toString());
            this.dropdownList.add(Boolean.FALSE.toString());
            this.dropdownList.setEditable(false);
            this.dropdownList.setEnabled(this.isEditable());
            return this.control;
        }

        public Object getValue() {
            return new Boolean(this.dropdownList.getItem(this.dropdownList.getSelectionIndex()));
        }

        public void setValue(Object value) {
            if (value == null) {
                this.setValue(Boolean.FALSE);
            } else {
                int i = 0;
                while (i < this.dropdownList.getItemCount()) {
                    if (value.toString().equals(this.dropdownList.getItem(i))) {
                        this.dropdownList.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        public boolean hasValidValue() {
            return true;
        }

        public void setModificationListener(ModificationListener listener) {
        }
    }

    static class CharacterValueEditor
    extends TextTypeEditor {
        public CharacterValueEditor(Composite parent, boolean editable, boolean editInDialog) {
            super(parent, editable, editInDialog);
        }

        protected int getDialogModifiers() {
            return 2624;
        }

        protected String format(Object obj) {
            if (!(obj instanceof Character)) {
                return "";
            }
            char charValue = ((Character)obj).charValue();
            if (charValue == '\n') {
                return "\\n";
            }
            if (charValue == '\t') {
                return "\\t";
            }
            if (charValue == '\r') {
                return "\\r";
            }
            if (charValue >= ' ' && charValue < '\u0100') {
                return obj.toString();
            }
            String hexString = Integer.toHexString(charValue);
            return "\\u" + "000".substring(hexString.length() - 1) + hexString;
        }

        protected Object parseObject(String source) throws ParseException {
            if (source.equals("\\n")) {
                return new Character('\n');
            }
            if (source.equals("\\t")) {
                return new Character('\t');
            }
            if (source.equals("\\r")) {
                return new Character('\r');
            }
            if (source.length() == 1) {
                return new Character(source.charAt(0));
            }
            if (source.length() == 6 && source.startsWith("\\u")) {
                try {
                    String hexString = source.substring(2);
                    int value = Integer.parseInt(hexString, 16);
                    return new Character((char)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ParseException(NLS.bind((String)Messages.ValueEditorFactory_PROBLEM_PARSING_CHARACTER_TEXT, (Object)source), 0);
        }
    }

    static class ComplexDataEditor
    implements ValueEditor,
    ValueChangedListener {
        private ValueChangedListener callback;
        private Object inspectedValue;
        private boolean editable;
        private Class complexType;
        private InspectorDialog dialog;

        public ComplexDataEditor(Class complexType, boolean editable) {
            this.editable = editable;
            this.complexType = complexType;
        }

        public Control activateEditing() {
            this.dialog = new InspectorDialog(Display.getCurrent().getActiveShell(), ValueEditorFactory.getDialogTitle(this.editable), this.complexType, this.inspectedValue, this.editable);
            this.dialog.setValueChangeListener(this);
            this.dialog.open();
            return null;
        }

        public Object getValue() {
            return this.inspectedValue;
        }

        public void setValue(Object value) {
            this.inspectedValue = value;
        }

        public void setValueChangedCallback(ValueChangedListener listener) {
            this.callback = listener;
        }

        public void valueChanged(boolean changed) {
            if (changed) {
                this.inspectedValue = this.dialog.getInspectedValue();
                if (this.callback != null) {
                    this.callback.valueChanged(true);
                }
            }
        }

        public boolean hasValidValue() {
            return true;
        }

        public void setModificationListener(ModificationListener listener) {
        }
    }

    public static class NullValueType {
        public String toString() {
            return String.valueOf(null);
        }
    }

    static class NumberValueEditor
    extends TextTypeEditor {
        private Class numberClass;

        public NumberValueEditor(Composite parent, Class numberClass, boolean editable, boolean editInDialog) {
            super(parent, editable, editInDialog);
            this.numberClass = numberClass;
        }

        protected int getDialogModifiers() {
            return 2624;
        }

        protected Object parseObject(String source) throws ParseException {
            block10: {
                try {
                    if (!source.equals(source.trim())) break block10;
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor constructor = this.numberClass.getConstructor(classArray);
                    return constructor.newInstance(source);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof NumberFormatException) break block10;
                    throw new RuntimeException(e);
                }
            }
            throw new ParseException(NLS.bind((String)Messages.ValueEditorFactory_PROBLEM_PARSING_NUMBER_TEXT, (Object)source, (Object)this.numberClass.getName()), 0);
        }

        protected String format(Object obj) {
            if (!(obj instanceof Number)) {
                return "";
            }
            return obj.toString();
        }
    }

    static abstract class SimpleTypeEditor
    implements ValueEditor {
        private boolean editable;
        protected ValueChangedListener callback;

        protected SimpleTypeEditor(boolean editable) {
            this.editable = editable;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setValueChangedCallback(ValueChangedListener callback) {
            this.callback = callback;
        }
    }

    static class StringValueEditor
    extends TextTypeEditor {
        public StringValueEditor(Composite parent, boolean editable, boolean editInDialog) {
            super(parent, editable, editInDialog);
        }

        protected int getDialogModifiers() {
            return 2882;
        }

        protected Object parseObject(String source) {
            return source;
        }

        protected String format(Object obj) {
            return obj.toString();
        }
    }

    static abstract class TextTypeEditor
    extends SimpleTypeEditor
    implements KeyListener,
    ModifyListener {
        private Text inputField;
        private ModificationListener modificationListener;

        public TextTypeEditor(Composite parent, boolean editable, boolean editInDialog) {
            super(editable);
            this.createEditorControl(parent, editInDialog);
            if (!editInDialog) {
                this.inputField.addKeyListener((KeyListener)this);
            } else {
                this.inputField.addModifyListener((ModifyListener)this);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r') {
                if (this.getValue() != null && this.callback != null) {
                    this.callback.valueChanged(this.isEditable());
                }
            } else if (e.character == '\u001b' && this.callback != null) {
                this.callback.valueChanged(false);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (this.modificationListener != null) {
                this.modificationListener.editorChanged(new ModificationEvent(this));
            }
        }

        protected abstract int getDialogModifiers();

        public Control activateEditing() {
            return this.inputField;
        }

        private void createEditorControl(Composite parent, boolean editInDialog) {
            int style = editInDialog ? this.getDialogModifiers() : 0;
            this.inputField = new Text(parent, style);
            this.inputField.setEditable(this.isEditable());
        }

        protected abstract String format(Object var1);

        protected abstract Object parseObject(String var1) throws ParseException;

        public Object getValue() {
            try {
                return this.parseObject(this.inputField.getText());
            }
            catch (ParseException e) {
                DialogToolkit.showError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ValueEditorFactory_DIALOG_PROBLEM_PARSING_VALUE_TITLE, (String)e.getMessage());
                return null;
            }
        }

        public void setValue(Object value) {
            if (value == null) {
                this.inputField.setText("");
            } else {
                this.inputField.setText(this.format(value));
            }
            this.inputField.setSelection(this.inputField.getText().length());
        }

        public boolean hasValidValue() {
            try {
                this.parseObject(this.inputField.getText());
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public void setModificationListener(ModificationListener listener) {
            this.modificationListener = listener;
        }
    }
}

