/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.CopyAttributesAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TabularDataInspector
implements ValueEditor {
    private Composite parent;
    private TableViewer dataViewer;
    private TableLayout tableLayout;
    private TabularData inspectedValue;
    private String[] compositeKeys;
    private ValueEditorFactory valueEditorFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TabularDataInspector(Composite parent, ValueEditorFactory valueEditorFactory) {
        this.parent = parent;
        this.valueEditorFactory = valueEditorFactory;
    }

    private void attachValueEditors(final Table table) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Text editorControl;
                Class<?> type;
                TableItem item;
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
                if ((item = TabularDataInspector.this.dataViewer.getTable().getItem(new Point(10, e.y))) == null) {
                    return;
                }
                Object selectedValue = null;
                int editableColumn = 0;
                int i = 0;
                while (i < TabularDataInspector.this.compositeKeys.length) {
                    if (item.getBounds(i).contains(e.x, e.y)) {
                        editableColumn = i;
                        selectedValue = ((CompositeData)TabularDataInspector.this.dataViewer.getElementAt(table.indexOf(item))).get(TabularDataInspector.this.compositeKeys[i]);
                        break;
                    }
                    ++i;
                }
                if (selectedValue == null) {
                    return;
                }
                Object data = selectedValue;
                if (data != null) {
                    type = data.getClass();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory$NullValueType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    type = clazz;
                }
                ValueEditor valueEditor = TabularDataInspector.this.valueEditorFactory.createEditorForType((Composite)table, type, false, false);
                if (valueEditor != null) {
                    valueEditor.setValue(data);
                    valueEditor.setValueChangedCallback(new ValueChangedListener(this, valueEditor, editor){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ValueEditor val$valueEditor;
                        private final /* synthetic */ TableEditor val$editor;
                        {
                            this.this$1 = var1_1;
                            this.val$valueEditor = valueEditor;
                            this.val$editor = tableEditor;
                        }

                        public void valueChanged(boolean sendUpdate) {
                            Object value = this.val$valueEditor.getValue();
                            Control currentControl = this.val$editor.getEditor();
                            if (currentControl != null) {
                                currentControl.dispose();
                            }
                            this.val$editor.setEditor(null);
                            if (sendUpdate) {
                                // empty if block
                            }
                            TabularDataInspector.access$0(1.access$0(this.this$1)).setInput((Object)TabularDataInspector.access$3(1.access$0(this.this$1)));
                            TabularDataInspector.access$0(1.access$0(this.this$1)).refresh();
                        }
                    });
                    editorControl = valueEditor.activateEditing();
                } else {
                    editorControl = new Text((Composite)table, 0);
                    editorControl.setEditable(false);
                    editorControl.setText(TypeHandling.simplifyType(data.getClass().getName()));
                }
                if (editorControl != null) {
                    editorControl.setFocus();
                    editor.setEditor((Control)editorControl, item, editableColumn);
                }
            }

            static /* synthetic */ TabularDataInspector access$0(1 var0) {
                return var0.TabularDataInspector.this;
            }
        });
    }

    public Control activateEditing() {
        Composite control = new Composite(this.parent, 0);
        control.setLayout((Layout)new FillLayout());
        this.dataViewer = new TableViewer(control, 67586);
        this.tableLayout = new TableLayout();
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setLayout((Layout)this.tableLayout);
        this.compositeKeys = this.inspectedValue.getTabularType().getRowType().keySet().toArray(new String[this.inspectedValue.getTabularType().getRowType().keySet().size()]);
        TableColumn[] columns = new TableColumn[this.compositeKeys.length];
        int i = 0;
        while (i < this.compositeKeys.length) {
            if (columns[i] == null) {
                columns[i] = new TableColumn(this.dataViewer.getTable(), 0);
                this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData((int)(100.0 / (double)i), 50, true));
            }
            columns[i].setText(this.compositeKeys[i]);
            ++i;
        }
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                TabularData data = (TabularData)inputElement;
                return data.values().toArray(new CompositeData[data.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                CompositeData data = (CompositeData)element;
                return TypeHandling.getValueString(data.get(TabularDataInspector.this.compositeKeys[columnIndex]));
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.dataViewer.refresh(false);
        this.dataViewer.setInput((Object)this.inspectedValue);
        this.attachValueEditors(this.dataViewer.getTable());
        MenuManager manager = CopyAttributesAction.createContextMenuWithAction((StructuredViewer)this.dataViewer);
        this.valueEditorFactory.addValueInspectorMenuItem(manager, (StructuredViewer)this.dataViewer, new InspectorContext(){

            private Object getActiveElement() {
                if (((IStructuredSelection)TabularDataInspector.this.dataViewer.getSelection()).size() == 1) {
                    return ((IStructuredSelection)TabularDataInspector.this.dataViewer.getSelection()).getFirstElement();
                }
                return null;
            }

            public boolean canEdit() {
                return false;
            }

            public Class getTypeToInspect() {
                Object valueToInspect = this.getValueToInspect();
                if (valueToInspect == null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                return valueToInspect.getClass();
            }

            public Object getValueToInspect() {
                return this.getActiveElement();
            }

            public void setValue(Object value) {
            }

            public boolean canInspect() {
                return this.getActiveElement() != null;
            }
        });
        return control;
    }

    public Object getValue() {
        return this.inspectedValue;
    }

    public void setValue(Object value) {
        this.inspectedValue = value != null && value instanceof TabularData ? (TabularData)value : null;
    }

    public void setValueChangedCallback(ValueChangedListener listener) {
    }

    public boolean hasValidValue() {
        return true;
    }

    public void setModificationListener(ModificationListener listener) {
    }

    static /* synthetic */ TabularData access$3(TabularDataInspector tabularDataInspector) {
        return tabularDataInspector.inspectedValue;
    }
}

