/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.CopyAttributesAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import java.util.Map;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MapDataInspector
implements ValueEditor {
    private Composite parent;
    private TableViewer dataViewer;
    private TableLayout tableLayout;
    private Map inspectedValue;
    private ValueEditorFactory valueEditorFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MapDataInspector(Composite parent, ValueEditorFactory valueEditorFactory) {
        this.parent = parent;
        this.valueEditorFactory = valueEditorFactory;
    }

    private void attachValueEditors(final Table table) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Text editorControl;
                Class<?> type;
                Object data;
                TableItem[] selectedItems;
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
                if ((selectedItems = MapDataInspector.this.dataViewer.getTable().getSelection()) == null || selectedItems.length < 1) {
                    return;
                }
                TableItem item = selectedItems[0];
                if (item == null) {
                    return;
                }
                int column = -1;
                int i = 0;
                while (i < 2) {
                    Rectangle bounds = item.getBounds(i);
                    if (e.x >= bounds.x && e.x <= bounds.x + bounds.width) {
                        column = i;
                        break;
                    }
                    ++i;
                }
                if (column == -1) {
                    return;
                }
                Map.Entry entry = (Map.Entry)((IStructuredSelection)MapDataInspector.this.dataViewer.getSelection()).getFirstElement();
                Object object = data = column == 0 ? entry.getKey() : entry.getValue();
                if (data != null) {
                    type = data.getClass();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory$NullValueType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    type = clazz;
                }
                ValueEditor valueEditor = MapDataInspector.this.valueEditorFactory.createEditorForType((Composite)table, type, false, false);
                if (valueEditor != null) {
                    valueEditor.setValue(data);
                    valueEditor.setValueChangedCallback(new ValueChangedListener(this, valueEditor, editor){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ValueEditor val$valueEditor;
                        private final /* synthetic */ TableEditor val$editor;
                        {
                            this.this$1 = var1_1;
                            this.val$valueEditor = valueEditor;
                            this.val$editor = tableEditor;
                        }

                        public void valueChanged(boolean sendUpdate) {
                            Object value = this.val$valueEditor.getValue();
                            Control currentControl = this.val$editor.getEditor();
                            if (currentControl != null) {
                                currentControl.dispose();
                            }
                            this.val$editor.setEditor(null);
                            if (sendUpdate) {
                                // empty if block
                            }
                            MapDataInspector.access$0(1.access$0(this.this$1)).setInput((Object)MapDataInspector.access$2(1.access$0(this.this$1)));
                            MapDataInspector.access$0(1.access$0(this.this$1)).refresh();
                        }
                    });
                    editorControl = valueEditor.activateEditing();
                } else {
                    editorControl = new Text((Composite)table, 0);
                    editorControl.setEditable(false);
                    editorControl.setText(TypeHandling.simplifyType(data.getClass().getName()));
                }
                if (editorControl != null) {
                    editorControl.setFocus();
                    editor.setEditor((Control)editorControl, item, column);
                }
            }

            static /* synthetic */ MapDataInspector access$0(1 var0) {
                return var0.MapDataInspector.this;
            }
        });
    }

    public Control activateEditing() {
        Composite control = new Composite(this.parent, 0);
        control.setLayout((Layout)new FillLayout());
        this.dataViewer = new TableViewer(control, 67586);
        this.tableLayout = new TableLayout();
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setLayout((Layout)this.tableLayout);
        TableColumn[] columns = new TableColumn[2];
        columns[0] = new TableColumn(this.dataViewer.getTable(), 0);
        columns[0].setText(Messages.CompositeDataInspector_COLUMN_HEADER_KEYS);
        this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        columns[1] = new TableColumn(this.dataViewer.getTable(), 0);
        columns[1].setText(Messages.CompositeDataInspector_COLUMN_HEADER_VALUES);
        this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Map)inputElement).entrySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                Map.Entry entry = (Map.Entry)element;
                if (columnIndex == 0) {
                    return TypeHandling.getValueString(entry.getKey());
                }
                return TypeHandling.getValueString(entry.getValue());
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.dataViewer.refresh(false);
        this.dataViewer.setInput((Object)this.inspectedValue);
        this.attachValueEditors(this.dataViewer.getTable());
        MenuManager manager = CopyAttributesAction.createContextMenuWithAction((StructuredViewer)this.dataViewer);
        this.valueEditorFactory.addValueInspectorMenuItem(manager, (StructuredViewer)this.dataViewer, new InspectorContext(){

            private Object getActiveElement() {
                if (((IStructuredSelection)MapDataInspector.this.dataViewer.getSelection()).size() == 1) {
                    return ((IStructuredSelection)MapDataInspector.this.dataViewer.getSelection()).getFirstElement();
                }
                return null;
            }

            public boolean canEdit() {
                return false;
            }

            public Class getTypeToInspect() {
                Object valueToInspect = this.getValueToInspect();
                if (valueToInspect == null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                return valueToInspect.getClass();
            }

            public Object getValueToInspect() {
                Object element = this.getActiveElement();
                if (element instanceof Map.Entry) {
                    return ((Map.Entry)element).getValue();
                }
                return element;
            }

            public void setValue(Object value) {
            }

            public boolean canInspect() {
                return this.getActiveElement() != null;
            }
        });
        return control;
    }

    public Object getValue() {
        return this.inspectedValue;
    }

    public void setValue(Object value) {
        this.inspectedValue = value != null && value instanceof Map ? (Map)value : null;
    }

    public void setValueChangedCallback(ValueChangedListener listener) {
    }

    public boolean hasValidValue() {
        return true;
    }

    public void setModificationListener(ModificationListener listener) {
    }

    static /* synthetic */ Map access$2(MapDataInspector mapDataInspector) {
        return mapDataInspector.inspectedValue;
    }
}

