/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ArrayDataInspector;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.CompositeDataInspector;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.MapDataInspector;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationEvent;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.TabularDataInspector;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class InspectorDialog
extends MessageDialog
implements ModificationListener {
    private Object inspectedValue;
    private ValueChangedListener callback;
    private boolean editable;
    private ValueEditor valueEditor;
    private Control inspector;
    private Class typeToInspect;
    private Button okButton;
    private ValueEditorFactory valueEditorFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public InspectorDialog(Shell parentShell, String dialogTitle, Class typeToInspect, Object value, boolean editable) {
        String[] stringArray;
        if (editable) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = IDialogConstants.OK_LABEL;
            stringArray = stringArray2;
            stringArray2[1] = IDialogConstants.CANCEL_LABEL;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = IDialogConstants.OK_LABEL;
        }
        super(parentShell, dialogTitle, null, null, 0, stringArray, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.inspectedValue = value;
        this.editable = editable;
        this.valueEditorFactory = new ValueEditorFactory();
        this.typeToInspect = typeToInspect;
        this.updateOkButton(false);
    }

    public void setValueChangeListener(ValueChangedListener callback) {
        this.callback = callback;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.editable) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.updateOkButton(this.valueEditor == null ? false : this.valueEditor.hasValidValue());
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        }
    }

    protected Control createCustomArea(Composite parent) {
        this.getShell().setImage(ConsolePlugin.getDefault().getImage("inspect-16.gif"));
        Label label = new Label(parent, 0);
        label.setText(Messages.InspectorDialog_USE_CONTECT_MENU_TO_INSPECT_TEXT);
        GridData gd1 = new GridData(4, 4, true, true);
        label.setLayoutData((Object)gd1);
        ScrolledComposite dialogArea = new ScrolledComposite(parent, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.management.openmbean.TabularData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(this.typeToInspect)) {
            this.valueEditor = new TabularDataInspector((Composite)dialogArea, this.valueEditorFactory);
        } else if (this.typeToInspect.isArray()) {
            this.valueEditor = new ArrayDataInspector((Composite)dialogArea, this.editable, Messages.ArrayDataInspector_COLUMN_ARRAY_TEXT, this.typeToInspect, this.valueEditorFactory);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("javax.management.openmbean.CompositeData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(this.typeToInspect)) {
                this.valueEditor = new CompositeDataInspector((Composite)dialogArea, this.valueEditorFactory);
            } else {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.util.Collection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(this.typeToInspect)) {
                    Class<?> type = this.typeToInspect;
                    if (this.inspectedValue != null && this.inspectedValue instanceof Collection) {
                        type = this.inspectedValue.getClass();
                        this.inspectedValue = ((Collection)this.inspectedValue).toArray();
                    } else {
                        this.inspectedValue = null;
                    }
                    this.valueEditor = new ArrayDataInspector((Composite)dialogArea, false, Messages.ArrayDataInspector_COLUMN_COLLECTION_TEXT, type, this.valueEditorFactory);
                } else {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.util.Map");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4.isAssignableFrom(this.typeToInspect)) {
                        this.valueEditor = new MapDataInspector((Composite)dialogArea, this.valueEditorFactory);
                    } else {
                        gd1.exclude = true;
                        this.valueEditor = this.valueEditorFactory.createEditorForType((Composite)dialogArea, this.typeToInspect, this.editable, true);
                    }
                }
            }
        }
        this.valueEditor.setValue(this.inspectedValue);
        this.valueEditor.setModificationListener(this);
        this.updateOkButton(this.valueEditor.hasValidValue());
        this.inspector = this.valueEditor.activateEditing();
        dialogArea.setContent(this.inspector);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        gd.heightHint = 300;
        dialogArea.setLayoutData((Object)gd);
        dialogArea.setExpandHorizontal(true);
        dialogArea.setExpandVertical(true);
        if (this.inspector != null) {
            this.inspector.setSize(this.inspector.computeSize(-1, -1));
        }
        return dialogArea;
    }

    public Object getInspectedValue() {
        return this.inspectedValue;
    }

    protected void buttonPressed(int button) {
        if (button == 0) {
            Object value = this.valueEditor.getValue();
            if (value == null) {
                return;
            }
            this.inspectedValue = value;
        }
        super.buttonPressed(button);
        if (this.callback != null) {
            this.callback.valueChanged(this.editable && button == 0);
        }
    }

    public void editorChanged(ModificationEvent e) {
        this.updateOkButton(e.hasValidValue());
    }

    private void updateOkButton(boolean editorHasValidValue) {
        if (this.okButton != null) {
            this.okButton.setEnabled(editorHasValidValue);
        }
    }
}

