/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.ArrayPartValueInfo;
import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.core.ui.fields.ClipboardManager;
import java.util.ArrayList;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;

public class CopyAttributesAction
extends RetargetAction {
    private StructuredViewer viewer;

    public CopyAttributesAction(StructuredViewer viewerToCopy) {
        super(ActionFactory.COPY.getId(), Messages.CopyAttributesAction_ACTION_TEXT);
        this.viewer = viewerToCopy;
        this.setEnabled(true);
    }

    public static MenuManager createContextMenuWithAction(final StructuredViewer viewer) {
        final MCContextMenuManager menuMgr = new MCContextMenuManager("array.inspector");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                menuMgr.add((IContributionItem)new GroupMarker("additions"));
                menuMgr.prependToGroup("additions", (IAction)new CopyAttributesAction(viewer));
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        return menuMgr;
    }

    public void run() {
        Object[] rowElements;
        int columnCount;
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.viewer.getLabelProvider();
        StringBuffer textRep = new StringBuffer();
        Control control = this.viewer.getControl();
        if (control instanceof Table) {
            columnCount = ((Table)control).getColumnCount();
            rowElements = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        } else if (control instanceof Tree) {
            columnCount = ((Tree)control).getColumnCount();
            TreePath[] paths = ((TreeSelection)this.viewer.getSelection()).getPaths();
            ArrayList<Object> elements = new ArrayList<Object>(paths.length);
            int i = 0;
            while (i < paths.length) {
                Object rowElement = paths[i].getLastSegment();
                if (!(rowElement instanceof ArrayPartValueInfo)) {
                    elements.add(rowElement);
                }
                ++i;
            }
            rowElements = elements.toArray();
        } else {
            columnCount = 0;
            rowElements = new Object[]{};
        }
        int row = 0;
        while (row < rowElements.length) {
            if (row > 0) {
                textRep.append(ClipboardManager.getDefault().LINE_SEPARATOR);
            }
            Object rowElement = rowElements[row];
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                String text = labelProvider.getColumnText(rowElement, columnIndex);
                if (text != null) {
                    if (columnIndex > 0) {
                        ClipboardManager.getDefault().getClass();
                        textRep.append("\t");
                    }
                    textRep.append(text);
                }
                ++columnIndex;
            }
            ++row;
        }
        ClipboardManager.getDefault().setContents(textRep.toString());
    }

    public void runWithEvent(Event e) {
        this.run();
    }
}

