/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.CopyAttributesAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CompositeDataInspector
implements ValueEditor {
    private Composite parent;
    private TableViewer dataViewer;
    private TableLayout tableLayout;
    private CompositeData inspectedValue;
    private ValueEditorFactory valueEditorFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompositeDataInspector(Composite parent, ValueEditorFactory valueEditorFactory) {
        this.parent = parent;
        this.valueEditorFactory = valueEditorFactory;
    }

    private void attachValueEditors(final Table table) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        boolean EDITABLECOLUMN = true;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Text editorControl;
                Class<?> type;
                TableItem[] selectedItems;
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
                if ((selectedItems = CompositeDataInspector.this.dataViewer.getTable().getSelection()) == null || selectedItems.length < 1) {
                    return;
                }
                TableItem item = selectedItems[0];
                Rectangle bounds = item.getBounds(1);
                if (item == null || e.x < bounds.x || e.x > bounds.x + bounds.width) {
                    return;
                }
                KeyValuePair pair = (KeyValuePair)((IStructuredSelection)CompositeDataInspector.this.dataViewer.getSelection()).getFirstElement();
                Object data = pair.value;
                if (data != null) {
                    type = data.getClass();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory$NullValueType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    type = clazz;
                }
                ValueEditor valueEditor = CompositeDataInspector.this.valueEditorFactory.createEditorForType((Composite)table, type, false, false);
                if (valueEditor != null) {
                    valueEditor.setValue(data);
                    valueEditor.setValueChangedCallback(new ValueChangedListener(this, valueEditor, editor){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ValueEditor val$valueEditor;
                        private final /* synthetic */ TableEditor val$editor;
                        {
                            this.this$1 = var1_1;
                            this.val$valueEditor = valueEditor;
                            this.val$editor = tableEditor;
                        }

                        public void valueChanged(boolean sendUpdate) {
                            Object value = this.val$valueEditor.getValue();
                            Control currentControl = this.val$editor.getEditor();
                            if (currentControl != null) {
                                currentControl.dispose();
                            }
                            this.val$editor.setEditor(null);
                            if (sendUpdate) {
                                // empty if block
                            }
                            CompositeDataInspector.access$0(1.access$0(this.this$1)).setInput((Object)CompositeDataInspector.access$2(1.access$0(this.this$1)));
                            CompositeDataInspector.access$0(1.access$0(this.this$1)).refresh();
                        }
                    });
                    editorControl = valueEditor.activateEditing();
                } else {
                    editorControl = new Text((Composite)table, 0);
                    editorControl.setEditable(false);
                    editorControl.setText(TypeHandling.simplifyType(data.getClass().getName()));
                }
                if (editorControl != null) {
                    editorControl.setFocus();
                    editor.setEditor((Control)editorControl, item, 1);
                }
            }

            static /* synthetic */ CompositeDataInspector access$0(1 var0) {
                return var0.CompositeDataInspector.this;
            }
        });
    }

    public Control activateEditing() {
        Composite control = new Composite(this.parent, 0);
        control.setLayout((Layout)new FillLayout());
        this.dataViewer = new TableViewer(control, 67586);
        this.tableLayout = new TableLayout();
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setLayout((Layout)this.tableLayout);
        TableColumn[] columns = new TableColumn[2];
        columns[0] = new TableColumn(this.dataViewer.getTable(), 0);
        columns[0].setText(Messages.CompositeDataInspector_COLUMN_HEADER_KEYS);
        this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        columns[1] = new TableColumn(this.dataViewer.getTable(), 0);
        columns[1].setText(Messages.CompositeDataInspector_COLUMN_HEADER_VALUES);
        this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                CompositeData data = (CompositeData)inputElement;
                Set<String> keySet = data.getCompositeType().keySet();
                Object[] keyValuePairs = new Object[keySet.size()];
                Iterator<String> iter = keySet.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    String key = iter.next();
                    keyValuePairs[i] = new KeyValuePair(key, data.get(key));
                    ++i;
                }
                return keyValuePairs;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                KeyValuePair pair = (KeyValuePair)element;
                if (columnIndex == 0) {
                    return pair.key;
                }
                return TypeHandling.getValueString(pair.value);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.attachValueEditors(this.dataViewer.getTable());
        this.dataViewer.refresh(false);
        this.dataViewer.setInput((Object)this.inspectedValue);
        MenuManager manager = CopyAttributesAction.createContextMenuWithAction((StructuredViewer)this.dataViewer);
        this.valueEditorFactory.addValueInspectorMenuItem(manager, (StructuredViewer)this.dataViewer, new InspectorContext(){

            private Object getActiveElement() {
                if (((IStructuredSelection)CompositeDataInspector.this.dataViewer.getSelection()).size() == 1) {
                    return ((IStructuredSelection)CompositeDataInspector.this.dataViewer.getSelection()).getFirstElement();
                }
                return null;
            }

            public boolean canEdit() {
                return false;
            }

            public Class getTypeToInspect() {
                Object valueToInspect = this.getValueToInspect();
                if (valueToInspect == null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                return valueToInspect.getClass();
            }

            public Object getValueToInspect() {
                Object element = this.getActiveElement();
                if (element instanceof KeyValuePair) {
                    return ((KeyValuePair)element).value;
                }
                return element;
            }

            public void setValue(Object editedValue) {
            }

            public boolean canInspect() {
                return this.getActiveElement() != null;
            }
        });
        return control;
    }

    public Object getValue() {
        return this.inspectedValue;
    }

    public void setValue(Object value) {
        this.inspectedValue = value != null && value instanceof CompositeData ? (CompositeData)value : null;
    }

    public void setValueChangedCallback(ValueChangedListener listener) {
    }

    public boolean hasValidValue() {
        return true;
    }

    public void setModificationListener(ModificationListener listener) {
    }

    static /* synthetic */ CompositeData access$2(CompositeDataInspector compositeDataInspector) {
        return compositeDataInspector.inspectedValue;
    }

    static class KeyValuePair {
        public String key;
        public Object value;

        public KeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

