/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.inspect;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.CopyAttributesAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ModificationListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import java.lang.reflect.Array;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ArrayDataInspector
implements ValueEditor {
    private Composite parent;
    private TableViewer dataViewer;
    private TableLayout tableLayout;
    private Object inspectedValue;
    private boolean editable;
    private boolean isPrimitiveArrayComponent;
    private String columnHeader;
    private Class inspectedValueType;
    private ValueEditor currentValueEditor;
    private ValueEditorFactory valueEditorFactory;

    public ArrayDataInspector(Composite parent, boolean editable, String columnHeader, Class inspectedValueType, ValueEditorFactory factory) {
        this.parent = parent;
        this.editable = editable;
        this.columnHeader = columnHeader;
        this.inspectedValueType = inspectedValueType;
        this.valueEditorFactory = factory;
    }

    private void attachValueEditors(final Table table) {
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        boolean editableColumn = false;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
                ArrayDataInspector.this.currentValueEditor = null;
            }

            public void mouseDoubleClick(MouseEvent e) {
                Text editorControl;
                Control oldEditorControl = editor.getEditor();
                if (oldEditorControl != null) {
                    oldEditorControl.dispose();
                }
                ArrayDataInspector.this.currentValueEditor = null;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                int selectionIndex = ArrayDataInspector.this.dataViewer.getTable().getSelectionIndex();
                Object data = Array.get(ArrayDataInspector.this.inspectedValue, selectionIndex);
                Class<?> type = data != null ? data.getClass() : ArrayDataInspector.this.inspectedValue.getClass().getComponentType();
                ArrayDataInspector.this.currentValueEditor = ArrayDataInspector.this.valueEditorFactory.createEditorForType((Composite)table, type, ArrayDataInspector.this.editable, false);
                if (ArrayDataInspector.this.currentValueEditor != null) {
                    ArrayDataInspector.this.currentValueEditor.setValue(data);
                    ArrayDataInspector.this.currentValueEditor.setValueChangedCallback(new ValueChangedListener(this, editor){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ TableEditor val$editor;
                        {
                            this.this$1 = var1_1;
                            this.val$editor = tableEditor;
                        }

                        public void valueChanged(boolean sendUpdate) {
                            ArrayDataInspector.access$6(1.access$0(this.this$1), sendUpdate);
                            Control currentControl = this.val$editor.getEditor();
                            if (currentControl != null) {
                                currentControl.dispose();
                            }
                            this.val$editor.setEditor(null);
                            ArrayDataInspector.access$1(1.access$0(this.this$1)).setInput(ArrayDataInspector.access$2(1.access$0(this.this$1)));
                            ArrayDataInspector.access$1(1.access$0(this.this$1)).refresh();
                        }
                    });
                    editorControl = ArrayDataInspector.this.currentValueEditor.activateEditing();
                } else {
                    editorControl = new Text((Composite)table, 0);
                    editorControl.setEditable(false);
                    editorControl.setText(TypeHandling.simplifyType(data.getClass().getName()));
                }
                if (editorControl != null) {
                    editorControl.setFocus();
                    editor.setEditor((Control)editorControl, item, 0);
                }
            }

            static /* synthetic */ ArrayDataInspector access$0(1 var0) {
                return var0.ArrayDataInspector.this;
            }
        });
    }

    private void finishEditing(boolean save) {
        Object value = this.currentValueEditor.getValue();
        if (save && value != null) {
            Array.set(this.inspectedValue, this.dataViewer.getTable().getSelectionIndex(), value);
        }
        this.currentValueEditor = null;
    }

    private String createColumnHeader() {
        Class type = this.inspectedValueType;
        String typeName = TypeHandling.simplifyType(type.getName());
        int length = this.inspectedValue == null ? 0 : Array.getLength(this.inspectedValue);
        return NLS.bind((String)this.columnHeader, (Object)typeName, (Object)new Integer(length));
    }

    public Control activateEditing() {
        Composite control = new Composite(this.parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        this.dataViewer = new TableViewer(control, 67586);
        this.tableLayout = new TableLayout();
        this.dataViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLinesVisible(true);
        this.dataViewer.getTable().setLayout((Layout)this.tableLayout);
        final TableColumn column = new TableColumn(this.dataViewer.getTable(), 0);
        column.setText(this.createColumnHeader());
        this.tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 50, true));
        this.dataViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (ArrayDataInspector.this.isPrimitiveArrayComponent) {
                    Object[] elements = new Object[Array.getLength(inputElement)];
                    int i = 0;
                    while (i < elements.length) {
                        elements[i] = Array.get(inputElement, i);
                        ++i;
                    }
                    return elements;
                }
                int i = 0;
                while (i < ((Object[])inputElement).length) {
                    if (((Object[])inputElement)[i] == null) {
                        Object[] obj = new Object[((Object[])inputElement).length];
                        int j = 0;
                        while (j < obj.length) {
                            Object elem = ((Object[])inputElement)[j];
                            obj[j] = elem == null ? new ValueEditorFactory.NullValueType() : elem;
                            ++j;
                        }
                        return obj;
                    }
                    ++i;
                }
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                return TypeHandling.getValueString(element);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.dataViewer.refresh(false);
        if (this.inspectedValue != null) {
            this.dataViewer.setInput(this.inspectedValue);
        }
        this.attachValueEditors(this.dataViewer.getTable());
        if (this.editable) {
            Button createNewButton = new Button(control, 0);
            createNewButton.setText(Messages.ArrayDataInspector_BUTTON_CREATE_NEW_TEXT);
            createNewButton.setEnabled(this.editable);
            createNewButton.setLayoutData((Object)new GridData(131072, 128, false, true));
            createNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)Messages.ArrayDataInspector_DIALOG_CREATE_NEW_ARRAY_TITLE, (Object)TypeHandling.simplifyType(ArrayDataInspector.this.inspectedValueType.getComponentType().getName())), Messages.ArrayDataInspector_DIALOG_CREATE_NEW_ARRAY_TEXT, Integer.toString(ArrayDataInspector.this.inspectedValue == null ? 0 : Array.getLength(ArrayDataInspector.this.inspectedValue)), new IInputValidator(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public String isValid(String newText) {
                            String s = Messages.ArrayDataInspector_ERROR_MESSAGE_MUST_BE_POSITIVE_INTEGER;
                            try {
                                if (Integer.parseInt(newText) >= 0) {
                                    return null;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            return s;
                        }
                    });
                    if (dialog.open() == 0) {
                        ArrayDataInspector.this.inspectedValue = Array.newInstance(ArrayDataInspector.this.inspectedValueType.getComponentType(), Integer.parseInt(dialog.getValue()));
                        ArrayDataInspector.this.dataViewer.setInput(ArrayDataInspector.this.inspectedValue);
                        column.setText(ArrayDataInspector.this.createColumnHeader());
                        ArrayDataInspector.this.dataViewer.refresh();
                    }
                }
            });
        }
        MenuManager manager = CopyAttributesAction.createContextMenuWithAction((StructuredViewer)this.dataViewer);
        this.valueEditorFactory.addValueInspectorMenuItem(manager, (StructuredViewer)this.dataViewer, new InspectorContext(){

            private Object getActiveElement() {
                if (((IStructuredSelection)ArrayDataInspector.this.dataViewer.getSelection()).size() == 1) {
                    return ((IStructuredSelection)ArrayDataInspector.this.dataViewer.getSelection()).getFirstElement();
                }
                return null;
            }

            public boolean canEdit() {
                return ArrayDataInspector.this.editable && ArrayDataInspector.this.valueEditorFactory.isTypeInspectable(this.getTypeToInspect());
            }

            public Class getTypeToInspect() {
                return ArrayDataInspector.this.inspectedValue.getClass().getComponentType();
            }

            public Object getValueToInspect() {
                Object obj = this.getActiveElement();
                if (obj instanceof ValueEditorFactory.NullValueType) {
                    obj = null;
                }
                return obj;
            }

            public void setValue(Object editedValue) {
                Array.set(ArrayDataInspector.this.inspectedValue, ArrayDataInspector.this.dataViewer.getTable().getSelectionIndex(), editedValue);
                ArrayDataInspector.this.dataViewer.refresh();
            }

            public boolean canInspect() {
                return this.getActiveElement() != null;
            }
        });
        return control;
    }

    public Object getValue() {
        if (this.currentValueEditor != null) {
            this.finishEditing(this.editable);
        }
        return this.inspectedValue;
    }

    public void setValue(Object value) {
        this.inspectedValue = value != null && value.getClass().isArray() ? value : null;
        this.isPrimitiveArrayComponent = this.inspectedValueType.isArray() ? this.inspectedValueType.getComponentType().isPrimitive() : false;
    }

    public void setValueChangedCallback(ValueChangedListener listener) {
    }

    public boolean hasValidValue() {
        return true;
    }

    public void setModificationListener(ModificationListener listener) {
    }

    static /* synthetic */ void access$6(ArrayDataInspector arrayDataInspector, boolean bl) {
        arrayDataInspector.finishEditing(bl);
    }
}

