/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes.visualize;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.visualize.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.visualize.VisualizeWizardPage;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;

public class VisualizeAction
extends Action {
    private final ConsoleEditor m_consoleEditor;
    private final StructuredViewer m_viewer;

    public VisualizeAction(ConsoleEditor consoleEditor, StructuredViewer viewer) {
        super(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT);
        this.m_consoleEditor = consoleEditor;
        this.m_viewer = viewer;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        List numericals = AttributeValueToolkit.filterForNumericalAttributeDescriptors(selection.toList());
        if (!numericals.isEmpty()) {
            this.showVisualizeWizard(numericals);
        }
    }

    private void showVisualizeWizard(List numericals) {
        VisualizeWizardPage wizardPage = new VisualizeWizardPage(this.m_consoleEditor.getSectionPartManagers(), numericals);
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.m_viewer.getControl().getShell(), (IWizardPage)wizardPage);
        dialog.setImage(RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        dialog.setTitle(Messages.VisualizeAction_VISUALIZE_WIZARD_TITLE_TEXT);
        dialog.open();
    }
}

